/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.io;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.FileCachingLoggingMarker;

public class HecByteArrayInputStream
extends ByteArrayInputStream {
    private static final MarkingClassLogger FILE_CACHING_LOGGER = MarkingClassLogger.forMarkingClass(FileCachingLoggingMarker.class);
    protected HecFileImpl _parentFile = null;
    protected OutputStream _outStream;
    protected boolean _checkingParent = false;
    protected long _offset;

    public HecByteArrayInputStream(byte[] buf) {
        super(buf);
        this._offset = 0L;
    }

    public HecByteArrayInputStream(byte[] buf, HecFileImpl parentFile) {
        super(buf);
        this.setParentFile(parentFile);
        this._offset = 0L;
    }

    public void setParentFile(HecFileImpl parentFile) {
        this._parentFile = parentFile;
        this.openCacheFile();
    }

    private void openCacheFile() {
        if (this._parentFile != null && this._parentFile.shouldCacheLocalFile()) {
            String localFile = this._parentFile.getCachedFilename();
            if (localFile == null) {
                return;
            }
            ((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atFine()).log("writing to local cache file %s", (Object)localFile);
            File f = new File(localFile);
            f.getParentFile().mkdirs();
            try {
                this._outStream = new FileOutputStream(localFile);
            }
            catch (FileNotFoundException e) {
                System.out.println("openCacheFile:FileNotFoundException " + e);
            }
            if (this.buf != null) {
                this.writeToCachedFile(this.buf);
            }
        }
    }

    @Override
    public synchronized long skip(long n) {
        long skipped = super.skip(n);
        if (skipped < n) {
            this._offset += (long)this.buf.length;
            this.buf = this._parentFile.getByteArray(this._offset, this.buf.length);
            this.writeToCachedFile(this.buf);
            this.pos = 0;
            this.count = this.buf.length;
            this.mark(0);
        }
        return skipped;
    }

    @Override
    public synchronized int read() {
        int value = super.read();
        if (!this._checkingParent && value == -1) {
            this._checkingParent = true;
            this._offset += (long)this.buf.length;
            this.buf = this._parentFile.getByteArray(this._offset, this.buf.length);
            this.writeToCachedFile(this.buf);
            this.pos = 0;
            this.count = this.buf.length;
            this.mark(0);
            value = this.read();
        } else if (this._checkingParent && value > -1) {
            this._checkingParent = false;
        }
        return value;
    }

    @Override
    public synchronized int read(byte[] b, int off, int len) {
        int hpos = this.pos;
        int blength = len;
        if (off != 0) {
            System.out.println("HecByteArray Offset not set to Zero.");
        }
        int numBytesRead = super.read(b, off, len);
        if (!this._checkingParent && numBytesRead < blength) {
            this._checkingParent = true;
            this._offset += (long)hpos;
            if (this._offset > 0L) {
                this.buf = this._parentFile.getByteArray(this._offset, this.buf.length);
                this.writeToCachedFile(this.buf);
            }
            this.pos = 0;
            this.count = this.buf.length;
            numBytesRead = this.read(b, off, len);
        } else if (this._checkingParent && numBytesRead > -1) {
            this._checkingParent = false;
        }
        return numBytesRead;
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this._parentFile != null) {
            this._parentFile.close();
        }
        if (this._outStream != null) {
            this._outStream.flush();
            this._parentFile.addFileToCacheList();
            this._outStream.close();
        }
    }

    public void writeToCachedFile(byte[] buf) {
        if (this._outStream == null) {
            return;
        }
        try {
            this._outStream.write(buf);
        }
        catch (IOException e) {
            System.out.println("writeToCachedFile:IOException " + e);
        }
    }
}

