/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.io;

import com.google.common.flogger.LazyArgs;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.FileCachingLoggingMarker;

public class HecByteArrayOutputStream
extends ByteArrayOutputStream {
    private static final MarkingClassLogger FILE_CACHING_LOGGER = MarkingClassLogger.forMarkingClass(FileCachingLoggingMarker.class);
    protected HecFileImpl _parentFile = null;
    protected int _fillToSize;
    private FileOutputStream _outStream;
    protected static int _bufSize = 32768;

    public HecByteArrayOutputStream(HecFileImpl parentFile) {
        this(_bufSize, parentFile, false);
    }

    public HecByteArrayOutputStream(HecFileImpl parentFile, boolean append) {
        this(_bufSize, parentFile, append);
    }

    public HecByteArrayOutputStream(int size, HecFileImpl parentFile, boolean append) {
        super(size);
        this._fillToSize = size;
        this.setParentFile(parentFile);
        this._parentFile = parentFile;
        if (!append) {
            byte[] bytes = new byte[]{};
            this._parentFile.setByteArray(bytes);
            this.writeToCachedFile(bytes);
        }
    }

    public void setParentFile(HecFileImpl parentFile) {
        this._parentFile = parentFile;
        this.openCacheFile();
    }

    private void openCacheFile() {
        if (this._parentFile != null && this._parentFile.shouldCacheLocalFile()) {
            String localFile = this._parentFile.getCachedFilename();
            if (localFile == null) {
                return;
            }
            ((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atFine()).log("saving to local cache file %s", (Object)localFile);
            File f = new File(localFile);
            f.getParentFile().mkdirs();
            try {
                this._outStream = new FileOutputStream(localFile);
            }
            catch (FileNotFoundException e) {
                System.out.println("openCacheFile:FileNotFoundException " + e);
            }
        } else if (this._parentFile != null) {
            ((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atFine()).log("no local caching for %s", (Object)LazyArgs.lazy(() -> this._parentFile.getPath()));
        }
    }

    public synchronized void incrementalSave() {
        if (this.count > 0) {
            byte[] bytes = this.toByteArray();
            this._parentFile.appendByteArray(bytes);
            this.writeToCachedFile(bytes);
            this.reset();
            this.buf = new byte[this._fillToSize];
        }
    }

    public synchronized void finalSave() {
        this.incrementalSave();
    }

    @Override
    public synchronized void write(byte[] b, int off, int len) {
        this.checkSize();
        if (len + this.count >= this._fillToSize) {
            this.incrementalSave();
        }
        super.write(b, off, len);
    }

    @Override
    public synchronized void write(int b) {
        this.checkSize();
        super.write(b);
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        if (this._outStream != null) {
            this._outStream.flush();
        }
        this.finalSave();
    }

    protected synchronized void checkSize() {
        if (this.count >= this._fillToSize) {
            this.incrementalSave();
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this._outStream != null) {
            this._outStream.flush();
            this._outStream.close();
        }
        super.close();
        this._parentFile.close();
    }

    public void writeToCachedFile(byte[] buf) {
        if (this._outStream == null) {
            return;
        }
        try {
            this._outStream.write(buf);
        }
        catch (IOException e) {
            System.out.println("writeToCachedFile:IOException " + e);
        }
    }

    static {
        String bufSize = System.getProperty("hecfile.bufsize", "32768");
        _bufSize = RMAIO.parseInt((String)bufSize, (int)32768);
    }
}

