/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.io;

import com.google.common.flogger.LazyArgs;
import com.google.common.flogger.StackSize;
import hec.io.EndianInputStream;
import hec.io.EndianOutputStream;
import hec.io.FileLock;
import hec.io.FilePath;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.lang.ClientAppCheck;
import hec.lang.UserId;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import mil.army.usace.hec.rmi.csinterface.ClientServerUtil;
import mil.army.usace.hec.rmi.csinterface.RmiFile;
import mil.army.usace.hec.rmi.csinterface.RmiFileCallBack;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.io.HecByteArrayInputStream;
import mil.army.usace.hec.rmi.io.HecByteArrayOutputStream;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import mil.army.usace.hec.rmi.server.RmiFileImpl;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.FileCachingLoggingMarker;

public class HecFileImpl
extends File
implements HecFile,
Serializable {
    private static final MarkingClassLogger FILE_CACHING_LOGGER = MarkingClassLogger.forMarkingClass(FileCachingLoggingMarker.class);
    static final long serialVersionUID = -1762215052777274314L;
    protected static int _retryMax = 3;
    protected static int _readBufferSize = 32768;
    protected static boolean _lockDebug = false;
    protected static boolean _useSockets = false;
    protected static long _retrySleepAmt = 500L;
    protected static boolean _useFileCaching = false;
    protected FilePath _filePath;
    protected RemoteWrapper _rmiFile;
    protected boolean _local;
    protected String _clientUserId;
    protected String _path;
    protected String _lnSeparator;
    protected transient Socket _socket;
    protected FileLock _fileLock;
    private boolean _usingCompression;
    private transient byte[] _unzippedByteArray;
    private boolean _cacheLocalFile;

    public HecFileImpl(RemoteWrapper rmiFileImpl, String clientUserId) {
        super(rmiFileImpl.getName());
        this._path = null;
        this._lnSeparator = null;
        this._socket = null;
        this.init();
        this._local = false;
        this._rmiFile = rmiFileImpl;
        this._usingCompression = !(this._rmiFile.getRemote() instanceof RmiFileImpl);
        this._cacheLocalFile = _useFileCaching;
        if (Boolean.getBoolean("HecFile.NoFileCompression")) {
            this._usingCompression = false;
        }
        try {
            this._clientUserId = clientUserId;
            this._path = ((RmiFile)rmiFileImpl.getRemote()).getRelativePath();
            ((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atFine()).log("file = %s", (Object)this._path);
        }
        catch (RemoteException re) {
            System.out.println("Error getting user name from RmiFileImpl in HecFile  " + re);
        }
    }

    public HecFileImpl(FilePath filePath) {
        block5: {
            super(filePath.getPath());
            this._path = null;
            this._lnSeparator = null;
            this._socket = null;
            this._filePath = filePath;
            this._local = this._filePath.getLocal();
            ((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atFine()).log("file = %s", (Object)LazyArgs.lazy(() -> this._filePath.getPath()));
            this.init();
            if (!this._local) {
                String url = this._filePath.getRMIUrl();
                Identifier fileId = new Identifier(this._filePath.getPathAndFileAndExtension());
                try {
                    RmiFileManager fmiObj = ClientServerUtil.getRmiFileManager(url);
                    String userId = UserId.getUserId((String)url);
                    Identifier id = fmiObj.openFile(userId, fileId);
                    if (id != null) {
                        this._rmiFile = ((HecFileImpl)id.getFile()).getFileWrapper();
                        break block5;
                    }
                    id = fmiObj.newFile(userId, fileId);
                    if (id != null) {
                        this._rmiFile = ((HecFileImpl)id.getFile()).getFileWrapper();
                        break block5;
                    }
                    throw new InstantiationException("Can't create file " + fileId.getPath());
                }
                catch (Exception e) {
                    System.out.println(e);
                    e.printStackTrace();
                }
            }
        }
    }

    protected void init() {
        this._clientUserId = "noone";
    }

    public void setCallBack(RemoteWrapper callBackWrap) {
        if (this._local) {
            return;
        }
        try {
            RmiFile file = (RmiFile)this._rmiFile.getRemote();
            RmiFileCallBack callBack = (RmiFileCallBack)callBackWrap.getRemote();
            if (!this._rmiFile.getExported()) {
                file.setCallBack(callBack);
            } else if (callBack != null) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atWarning()).withStackTrace(StackSize.MEDIUM)).log("Remote file handle callbacks are not supported for HecFileImpl");
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    public void removeCallBack(RmiFileCallBack callBack) {
        if (this._local) {
            return;
        }
        try {
            RmiFile file = (RmiFile)this._rmiFile.getRemote();
            if (callBack != null && file != null) {
                file.removeCallBack(callBack);
            }
        }
        catch (Exception e) {
            System.out.println("Failed to remove callback for " + this.getName());
        }
    }

    public void removeCallBack(RemoteWrapper callBackWrap) {
        if (callBackWrap == null) {
            return;
        }
        RmiFileCallBack callBack = (RmiFileCallBack)callBackWrap.getRemote();
        this.removeCallBack(callBack);
    }

    @Override
    public boolean isDirectory() {
        if (this._local) {
            return super.isDirectory();
        }
        try {
            RmiFile file = (RmiFile)this._rmiFile.getRemote();
            return file.getIsDirectory();
        }
        catch (RemoteException re) {
            System.out.println(re);
            re.printStackTrace();
            return false;
        }
    }

    @Override
    public String getName() {
        if (this._local) {
            String name = super.getName().replace('\\', '/');
            int index = name.lastIndexOf("/");
            return index < 0 ? name : name.substring(index + 1);
        }
        try {
            RmiFile file = (RmiFile)this._rmiFile.getRemote();
            return file.getFileName();
        }
        catch (Exception e) {
            System.out.println("getName():Error trying to get filename. " + e);
            if (e instanceof RemoteException) {
                RemoteException re = (RemoteException)e;
                System.out.println("Cause=" + re.getCause());
            }
            return null;
        }
    }

    public RemoteWrapper getFileWrapper() {
        return this._rmiFile;
    }

    @Override
    public String getPath() {
        if (this._path == null) {
            return super.getPath();
        }
        return this._path;
    }

    public byte[] getByteArray() {
        if (this._local) {
            try {
                FileInputStream fis = new FileInputStream(this);
                int available = fis.available();
                byte[] byteArray = new byte[available];
                fis.read(byteArray);
                fis.close();
                return byteArray;
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("File Not Found: " + this.getPath());
                System.out.println(fnfe.getMessage());
                fnfe.printStackTrace();
            }
            catch (IOException ioe) {
                System.out.println("File IO Exception: " + this.getPath());
                System.out.println(ioe.getMessage());
                ioe.printStackTrace();
            }
            return null;
        }
        RmiFile file = (RmiFile)this._rmiFile.remote;
        try {
            byte[] b = file.getByteArray(false, this._clientUserId);
            return b;
        }
        catch (RemoteException re) {
            System.out.println("Error getting RmiFileImpl byte array from HecFile  " + re);
            return null;
        }
    }

    public byte[] getByteArray(long off, int len) {
        if (this._local) {
            try {
                FileInputStream fis = new FileInputStream(this);
                long available = this.length();
                long wants = off + (long)len;
                if (available < wants) {
                    len = (int)(available - off);
                }
                byte[] byteArray = new byte[len];
                fis.skip(off);
                fis.read(byteArray);
                fis.close();
                return byteArray;
            }
            catch (FileNotFoundException fnfe) {
                System.out.println("File Not Found: " + this.getPath());
                System.out.println(fnfe.getMessage());
                fnfe.printStackTrace();
            }
            catch (IOException ioe) {
                System.out.println("File IO Exception: " + this.getPath());
                System.out.println(ioe.getMessage());
                ioe.printStackTrace();
            }
            return null;
        }
        RmiFile file = (RmiFile)this._rmiFile.remote;
        if (_useSockets && !(file instanceof RmiFileImpl)) {
            try {
                byte[] buffer = new byte[len];
                if (this._socket == null) {
                    String hostAndPort = file.getHostAndPort(this._clientUserId);
                    String host = null;
                    int port = 0;
                    if (hostAndPort != null) {
                        host = RMAIO.getType((String)hostAndPort, (String)":");
                        port = RMAIO.parseInt((String)RMAIO.getParam((String)hostAndPort, (String)":"), (int)-1);
                        this._socket = new Socket(host, port);
                    } else {
                        return this.getRmiByteArray((int)off, len);
                    }
                }
                try {
                    DataOutputStream dos = new DataOutputStream(this._socket.getOutputStream());
                    dos.writeChar(82);
                    dos.writeInt((int)off);
                    dos.writeInt(len);
                }
                catch (IOException ioe) {
                    System.out.println("getByteArray: error sending header info to socket " + ioe);
                    return this.getRmiByteArray((int)off, len);
                }
                BufferedInputStream fromHostStream = new BufferedInputStream(this._socket.getInputStream());
                int numread = fromHostStream.read(buffer);
                if (numread != len) {
                    byte[] tmpbuf = new byte[numread];
                    System.arraycopy(buffer, 0, tmpbuf, 0, numread);
                    return tmpbuf;
                }
                return buffer;
            }
            catch (Exception e) {
                System.out.println("Error getting RmiFileImpl Socket from HecFile  " + e);
                return this.getRmiByteArray(off, len);
            }
        }
        return this.getRmiByteArray(off, len);
    }

    protected byte[] getRmiByteArray(long off, int len) {
        RmiFile file = (RmiFile)this._rmiFile.remote;
        try {
            byte[] b = file.getByteArray(off, len, this._usingCompression, this._clientUserId);
            if (this._usingCompression) {
                b = this.unzip(b);
            }
            return b;
        }
        catch (RemoteException re) {
            System.out.println("Error getting RmiFileImpl byte array from HecFile  " + re);
            return null;
        }
    }

    public boolean setByteArray(byte[] byteArray) {
        if (this._local) {
            try {
                FileOutputStream fos = new FileOutputStream(this);
                fos.write(byteArray);
                fos.close();
                return true;
            }
            catch (Exception e) {
                System.out.println(e);
                if (!this.isFile()) {
                    System.out.println("********** RMI File : \"" + this.getPath() + "\". Is not a File **********");
                    return false;
                }
                if (!this.canWrite()) {
                    System.out.println("********** RMI File : \"" + this.getPath() + "\" is *READ-ONLY*. **********");
                    return false;
                }
                e.printStackTrace();
                return false;
            }
        }
        RmiFile file = (RmiFile)this._rmiFile.remote;
        try {
            if (this._usingCompression) {
                byteArray = this.zip(byteArray);
            }
            return file.setByteArray(byteArray, this._usingCompression, this._clientUserId);
        }
        catch (RemoteException re) {
            System.out.println("Error getting RmiFileImpl byte array from HecFile  " + re);
            return false;
        }
    }

    public boolean appendByteArray(byte[] byteArray) {
        if (this._local) {
            try {
                RandomAccessFile raFile = new RandomAccessFile(this, "rw");
                long length = raFile.length();
                raFile.seek(length);
                raFile.write(byteArray);
                raFile.close();
                return true;
            }
            catch (Exception e) {
                System.out.println(e);
                if (!this.isFile()) {
                    System.out.println("********** RMI File : \"" + this.getPath() + "\". Is not a File **********");
                    return false;
                }
                if (!this.canWrite()) {
                    System.out.println("********** RMI File : \"" + this.getPath() + "\" is *READ-ONLY*. **********");
                    return false;
                }
                e.printStackTrace();
                return false;
            }
        }
        RmiFile file = (RmiFile)this._rmiFile.remote;
        try {
            if (this._usingCompression) {
                byteArray = this.zip(byteArray);
            }
            return file.appendByteArray(byteArray, this._usingCompression, this._clientUserId);
        }
        catch (RemoteException re) {
            System.out.println("Error getting RmiFileImpl byte array from HecFile  " + re);
            return false;
        }
    }

    public synchronized BufferedWriter getBufferedWriter() {
        BufferedWriter bufferedWriter = null;
        if (this._local) {
            try {
                FileWriter fw = new FileWriter(this){

                    @Override
                    public void close() throws IOException {
                        this.flush();
                        super.close();
                    }
                };
                bufferedWriter = new BufferedWriter(fw);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        } else {
            if (!this.getLock(4)) {
                return null;
            }
            RmiFile file = (RmiFile)this._rmiFile.remote;
            HecByteArrayOutputStream hecByteArrayOutputStream = new HecByteArrayOutputStream(this);
            OutputStreamWriter osw = new OutputStreamWriter(hecByteArrayOutputStream){

                @Override
                public void close() throws IOException {
                    this.flush();
                    super.close();
                }
            };
            this.getLineSeparator();
            bufferedWriter = new BufferedWriter(osw){

                @Override
                public void newLine() throws IOException {
                    this.write(HecFileImpl.this._lnSeparator);
                }
            };
        }
        return bufferedWriter;
    }

    public String getLineSeparator() {
        if (this._local) {
            return pathSeparator;
        }
        if (this._lnSeparator == null) {
            RmiFile file = (RmiFile)this._rmiFile.remote;
            try {
                this._lnSeparator = file.lnSeparator();
            }
            catch (Exception re) {
                this._lnSeparator = System.getProperty("line.separator");
            }
        }
        return this._lnSeparator;
    }

    public synchronized BufferedWriter getAppendedBufferedWriter() {
        BufferedWriter bufferedWriter = null;
        if (this._local) {
            try {
                FileWriter fw = new FileWriter(this.getPath(), true){

                    @Override
                    public void close() throws IOException {
                        this.flush();
                        super.close();
                    }
                };
                bufferedWriter = new BufferedWriter(fw);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        } else {
            if (!this.getLock(4)) {
                return null;
            }
            RmiFile file = (RmiFile)this._rmiFile.remote;
            try {
                file.append();
            }
            catch (RemoteException re) {
                System.out.println("Error setting RmiFileImpl to append. " + re);
                return null;
            }
            HecByteArrayOutputStream hecByteArrayOutputStream = new HecByteArrayOutputStream(this, true);
            OutputStreamWriter osw = new OutputStreamWriter(hecByteArrayOutputStream){

                @Override
                public void close() throws IOException {
                    this.flush();
                    super.close();
                }
            };
            bufferedWriter = new BufferedWriter(osw);
        }
        return bufferedWriter;
    }

    public synchronized DataOutputStream getDataOutputStream() {
        DataOutputStream dataOutputStream = null;
        if (this._local) {
            try {
                FileOutputStream fos = new FileOutputStream(this);
                dataOutputStream = new DataOutputStream(fos);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        } else {
            if (!this.getLock(4)) {
                return null;
            }
            HecByteArrayOutputStream hecByteArrayOutputStream = new HecByteArrayOutputStream(this);
            dataOutputStream = new DataOutputStream(hecByteArrayOutputStream);
        }
        return dataOutputStream;
    }

    public synchronized DataOutputStream getAppendedDataOutputStream() {
        DataOutputStream dataOutputStream = null;
        if (this._local) {
            try {
                FileOutputStream fos = new FileOutputStream(this.getPath(), true);
                dataOutputStream = new DataOutputStream(fos);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        } else {
            RmiFile file = (RmiFile)this._rmiFile.remote;
            try {
                file.append();
            }
            catch (RemoteException re) {
                System.out.println("Error setting RmiFileImpl to append. " + re);
                return null;
            }
            if (!this.getLock(4)) {
                return null;
            }
            HecByteArrayOutputStream hecByteArrayOutputStream = new HecByteArrayOutputStream(this, true);
            dataOutputStream = new DataOutputStream(hecByteArrayOutputStream);
        }
        return dataOutputStream;
    }

    public synchronized DataInputStream getDataInputStream() {
        DataInputStream dataInputStream = null;
        if (this._local) {
            try {
                int len = 32768;
                byte[] byteArray = this.getByteArray(0L, len);
                HecByteArrayInputStream in = new HecByteArrayInputStream(byteArray, this);
                BufferedInputStream bis = new BufferedInputStream(in);
                dataInputStream = new DataInputStream(bis);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        } else {
            if (!this.getLock(3)) {
                return null;
            }
            try {
                RmiFile file = (RmiFile)this._rmiFile.remote;
                int len = 32768;
                byte[] byteArray = file.getByteArray(0L, len, this._usingCompression, this._clientUserId);
                if (this._usingCompression) {
                    byteArray = this.unzip(byteArray);
                }
                HecByteArrayInputStream in = new HecByteArrayInputStream(byteArray, this);
                dataInputStream = new DataInputStream(in);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
        return dataInputStream;
    }

    public synchronized ObjectOutputStream getObjectOutputStream() throws IOException {
        ObjectOutputStream objectOutputStream = null;
        if (this._local) {
            try {
                FileOutputStream fos = new FileOutputStream(this);
                objectOutputStream = new ObjectOutputStream(fos);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        } else {
            if (!this.getLock(4)) {
                return null;
            }
            HecByteArrayOutputStream hecByteArrayOutputStream = new HecByteArrayOutputStream(this);
            objectOutputStream = new ObjectOutputStream(hecByteArrayOutputStream);
        }
        return objectOutputStream;
    }

    public synchronized ObjectInputStream getObjectInputStream() {
        ObjectInputStream objectInputStream = null;
        if (this._local) {
            try {
                FileInputStream fis = new FileInputStream(this);
                objectInputStream = new ObjectInputStream(fis);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        } else {
            if (!this.getLock(3)) {
                return null;
            }
            try {
                RmiFile file = (RmiFile)this._rmiFile.remote;
                int len = 32768;
                byte[] byteArray = file.getByteArray(0L, len, this._usingCompression, this._clientUserId);
                if (this._usingCompression) {
                    byteArray = this.unzip(byteArray);
                }
                HecByteArrayInputStream in = new HecByteArrayInputStream(byteArray, this);
                objectInputStream = new ObjectInputStream(in);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
        return objectInputStream;
    }

    public synchronized ByteArrayOutputStream getByteArrayOutputStream() {
        if (this._local) {
            return null;
        }
        if (!this.getLock(4)) {
            return null;
        }
        HecByteArrayOutputStream hecByteArrayOutputStream = new HecByteArrayOutputStream(this);
        this._usingCompression = false;
        return hecByteArrayOutputStream;
    }

    public synchronized ByteArrayInputStream getByteArrayInputStream() {
        if (this._local) {
            return null;
        }
        HecByteArrayInputStream in = null;
        try {
            if (!this.getLock(3)) {
                return null;
            }
            RmiFile file = (RmiFile)this._rmiFile.remote;
            if (!file.fileExists()) {
                return null;
            }
            int len = 32768;
            byte[] byteArray = file.getByteArray(0L, len, false, this._clientUserId);
            if (byteArray == null) {
                return null;
            }
            in = new HecByteArrayInputStream(byteArray, this);
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        return in;
    }

    public synchronized EndianInputStream getEndianInputStream() {
        EndianInputStream dataInputStream = null;
        if (this._local) {
            try {
                FileInputStream fis = new FileInputStream(this);
                dataInputStream = new EndianInputStream((InputStream)new BufferedInputStream(fis));
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        } else {
            if (!this.getLock(3)) {
                return null;
            }
            try {
                RmiFile file = (RmiFile)this._rmiFile.remote;
                int len = 32768;
                byte[] byteArray = file.getByteArray(0L, len, this._usingCompression, this._clientUserId);
                if (this._usingCompression) {
                    byteArray = this.unzip(byteArray);
                }
                HecByteArrayInputStream in = new HecByteArrayInputStream(byteArray, this);
                dataInputStream = new EndianInputStream((InputStream)in);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        }
        return dataInputStream;
    }

    public synchronized EndianOutputStream getEndianOutputStream() {
        EndianOutputStream dataOutputStream = null;
        if (this._local) {
            try {
                FileOutputStream fos = new FileOutputStream(this);
                dataOutputStream = new EndianOutputStream((OutputStream)fos);
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        } else {
            if (!this.getLock(4)) {
                return null;
            }
            HecByteArrayOutputStream hecByteArrayOutputStream = new HecByteArrayOutputStream(this);
            dataOutputStream = new EndianOutputStream((OutputStream)hecByteArrayOutputStream);
        }
        return dataOutputStream;
    }

    public boolean save() {
        return true;
    }

    public synchronized BufferedReader getBufferedReader() {
        BufferedReader bufferedReader = null;
        if (this._local) {
            try {
                FileReader fr = new FileReader(this);
                bufferedReader = new BufferedReader(fr);
                ((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atFine()).log("Read local file %s", (Object)LazyArgs.lazy(() -> this.getPath()));
            }
            catch (Exception e) {
                System.out.println(e);
                e.printStackTrace();
            }
        } else {
            RmiFile file = (RmiFile)this._rmiFile.remote;
            if (this.shouldCacheLocalFile()) {
                if (!this.isFileCached()) {
                    if (((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atFine()).isEnabled()) {
                        try {
                            String truePath = file.getTruePath();
                            ((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atFine()).log("Read remote file %s", (Object)truePath);
                        }
                        catch (Exception e) {
                            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atFine()).withCause((Throwable)e)).log();
                        }
                    }
                    bufferedReader = this.getBufferedReaderFromServer();
                } else {
                    String cachedFile = this.getCachedFilename();
                    ((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atFine()).log("reading cached file %s", (Object)cachedFile);
                    try {
                        FileReader fr = new FileReader(cachedFile);
                        bufferedReader = new BufferedReader(fr);
                    }
                    catch (FileNotFoundException e) {
                        System.out.println("getBufferedReader:FileNotFoundException " + e);
                        bufferedReader = this.getBufferedReaderFromServer();
                    }
                }
            } else {
                bufferedReader = this.getBufferedReaderFromServer();
                if (((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atFine()).isEnabled()) {
                    try {
                        String truePath = file.getTruePath();
                        ((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atFine()).log("Read file %s", (Object)truePath);
                    }
                    catch (Exception e) {
                        ((MarkingClassLogger.Api)((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atFine()).withCause((Throwable)e)).log();
                    }
                }
            }
        }
        return bufferedReader;
    }

    private BufferedReader getBufferedReaderFromServer() {
        BufferedReader bufferedReader = null;
        if (!this.getLock(3)) {
            return bufferedReader;
        }
        try {
            RmiFile file = (RmiFile)this._rmiFile.remote;
            byte[] byteArray = file.getByteArray(0L, _readBufferSize, this._usingCompression, this._clientUserId);
            if (byteArray == null) {
                return null;
            }
            if (this._usingCompression) {
                byteArray = this.unzip(byteArray);
            }
            HecByteArrayInputStream in = new HecByteArrayInputStream(byteArray, this);
            InputStreamReader isr = new InputStreamReader(in);
            bufferedReader = new BufferedReader(isr, _readBufferSize);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return bufferedReader;
    }

    public boolean shouldCacheLocalFile() {
        return false;
    }

    public void setCacheLocalFile(boolean cacheIt) {
        this._cacheLocalFile = cacheIt;
    }

    public String readln() {
        String line = null;
        return line;
    }

    protected boolean renameAndCopy(String newBasename) {
        if (this._local) {
            BufferedInputStream in;
            String oldpath = this.getPath();
            FilePath fp = new FilePath(oldpath);
            HecFileImpl oldfile = new HecFileImpl(fp);
            if (!oldfile.canRead()) {
                return false;
            }
            String dir = oldfile.getParent() + "/";
            String fname = oldfile.getName();
            String ext = fname.substring(fname.lastIndexOf(".") + 1);
            String newpath = dir + newBasename + "." + ext;
            try {
                in = new BufferedInputStream(new FileInputStream(oldpath));
            }
            catch (FileNotFoundException e) {
                return false;
            }
            try {
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newpath));
                int len = 4096;
                byte[] b = new byte[len];
                int ibytes = 0;
                ibytes = in.read(b, 0, len);
                while (ibytes > -1) {
                    out.write(b, 0, ibytes);
                    ibytes = in.read(b, 0, len);
                }
                out.flush();
                in.close();
                out.close();
            }
            catch (IOException eio) {
                return false;
            }
            return true;
        }
        return false;
    }

    public void notify(String message) {
        RmiFile file = (RmiFile)this._rmiFile.getRemote();
        try {
            file.notify(message);
        }
        catch (RemoteException re) {
            System.out.println("Exception: " + re);
            re.printStackTrace();
        }
    }

    @Override
    public boolean canRead() {
        if (this._local) {
            return super.canRead();
        }
        RmiFile file = (RmiFile)this._rmiFile.getRemote();
        if (file == null) {
            return false;
        }
        try {
            return file.canReadFile();
        }
        catch (RemoteException re) {
            return false;
        }
    }

    @Override
    public boolean isFile() {
        if (this._local) {
            return super.isFile();
        }
        RmiFile file = (RmiFile)this._rmiFile.getRemote();
        if (file == null) {
            return false;
        }
        try {
            return file.getIsFile();
        }
        catch (RemoteException re) {
            return false;
        }
    }

    @Override
    public String getAbsolutePath() {
        if (this._local) {
            return super.getAbsolutePath();
        }
        RmiFile file = (RmiFile)this._rmiFile.getRemote();
        if (file == null) {
            return this.getPath();
        }
        try {
            return file.getAbsolutePath();
        }
        catch (RemoteException re) {
            return this.getPath();
        }
    }

    @Override
    public boolean exists() {
        if (this._local) {
            return super.exists();
        }
        RmiFile file = (RmiFile)this._rmiFile.getRemote();
        if (file == null) {
            return false;
        }
        try {
            return file.fileExists();
        }
        catch (RemoteException re) {
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        if (this._local) {
            return super.canWrite();
        }
        RmiFile file = (RmiFile)this._rmiFile.getRemote();
        if (file == null) {
            return false;
        }
        try {
            return file.canWriteFile();
        }
        catch (RemoteException re) {
            return false;
        }
    }

    @Override
    public boolean mkdirs() {
        if (this._local) {
            return super.mkdirs();
        }
        RmiFile file = (RmiFile)this._rmiFile.getRemote();
        if (file == null) {
            return false;
        }
        try {
            return file.fmkdirs();
        }
        catch (RemoteException re) {
            return false;
        }
    }

    @Override
    public long length() {
        if (this._local) {
            return super.length();
        }
        RmiFile file = (RmiFile)this._rmiFile.getRemote();
        if (file == null) {
            System.out.println(this.getName() + ".length: null rmifile");
            return -1L;
        }
        try {
            if (!this.getLock(3)) {
                return -1L;
            }
            long size = file.fileSize();
            if (this.unlockFile(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
                this._fileLock = null;
            }
            return size;
        }
        catch (RemoteException re) {
            System.out.println(this.getName() + ".length: rmi exception " + re);
            return -1L;
        }
    }

    @Override
    public long lastModified() {
        if (this._local) {
            return super.lastModified();
        }
        RmiFile file = (RmiFile)this._rmiFile.getRemote();
        if (file == null) {
            return -1L;
        }
        try {
            if (!this.getLock(3)) {
                return -1L;
            }
            long modTime = file.modifiedTime();
            if (this.unlockFile(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
                this._fileLock = null;
            }
            return modTime;
        }
        catch (RemoteException re) {
            System.out.println(this.getName() + ".lastModified: rmi exception " + re);
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setLastModified(long time) {
        boolean retval = false;
        if (this._local) {
            retval = super.setLastModified(time);
        } else {
            RmiFile file = (RmiFile)this._rmiFile.getRemote();
            if (file != null) {
                try {
                    if (this.getLock(4)) {
                        retval = file.setLastModified(time);
                    }
                }
                catch (RemoteException re) {
                    System.out.println(this.getName() + ".lastModified: rmi exception " + re);
                    retval = false;
                }
                finally {
                    if (this.unlockFile(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
                        this._fileLock = null;
                    }
                }
            }
        }
        return retval;
    }

    public void close() throws IOException {
        if (this._local) {
            return;
        }
        RmiFile file = (RmiFile)this._rmiFile.getRemote();
        if (file == null) {
            throw new IOException("RmiFile is Null");
        }
        if (this._socket != null) {
            try {
                this._socket.close();
                this._socket = null;
            }
            catch (IOException ioe) {
                System.out.println(this.getName() + ".close: IOExeption on Socket close " + ioe);
            }
        }
        try {
            if (file.closeAndUnlock(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
                this._fileLock = null;
            }
            this._unzippedByteArray = null;
        }
        catch (RemoteException re) {
            System.out.println(this.getName() + ".close: rmi exception " + re);
            throw new IOException("RemoteException on RmiFile.close() " + re);
        }
    }

    public long getCheckSum() {
        if (this._local) {
            System.out.println("getCheckSum: not available in local mode");
            return -1L;
        }
        RmiFile file = (RmiFile)this._rmiFile.getRemote();
        if (file == null) {
            return -1L;
        }
        try {
            if (!this.getLock(3)) {
                return -1L;
            }
            long chkSum = file.getCheckSum();
            if (this.unlockFile(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
                this._fileLock = null;
            }
            return chkSum;
        }
        catch (RemoteException re) {
            System.out.println(this.getName() + ".getCheckSum: rmi exception " + re);
            return -1L;
        }
    }

    public boolean isNetworked() {
        return !this._local;
    }

    public boolean lockFile(FileLock fLock) {
        if (this._local) {
            return true;
        }
        if (this._rmiFile == null) {
            return false;
        }
        try {
            if (_lockDebug) {
                System.out.println(this.getName() + ".lockFile: attempting lock " + fLock);
            }
            RmiFile file = (RmiFile)this._rmiFile.getRemote();
            boolean locked = false;
            for (int retryCnt = 0; !locked && retryCnt < _retryMax; ++retryCnt) {
                locked = file.addLock(fLock);
                if (!locked) {
                    if (_lockDebug) {
                        System.out.println(this.getName() + ".lockFile: lock failed. retrying...");
                    }
                    try {
                        Thread.currentThread();
                        Thread.sleep(_retrySleepAmt);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
                if (_lockDebug) {
                    System.out.println(this.getName() + ".lockFile: got lock " + fLock);
                }
                return locked;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        if (_lockDebug) {
            System.out.println(this.getName() + ".lockFile: failed to get " + fLock);
        }
        return false;
    }

    public boolean unlockFile(FileLock fLock) {
        if (this._local) {
            return true;
        }
        if (this._rmiFile == null) {
            return false;
        }
        try {
            RmiFile file = (RmiFile)this._rmiFile.getRemote();
            if (_lockDebug) {
                System.out.println(this.getName() + ".unlockFile: unlocking " + fLock);
            }
            return file.unlock(fLock);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    protected boolean getLock(int lockType) {
        FileLock newLock;
        boolean locked;
        if (_lockDebug) {
            System.out.println(this.getName() + ".getLock: type=" + FileLock.getLockTypeString((int)lockType));
        }
        if (this._fileLock != null && this.unlockFile(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
            this._fileLock = null;
        }
        if (locked = this.lockFile(newLock = new FileLock(this._clientUserId, lockType))) {
            this._fileLock = newLock;
        } else {
            System.out.println(this.getName() + " failed to get Lock " + newLock);
        }
        return locked;
    }

    public void setUseCompression(boolean compress) {
        this._usingCompression = compress;
    }

    public boolean getUsingCompression() {
        return this._usingCompression;
    }

    private synchronized byte[] unzip(byte[] zipped) {
        if (zipped == null || zipped.length == 0) {
            return zipped;
        }
        if (this._unzippedByteArray == null) {
            this._unzippedByteArray = new byte[_readBufferSize];
        }
        Inflater _inflater = new Inflater();
        _inflater.setInput(zipped);
        int totalOut = 0;
        try {
            totalOut = _inflater.inflate(this._unzippedByteArray);
        }
        catch (DataFormatException dfe) {
            System.out.println("unzip: error unzipping: " + dfe);
            _inflater.end();
            return null;
        }
        _inflater.end();
        byte[] newUnZipped = new byte[totalOut];
        System.arraycopy(this._unzippedByteArray, 0, newUnZipped, 0, totalOut);
        return newUnZipped;
    }

    protected synchronized byte[] zip(byte[] unzipped) {
        if (unzipped == null || unzipped.length == 0) {
            return unzipped;
        }
        Deflater deflater = new Deflater(1);
        deflater.setInput(unzipped);
        deflater.finish();
        if (this._unzippedByteArray == null) {
            this._unzippedByteArray = new byte[_readBufferSize];
        }
        int deflateCnt = deflater.deflate(this._unzippedByteArray);
        byte[] actualDeflated = new byte[deflateCnt];
        System.arraycopy(this._unzippedByteArray, 0, actualDeflated, 0, deflateCnt);
        deflater.end();
        return actualDeflated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeBytes(long bytePos, byte[] bytes) {
        if (this._local) {
            try {
                RandomAccessFile raf = new RandomAccessFile(this, "rw");
                raf.seek(bytePos);
                raf.write(bytes, 0, bytes.length);
            }
            catch (Exception e) {
                System.out.println(this.getName() + ".writeFloat: exception " + e);
            }
        } else {
            RmiFile file = (RmiFile)this._rmiFile.getRemote();
            if (file == null) {
                return;
            }
            try {
                if (!this.getLock(4)) {
                    return;
                }
                file.writeBytes(bytePos, bytes);
                return;
            }
            catch (Exception e) {
                System.out.println(this.getName() + ".writeFloat: server exception " + e);
                return;
            }
            finally {
                if (this.unlockFile(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
                    this._fileLock = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeFloat(long bytePos, float f) {
        if (this._local) {
            try {
                RandomAccessFile raf = new RandomAccessFile(this, "rw");
                raf.seek(bytePos);
                raf.writeFloat(f);
            }
            catch (Exception e) {
                System.out.println(this.getName() + ".writeFloat: exception " + e);
            }
        } else {
            RmiFile file = (RmiFile)this._rmiFile.getRemote();
            if (file == null) {
                return;
            }
            try {
                if (!this.getLock(4)) {
                    return;
                }
                file.writeFloat(bytePos, f);
                return;
            }
            catch (Exception e) {
                System.out.println(this.getName() + ".writeFloat: server exception " + e);
                return;
            }
            finally {
                if (this.unlockFile(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
                    this._fileLock = null;
                }
            }
        }
    }

    public String getCachedFilename() {
        if (!ClientAppCheck.haveClientApp()) {
            return null;
        }
        if (this._local) {
            return this.getPath();
        }
        return null;
    }

    @Deprecated
    public void addFileToCacheList() {
    }

    @Deprecated
    public boolean isFileCached() {
        return false;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this._cacheLocalFile = _useFileCaching;
    }

    public static void setCachingEnabled(boolean b) {
        _useFileCaching = b;
    }

    static {
        String bufSize = System.getProperty("hecfile.bufsize", "32768");
        _readBufferSize = RMAIO.parseInt((String)bufSize, (int)32768);
        String retrys = System.getProperty("hecfile.retryMax", "3");
        _retryMax = RMAIO.parseInt((String)retrys, (int)_retryMax);
        _lockDebug = Boolean.getBoolean("hec.io.FileLock.debug");
        String sleepTime = System.getProperty("hecfile.retrySleepAmount", "" + _retrySleepAmt);
        _retrySleepAmt = RMAIO.parseLong((String)sleepTime, (long)_retrySleepAmt);
        _useFileCaching = Boolean.getBoolean("hec.io.HecFile.useFileCaching");
        if (_useFileCaching) {
            ((MarkingClassLogger.Api)FILE_CACHING_LOGGER.atFine()).log("****File Caching is on");
        }
    }
}

