/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.io;

import hec.model.UserInterface;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.rmi.RemoteException;
import mil.army.usace.hec.rmi.csinterface.RmiProgress;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import rma.util.RMAIO;

public class RunProcess {
    private String _cmdLine;
    private boolean _waitForProcess;
    private UserInterface _userInterface;
    private RemoteWrapper _uiWrapper;

    public RunProcess(String cmdLine) {
        this(cmdLine, true);
    }

    public RunProcess(String cmdLine, boolean waitForProcess) {
        this._cmdLine = cmdLine;
        this._waitForProcess = waitForProcess;
    }

    public void setUserInterface(RemoteWrapper uiWrapper) {
        this._uiWrapper = uiWrapper;
    }

    public void setUserInterface(UserInterface ui) {
        this._userInterface = ui;
    }

    public int execute() {
        int os = RMAIO.getOSType();
        Object cmd = null;
        if (os == 0) {
            cmd = this._cmdLine.replace('/', File.separatorChar);
            if (!((String)cmd).startsWith("start ")) {
                cmd = "cmd /c " + (String)cmd;
            }
            System.out.println("exec:" + this._cmdLine);
            return this.exec((String)cmd);
        }
        if (os == 2) {
            cmd = this._cmdLine.replace('\\', File.separatorChar);
            System.out.println("exec:" + this._cmdLine);
            return this.exec((String)cmd);
        }
        if (os == 1) {
            cmd = this._cmdLine.replace('/', File.separatorChar);
            String[] cmdLine = new String[]{"start", "/wait", cmd};
            System.out.println("exec: " + cmdLine);
            return this.exec(cmdLine);
        }
        System.out.println("Unknown OS Type " + os);
        return -1;
    }

    private int exec(String[] cmdline) {
        Runtime rt = Runtime.getRuntime();
        try {
            Process proc = rt.exec(cmdline);
            return this.waitForProcess(proc);
        }
        catch (IOException ioe) {
            this.printErrorMessage("Exec failed " + ioe);
            return -3;
        }
    }

    private int exec(String cmdline) {
        Runtime rt = Runtime.getRuntime();
        try {
            Process proc = rt.exec(cmdline);
            return this.waitForProcess(proc);
        }
        catch (IOException ioe) {
            this.printErrorMessage("Exec (" + cmdline + ") failed " + ioe);
            return -3;
        }
    }

    private int waitForProcess(Process proc) {
        if (proc == null) {
            return -1;
        }
        if (!this._waitForProcess) {
            return 0;
        }
        try {
            ReaderThread inThread = new ReaderThread(proc.getInputStream(), false);
            ReaderThread errThread = new ReaderThread(proc.getErrorStream(), true);
            inThread.start();
            errThread.start();
            proc.waitFor();
            int istatus = proc.exitValue();
            System.out.println(" Process status = " + Integer.toString(istatus));
            return istatus;
        }
        catch (InterruptedException e) {
            System.out.println(e);
            return -2;
        }
    }

    protected void printErrorMessage(String msg) {
        if (this._userInterface == null) {
            if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
                System.out.println("ERROR " + msg + "\n");
            } else {
                try {
                    ((RmiProgress)this._uiWrapper.getRemote()).printErrorMessage(msg);
                }
                catch (RemoteException re) {
                    System.out.println("ERROR " + msg + "\n");
                }
            }
        } else {
            this._userInterface.printMessage("ERROR " + msg + "\n");
        }
    }

    protected void printMessage(String msg) {
        if (this._userInterface == null) {
            if (this._uiWrapper == null || this._uiWrapper.getRemote() == null || !(this._uiWrapper.getRemote() instanceof RmiProgress)) {
                System.out.println(msg + "\n");
            } else {
                try {
                    ((RmiProgress)this._uiWrapper.getRemote()).printMessage(msg);
                }
                catch (RemoteException re) {
                    System.out.println(msg + "\n");
                }
            }
        } else {
            this._userInterface.printMessage(msg + "\n");
        }
    }

    public static void main(String[] args) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < args.length; ++i) {
            buf.append(args[i]);
            buf.append(" ");
        }
        new RunProcess(buf.toString()).execute();
    }

    class ReaderThread
    extends Thread {
        private InputStream _is;
        private boolean _isErrorStream;

        public ReaderThread(InputStream is, boolean isErrorStream) {
            super(isErrorStream ? "ErrorReaderThread" : "InputReaderThread");
            this._is = is;
            this._isErrorStream = isErrorStream;
            super.setPriority(6);
        }

        @Override
        public void run() {
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(this._is));
                while ((line = reader.readLine()) != null) {
                    if (this._isErrorStream) {
                        RunProcess.this.printErrorMessage(line);
                        continue;
                    }
                    RunProcess.this.printMessage(line);
                }
                reader.close();
            }
            catch (IOException ioe) {
                System.out.println("run: IOError reading process output " + ioe);
            }
        }
    }
}

