/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.io.dbf;

import codebase.Code4jni;
import codebase.Data4;
import codebase.Data4jni;
import codebase.Error4;
import codebase.Error4locked;
import codebase.Error4unexpected;
import codebase.Error4unique;
import codebase.Error4usage;
import codebase.Field4deleteFlag;
import codebase.Field4double;
import codebase.Field4stringBuffer;
import com.google.common.flogger.LazyArgs;
import hec.io.AbstractDataStorage;
import hec.io.AsciiSplitFileNameFactory;
import hec.io.CodebaseErrorTable;
import hec.io.FileListener;
import hec.io.FileMonitor;
import hec.io.Identifier;
import hec.io.dbf.AsciiDbfDataStorageHeader;
import hec.lang.LongContainer;
import hec.model.DataObject;
import hec.model.DataStruct;
import hec.model.StreamSegmentIdentifier;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import mil.army.usace.hec.rmi.io.HecAsciiDeserializer;
import mil.army.usace.hec.rmi.io.HecAsciiSerializer;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.DataStorageLoggingMarker;

public class AsciiDBFDataStorage
extends AbstractDataStorage
implements FileListener {
    private static final MarkingClassLogger DATA_STORAGE_LOGGER = MarkingClassLogger.forMarkingClass(DataStorageLoggingMarker.class);
    static final boolean CREATE_THREAD = false;
    protected static Code4jni m_database = null;
    static FileMonitor m_fileMonitor;
    AsciiDbfDataStorageHeader _header = new AsciiDbfDataStorageHeader();
    Data4jni m_dataFile = null;
    Field4double m_objIdField = null;
    Field4stringBuffer m_objNameField = null;
    Field4stringBuffer m_objDescField = null;
    Field4stringBuffer m_objSerializeField = null;
    Field4deleteFlag m_deleteFlag = null;
    Identifier m_id = null;
    File m_file;
    boolean m_hasBeenInitd = false;
    boolean m_createFileInit = false;
    boolean m_dbfFileOpen = false;
    protected String m_objClass = null;
    long m_nextId = 1L;
    HecAsciiDeserializer m_deSerializer;
    HecAsciiSerializer m_Serializer;
    boolean m_recordDeleted = false;
    String _fileName;
    MessageFormat mf = new MessageFormat("Time To {0} = {1}");
    private Hashtable m_addbuffer = null;
    private Hashtable m_deleteBuffer = null;
    Object _idLock = new Object();
    public static boolean DEBUG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsciiDBFDataStorage() {
        if (m_database == null) {
            try {
                try {
                    m_database = new Code4jni();
                }
                catch (UnsatisfiedLinkError ule) {
                    String property = System.getProperty("java.library.path");
                    Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, ule.getMessage() + ":" + property, ule);
                    return;
                }
                Code4jni ule = m_database;
                synchronized (ule) {
                    try {
                        if (Boolean.getBoolean("Codebase.readonly")) {
                            m_database.accessMode((byte)2);
                        } else {
                            m_database.accessMode((byte)0);
                        }
                    }
                    catch (Error4usage e) {
                        System.out.println("Error4usage " + e);
                        e.printStackTrace();
                    }
                }
            }
            catch (IOException e) {
                System.out.println("Critical Error trying to open the database");
                System.out.println(e.getMessage());
            }
        }
    }

    public AsciiDBFDataStorage(String workspacePath, String clsType) {
        this();
        this.setup(workspacePath, clsType);
    }

    protected void setup(String wkspPath, String clsType) {
        this.m_addbuffer = new Hashtable();
        this.m_deleteBuffer = new Hashtable();
        this._fileName = AsciiSplitFileNameFactory.getFileNameforClass((String)clsType);
        if (this._fileName == null) {
            System.out.println("AsciiSplitDataStorage.<init>: failed to get filename for " + clsType);
            return;
        }
        this._fileName = wkspPath + "/" + this._fileName;
        this.m_objClass = clsType;
        int index = -1;
        index = this._fileName.lastIndexOf(46);
        if (index >= 0) {
            this._fileName = this._fileName.substring(0, index);
        }
        this._fileName = this._fileName + ".dbf";
        this.m_id = new Identifier(this._fileName);
        this.m_deSerializer = new HecAsciiDeserializer(new BufferedReader(new StringReader("")));
        this.m_deSerializer.addClassMapping("hec.watershed.model.StreamSegmentIdentifier", StreamSegmentIdentifier.class.getName());
        this.m_Serializer = new HecAsciiSerializer(new BufferedWriter(new StringWriter()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean init() {
        if (this.m_hasBeenInitd) {
            return this.m_hasBeenInitd;
        }
        if (this.m_id == null) {
            System.out.println("AsciiDBFDataStorage.init: Error no id. can't init");
            return false;
        }
        Identifier identifier = this.m_id;
        synchronized (identifier) {
            try {
                ((MarkingClassLogger.Api)DATA_STORAGE_LOGGER.atFine()).log("OPENING DBF FILE %s", (Object)LazyArgs.lazy(() -> this.m_id != null ? " - " + this.m_id.getPath() : ""));
                if (RMAIO.getOSType() == 1 || RMAIO.getOSType() == 0) {
                    this.m_id.setPath(this.m_id.getPath().replace('/', '\\'));
                }
                this.m_file = new File(this.m_id.getPath());
                this.m_hasBeenInitd = this.m_file.exists() ? this.openExistingFile(m_database, this.m_id.getPath()) : this.openNewFile(m_database, this.m_id.getPath());
                if (Boolean.getBoolean("Codebase.MonitorFile")) {
                    ((MarkingClassLogger.Api)DATA_STORAGE_LOGGER.atFine()).log("****Adding monitor for %s", (Object)this.m_file.getPath());
                    m_fileMonitor.removeListener(this.m_file, (FileListener)this);
                    m_fileMonitor.addFile(this.m_file, (FileListener)this);
                }
            }
            catch (Exception e) {
                System.out.println("init(" + this.m_id.getPath() + "): ERROR:" + e.getMessage());
                e.printStackTrace(System.out);
                return false;
            }
        }
        return this.m_hasBeenInitd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openExistingFile(Code4jni database, String path) {
        try {
            Code4jni code4jni = m_database;
            synchronized (code4jni) {
                this.m_dataFile = new Data4jni(database, this.m_id.getPath());
            }
        }
        catch (Exception e) {
            System.out.println("AsciiDBFDataStorage.openExistingFile(" + path + "): ERROR:" + e.getMessage() + " Error Code = (" + m_database.getLastError() + ") - " + CodebaseErrorTable.getErrorCodeString((int)m_database.getLastError()));
            e.printStackTrace(System.out);
            return false;
        }
        this.m_dbfFileOpen = true;
        return this.initializeDataVariables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean openNewFile(Code4jni database, String path) {
        try {
            File file = new File(path);
            File parent = file.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                System.out.println("AsciiDBFDataStorage.openNewFile(" + this.m_id.getPath() + "): Cannot create parent directory structure.");
                return false;
            }
            Code4jni code4jni = m_database;
            synchronized (code4jni) {
                this.m_dataFile = new Data4jni(m_database);
                this.m_dataFile.create(this.m_id.getPath(), this._header.getField4infoContainer().getField4info(), this._header.getTag4infoContainer().getTag4info());
            }
        }
        catch (Exception e) {
            System.out.println("AsciiDBFDataStorage.openNewFile(" + path + "): ERROR:" + e.getMessage() + " Error Code = (" + m_database.getLastError() + ") - " + CodebaseErrorTable.getErrorCodeString((int)m_database.getLastError()));
            e.printStackTrace(System.out);
            return false;
        }
        this.m_dbfFileOpen = true;
        return this.initializeDataVariables();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initializeDataVariables() {
        if (!this.mapFields()) {
            return false;
        }
        try {
            Code4jni code4jni = m_database;
            synchronized (code4jni) {
                long nextId;
                this.m_dataFile.select("TAG_ID");
                this.m_dataFile.bottom();
                if (this.m_dataFile.recCount() != 0 && this.m_nextId < (nextId = this.m_objIdField.get().longValue() + 1L)) {
                    this.m_nextId = nextId;
                }
                this.m_dataFile.top();
            }
        }
        catch (Exception e) {
            System.out.println("AsciiDBFDataStorage.init(" + this.m_id.getPath() + ") : ERROR computing the next ID value.");
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDataFileInit() {
        try {
            long t1 = System.currentTimeMillis();
            Code4jni code4jni = m_database;
            synchronized (code4jni) {
                this.m_dataFile = new Data4jni(m_database);
                this.m_dataFile.create(this.m_id.getPath(), this._header.getField4infoContainer().getField4info(), this._header.getTag4infoContainer().getTag4info());
            }
            long t2 = System.currentTimeMillis();
            System.out.println(this.mf.format(new Object[]{"Create file " + this.m_id.getPath(), new Long(t2 - t1)}));
        }
        catch (Exception e) {
            System.out.println("createDataFileInit(" + this.m_id.getPath() + ") ERROR:" + e.getMessage());
            e.printStackTrace(System.out);
            return false;
        }
        if (!this.mapFields()) {
            return false;
        }
        this.m_createFileInit = false;
        this.m_hasBeenInitd = true;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean mapFields() {
        try {
            Code4jni code4jni = m_database;
            synchronized (code4jni) {
                this.m_objIdField = new Field4double((Data4)this.m_dataFile, "F_ID");
                this.m_objNameField = new Field4stringBuffer((Data4)this.m_dataFile, "F_NAME");
                this.m_objDescField = new Field4stringBuffer((Data4)this.m_dataFile, "F_DESC");
                this.m_objSerializeField = new Field4stringBuffer((Data4)this.m_dataFile, "F_OBJ");
                this.m_deleteFlag = new Field4deleteFlag((Data4)this.m_dataFile);
            }
        }
        catch (Exception e) {
            System.out.println("AsciiDBFDataStorage.mapFields(" + this.m_id.getPath() + ") ERROR: " + e.getMessage());
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long nextId() {
        Object object = this._idLock;
        synchronized (object) {
            long currentId = this.m_nextId++;
            this._idLock.notifyAll();
            return currentId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int numberRecords() {
        if (!this.m_hasBeenInitd) {
            return 0;
        }
        try {
            Code4jni code4jni = m_database;
            synchronized (code4jni) {
                this.m_dataFile.bottom();
                int recCount = this.m_dataFile.recCount();
                this.m_dataFile.top();
                return recCount;
            }
        }
        catch (Exception e) {
            System.out.println("numberRecords(" + this.m_id.getPath() + ") ERROR: Trying to count records");
            System.out.println(e.getMessage());
            return 0;
        }
    }

    public Object[] getDataObjectIdList(String objClass) {
        try {
            Class<?> cls = Class.forName(objClass);
        }
        catch (ClassNotFoundException cfe) {
            System.out.println("AsciiDataStorage.getDataObjectIdList(" + this.m_id.getPath() + "): can't find class " + objClass + " " + cfe);
            return null;
        }
        return this.getObjectList(objClass);
    }

    public synchronized DataStruct[] getObjectList(String objClass) {
        if (!this.m_hasBeenInitd && !this.init()) {
            return new DataStruct[0];
        }
        try {
            DataStruct[] dataStructArray = this.getObjectListLocked(objClass);
            return dataStructArray;
        }
        finally {
            this.closeDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataStruct[] getObjectListLocked(String objClass) {
        if (!this.m_hasBeenInitd) {
            return new DataStruct[0];
        }
        DataStruct[] objs = new DataStruct[this.numberRecords()];
        try {
            Code4jni code4jni = m_database;
            synchronized (code4jni) {
                this.m_dataFile.select("TAG_ID");
            }
        }
        catch (Exception e4) {
            System.out.println("ERROR AsciiDBFDataStorage.getObjectList(" + this.m_id.getPath() + ") : Error selecting ID tag - " + e4.getMessage());
            e4.printStackTrace(System.out);
        }
        int i = 0;
        try {
            Code4jni code4jni = m_database;
            synchronized (code4jni) {
                LongContainer longCont = new LongContainer();
                int rc = this.m_dataFile.top();
                while (rc == 0) {
                    try {
                        DataStruct dataObj = (DataStruct)this.loadCurrentRecord(objClass);
                        longCont._value = dataObj.getId();
                        if (this.m_deleteBuffer.get(longCont) == null) {
                            objs[i] = dataObj;
                            ++i;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    rc = this.m_dataFile.skip(1);
                }
            }
            return objs;
        }
        catch (Exception e) {
            System.out.println("getObjectList(" + this.m_id.getPath() + ") ERROR: Trying to load object list");
            System.out.println(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object loadObject(String name, String objClass) {
        DataObject dObj;
        if (name == null) {
            return null;
        }
        Enumeration enumeration = this.m_deleteBuffer.elements();
        while (enumeration != null && enumeration.hasMoreElements()) {
            dObj = (DataObject)enumeration.nextElement();
            if (dObj == null || !dObj.getName().equals(name)) continue;
            return null;
        }
        enumeration = this.m_addbuffer.elements();
        while (enumeration != null && enumeration.hasMoreElements()) {
            dObj = (DataObject)enumeration.nextElement();
            if (dObj == null || !dObj.getName().equals(name)) continue;
            return dObj;
        }
        if (!this.m_hasBeenInitd && !this.init()) {
            return null;
        }
        try {
            Object object;
            if (!this.findObjectLocked("TAG_NAME", name.toUpperCase())) {
                object = null;
                return object;
            }
            object = this.loadCurrentRecord(objClass);
            return object;
        }
        finally {
            this.closeDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Object loadObject(long id, String objClass) {
        if (this.m_deleteBuffer.get(new LongContainer(id)) != null) {
            return null;
        }
        LongContainer lc = new LongContainer(id);
        if (this.m_addbuffer.get(lc) != null) {
            return this.m_addbuffer.get(lc);
        }
        if (!this.m_hasBeenInitd && !this.init()) {
            return null;
        }
        try {
            if (!this.findObjectLocked("TAG_ID", Long.toString(id))) {
                Object var5_4 = null;
                return var5_4;
            }
            Object object = this.loadCurrentRecord(objClass);
            return object;
        }
        finally {
            this.closeDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadPartialCurrentRecord(String objClass) {
        if (!this.m_hasBeenInitd) {
            return null;
        }
        DataObject dObj = null;
        try {
            Code4jni code4jni = m_database;
            synchronized (code4jni) {
                dObj = (DataObject)Class.forName(objClass).newInstance();
                dObj.setId(this.m_objIdField.get().longValue());
                dObj.setName(this.m_objNameField.get().toString());
                dObj.setDescription(this.m_objDescField.get().toString());
            }
            return dObj;
        }
        catch (Error4 e) {
            System.out.println("ERROR AsciiDBFDataStorage.loadPartialCurrentRecord(" + this.m_id.getPath() + ") : Database Error " + e.getMessage());
            return null;
        }
        catch (Exception cnfe) {
            System.out.println("ERROR <AsciiDBFDataStorage.loadPartialCurrentRecord(" + this.m_id.getPath() + ")> : class " + objClass + " does not exist. Returning NULL!");
            return null;
        }
    }

    private Object loadCurrentRecord(String objClass) {
        if (!this.m_hasBeenInitd) {
            return null;
        }
        try {
            StringReader strReader = new StringReader(this.m_objSerializeField.get().toString());
            BufferedReader bufReader = new BufferedReader(strReader);
            this.m_deSerializer.reset(bufReader);
        }
        catch (Exception e) {
            System.out.println("ERROR <AsciiDataStorage.loadObject(" + this.m_id.getPath() + ")> : Unable to get serialize object from data base -  " + e.getMessage());
            return null;
        }
        Object obj = null;
        try {
            obj = Class.forName(objClass).newInstance();
            this.m_deSerializer.deserializeObject(obj);
            this.m_deSerializer.clear();
        }
        catch (ClassNotFoundException e) {
            System.out.println("ERROR <AsciiDataStorage.loadObject(" + this.m_id.getPath() + ")> : Class not Found error for class " + objClass);
            return null;
        }
        catch (Exception e) {
            System.out.println("ERROR <AsciiDataStorage.loadObject(" + this.m_id.getPath() + ")> : " + e.getMessage());
            return null;
        }
        return obj;
    }

    public DataObject addNewObject2(Object obj) {
        if (!(obj instanceof DataObject)) {
            throw new IllegalArgumentException("CANNONT Store a non DataObject in AsciiDBFDataStorage");
        }
        DataObject dataObj = (DataObject)obj;
        long id = this.nextId();
        dataObj.setId(id);
        ((MarkingClassLogger.Api)DATA_STORAGE_LOGGER.atFine()).log("got new object %s id=%s", (Object)dataObj, id);
        this.m_addbuffer.put(new LongContainer(id), dataObj);
        return dataObj;
    }

    public long addNewObject(Object obj) {
        if (!(obj instanceof DataObject)) {
            throw new IllegalArgumentException("CANNONT Store a non DataObject in AsciiDBFDataStorage");
        }
        DataObject dataObj = (DataObject)obj;
        long id = this.nextId();
        dataObj.setId(id);
        ((MarkingClassLogger.Api)DATA_STORAGE_LOGGER.atFine()).log("got new object %s id=%s", (Object)dataObj, id);
        this.m_addbuffer.put(new LongContainer(id), dataObj);
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean save() {
        Object[] keys = this.m_addbuffer.keySet().toArray();
        boolean success = true;
        if (!this.m_hasBeenInitd && !this.init()) {
            return false;
        }
        try {
            boolean tf;
            int ii;
            for (ii = 0; ii < keys.length; ++ii) {
                Object dObj = this.m_addbuffer.get(keys[ii]);
                if (dObj == null) continue;
                ((MarkingClassLogger.Api)DATA_STORAGE_LOGGER.atFine()).log("saving new object %s", dObj);
                tf = this.storeObjectLocked(dObj);
                if (tf) {
                    this.m_addbuffer.remove(keys[ii]);
                }
                success &= tf;
            }
            keys = this.m_deleteBuffer.keySet().toArray();
            for (ii = 0; ii < keys.length; ++ii) {
                DataObject dobj = (DataObject)this.m_deleteBuffer.get(keys[ii]);
                if (dobj == null) continue;
                ((MarkingClassLogger.Api)DATA_STORAGE_LOGGER.atFine()).log("removing object %s id=%s", (Object)dobj, (Object)LazyArgs.lazy(() -> dobj.getId()));
                tf = this.removeRecordLocked(dobj.getId(), this.m_objClass);
                if (tf) {
                    this.m_deleteBuffer.remove(keys[ii]);
                }
                success &= tf;
            }
            boolean bl = success;
            return bl;
        }
        finally {
            this.closeDatabase();
        }
    }

    public synchronized boolean storeObject(Object obj) {
        if (!this.m_hasBeenInitd && !this.init()) {
            return true;
        }
        try {
            boolean bl = this.storeObjectLocked(obj);
            return bl;
        }
        finally {
            this.closeDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean storeObjectLocked(Object obj) {
        if (!(obj instanceof DataObject)) {
            throw new IllegalArgumentException("CANNONT Store a non DataObject in AsciiDBFDataStorage");
        }
        DataObject dObj = (DataObject)obj;
        String idStr = Long.toString(dObj.getId());
        boolean objExists = this.findObjectLocked("TAG_ID", idStr);
        ((MarkingClassLogger.Api)DATA_STORAGE_LOGGER.atFine()).log("storing %s id=%s objExists=%s", (Object)dObj, (Object)idStr, (Object)objExists);
        try {
            Code4jni code4jni = m_database;
            synchronized (code4jni) {
                this.m_objIdField.set(new Double(idStr));
                this.m_objNameField.set(new StringBuffer(dObj.getName()));
                String desc = dObj.getDescription();
                if (desc != null) {
                    this.m_objDescField.set(new StringBuffer(desc));
                } else {
                    this.m_objDescField.set(new StringBuffer());
                }
                StringWriter strWriter = new StringWriter();
                BufferedWriter buffWriter = new BufferedWriter(strWriter);
                this.m_Serializer.reset(buffWriter);
                this.m_Serializer.serializeObject(dObj);
                buffWriter.flush();
                this.m_objSerializeField.set(strWriter.getBuffer());
                if (objExists) {
                    this.m_dataFile.update();
                } else {
                    this.m_addbuffer.remove(new LongContainer(dObj.getId()));
                    this.m_dataFile.append();
                }
            }
            m_fileMonitor.updateLastModified(this.m_file, System.currentTimeMillis());
        }
        catch (Error4unique e4unique) {
            System.out.println("ERROR <AsciiDBFDataStorage.storeObject(" + this.m_id.getPath() + ")> : Unique key constraint is violated in DBFDataStorage.storeObject()");
            System.out.println("ERROR Occured for object (" + dObj.getId() + ") - " + dObj.getName());
            System.out.println(e4unique.getMessage());
            return false;
        }
        catch (Exception e) {
            System.out.println("ERROR <AsciiDBFDataStorage.storeObject(" + this.m_id.getPath() + ")> : Fatal Error Saving Data");
            System.out.println("ERROR Occured for object (" + dObj.getId() + ") - " + dObj.getName());
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean findObject(String tag, String key) {
        if (!this.m_hasBeenInitd && !this.init()) {
            return true;
        }
        try {
            boolean bl = this.findObjectLocked(tag, key);
            return bl;
        }
        finally {
            this.closeDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findObjectLocked(String tag, String key) {
        if (!this.m_hasBeenInitd) {
            return false;
        }
        try {
            Code4jni code4jni = m_database;
            synchronized (code4jni) {
                this.m_dataFile.select(tag);
                this.m_dataFile.top();
                if (this.m_dataFile.seek(key) != 0) {
                    return false;
                }
            }
        }
        catch (Exception e) {
            System.out.println("findObject(" + this.m_id.getPath() + ") Exception when seeking for record. tag=" + tag + " key=" + key);
            System.out.println(CodebaseErrorTable.getErrorCodeString((int)m_database.getLastError()));
            e.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeDatabase() {
        if (!this.m_hasBeenInitd) {
            return;
        }
        if (!this.m_dbfFileOpen) {
            return;
        }
        ((MarkingClassLogger.Api)DATA_STORAGE_LOGGER.atFine()).log("CLOSING DBF FILE %s", (Object)LazyArgs.lazy(() -> this.m_id != null ? " - " + this.m_id.getPath() : ""));
        try {
            Code4jni code4jni = m_database;
            synchronized (code4jni) {
                if (this.m_recordDeleted) {
                    this.m_dataFile.pack();
                    this.m_dataFile.memoCompress();
                    this.m_recordDeleted = false;
                }
                this.m_dataFile.close();
            }
            this.m_dbfFileOpen = false;
            this.m_hasBeenInitd = false;
            m_fileMonitor.updateLastModified(this.m_file, System.currentTimeMillis());
        }
        catch (Error4unexpected e4unex) {
            System.out.println("AsciiDBFDataStorage.workspaceClosing(" + this.m_id.getPath() + "): ERROR:" + e4unex.getMessage() + " Error Code = (" + m_database.getLastError() + ") - " + CodebaseErrorTable.getErrorCodeString((int)m_database.getLastError()));
            e4unex.printStackTrace(System.out);
        }
        catch (Error4usage e4usage) {
            e4usage.printStackTrace(System.out);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public synchronized void workspaceClosing() {
        this.closeDatabase();
    }

    public boolean removeObject(long objId, String objClass) {
        LongContainer lc = new LongContainer(objId);
        Object obj = this.loadObject(objId, this.m_objClass);
        if (obj != null) {
            this.m_deleteBuffer.put(lc, obj);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized boolean removeRecord(long objId, String objClass) {
        if (!this.m_hasBeenInitd && !this.init()) {
            return false;
        }
        try {
            boolean bl = this.removeRecordLocked(objId, objClass);
            return bl;
        }
        finally {
            this.closeDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean removeRecordLocked(long objId, String objClass) {
        if (!this.m_hasBeenInitd) {
            return true;
        }
        if (!this.findObjectLocked("TAG_ID", Long.toString(objId))) {
            System.out.println("removeRecord(" + this.m_id.getPath() + ") Data Object " + objClass + " with id=" + objId + " was not found!");
            return false;
        }
        try {
            Code4jni code4jni = m_database;
            synchronized (code4jni) {
                this.m_deleteFlag.set(true);
                this.m_dataFile.update();
            }
            this.m_recordDeleted = true;
        }
        catch (Exception eMsg) {
            System.out.println("ERROR <AsciiDBFDataStorage.removeObject(" + this.m_id.getPath() + ")> : An error occurred when removeing object " + objClass + " width id=" + objId);
            System.out.println(eMsg.getMessage());
            eMsg.printStackTrace(System.out);
            return false;
        }
        return true;
    }

    public boolean reload() {
        this.m_addbuffer.clear();
        this.m_deleteBuffer.clear();
        return true;
    }

    public static void main(String[] args) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                DEBUG = true;
                AsciiDBFDataStorage dbfDataStorage = new AsciiDBFDataStorage(null, "hec.watershed.model.ComputationPoint");
                dbfDataStorage.init();
                System.exit(0);
            }
        };
        SwingUtilities.invokeLater(run);
    }

    public String getFilename() {
        return this._fileName;
    }

    public File getFile() {
        return this.m_file;
    }

    public void fileChanged(File file) {
        System.out.println("AsciiDBFDataStorage.fileChanged(" + this.m_objClass + "):" + file);
        System.out.println("fileChanged:no reload occurred");
    }

    public void compress() {
        try {
            this.m_dataFile.pack();
            this.m_dataFile.memoCompress();
        }
        catch (Error4usage ex) {
            Logger.getLogger(AsciiDBFDataStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Error4unexpected ex) {
            Logger.getLogger(AsciiDBFDataStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Error4locked ex) {
            Logger.getLogger(AsciiDBFDataStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (Error4unique ex) {
            Logger.getLogger(AsciiDBFDataStorage.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public long getnextId() {
        return this.m_nextId++;
    }

    static {
        Long pollInterval = Long.getLong("Codebase.FileMonitorInterval", 30000L);
        m_fileMonitor = new FileMonitor(pollInterval.longValue());
        DEBUG = false;
    }
}

