/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.io.dbf;

import codebase.Error4;
import com.google.common.flogger.FluentLogger;
import hec.io.EndianInputStream;
import hec.io.EndianOutputStream;
import hec.io.FileLock;
import hec.io.FilePath;
import hec.io.dbf.DBFHeader;
import hec.io.dbf.DbfQueryResultSet;
import hec.io.dbf.DbfRecordIndexSet;
import hec.io.dbf.DbfRecordQuery;
import hec.io.dbf.DbfRecordSet;
import hec.io.dbf.DbfResultSet;
import hec.io.dbf.DbfUtil;
import hec.io.dbf.DbfWriteResultSet;
import hec.io.dbf.Tag4infoContainer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import mil.army.usace.hec.rmi.csinterface.RmiDbfFile;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import mil.army.usace.hec.rmi.server.RemoteWrapper;

public class DbfFile
extends HecFileImpl
implements Serializable {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    static final long serialVersionUID = -4249333838973072119L;

    public DbfFile(RemoteWrapper rmiDbfFileImpl, String clientUserId) {
        super(rmiDbfFileImpl, clientUserId);
    }

    public DbfFile(FilePath filePath) {
        super(filePath);
    }

    public boolean createDbfFile(DBFHeader header) {
        return this.createDbfFile(header, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean createDbfFile(DBFHeader header, Tag4infoContainer tag4infoContainer) {
        if (this._local) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("DBF File Creation not supported in Local mode!");
            return false;
        }
        if (!this.getLock(4)) {
            return false;
        }
        RmiDbfFile file = (RmiDbfFile)this._rmiFile.getRemote();
        try {
            file.createDbfFile(header, tag4infoContainer);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)re)).log("createDbfFile: RMI Error creating file.");
        }
        catch (IOException ioe) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)ioe)).log("createDbfFile: IOException creating file.");
        }
        catch (Error4 e4) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e4)).log("createDbfFile: Error4 creating file. May be caused by dbt or mdx file already being present.");
        }
        finally {
            if (this.unlockFile(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
                this._fileLock = null;
            }
        }
        return false;
    }

    public boolean createIndex(String indexFileName, Tag4infoContainer tagContainer) {
        if (this._local) {
            return false;
        }
        if (!this.getLock(6)) {
            return false;
        }
        RmiDbfFile file = (RmiDbfFile)this._rmiFile.getRemote();
        try {
            file.createIndex(indexFileName, tagContainer);
        }
        catch (RemoteException re) {
            System.out.println("createIndex: RMI Error creating index. " + re);
        }
        catch (Error4 e4) {
            System.out.println("createIndex: Error4 creating index. " + e4);
        }
        catch (IOException ioe) {
            System.out.println("createIndex: IOException creating index. " + ioe);
        }
        if (this.unlockFile(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
            this._fileLock = null;
        }
        return true;
    }

    public void setSaftey(boolean tf) {
        if (this._local) {
            return;
        }
        if (!this.getLock(6)) {
            return;
        }
        RmiDbfFile file = (RmiDbfFile)this._rmiFile.getRemote();
        try {
            file.setSafety(tf);
        }
        catch (RemoteException re) {
            System.out.println("Error setting codebase safety. " + re);
        }
    }

    public boolean getSafety() {
        if (this._local) {
            return false;
        }
        RmiDbfFile file = (RmiDbfFile)this._rmiFile.getRemote();
        try {
            return file.getSafety();
        }
        catch (RemoteException re) {
            System.out.println("Error getting codebase safety. " + re);
            return false;
        }
    }

    public void setAccessMode(byte b) {
        if (this._local) {
            return;
        }
        if (!this.getLock(6)) {
            return;
        }
        RmiDbfFile file = (RmiDbfFile)this._rmiFile.getRemote();
        try {
            file.setAccessMode(b);
        }
        catch (RemoteException re) {
            System.out.println("Error setting codebase safety. " + re);
        }
        catch (Error4 e4) {
            System.out.println("Error setting codebase safety. " + e4);
        }
    }

    public byte getAccessMode() {
        if (this._local) {
            return 1;
        }
        RmiDbfFile file = (RmiDbfFile)this._rmiFile.getRemote();
        try {
            return file.getAccessMode();
        }
        catch (RemoteException re) {
            System.out.println("Error getting codebase safety. " + re);
            return 1;
        }
    }

    public DbfResultSet deleteRecords(DbfRecordIndexSet recordIndexSet) {
        if (this._local) {
            return null;
        }
        try {
            if (!this.getLock(4)) {
                return null;
            }
            RmiDbfFile file = (RmiDbfFile)this._rmiFile.getRemote();
            DbfResultSet resultSet = file.deleteRecords(recordIndexSet);
            if (this.unlockFile(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
                this._fileLock = null;
            }
            return resultSet;
        }
        catch (Exception e) {
            System.out.println("Error trying to read DBF records. " + e);
            e.printStackTrace();
            return null;
        }
    }

    public DbfQueryResultSet queryRecords(DbfRecordQuery query) {
        if (this._local) {
            return null;
        }
        try {
            if (!this.getLock(3)) {
                return null;
            }
            RmiDbfFile file = (RmiDbfFile)this._rmiFile.getRemote();
            DbfQueryResultSet resultSet = file.queryRecords(query);
            if (this.unlockFile(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
                this._fileLock = null;
            }
            return resultSet;
        }
        catch (Exception e) {
            System.out.println("Error trying to read DBF records. " + e);
            e.printStackTrace();
            return null;
        }
    }

    public boolean pack() {
        if (this._local) {
            return false;
        }
        try {
            if (!this.getLock(4)) {
                return false;
            }
            RmiDbfFile file = (RmiDbfFile)this._rmiFile.getRemote();
            file.pack();
            if (this.unlockFile(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
                this._fileLock = null;
            }
            return true;
        }
        catch (Exception e) {
            System.out.println("Error trying to pack DBF records. " + e);
            e.printStackTrace();
            return false;
        }
    }

    public DbfWriteResultSet writeRecords(DbfRecordSet records) {
        if (this._local) {
            return null;
        }
        try {
            if (!this.getLock(4)) {
                return null;
            }
            RmiDbfFile file = (RmiDbfFile)this._rmiFile.getRemote();
            DbfWriteResultSet resultSet = file.writeRecords(records);
            if (this.unlockFile(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
                this._fileLock = null;
            }
            return resultSet;
        }
        catch (Exception e) {
            System.out.println("Error trying to write DBF records. " + e);
            e.printStackTrace();
            return null;
        }
    }

    public synchronized DBFHeader getHeader() {
        DBFHeader header = null;
        if (this._local) {
            return DbfUtil.readHeader((File)this);
        }
        if (!this.getLock(3)) {
            return null;
        }
        try {
            RmiDbfFile file = (RmiDbfFile)this._rmiFile.remote;
            header = file.getHeader();
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
        if (this.unlockFile(FileLock.getUnlockForLock((FileLock)this._fileLock))) {
            this._fileLock = null;
        }
        return header;
    }

    @Override
    public synchronized EndianInputStream getEndianInputStream() {
        return super.getEndianInputStream();
    }

    @Override
    public synchronized EndianOutputStream getEndianOutputStream() {
        return super.getEndianOutputStream();
    }

    @Override
    public synchronized BufferedWriter getBufferedWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized BufferedWriter getAppendedBufferedWriter() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized DataOutputStream getDataOutputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized DataOutputStream getAppendedDataOutputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized ObjectOutputStream getObjectOutputStream() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized ByteArrayOutputStream getByteArrayOutputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized ByteArrayInputStream getByteArrayInputStream() {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized BufferedReader getBufferedReader() {
        throw new UnsupportedOperationException();
    }
}

