/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.model;

import com.google.common.flogger.LazyArgs;
import hec.io.Identifier;
import hec.lang.PreferencesConstants;
import hec.lang.UserId;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.rmi.RemoteException;
import java.util.Properties;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.PreferencesLoggingMarker;

public class PreferencesManager
implements PreferencesConstants {
    private static final MarkingClassLogger PREFERENCES_LOGGER = MarkingClassLogger.forMarkingClass(PreferencesLoggingMarker.class);
    private static String ALL_DIR = "All";
    private static String CWMS_DIR = "CWMS";
    private static String USERS_DIR = "users";
    private static String PREF_DIR = "preferences";
    private static boolean locationFirst = true;
    private static int FIRST_LOC = 0;
    private static int LAST_LOC = 3;
    private static String _userDir = null;
    private static String _baseDir = null;
    private static String _wkspName = null;
    private static RmiFileManager _fileMgr = null;

    private PreferencesManager() {
    }

    public static void setUserDirectory(String dir) {
        if (_userDir == null) {
            _userDir = dir;
        }
    }

    public static void setCwmsAll(String cwmsAll) {
        ALL_DIR = cwmsAll;
    }

    public static void setCwmsDirl(String cwmsDir) {
        CWMS_DIR = cwmsDir;
    }

    public static void setCwmsUsers(String cwmsUsers) {
        USERS_DIR = cwmsUsers;
    }

    public static void setLocationFirst(boolean locFirst) {
        locationFirst = locFirst;
    }

    public static void setBaseDirectory(String dir) {
        _baseDir = dir != null ? (_userDir != null && _userDir.length() > 0 ? (dir.endsWith("/") || dir.endsWith("\\") ? dir + USERS_DIR : dir + "/" + USERS_DIR) : dir) : USERS_DIR;
        System.setProperty("USERS_DIRECTORY", _baseDir);
        System.setProperty("USER_PREFERENCES", _baseDir + "/" + _userDir);
        System.setProperty("SYSTEM_PREFERENCES", _baseDir + "/CWMS");
    }

    public static void setWorkspaceName(String wkspName) {
        _wkspName = RMAIO.userNameToFileName((String)wkspName);
    }

    public static void setFileManager(RmiFileManager fileManager) {
        _fileMgr = fileManager;
    }

    public static RmiFileManager getFileManager() {
        return _fileMgr;
    }

    public static BufferedWriter getBufferedWriter(int location, String fileName) {
        if (location < FIRST_LOC || location > LAST_LOC) {
            throw new IllegalArgumentException("Invalid Preference Location");
        }
        if (fileName == null || fileName.length() < 1) {
            throw new NullPointerException("FileName is null or empty");
        }
        if (location == 2 || location == 3) {
            throw new IllegalArgumentException("Location can not be in the CWMS area");
        }
        if (location == 0 && _wkspName == null) {
            throw new IllegalStateException("Attempt to save to user watershed directory with no watershed defined");
        }
        if (_fileMgr != null) {
            String absFileName = PreferencesManager.getFileName(location, fileName);
            Identifier id = new Identifier(absFileName);
            try {
                String userId = UserId.getUserId();
                Identifier openId = _fileMgr.openFile(userId, id);
                if (openId == null) {
                    openId = _fileMgr.newFile(userId, id);
                }
                if (openId == null || openId.getFile() == null) {
                    return null;
                }
                return openId.getFile().getBufferedWriter();
            }
            catch (RemoteException re) {
                System.out.println("setUserPreference: RMI Error opening file " + id.getPath() + " with FileManager " + re);
            }
        }
        return null;
    }

    public static BufferedReader getBufferedReader(int location, String fileName) {
        if (location < FIRST_LOC || location > LAST_LOC) {
            throw new IllegalArgumentException("Invalid Preference Location");
        }
        if (fileName == null || fileName.length() < 1) {
            throw new NullPointerException("FileName is null or empty");
        }
        if ((location == 0 || location == 2) && _wkspName == null) {
            throw new IllegalStateException("Attempt to save to watershed directory with no watershed defined");
        }
        if (_fileMgr != null) {
            String absFileName = PreferencesManager.getFileName(location, fileName);
            Identifier id = new Identifier(absFileName);
            try {
                String userId = UserId.getUserId();
                Identifier openId = _fileMgr.openFile(userId, id);
                if (openId == null || openId.getFile() == null) {
                    return null;
                }
                return openId.getFile().getBufferedReader();
            }
            catch (RemoteException re) {
                System.out.println("getPreference: RMI Error opening file " + id.getPath() + " with FileManager " + re);
            }
        }
        return null;
    }

    public static BufferedReader getBufferedReader(String fileName) {
        if (fileName == null || fileName.length() < 1) {
            throw new NullPointerException("FileName is null or empty");
        }
        if (_fileMgr != null) {
            Identifier openId = null;
            String userId = UserId.getUserId();
            int location = FIRST_LOC;
            while (openId == null && location <= LAST_LOC) {
                if ((location == 0 || location == 2) && _wkspName == null) {
                    ++location;
                    continue;
                }
                String absFileName = PreferencesManager.getFileName(location, fileName);
                ((MarkingClassLogger.Api)PREFERENCES_LOGGER.atFine()).log("checking file %s", (Object)absFileName);
                Identifier id = new Identifier(absFileName);
                try {
                    openId = _fileMgr.openFile(userId, id);
                    if (openId == null || openId.getFile() == null) {
                        ++location;
                        continue;
                    }
                    ((MarkingClassLogger.Api)PREFERENCES_LOGGER.atFine()).log("found %s at %s", (Object)fileName, (Object)absFileName);
                    return openId.getFile().getBufferedReader();
                }
                catch (RemoteException re) {
                    System.out.println("getPreference: RMI Error opening file " + id.getPath() + " with FileManager " + re);
                    break;
                }
            }
        }
        ((MarkingClassLogger.Api)PREFERENCES_LOGGER.atFine()).log("failed to find file %s", (Object)fileName);
        return null;
    }

    public static String getFileName(String fileName) {
        if (fileName == null || fileName.length() < 1) {
            throw new NullPointerException("FileName is null or empty");
        }
        if (_fileMgr != null) {
            Identifier openId = null;
            String userId = UserId.getUserId();
            int location = FIRST_LOC;
            while (openId == null && location <= LAST_LOC) {
                if ((location == 0 || location == 2) && _wkspName == null) {
                    ++location;
                    continue;
                }
                String absFileName = PreferencesManager.getFileName(location++, fileName);
                Identifier id = new Identifier(absFileName);
                try {
                    openId = _fileMgr.openFile(userId, id);
                    if (openId == null || openId.getFile() == null) continue;
                    ((MarkingClassLogger.Api)PREFERENCES_LOGGER.atFine()).log("found %s at %s", (Object)fileName, (Object)absFileName);
                    return openId.getPath();
                }
                catch (RemoteException re) {
                    System.out.println("getFileName: RMI Error opening file " + id.getPath() + " with FileManager " + re);
                    break;
                }
            }
        }
        ((MarkingClassLogger.Api)PREFERENCES_LOGGER.atFine()).log("failed to find file %s", (Object)fileName);
        return null;
    }

    public static int getLocationForFile(String fileName) {
        if (fileName == null) {
            return -1;
        }
        Object openId = null;
        int location = FIRST_LOC;
        while (openId == null && location <= LAST_LOC) {
            if ((location == 0 || location == 2) && _wkspName == null) {
                ++location;
                continue;
            }
            String absFileName = PreferencesManager.getFileName(location, fileName);
            try {
                if (!_fileMgr.fileExists(absFileName)) {
                    ++location;
                    continue;
                }
                ((MarkingClassLogger.Api)PREFERENCES_LOGGER.atFine()).log("found %s at %s", (Object)fileName, (Object)absFileName);
                return location;
            }
            catch (RemoteException re) {
                System.out.println("getFileName: RMI Error opening file " + absFileName + " with FileManager " + re);
                break;
            }
        }
        return -1;
    }

    public static String getFileName(int location, String fileName) {
        Object path = PreferencesManager.getDirectoryForLocation(location);
        if (path == null) {
            return path;
        }
        path = (String)path + "/" + fileName;
        ((MarkingClassLogger.Api)PREFERENCES_LOGGER.atFine()).log("returning %s", path);
        return path;
    }

    public static String getFileName(int location, String fileName, boolean addPrefDir) {
        String path = PreferencesManager.getDirectoryForLocation(location, addPrefDir);
        return path.concat("/").concat(fileName);
    }

    public static String getDirectoryForLocation(int location) {
        return PreferencesManager.getDirectoryForLocation(location, true, PREF_DIR);
    }

    public static String getDirectoryForLocation(int location, boolean addPrefDirectory) {
        return PreferencesManager.getDirectoryForLocation(location, addPrefDirectory, PREF_DIR);
    }

    public static String getDirectoryForLocation(int location, boolean addDirectory, String dirName) {
        if (location < FIRST_LOC || location > LAST_LOC) {
            throw new IllegalArgumentException("Invalid Preference Location " + location);
        }
        String loc = null;
        StringBuffer pathsb = new StringBuffer();
        String userPart = null;
        switch (location) {
            case 1: 
            case 3: {
                loc = ALL_DIR;
                break;
            }
            case 0: 
            case 2: {
                loc = _wkspName;
            }
        }
        userPart = location == 3 || location == 2 ? CWMS_DIR : _userDir;
        if (_baseDir == null || loc == null) {
            return null;
        }
        pathsb.append(_baseDir);
        if (userPart != null && userPart.length() > 0) {
            pathsb.append("/");
            pathsb.append(userPart);
        }
        if (locationFirst) {
            if (loc != null && loc.length() > 0) {
                pathsb.append("/");
                pathsb.append(loc);
            }
            if (addDirectory && dirName != null && dirName.length() > 0) {
                pathsb.append("/");
                pathsb.append(dirName);
            }
        } else {
            if (addDirectory && dirName != null && dirName.length() > 0) {
                pathsb.append("/");
                pathsb.append(dirName);
            }
            if (loc != null && loc.length() > 0) {
                pathsb.append("/");
                pathsb.append(loc);
            }
        }
        ((MarkingClassLogger.Api)PREFERENCES_LOGGER.atFine()).log("path: %s", (Object)LazyArgs.lazy(() -> pathsb.toString()));
        return pathsb.toString();
    }

    public static Properties getProperties(int location, String fileName) {
        if (location < FIRST_LOC || location > LAST_LOC) {
            throw new IllegalArgumentException("Invalid Preference Location");
        }
        if (fileName == null || fileName.length() < 1) {
            throw new NullPointerException("FileName is null or empty");
        }
        if ((location == 0 || location == 2) && _wkspName == null) {
            throw new IllegalStateException("Attempt to save to watershed directory with no watershed defined");
        }
        if (_fileMgr != null) {
            String absFileName = PreferencesManager.getFileName(location, fileName);
            Identifier id = new Identifier(absFileName);
            try {
                String userId = UserId.getUserId();
                Identifier openId = _fileMgr.openFile(userId, id);
                if (openId == null || openId.getFile() == null) {
                    return null;
                }
                Properties props = new Properties();
                ByteArrayInputStream stream = openId.getFile().getByteArrayInputStream();
                props.load(stream);
                stream.close();
                return props;
            }
            catch (RemoteException re) {
                System.out.println("getProperties: RMI Error opening file " + id.getPath() + " with FileManager " + re);
            }
            catch (Exception e) {
                System.out.println("getProperties: Error reading file " + id.getPath() + " Error:" + e);
            }
        }
        return null;
    }

    public static boolean setProperties(int location, String fileName, Properties props, String header) {
        if (location < FIRST_LOC || location > LAST_LOC) {
            throw new IllegalArgumentException("Invalid Preference Location");
        }
        if (location == 2 || location == 3) {
            throw new IllegalArgumentException("Location can not be in the CWMS area");
        }
        if (fileName == null || fileName.length() < 1) {
            throw new NullPointerException("FileName is null or empty");
        }
        if (props == null) {
            throw new NullPointerException("Properties is null");
        }
        if ((location == 0 || location == 2) && _wkspName == null) {
            throw new IllegalStateException("Attempt to save to watershed directory with no watershed defined");
        }
        if (_fileMgr != null) {
            String absFileName = PreferencesManager.getFileName(location, fileName);
            Identifier id = new Identifier(absFileName);
            try {
                String userId = UserId.getUserId();
                Identifier openId = _fileMgr.openFile(userId, id);
                if (openId == null) {
                    openId = _fileMgr.newFile(userId, id);
                }
                if (openId == null || openId.getFile() == null) {
                    return false;
                }
                ByteArrayOutputStream stream = openId.getFile().getByteArrayOutputStream();
                props.store(stream, header);
                stream.close();
                return true;
            }
            catch (RemoteException re) {
                System.out.println("setProperties: RMI Error opening file " + id.getPath() + " with FileManager " + re);
            }
            catch (Exception e) {
                System.out.println("setProperties: Exception writing properties to " + fileName + " Error:" + e);
            }
        }
        return false;
    }

    public static boolean isValidLocation(int location) {
        return location >= FIRST_LOC && location <= LAST_LOC;
    }
}

