/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.proxy;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import mil.army.usace.hec.rmi.proxy.LinkedProxy;

public class LogProxy
implements InvocationHandler,
Serializable,
LinkedProxy {
    Object next;

    public LogProxy(Object next) {
        this.next = next;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String log = method.getDeclaringClass().getName() + "." + method.getName() + "(";
        if (args != null) {
            for (int i = 0; i < args.length; ++i) {
                log = log + (i > 0 ? "," : "") + args[i].toString();
            }
        }
        log = log + ")";
        long t1 = 0L;
        long t2 = 0L;
        try {
            t1 = System.currentTimeMillis();
            Object object = method.invoke(this.next, args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            t2 = System.currentTimeMillis();
            System.out.println(log + " took:" + (t2 - t1) + "ms.");
        }
    }

    @Override
    public Object getNext() {
        return this.next;
    }

    @Override
    public void setNext(Object next) {
        this.next = next;
    }
}

