/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.proxy;

import com.google.common.flogger.FluentLogger;
import com.google.common.flogger.LazyArgs;
import hec.lang.ServerSecurityException;
import hec.lang.UserId;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.SocketException;
import java.rmi.RemoteException;
import mil.army.usace.hec.rmi.proxy.LinkedProxy;
import mil.army.usace.hec.rmi.server.PortableRmiObject;

public class NotifyUserProxy
implements InvocationHandler,
Serializable,
LinkedProxy {
    private static final long serialVersionUID = 6353947459458478926L;
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private final String _serverUrl;
    protected Object _next;

    public NotifyUserProxy(Object next, String serverUrl) {
        this._next = next;
        this._serverUrl = serverUrl;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            return method.invoke(this._next, args);
        }
        catch (IllegalArgumentException ie) {
            throw this.handleIllegalArgumentException(ie);
        }
        catch (InvocationTargetException e) {
            throw this.handleInvocationTargetException(method, e);
        }
    }

    private Throwable handleInvocationTargetException(Method method, InvocationTargetException exception) {
        Throwable retval = exception;
        ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFine()).withCause((Throwable)exception)).log("Unable to communicate with server: %s Error invoking method %s on %s", (Object)this._serverUrl, (Object)method.getName(), (Object)this._next.getClass().getName());
        Throwable te = exception.getTargetException();
        if (te instanceof RemoteException) {
            if (te.getCause() instanceof SocketException && te.getMessage().contains("An established connection was aborted by the software in your host machine")) {
                String userId = UserId.getUserId();
                if (this._next instanceof PortableRmiObject) {
                    userId = UserId.getUserId((String)this._serverUrl);
                }
                retval = new ServerSecurityException("User (" + userId + ") not recognized as having permissions to execute method " + method.getName() + " on server", (Throwable)exception);
            }
        } else if (te instanceof IllegalArgumentException) {
            retval = this.handleIllegalArgumentException(te);
        }
        return retval;
    }

    private Throwable handleIllegalArgumentException(Throwable te) {
        ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause(te)).log("Unable to communicate with server: %s", (Object)LazyArgs.lazy(() -> {
            Class<?>[] interfaces;
            StringBuilder builder = new StringBuilder(this._serverUrl).append(" ").append(te).append("next is ").append(this._next.getClass()).append("Interfaces are:");
            for (Class<?> anInterface : interfaces = this._next.getClass().getInterfaces()) {
                builder.append(anInterface.getName()).append(";");
            }
            return builder;
        }));
        return te;
    }

    @Override
    public Object getNext() {
        return this._next;
    }

    @Override
    public void setNext(Object next) {
        this._next = next;
    }
}

