/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class EncryptedPayload<T extends Serializable>
implements Serializable {
    private static final long serialVersionUID = -6921603848703614706L;
    private static final Logger LOGGER = Logger.getLogger(EncryptedPayload.class.getName());
    private transient PrivateKey _privateKey;
    private PublicKey _publicKey;
    private List<byte[]> _encryptedT;
    private transient Cipher _cipher;

    public EncryptedPayload(PublicKey publicKey, T t) throws IOException, InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException {
        this._publicKey = publicKey;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        oos.writeObject(t);
        oos.flush();
        oos.close();
        byte[] needsToBeEncryptedByteArray = baos.toByteArray();
        this._encryptedT = this.encrypt(publicKey, needsToBeEncryptedByteArray);
    }

    public T getPayload() {
        try {
            byte[] decryptedTBytes = this.decrypt(this._privateKey, this._encryptedT);
            ByteArrayInputStream bais = new ByteArrayInputStream(decryptedTBytes);
            ObjectInputStream ois = new ObjectInputStream(bais);
            Serializable t = (Serializable)ois.readObject();
            ois.close();
            return (T)t;
        }
        catch (IOException | ClassNotFoundException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            LOGGER.log(Level.WARNING, "getPayload:" + e.getClass().getSimpleName(), e);
            return null;
        }
    }

    private List<byte[]> encrypt(PublicKey publicKey, byte[] bytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        ArrayList<byte[]> retval = new ArrayList<byte[]>();
        Cipher cipher = this.getCipher();
        cipher.init(1, publicKey);
        int i = 0;
        int keySize = 2048;
        if (publicKey instanceof RSAKey) {
            keySize = ((RSAKey)((Object)publicKey)).getModulus().bitLength();
        }
        while (i <= bytes.length) {
            int end = i + (keySize / 8 - 11);
            byte[] block = Arrays.copyOfRange(bytes, i, Math.min(bytes.length, end));
            retval.add(cipher.doFinal(block));
            i = end;
        }
        return retval;
    }

    private Cipher getCipher() throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (this._cipher == null) {
            this._cipher = Cipher.getInstance(this._publicKey.getAlgorithm());
        }
        return this._cipher;
    }

    private byte[] decrypt(PrivateKey privateKey, List<byte[]> encryptedBytes) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, IllegalBlockSizeException, BadPaddingException {
        Cipher cipher = this.getCipher();
        cipher.init(2, privateKey);
        int count = (int)encryptedBytes.stream().mapToLong(s -> ((byte[])s).length).sum();
        byte[] retval = new byte[count];
        int i = 0;
        for (byte[] encrypted : encryptedBytes) {
            byte[] decrypted;
            byte[] byArray = decrypted = cipher.doFinal(encrypted);
            int n = byArray.length;
            for (int j = 0; j < n; ++j) {
                byte b;
                retval[i] = b = byArray[j];
                ++i;
            }
        }
        return retval;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this._privateKey = privateKey;
    }
}

