/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.security;

import hec.security.ApplicationPermission;
import hec.security.ApplicationPermissionCollection;
import hec.security.PermissionConstants;

public class HecSecurityManager
implements PermissionConstants {
    private static HecSecurityManager _hsm;
    ApplicationPermissionCollection[] _permissions;
    private boolean _initialized = false;
    private static ApplicationPermission _allPermission;
    private boolean _readOnly = false;
    private static boolean _debug;

    private boolean hasAllPermission() {
        if (_allPermission == null) {
            _allPermission = ApplicationPermission.ALL_PERMISSION;
        }
        try {
            this.checkPermission(_allPermission);
            return true;
        }
        catch (SecurityException se) {
            return false;
        }
    }

    public HecSecurityManager(ApplicationPermissionCollection[] permissions) {
        if (_hsm != null) {
            throw new IllegalStateException("HecSecurityManager already create. Use HecSecurityManager.getSecurityManager()");
        }
        this.setPermissions(permissions);
        this._initialized = true;
        _hsm = this;
    }

    public void setPermissions(ApplicationPermissionCollection[] permissions) {
        if (this._readOnly) {
            return;
        }
        this._permissions = (ApplicationPermissionCollection[])permissions.clone();
        if (_debug) {
            for (int i = 0; i < this._permissions.length; ++i) {
                System.out.println("permission " + i + " " + this._permissions[i]);
            }
        }
    }

    public void setReadOnly() {
        this._readOnly = true;
    }

    public static HecSecurityManager getSecurityManager() {
        return _hsm;
    }

    public boolean checkPermission(String permission) {
        return this.checkPermission(new ApplicationPermission(permission, "read")) > 0;
    }

    public int checkPermission(String permission, String action) {
        return this.checkPermission(new ApplicationPermission(permission, action));
    }

    public int getActionForPermission(ApplicationPermission perm) {
        if (perm == null) {
            throw new NullPointerException("getModeForPermission: Permission can not be null");
        }
        return this.getActionForPermission(perm.getName());
    }

    public int getActionForPermission(String permName) {
        if (permName == null) {
            throw new NullPointerException("getModeForPermission: Permission name can not be null");
        }
        if (this._permissions == null || this._permissions.length == 0) {
            return 0;
        }
        for (int i = 0; i < this._permissions.length; ++i) {
            int permMode;
            if (this._permissions[i] == null || (permMode = this._permissions[i].getAction(permName)) <= 0) continue;
            return permMode;
        }
        return 0;
    }

    public int checkPermission(ApplicationPermission perm) {
        if (perm == null) {
            throw new NullPointerException("checkPermission: Permission can not be null");
        }
        return HecSecurityManager.checkPermission(perm, this._permissions);
    }

    public static int checkPermission(ApplicationPermission perm, ApplicationPermissionCollection[] permissions) {
        if (perm == null) {
            throw new NullPointerException("checkPermission: Permission can not be null");
        }
        if (permissions == null || permissions.length == 0) {
            return 0;
        }
        for (int i = 0; i < permissions.length; ++i) {
            int permImplied;
            if (permissions[i] == null || (permImplied = permissions[i].implies(perm)) <= 0) continue;
            return permImplied;
        }
        return 0;
    }

    static {
        _debug = false;
        _debug = Boolean.getBoolean("hec.security.debug");
    }
}

