/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.security;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Random;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import rma.util.ByteConversion;
import rma.util.RMAIO;

public class PasswordGenerator {
    private static final String ENCRYPTION_TYPE = "PBEWithMD5AndDES";

    public static String getEncryptedPassword(String userName, String password) {
        byte[] encrypted = PasswordGenerator.getEncryptedPassword(password, (String[])null);
        if (encrypted != null) {
            return new String(encrypted);
        }
        return null;
    }

    public static byte[] getEncryptedPassword(String password, String[] versionToEncrypt) {
        byte[] ciphertext;
        if (password == null) {
            System.out.println("getEncryptedPassword: password is null");
            return null;
        }
        byte[] salt = PasswordGenerator.getSalt();
        Cipher pbeCipher = PasswordGenerator.getCipher(salt, 1, versionToEncrypt);
        try {
            byte[] cleartext = password.getBytes();
            ciphertext = pbeCipher.doFinal(cleartext);
        }
        catch (IllegalStateException e) {
            System.out.println("getEncryptedPassword:IllegalStateException " + e);
            return null;
        }
        catch (IllegalBlockSizeException e) {
            System.out.println("getEncryptedPassword:IllegalBlockSizeException " + e);
            return null;
        }
        catch (BadPaddingException e) {
            System.out.println("getEncryptedPassword:BadPaddingException " + e);
            return null;
        }
        byte[] encrypted = new byte[ciphertext.length + salt.length + 2];
        ByteConversion.short2bytes((short)((short)salt.length), (byte[])encrypted, (int)0);
        System.arraycopy(salt, 0, encrypted, 2, salt.length);
        System.arraycopy(ciphertext, 0, encrypted, salt.length + 2, ciphertext.length);
        return encrypted;
    }

    public static String getDecryptedPassword(byte[] encryptedData) {
        if (encryptedData == null) {
            return null;
        }
        short saltLength = ByteConversion.bytes2short((byte[])encryptedData, (int)0);
        byte[] salt = new byte[saltLength];
        System.arraycopy(encryptedData, 2, salt, 0, saltLength);
        byte[] encrypted = new byte[encryptedData.length - 2 - saltLength];
        System.arraycopy(encryptedData, saltLength + 2, encrypted, 0, encrypted.length);
        Cipher pbeCipher = PasswordGenerator.getCipher(salt, 2, null);
        if (pbeCipher == null) {
            return null;
        }
        try {
            byte[] ciphertext = pbeCipher.doFinal(encrypted);
            if (ciphertext != null) {
                return new String(ciphertext);
            }
        }
        catch (IllegalStateException e) {
            System.out.println("getDecryptedPassword:IllegalStateException " + e);
            return null;
        }
        catch (IllegalBlockSizeException e) {
            System.out.println("getDecryptedPassword:IllegalBlockSizeException " + e);
            return null;
        }
        catch (BadPaddingException e) {
            System.out.println("getDecryptedPassword:BadPaddingException " + e);
            return null;
        }
        return null;
    }

    private static Cipher getCipher(byte[] salt, int mode, String[] versionToEncryptWith) {
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 20);
        String[] verStamp = null;
        verStamp = versionToEncryptWith == null || versionToEncryptWith.length < 1 ? RMAIO.getVersionStamp() : versionToEncryptWith;
        char[] charArray = verStamp[0].toCharArray();
        PBEKeySpec pbeKeySpec = new PBEKeySpec(charArray);
        SecretKey pbeKey = null;
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(ENCRYPTION_TYPE);
            pbeKey = factory.generateSecret(pbeKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("getCipher:NoSuchAlgorithmException " + e);
            return null;
        }
        catch (InvalidKeySpecException e) {
            System.out.println("getCipher:InvalidKeySpecException " + e);
            return null;
        }
        Cipher pbeCipher = null;
        try {
            pbeCipher = Cipher.getInstance(ENCRYPTION_TYPE);
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println("getCipher:NoSuchAlgorithmException " + e);
            return null;
        }
        catch (NoSuchPaddingException e) {
            System.out.println("getCipher:NoSuchPaddingException " + e);
            return null;
        }
        try {
            pbeCipher.init(mode, (Key)pbeKey, pbeParamSpec);
        }
        catch (InvalidKeyException e) {
            System.out.println("getCipher:InvalidKeyException " + e);
            return null;
        }
        catch (InvalidAlgorithmParameterException e) {
            System.out.println("getCipher:InvalidAlgorithmParameterException " + e);
            return null;
        }
        return pbeCipher;
    }

    private static byte[] getSalt() {
        Random rdm = new Random(System.currentTimeMillis());
        byte[] salt = new byte[8];
        rdm.nextBytes(salt);
        return salt;
    }

    private static byte[] getZippedPassword(String password) {
        if (password == null) {
            return null;
        }
        Deflater deflater = new Deflater();
        byte[] input = password.getBytes();
        deflater.setInput(input);
        deflater.finish();
        byte[] deflated = new byte[1024];
        deflater.deflate(deflated);
        int deflateCnt = deflater.getTotalOut();
        byte[] actualDeflated = new byte[deflateCnt];
        System.arraycopy(deflated, 0, actualDeflated, 0, deflateCnt);
        deflater.end();
        return actualDeflated;
    }

    private static String getUnZippedPassword(byte[] zippedPassword) {
        if (zippedPassword == null) {
            return null;
        }
        Inflater inflater = new Inflater();
        inflater.setInput(zippedPassword);
        byte[] inflated = new byte[1024];
        try {
            inflater.inflate(inflated);
        }
        catch (DataFormatException dfe) {
            System.out.println("getUnZippedPassword: error unzipping: " + dfe);
            inflater.end();
            return null;
        }
        int totalOut = inflater.getTotalOut();
        String s = new String(inflated, 0, totalOut);
        inflater.end();
        return s;
    }

    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            System.err.println("USAGE: PasswordGenerator username password");
            System.exit(1);
        }
        byte[] pass = PasswordGenerator.getEncryptedPassword(args[1], (String[])null);
        System.out.println("main:encrypted is " + pass);
        PasswordGenerator.printBytes("Encrypted String", pass);
        String unzippedpass = PasswordGenerator.getDecryptedPassword(pass);
        System.out.println("Decrypted password is " + unzippedpass + " Encrypted is " + pass);
        System.exit(0);
    }

    private static void printBytes(String info, byte[] bytes) {
        System.out.print(info);
        System.out.print(" ");
        for (int i = 0; i < bytes.length; ++i) {
            System.out.print(bytes[i]);
            System.out.print(" ");
        }
        System.out.print("\n");
        System.out.flush();
    }
}

