/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.server;

import com.google.common.flogger.FluentLogger;
import hec.io.PeriodicLogger;
import hec.io.StatusObject;
import hec.lang.UserIdKey;
import hec.server.RmiUserPrintStream;
import hec.server.ServerJavaLoggerLoader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import mil.army.usace.hec.rmi.csinterface.ClientServerUtil;
import mil.army.usace.hec.rmi.csinterface.ControllableServer;
import mil.army.usace.hec.rmi.csinterface.ControllableServerEvent;
import mil.army.usace.hec.rmi.csinterface.ControllableServerListener;
import mil.army.usace.hec.rmi.csinterface.RmiLogin;
import mil.army.usace.hec.rmi.csinterface.RmiLoginListener;
import mil.army.usace.hec.rmi.server.PortableRmiObject;
import rma.util.logging.OutputStreamLogger;

public abstract class ControllableServerImpl
extends PortableRmiObject
implements ControllableServer,
RmiLoginListener {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private final String _startTime;
    protected volatile boolean _shuttingDown = false;
    protected volatile boolean _paused = false;
    protected Map<String, UserIdKey> _loggedInUsers = new Hashtable<String, UserIdKey>();
    protected List<String> _registeredWithLoginServers = null;
    protected transient boolean _startedFromMain = true;
    protected List<String> _loginUrls;
    private Set<ControllableServerListener> controllableListenerSet;
    private ExecutorService eventExecutor;

    public ControllableServerImpl() throws RemoteException {
        this._startTime = new Date().toString();
        ControllableServerImpl.possiblyStartPeriodicLogger();
    }

    public ControllableServerImpl(int rmiPort) throws RemoteException {
        super(rmiPort);
        this._startTime = new Date().toString();
        ControllableServerImpl.possiblyStartPeriodicLogger();
    }

    public String getControllableServerStartTime() {
        return this._startTime;
    }

    @Override
    public String[] threadStatus() throws RemoteException {
        ThreadGroup root_group = null;
        for (ThreadGroup parent = Thread.currentThread().getThreadGroup().getParent(); parent != null; parent = parent.getParent()) {
            root_group = parent;
        }
        if (root_group == null) {
            System.out.println("threadStatus: null ThreadGroup parent");
            return null;
        }
        int cnt = root_group.activeCount();
        Thread[] threads = new Thread[cnt];
        root_group.enumerate(threads, true);
        String[] threadInfo = new String[cnt];
        for (int i = 0; i < threads.length; ++i) {
            Thread thread = threads[i];
            if (thread == null) continue;
            threadInfo[i] = "Name:" + thread.getName() + "\n";
            int n = i;
            threadInfo[n] = threadInfo[n] + " Priority:" + thread.getPriority() + "\n";
            int n2 = i;
            threadInfo[n2] = threadInfo[n2] + " Group:" + (thread.getThreadGroup() != null ? thread.getThreadGroup().getName() : "none") + "\n";
            int n3 = i;
            threadInfo[n3] = threadInfo[n3] + " Alive:" + thread.isAlive() + "\n";
            int n4 = i;
            threadInfo[n4] = threadInfo[n4] + " Daemon:" + thread.isDaemon() + "\n";
            int n5 = i;
            threadInfo[n5] = threadInfo[n5] + " Interrupted:" + thread.isInterrupted() + "\n";
        }
        return threadInfo;
    }

    @Override
    public boolean shutdown(int shutDownType, int delaySeconds, String userId) throws RemoteException {
        return false;
    }

    @Override
    public String getStatusString(int statusType) throws RemoteException {
        return "unknown";
    }

    @Override
    public StatusObject getStatusObject(int statusType) throws RemoteException {
        return null;
    }

    @Override
    public boolean setPaused(boolean pause) throws RemoteException {
        if (pause) {
            this.firePauseEvent();
        } else {
            this.fireResumeEvent();
        }
        return true;
    }

    @Override
    public boolean isPaused() {
        return this._paused;
    }

    protected final boolean isShuttingDown() {
        return this._shuttingDown;
    }

    protected void shutdown(int waitSeconds) {
        this.fireShuttingDownEvent(waitSeconds);
        this._shuttingDown = true;
        this._paused = true;
        if (waitSeconds < 0) {
            waitSeconds = 10;
        }
        final int fWaitSeconds = waitSeconds;
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.currentThread();
                    Thread.sleep(fWaitSeconds * 1000);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (ControllableServerImpl.this._registeredWithLoginServers != null) {
                    ControllableServerImpl.this.deregisterLoginListener();
                }
                try {
                    System.out.println(ControllableServerImpl.this.getName() + " shutdown: shutting down");
                    ControllableServerImpl.this.unbindServer();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    PortableRmiObject.unexportObject(ControllableServerImpl.this, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ControllableServerImpl.this._startedFromMain) {
                    System.exit(0);
                }
            }
        });
        t.start();
    }

    public void setStartedFromMain(boolean startedFromMain) {
        this._startedFromMain = startedFromMain;
    }

    @Override
    public long[] getMemoryUsage() {
        Runtime r = Runtime.getRuntime();
        long[] memInfo = new long[]{r.freeMemory(), r.totalMemory()};
        return memInfo;
    }

    @Override
    public String getServerProperty(String propName) throws RemoteException {
        if (propName == null) {
            return null;
        }
        return System.getProperty(propName);
    }

    @Override
    public Properties getServerProperties() throws RemoteException {
        return System.getProperties();
    }

    @Override
    public void userLoggedIn(UserIdKey userIdKey) {
        if (userIdKey == null) {
            return;
        }
        System.out.println(this.getName() + " userLoggedIn: added user " + userIdKey.getUserId());
        this._loggedInUsers.put(userIdKey.getUserId(), userIdKey);
    }

    public boolean userLoggedIn(long edipi, String host) {
        return this._loggedInUsers.values().stream().anyMatch(e -> e.getEdipi() == edipi && Objects.equals(e.getHost(), host));
    }

    @Override
    public void userLoggedOut(String userId) {
        if (userId == null) {
            return;
        }
        System.out.println(this.getName() + " userLoggedOut: removed user " + userId);
        this._loggedInUsers.remove(userId);
    }

    @Override
    public List<String> getKnownLoggedInUsers() {
        return new ArrayList<String>(this._loggedInUsers.keySet());
    }

    public List<String> getLoginServerUrlsRegisteredWith() {
        return this._registeredWithLoginServers;
    }

    @Override
    public void reregisterLoginListeners() {
        System.out.println(this.getName() + " reregisterLoginListeners:reregistering with login servers...");
        this.deregisterLoginListener();
        this.registerLoginListeners(this.getLoginServerUrls());
    }

    public List<String> getLoginServerUrls() {
        ArrayList<String> list = new ArrayList<String>();
        String url = null;
        try {
            url = this.getUrl();
            if (url == null) {
                ((FluentLogger.Api)LOGGER.atWarning()).log("The URL for this class is null. Cannot obtain the URL of the login server");
                return list;
            }
            int idx = url.lastIndexOf("/");
            url = idx > -1 ? url.substring(0, idx + 1) : url.concat("/");
            url = url.concat("LoginServer");
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)re)).log("Unable to obtain this object's own URL. Cannot obtain the URL of the login server");
        }
        list.add(url);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregisterLoginListener() {
        List<String> loginUrls = this.getLoginServerUrls();
        if (loginUrls == null) {
            System.out.println(this.getName() + " deregisterLoginListener: failed to get LoginServer URL");
            return;
        }
        if (this._registeredWithLoginServers == null) {
            return;
        }
        List<String> list = this._registeredWithLoginServers;
        synchronized (list) {
            for (String loginUrl : loginUrls) {
                RmiLogin loginServer;
                try {
                    loginServer = ClientServerUtil.getRmiLogin(loginUrl);
                }
                catch (Exception e) {
                    ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFine()).withCause((Throwable)e)).log(this.getName() + " deregisterLoginListener: LoginServer " + loginUrl + " not available ");
                    return;
                }
                try {
                    String serverUrl = this.getServerUrl();
                    ((FluentLogger.Api)LOGGER.atConfig()).log("Removing login listener server from login server: " + serverUrl);
                    loginServer.removeRmiLoginListener(serverUrl);
                    ((FluentLogger.Api)LOGGER.atFine()).log(this.getName() + " deregisterLoginListeners: deregistering with " + loginUrl);
                    this._registeredWithLoginServers.remove(loginUrl);
                    return;
                }
                catch (Exception e) {
                    ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e)).log(this.getName() + " deregisterLoginListener: ERROR registering with LoginServer " + e);
                }
            }
        }
    }

    public void registerLoginListener() {
        if (!this.getNetworked()) {
            System.out.println(this.getName() + " registerLoginListener: not networked");
            return;
        }
        if (this._registeredWithLoginServers != null) {
            System.out.println(this.getName() + " registerLoginListener: already registered");
            return;
        }
        this._loginUrls = this.getLoginServerUrls();
        if (this._loginUrls == null || this._loginUrls.size() < 1) {
            System.out.println(this.getName() + " registerLoginListener: failed to get LoginServers URL");
            return;
        }
        this.registerLoginListeners(this._loginUrls);
    }

    protected void registerLoginListeners(List<String> loginUrls) {
        for (int i = 0; i < loginUrls.size(); ++i) {
            String loginUrl = loginUrls.get(i);
            this.registerLoginListener(loginUrl, false);
        }
    }

    protected void registerLoginListener(String loginUrl, boolean threaded) {
        int cnt = 3;
        if (threaded) {
            cnt = 5;
        }
        int retryCnt = cnt;
        Runnable registerRunner = () -> {
            for (int i = retryCnt; i >= 0; --i) {
                RmiLogin remote;
                ((FluentLogger.Api)LOGGER.atFine()).log(this.getName() + " registerLoginListener: looking up loginServer " + loginUrl);
                try {
                    remote = ClientServerUtil.getRmiLogin(loginUrl);
                }
                catch (Exception e) {
                    ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFine()).withCause((Throwable)e)).log(this.getName() + " registerLoginListener: LoginServer " + loginUrl + " not available ");
                    try {
                        Thread.sleep((long)i * 3000L);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFine()).withCause((Throwable)e)).log(this.getName() + " Thread interrupted while trying to reconnect to the login server");
                    }
                    continue;
                }
                try {
                    String serverUrl = this.getServerUrl();
                    ((FluentLogger.Api)LOGGER.atConfig()).log("Adding login listener server to login server: " + serverUrl);
                    remote.addRmiLoginListener(serverUrl);
                    ControllableServerImpl controllableServerImpl = this;
                    synchronized (controllableServerImpl) {
                        if (this._registeredWithLoginServers == null) {
                            this._registeredWithLoginServers = new CopyOnWriteArrayList<String>();
                        }
                    }
                    this._registeredWithLoginServers.add(loginUrl);
                    ((FluentLogger.Api)LOGGER.atInfo()).log(this.getName() + " registerLoginListener: registered with LoginServer " + loginUrl);
                    return;
                }
                catch (Exception e) {
                    ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e)).log(this.getName() + " registerLoginListener: ERROR registering with LoginServer: " + loginUrl);
                }
            }
        };
        if (threaded) {
            Thread t = new Thread(registerRunner, this.getName() + " Register Login Listener Thread " + loginUrl);
            t.start();
        } else {
            registerRunner.run();
        }
    }

    @Override
    protected void rebindServer() {
        super.rebindServer();
        this.registerLoginListener();
    }

    @Override
    public String getServerUrl() throws RemoteException {
        return this.getUrl() + this.getName();
    }

    @Override
    public void addControllableServerListener(ControllableServerListener listener) {
        if (this.controllableListenerSet == null) {
            this.controllableListenerSet = new HashSet<ControllableServerListener>();
        }
        this.controllableListenerSet.add(listener);
    }

    public void removeControllableServerListener(ControllableServerListener listener) {
        if (this.controllableListenerSet != null) {
            this.controllableListenerSet.remove(listener);
        }
    }

    protected void firePauseEvent() {
        ControllableServerEvent event = new ControllableServerEvent(ControllableServerEvent.EventType.PAUSE);
        this.fireEvent(event);
    }

    protected void fireResumeEvent() {
        ControllableServerEvent event = new ControllableServerEvent(ControllableServerEvent.EventType.RESUME);
        this.fireEvent(event);
    }

    protected void fireShutdownInitiatedEvent() {
        ControllableServerEvent event = new ControllableServerEvent(ControllableServerEvent.EventType.SHUTDOWN_INITIATED);
        this.fireEvent(event);
    }

    protected void fireShuttingDownEvent(int waitSeconds) {
        ControllableServerEvent event = new ControllableServerEvent(ControllableServerEvent.EventType.SHUTTING_DOWN);
        event.setDelay(waitSeconds);
        this.fireEvent(event);
    }

    private void fireEvent(final ControllableServerEvent event) {
        if (this.controllableListenerSet == null) {
            return;
        }
        if (this.eventExecutor == null) {
            this.eventExecutor = Executors.newSingleThreadExecutor();
        }
        for (final ControllableServerListener controllableServerListener : this.controllableListenerSet) {
            Runnable eventRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        controllableServerListener.fireEvent(event);
                    }
                    catch (Throwable t) {
                        Logger logger = Logger.getLogger(this.getClass().getName());
                        logger.log(Level.FINER, "Error broadcasting controllable server event", t);
                    }
                }
            };
            this.eventExecutor.submit(eventRunnable);
        }
    }

    @Override
    public void loadLoggingConfiguration(String config) throws RemoteException {
        if (config == null || config.isEmpty()) {
            this.loadLoggingConfiguration();
        } else {
            LogManager logManager = LogManager.getLogManager();
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(config.getBytes(StandardCharsets.UTF_8));){
                logManager.readConfiguration(inputStream);
            }
            catch (IOException | SecurityException e) {
                Logger logger = Logger.getLogger(this.getClass().getName());
                logger.log(Level.FINER, "Error loading logging configuration from string", e);
            }
        }
    }

    @Override
    public void loadLoggingConfiguration() throws RemoteException {
        ServerJavaLoggerLoader.loadConfiguration();
    }

    public static void setupStdOutStdErr() {
        System.setOut((PrintStream)new RmiUserPrintStream(System.out));
        System.setErr(System.out);
        OutputStreamLogger outputStreamLogger = new OutputStreamLogger();
        PrintStream wrappingLoggerOutput = new PrintStream((OutputStream)outputStreamLogger);
        System.setOut(wrappingLoggerOutput);
    }

    public static void possiblyStartPeriodicLogger() {
        ((FluentLogger.Api)LOGGER.atFine()).log("Possibly starting Periodic Logger.");
        if (Boolean.getBoolean("PeriodicLogger.run")) {
            ((FluentLogger.Api)LOGGER.atFine()).log("Starting Periodic Logger.");
            PeriodicLogger.runAtFixedRate((boolean)true);
        } else {
            ((FluentLogger.Api)LOGGER.atFine()).log("Not starting periodic logger. Flag not set.");
        }
    }

    @Override
    public boolean isAlive() throws RemoteException {
        return true;
    }
}

