/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.server;

import com.google.common.flogger.LazyArgs;
import hec.data.DataSetException;
import hec.data.DataSetIllegalArgumentException;
import hec.data.UnitsConversionException;
import hec.data.tx.DSSTimeSeries;
import hec.data.tx.DSSTimeSeriesNoDataFoundException;
import hec.data.tx.DSSTimeSeriesReadException;
import hec.data.tx.DSSTimeSeriesTranslator;
import hec.data.tx.DSSTimeSeriesUtil;
import hec.data.tx.DSSTimeSeriesWriteException;
import hec.data.tx.DataSetTx;
import hec.data.tx.DataSetTxEmptyException;
import hec.data.tx.DataSetTxException;
import hec.data.tx.DataSetTxTemplate;
import hec.data.tx.UtcIntervalOffsetMismatchException;
import hec.heclib.dss.CondensedReference;
import hec.heclib.dss.DSSErrorMessage;
import hec.heclib.dss.DSSPathname;
import hec.heclib.dss.HecDSSFileAccess;
import hec.heclib.dss.HecDSSFileData;
import hec.heclib.dss.HecDSSFileDataManager;
import hec.heclib.dss.HecDSSRecordInfo;
import hec.heclib.dss.HecDSSUtilities;
import hec.heclib.dss.HecDataManager;
import hec.heclib.dss.HecDssCatalog;
import hec.heclib.dss.HecDssFileStore;
import hec.heclib.dss.HecDssText;
import hec.heclib.dss.HecPairedData;
import hec.heclib.dss.HecTimeSeries;
import hec.heclib.grid.AlbersInfo;
import hec.heclib.grid.Dss2AscGrid;
import hec.heclib.grid.GridData;
import hec.heclib.grid.GridInfo;
import hec.heclib.grid.GriddedData;
import hec.heclib.grid.HrapInfo;
import hec.heclib.util.HecDoubleArray;
import hec.heclib.util.HecTime;
import hec.heclib.util.Heclib;
import hec.heclib.util.doubleArrayContainer;
import hec.heclib.util.intArrayContainer;
import hec.heclib.util.stringContainer;
import hec.hecmath.HecMath;
import hec.hecmath.HecMathException;
import hec.io.DSSArrayContainer;
import hec.io.DSSIdentifier;
import hec.io.DSSPairedDataContainer;
import hec.io.DataContainer;
import hec.io.DssFileContainer;
import hec.io.PairedDataContainer;
import hec.io.TextContainer;
import hec.io.TimeSeriesContainer;
import hec.io.TimeSeriesContainerVertDatum;
import hec.lang.ExportException;
import hec.util.TextUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.Vector;
import mil.army.usace.hec.data.timeseries.TimeSeries;
import mil.army.usace.hec.data.timeseries.math.TimeComparisonMethod;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesCombine;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesDerive;
import mil.army.usace.hec.data.timeseries.math.TimeSeriesTemplate;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.VerticalDatumException;
import mil.army.usace.hec.metadata.constants.TimeSeriesStoreRule;
import mil.army.usace.hec.metadata.timeseries.DataSetTimeSeriesException;
import mil.army.usace.hec.metadata.timeseries.TimeSeriesIdentifier;
import mil.army.usace.hec.rmi.csinterface.DSSManager;
import mil.army.usace.hec.rmi.csinterface.ResultZinqir;
import mil.army.usace.hec.rmi.csinterface.ResultZquery;
import mil.army.usace.hec.rmi.csinterface.RmiLoginListener;
import mil.army.usace.hec.rmi.csinterface.RmiProgress;
import mil.army.usace.hec.rmi.extractpost.ExtractStatistic;
import mil.army.usace.hec.rmi.heclib.grid.HrapConvertTable;
import mil.army.usace.hec.rmi.proxy.NotifyUserProxy;
import mil.army.usace.hec.rmi.proxy.ReconnectProxy;
import mil.army.usace.hec.rmi.server.ControllableServerImpl;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.DSSFileManagerLoggingMarker;
import rma.util.logging.marking.GridUtilLoggingMarker;

public class DSSFileManager
extends ControllableServerImpl
implements DSSManager {
    private static final MarkingClassLogger LOGGER = MarkingClassLogger.forMarkingClass(DSSFileManagerLoggingMarker.class);
    private static final MarkingClassLogger GRID_UTIL_LOGGER = MarkingClassLogger.forMarkingClass(GridUtilLoggingMarker.class);
    protected String _workspacePath;
    protected static String sep = "/";
    protected static String abs = ":";
    public static final String TIME_SERIES = "TimeSeries";
    public static final String PAIRED_DATA = "PairedData";

    public DSSFileManager(int port) throws RemoteException {
        super(port);
        this.setName("DssFileManager");
        this._workspacePath = "workspace";
        String temp = System.getProperty("hecdss.set");
        if (temp != null) {
            HecDSSFileAccess.setDss((String)temp);
        }
    }

    public DSSFileManager() throws RemoteException {
        this.port = 8089;
        this.setName("DssFileManager");
        this._workspacePath = "workspace";
        String temp = System.getProperty("hecdss.set");
        if (temp != null) {
            HecDSSFileAccess.setDss((String)temp);
        }
    }

    public DSSFileManager(String workspacePath) throws RemoteException {
        this();
        this._workspacePath = workspacePath;
    }

    @Override
    public List<HecDSSFileData> DssFileManagerStatus() throws RemoteException {
        ArrayList<HecDSSFileData> output = new ArrayList<HecDSSFileData>();
        HecDSSFileDataManager.DssFileManagerStatus(output);
        return output;
    }

    @Override
    public void closeAndClearFinal() throws RemoteException {
        HecDataManager.closeAllFiles();
    }

    @Override
    public void closeAndClear() throws RemoteException {
        HecDataManager.closeAllFiles();
    }

    public void closeAll() throws RemoteException {
        HecDataManager.closeAllFiles();
    }

    @Override
    public boolean doesDSSFileExist(String DSSFileName) {
        String path = this.processPath(DSSFileName);
        return HecDataManager.doesDSSFileExist((String)path);
    }

    @Override
    public String cleanDSSFileName(String inName) {
        stringContainer sc = new stringContainer();
        boolean b = HecDataManager.cleanDSSFileName((String)inName, (stringContainer)sc);
        if (b) {
            return sc.string;
        }
        return null;
    }

    @Override
    public String defaultDSSFileName() {
        return HecDataManager.defaultDSSFileName();
    }

    @Override
    public void setDefaultDSSFileName(String name) {
        HecDataManager.setDefaultDSSFileName((String)name);
    }

    @Override
    public void setForceNewCatalog(String DSSFileName, boolean b) {
        if (DSSFileName != null) {
            HecDataManager dataManager = this.getDataManager(DSSFileName);
            dataManager.setForceNewCatalog(b);
        }
    }

    @Override
    public List<DSSIdentifier> recordsUpdated(Map<String, Long> fileTimeMap) throws RemoteException {
        ArrayList<DSSIdentifier> dssIdentifierList = new ArrayList<DSSIdentifier>();
        for (String filename : fileTimeMap.keySet()) {
            Long startTime = fileTimeMap.get(filename);
            if (startTime == null) continue;
            List<DSSIdentifier> fileList = this.recordsUpdated(filename, startTime);
            dssIdentifierList.addAll(fileList);
        }
        return dssIdentifierList;
    }

    @Override
    public List<DSSIdentifier> recordsUpdated(String name, long startingUpdateTime) throws RemoteException {
        if (name == null) {
            return Collections.emptyList();
        }
        Vector pathnames = new Vector();
        Vector updateTimes = new Vector();
        Vector recordTypes = new Vector();
        HecDataManager dataManager = this.getDataManager(name);
        int status = dataManager.recordsUpdated(startingUpdateTime, pathnames, updateTimes, recordTypes);
        HashMap dssPathMap = new HashMap();
        ArrayList<DSSIdentifier> identifierList = new ArrayList<DSSIdentifier>(pathnames.size());
        if (status > -1) {
            for (int ii = 0; ii < pathnames.size(); ++ii) {
                String dssPathWithDPart = (String)pathnames.get(ii);
                if (dssPathWithDPart == null) continue;
                DSSPathname dssPathname = new DSSPathname(dssPathWithDPart);
                dssPathname.setDPart("");
                String dssPath = dssPathname.pathname();
                ArrayList<DSSIdentifier> dssIdentifierList = (ArrayList<DSSIdentifier>)dssPathMap.get(dssPath);
                if (dssIdentifierList == null) {
                    dssIdentifierList = new ArrayList<DSSIdentifier>();
                    dssPathMap.put(dssPath, dssIdentifierList);
                }
                Long longTime = (Long)updateTimes.get(ii);
                DSSIdentifier dssIdentifier = new DSSIdentifier(name);
                dssIdentifier.setDSSPath(dssPathWithDPart);
                if (longTime != null) {
                    long time = longTime;
                    dssIdentifier.setUpdateTime(time);
                }
                dssIdentifierList.add(dssIdentifier);
            }
            for (String dssPath : dssPathMap.keySet()) {
                List dssIdentifierList = (List)dssPathMap.get(dssPath);
                CondensedReference condensedReference = new CondensedReference();
                int number = dssIdentifierList.size();
                String[] paths = new String[number];
                long latestUpdateTime = Long.MIN_VALUE;
                for (int ii = 0; ii < number; ++ii) {
                    DSSIdentifier dssIdentifier = (DSSIdentifier)dssIdentifierList.get(ii);
                    paths[ii] = dssIdentifier.getDSSPath();
                    long updateTime = dssIdentifier.getUpdateTime();
                    if (updateTime == Long.MIN_VALUE || latestUpdateTime >= updateTime) continue;
                    latestUpdateTime = updateTime;
                }
                condensedReference.setPathnameArray(paths, number);
                HecTime startTime = new HecTime();
                HecTime endTime = new HecTime();
                if (number > 0 && ((MarkingClassLogger.Api)LOGGER.atFinest()).isEnabled()) {
                    StringBuilder sb = new StringBuilder("Building pathname time window for records updated since: ").append(new Date(startingUpdateTime)).append("\n");
                    for (String path : paths) {
                        sb.append(path).append("\n");
                    }
                    ((MarkingClassLogger.Api)LOGGER.atFinest()).log(sb.toString());
                }
                condensedReference.getPathnameTimes((Object)dataManager, startTime, endTime);
                DSSIdentifier dssIdentifier = new DSSIdentifier(name);
                dssIdentifier.setDSSPath(dssPath);
                dssIdentifier.setUpdateTime(latestUpdateTime);
                dssIdentifier.setStartTime(startTime);
                dssIdentifier.setEndTime(endTime);
                identifierList.add(dssIdentifier);
            }
        }
        return identifierList;
    }

    @Override
    public String getPathType(DSSIdentifier dssId) throws RemoteException {
        HecDataManager dataManager = this.getDataManager(dssId.getFileName());
        if (dataManager == null) {
            return null;
        }
        int type = dataManager.recordType(dssId.getDSSPath());
        if (type >= 100 && type < 200) {
            return TIME_SERIES;
        }
        if (type >= 200 && type < 300) {
            return PAIRED_DATA;
        }
        return null;
    }

    @Override
    public String getUnitsType(DSSIdentifier dssId) throws RemoteException {
        HecDataManager dataManager = this.getDataManager(dssId.getFileName());
        if (dataManager == null) {
            return null;
        }
        HecDataManager dssDataSet = dataManager.createObject(dssId.getDSSPath());
        if (dssDataSet == null) {
            return null;
        }
        if (dssDataSet instanceof HecTimeSeries) {
            return ((HecTimeSeries)dssDataSet).type();
        }
        if (dssDataSet instanceof HecPairedData) {
            return "";
        }
        return null;
    }

    @Override
    public String getUnits(DSSIdentifier dssId) throws RemoteException {
        HecDataManager dataManager = this.getDataManager(dssId.getFileName());
        if (dataManager == null) {
            return null;
        }
        HecDataManager dssDataSet = dataManager.createObject(dssId.getDSSPath());
        if (dssDataSet == null) {
            return null;
        }
        if (dssDataSet instanceof HecTimeSeries) {
            return ((HecTimeSeries)dssDataSet).units();
        }
        if (dssDataSet instanceof HecPairedData) {
            return "";
        }
        return null;
    }

    @Override
    public Vector readPD(DSSIdentifier dssId) {
        doubleArrayContainer xArray = new doubleArrayContainer();
        Vector vector = new Vector();
        Vector<Object> data = new Vector<Object>();
        HecPairedData dssPD = new HecPairedData();
        String path = this.processPath(dssId.getFileName());
        dssPD.setDSSFileName(path);
        dssPD.setPathname(dssId.getDSSPath());
        if (!dssPD.checkRead()) {
            return null;
        }
        int numberRead = dssPD.read(xArray, vector);
        data.addElement(xArray);
        data.addElement(vector);
        dssPD.done();
        return data;
    }

    @Override
    public DSSPairedDataContainer readPDContainer(DSSIdentifier dssId) {
        if (dssId == null) {
            return null;
        }
        DSSPairedDataContainer dsspdContainer = new DSSPairedDataContainer(dssId);
        doubleArrayContainer xArray = new doubleArrayContainer();
        Vector vector = new Vector();
        Vector<Object> data = new Vector<Object>();
        HecPairedData dssPD = new HecPairedData();
        String path = this.processPath(dssId.getFileName());
        dssPD.setDSSFileName(path);
        dssPD.setPathname(dssId.getDSSPath());
        if (!dssPD.checkRead()) {
            return null;
        }
        int numberRead = dssPD.read(xArray, vector);
        if (numberRead == 0) {
            numberRead = xArray.length;
        }
        data.addElement(xArray);
        data.addElement(vector);
        dsspdContainer.xdata = xArray;
        dsspdContainer.ydata = vector;
        dsspdContainer.numberRead = numberRead;
        dsspdContainer.xtype = dssPD.typeX();
        dsspdContainer.ytype = dssPD.typeY();
        dsspdContainer.xunits = dssPD.unitsX();
        dsspdContainer.yunits = dssPD.unitsY();
        dsspdContainer.labels = dssPD.labels();
        return dsspdContainer;
    }

    @Override
    public PairedDataContainer readPairedDataContainer(DSSIdentifier dssId) {
        if (dssId == null) {
            return null;
        }
        HecPairedData dssPD = new HecPairedData();
        String path = this.processPath(dssId.getFileName());
        dssPD.setDSSFileName(path);
        dssPD.setPathname(dssId.getDSSPath());
        PairedDataContainer pdc = new PairedDataContainer();
        int status = dssPD.read(pdc);
        dssPD.close();
        return pdc;
    }

    @Override
    public Vector readPDLabels(DSSIdentifier dssId) {
        doubleArrayContainer xArray = new doubleArrayContainer();
        Vector vector = new Vector();
        HecPairedData dssPD = new HecPairedData();
        String path = this.processPath(dssId.getFileName());
        dssPD.setDSSFileName(path);
        dssPD.setPathname(dssId.getDSSPath());
        if (!dssPD.checkRead()) {
            return null;
        }
        int numberRead = dssPD.read(xArray, vector);
        return dssPD.labels();
    }

    @Override
    public int write(DataContainer dataContainer) {
        int status = 0;
        if (dataContainer instanceof PairedDataContainer) {
            HecPairedData dssPD = new HecPairedData();
            dssPD.setStoreDoubles(true);
            dssPD.setDSSFileName(dataContainer.fileName);
            status = dssPD.write((PairedDataContainer)dataContainer);
            dssPD.done();
        } else {
            status = dataContainer instanceof TimeSeriesContainer ? this.writeTS((TimeSeriesContainer)dataContainer, 3, 1) : -4;
        }
        return status;
    }

    @Override
    public int writeTS(TimeSeriesContainer timeSeriesContainer, int regularStoreMethod, int irregularStoreMethod) {
        int status = 0;
        HecTimeSeries dssTS = new HecTimeSeries();
        String path = this.processPath(timeSeriesContainer.fileName);
        dssTS.setDSSFileName(path);
        dssTS.setPathname(timeSeriesContainer.fullName);
        dssTS.setRegularIntervalStorePlan(regularStoreMethod);
        dssTS.setIrregularIntervalInFlag(irregularStoreMethod);
        status = dssTS.write(timeSeriesContainer);
        dssTS.done();
        return status;
    }

    @Override
    public int writePD(DSSIdentifier dssId, double[] xBuffer, Vector yBuffer, int numberOrdinates, boolean writeToDisk) {
        HecPairedData dssPD = new HecPairedData();
        String path = this.processPath(dssId.getFileName());
        dssPD.setDSSFileName(path);
        dssPD.setPathname(dssId.getDSSPath());
        dssPD.setStoreDoubles(true);
        int numberRead = dssPD.write(xBuffer, yBuffer, numberOrdinates, writeToDisk);
        dssPD.done();
        return numberRead;
    }

    @Override
    public int writePD(DSSIdentifier dssId, HecDoubleArray xBuffer, Vector yBuffer, boolean writeToDisk) {
        HecPairedData dssPD = new HecPairedData();
        String path = this.processPath(dssId.getFileName());
        dssPD.setDSSFileName(path);
        dssPD.setPathname(dssId.getDSSPath());
        dssPD.setStoreDoubles(true);
        int numberRead = dssPD.write(xBuffer, yBuffer, writeToDisk);
        dssPD.done();
        return numberRead;
    }

    @Override
    public int writePD(DSSIdentifier dssId, double[] xBuffer, double[] yBuffer, int numberOrdinates, boolean tf) {
        HecPairedData dssPD = new HecPairedData();
        String path = this.processPath(dssId.getFileName());
        dssPD.setDSSFileName(path);
        dssPD.setPathname(dssId.getDSSPath());
        dssPD.setStoreDoubles(true);
        int numberRead = dssPD.write(xBuffer, yBuffer, numberOrdinates, tf);
        dssPD.done();
        return numberRead;
    }

    @Override
    public int writePD(DSSIdentifier dssId, HecDoubleArray xBuffer, HecDoubleArray yBuffer, boolean writeToDisk) {
        HecPairedData dssPD = new HecPairedData();
        String path = this.processPath(dssId.getFileName());
        dssPD.setDSSFileName(path);
        dssPD.setPathname(dssId.getDSSPath());
        dssPD.setStoreDoubles(true);
        int numberRead = dssPD.write(xBuffer, yBuffer, writeToDisk);
        dssPD.done();
        return numberRead;
    }

    @Override
    public int writePD(DSSIdentifier dssId, double[] xBuffer, double[][] yBuffer, int numberOrdinates, int numberCurves, boolean writeToDisk) {
        HecPairedData dssPD = new HecPairedData();
        String path = this.processPath(dssId.getFileName());
        dssPD.setDSSFileName(path);
        dssPD.setPathname(dssId.getDSSPath());
        dssPD.setStoreDoubles(true);
        int numberRead = dssPD.write(xBuffer, yBuffer, numberOrdinates, numberCurves, writeToDisk);
        dssPD.done();
        return numberRead;
    }

    @Override
    public int writePD(DSSIdentifier dssId, double[] xBuffer, double[] yBuffer, int numberOrdinates, String[] sarray, boolean writeToDisk) {
        HecPairedData dssPD = new HecPairedData();
        String path = this.processPath(dssId.getFileName());
        dssPD.setDSSFileName(path);
        dssPD.setPathname(dssId.getDSSPath());
        dssPD.setXType(sarray[0]);
        dssPD.setYType(sarray[1]);
        dssPD.setXUnits(sarray[2]);
        dssPD.setYUnits(sarray[3]);
        dssPD.setLabel(sarray[4]);
        dssPD.setStoreDoubles(true);
        int numberRead = dssPD.write(xBuffer, yBuffer, numberOrdinates, writeToDisk);
        dssPD.done();
        return numberRead;
    }

    @Override
    public int writePD(DSSIdentifier dssId, double[] xBuffer, double[][] yBuffer, int numberOrdinates, int numberCurves, String xType, String yType, String xUnits, String yUnits, Vector labels, boolean writeToDisk) {
        HecPairedData dssPD = new HecPairedData();
        String path = this.processPath(dssId.getFileName());
        dssPD.setDSSFileName(path);
        dssPD.setPathname(dssId.getDSSPath());
        dssPD.setXType(xType);
        dssPD.setYType(yType);
        dssPD.setXUnits(xUnits);
        dssPD.setYUnits(yUnits);
        dssPD.setLabels(labels);
        dssPD.setStoreDoubles(true);
        int numberRead = dssPD.write(xBuffer, yBuffer, numberOrdinates, numberCurves, writeToDisk);
        dssPD.done();
        return numberRead;
    }

    public int writePD(PairedDataContainer pairedDataContainer) {
        HecPairedData dssPD = new HecPairedData();
        int status = dssPD.write(pairedDataContainer);
        return status;
    }

    @Override
    public boolean copyGriddedRecord(DSSIdentifier dssTo, DSSIdentifier dssFrom) {
        if (dssTo == null || dssFrom == null) {
            return false;
        }
        Vector results = null;
        try {
            results = this.getGriddedData(dssFrom);
        }
        catch (Exception e) {
            System.out.println("copyGriddedRecord:Exception " + e + " in reading gridded record from " + dssTo.getFileName());
            return false;
        }
        catch (Error ee) {
            System.out.println("copyGriddedRecord:Error " + ee + " in reading gridded record from " + dssTo.getFileName());
            return false;
        }
        if (results == null || results.isEmpty()) {
            return false;
        }
        GridData grid = (GridData)results.elementAt(1);
        AlbersInfo albers = (AlbersInfo)grid.getGridInfo();
        int status = -1;
        try {
            status = this.storeGriddedData(dssTo, (GridInfo)albers, grid);
        }
        catch (Exception e) {
            System.out.println("copyGriddedRecord:Exception " + e + " in write gridded record to " + dssFrom.getFileName());
            return false;
        }
        catch (Error ee) {
            System.out.println("copyGriddedRecord:Error " + ee + " in write gridded record to " + dssFrom.getFileName());
            return false;
        }
        return status >= 0;
    }

    @Override
    public Vector getGriddedData(DSSIdentifier dssId) {
        return this.getGriddedData(dssId, true);
    }

    @Override
    public Vector getGriddedData(DSSIdentifier dssId, boolean retrieveData) {
        return this.getGriddedData(dssId, retrieveData, false);
    }

    public Vector getGriddedData(DSSIdentifier dssId, boolean retrieveData, boolean showDebug) {
        if (dssId == null) {
            return null;
        }
        String gridFile = dssId.getFileName();
        if (!HecDSSFileAccess.doesDSSFileExist((String)gridFile)) {
            return null;
        }
        GriddedData gd = new GriddedData(showDebug);
        gd.setDSSFileName(gridFile, true);
        String pathName = dssId.getDSSPath();
        if (pathName.indexOf("/") > -1) {
            gd.setPathname(pathName);
        } else {
            gd.setPathnameParts(pathName);
        }
        if (dssId.getEndTime() == null || !dssId.getEndTime().isDefined()) {
            gd.setGridTime(dssId.getStartTime());
        } else {
            gd.setGriddedTimeWindow(dssId.getStartTime(), dssId.getEndTime());
        }
        GridData grid = new GridData();
        int[] stat = new int[1];
        GridInfo info = gd.retrieveGriddedData(retrieveData, grid, stat);
        gd.done();
        if (stat[0] < 0 || info == null) {
            if (showDebug) {
                System.out.println("Error in DSSFileManager.getGriddedData stat=" + stat[0]);
                System.out.println("Error in Retrieving Gridded Data. GridInfo=" + info);
                System.out.println("Trying to read Pathname: " + dssId.getDSSPath());
                System.out.println("Trying to read file: " + dssId.getFileName());
            }
            return null;
        }
        Vector<Object> results = new Vector<Object>(2);
        results.addElement(info);
        results.addElement(grid);
        return results;
    }

    @Override
    public int storeGriddedData(DSSIdentifier dssId, GridInfo albers, GridData grid) {
        if (dssId == null || albers == null || grid == null) {
            System.out.println("storeGriddedData: null arguments recieved");
            return -1;
        }
        String gridFile = dssId.getFileName();
        GriddedData gd = new GriddedData();
        gd.setDSSFileName(gridFile);
        String pathName = dssId.getDSSPath();
        if (pathName.indexOf("/") > -1) {
            gd.setPathname(pathName);
        } else {
            gd.setPathnameParts(pathName);
        }
        if (dssId.getEndTime() == null || !dssId.getEndTime().isDefined()) {
            gd.setGridTime(dssId.getStartTime());
        } else {
            gd.setGriddedTimeWindow(dssId.getStartTime(), dssId.getEndTime());
        }
        int stat = gd.storeGriddedData(albers, grid);
        gd.done();
        if (stat < 0) {
            System.out.println("Error in DSSFileManager.getGriddedData");
            System.out.println("Error in Storing Gridded Data");
            System.out.println("Trying to read Pathname: " + dssId.getDSSPath());
            System.out.println("Trying to read file: " + dssId.getFileName());
            return stat;
        }
        return stat;
    }

    @Override
    public int write(DSSIdentifier dssId, double[] array, int numSteps, boolean tf) throws RemoteException {
        return this.write(dssId, array, numSteps, tf, false, true);
    }

    @Override
    public int write(DSSIdentifier dssId, double[] array, int numSteps, boolean tf, boolean compress) throws RemoteException {
        return this.write(dssId, array, numSteps, tf, compress, true);
    }

    @Override
    public int write(DSSIdentifier dssId, double[] array, int numSteps, boolean tf, boolean compress, boolean storeAsDoubles) throws RemoteException {
        int i;
        if (dssId == null || dssId.getFileName() == null || dssId.getDSSPath() == null) {
            throw new RemoteException("Invalid DSS Identifier;  DSSFileManagerWrite");
        }
        DSSPathname path = new DSSPathname(dssId.getDSSPath());
        if (!path.isTimeSeries()) {
            throw new RemoteException("Invalid Time Series Identifier;  Pathname = " + dssId.getDSSPath() + "\nDSSFileManagerWrite");
        }
        int intl = HecTimeSeries.getIntervalFromEPart((String)path.ePart());
        if (intl < 0) {
            throw new RemoteException("Invalid Time Series Interval;  Pathname = " + dssId.getDSSPath() + "\nDSSFileManagerWrite");
        }
        HecTime start = dssId.getStartTime();
        if (!start.isDateDefined()) {
            throw new RemoteException("Invalid Start Time;  Pathname = " + dssId.getDSSPath() + "\nDSSFileManagerWrite");
        }
        start = new HecTime(start);
        TimeSeriesContainer tsc = null;
        String verticalDatumInfo = dssId.getVerticalDatumInfo();
        String currentVerticalDatum = dssId.getCurrentVerticalDatum();
        String parameter = path.getCPart();
        if (verticalDatumInfo != null && TimeSeriesContainerVertDatum.isCorrectParameter((String)parameter)) {
            tsc = new TimeSeriesContainerVertDatum();
            tsc.parameter = parameter;
            try {
                ((TimeSeriesContainerVertDatum)tsc).setVerticalDatumInfo(verticalDatumInfo);
                if (currentVerticalDatum != null) {
                    ((TimeSeriesContainerVertDatum)tsc).forceVerticalDatum(currentVerticalDatum);
                }
            }
            catch (VerticalDatumException e) {
                e.printStackTrace();
            }
        } else {
            tsc = new TimeSeriesContainer();
        }
        tsc.fullName = path.getPathname();
        tsc.fileName = dssId.getFileName();
        tsc.values = array;
        tsc.numberValues = numSteps;
        tsc.interval = intl;
        tsc.startTime = start.value();
        tsc.times = new int[numSteps];
        tsc.times[0] = tsc.startTime;
        if (intl <= 1440) {
            for (i = 1; i < numSteps; ++i) {
                tsc.times[i] = tsc.times[i - 1] + intl;
            }
        } else {
            for (i = 1; i < numSteps; ++i) {
                start.increment(1, intl);
                tsc.times[i] = start.value();
            }
        }
        if (dssId.getUnits() != null) {
            tsc.units = dssId.getUnits();
        }
        if (dssId.getType() != null) {
            tsc.type = dssId.getType();
        }
        tsc.setCompressData(compress);
        tsc.storedAsdoubles = storeAsDoubles;
        if (dssId.getTimeZoneID() != null) {
            tsc.timeZoneID = dssId.getTimeZoneID();
        }
        int status = this.writeTS(tsc, 0, 0);
        return status;
    }

    @Override
    public DSSArrayContainer read(DSSIdentifier dssId) throws RemoteException, FileNotFoundException {
        HecTimeSeries timeSeries;
        String path = this.processPath(dssId.getFileName());
        if (path != null) {
            path = path.trim();
        }
        if (path == null || path.isEmpty()) {
            throw new RemoteException("read: Error no file specified. DssPath=" + dssId.getDSSPath());
        }
        File f = new File(path);
        if (!f.exists()) {
            throw new FileNotFoundException("File " + path + " doesn't exist");
        }
        HecDataManager dataManager = this.getDataManager(path);
        try {
            timeSeries = this.getTimeSeries(dataManager, dssId.getDSSPath());
        }
        catch (IllegalArgumentException e) {
            System.out.println("read:error reading " + path + ":" + dssId.getDSSPath());
            throw new RemoteException("read: Error.", e);
        }
        if (timeSeries == null) {
            return null;
        }
        timeSeries.setReadPreviousSubsquent(dssId.getReadPrevious(), dssId.getReadSubsequent());
        if (dssId.getStartTime() != null && dssId.getEndTime() != null) {
            timeSeries.setStartTime(dssId.getStartTime());
            timeSeries.setEndTime(dssId.getEndTime());
        } else if (dssId.getTimeWindow() != null) {
            timeSeries.setTimeWindow(dssId.getTimeWindow());
        }
        DSSArrayContainer dssArray = new DSSArrayContainer(dssId);
        intArrayContainer timeArray = new intArrayContainer();
        doubleArrayContainer dataArray = new doubleArrayContainer();
        TimeSeriesContainer tsc = new TimeSeriesContainer();
        int status = timeSeries.read(tsc, false);
        if (status != 0) {
            throw new RemoteException("DSS read status = " + status);
        }
        dssArray.numberRead = tsc.getNumberValues();
        dssArray.timeArray = tsc.getMinutes();
        dssArray.dataArray = tsc.getValues();
        dssArray.setUnits(tsc.getUnits());
        dssArray.setType(tsc.getType());
        HashMap si = tsc.getSupplementalInfo();
        if (si.containsKey("verticalDatumInfo")) {
            try {
                dssArray.setVerticalDatumInfo(TextUtil.uncompress((String)((String)si.get("verticalDatumInfo")), (String)"base64"));
            }
            catch (IOException e) {
                throw (RemoteException)e;
            }
            si.remove("verticalDatumInfo");
        }
        if (si.containsKey("verticalDatum")) {
            dssArray.setCurrentVerticalDatum((String)si.get("verticalDatum"));
            si.remove("verticalDatum");
        }
        return dssArray;
    }

    @Override
    public TimeSeriesContainer readTS(DSSIdentifier dssId, boolean removeMissing) throws RemoteException, FileNotFoundException {
        return this.readTS(dssId, false, removeMissing);
    }

    @Override
    public TimeSeriesContainer readTS(DSSIdentifier dssId, boolean getRecordInfo, boolean removeMissing) throws RemoteException, FileNotFoundException {
        HecTimeSeries timeSeries;
        if (dssId == null || dssId.getFileName() == null || dssId.getDSSPath() == null) {
            System.out.println("readTS: null DSSIdentifier or missing DSSIdentifier info " + dssId);
            return null;
        }
        String path = this.processPath(dssId.getFileName());
        File f = new File(path);
        if (!f.exists()) {
            System.out.println("File " + path + " doesn't exist");
        }
        HecDataManager dataManager = this.getDataManager(dssId.getFileName());
        try {
            timeSeries = this.getTimeSeries(dataManager, dssId.getDSSPath());
        }
        catch (IllegalArgumentException e) {
            throw new RemoteException("read: Error.", e);
        }
        timeSeries.setReadPreviousSubsquent(dssId.getReadPrevious(), dssId.getReadSubsequent());
        if (timeSeries == null) {
            return null;
        }
        if (dssId.getStartTime() != null && dssId.getEndTime() != null) {
            timeSeries.setStartTime(dssId.getStartTime());
            timeSeries.setEndTime(dssId.getEndTime());
        } else if (dssId.getTimeWindow() != null) {
            timeSeries.setTimeWindow(dssId.getTimeWindow());
        }
        TimeSeriesContainer tsc = new TimeSeriesContainer();
        if (getRecordInfo) {
            tsc.otherInfo = new HecDSSRecordInfo();
        }
        if (dssId.getTimeZoneID() != null) {
            tsc.timeZoneID = dssId.getTimeZoneID();
        }
        timeSeries.read(tsc, removeMissing);
        return tsc;
    }

    @Override
    public boolean getTimeSeriesExtents(DSSIdentifier dssId, HecTime startTime, HecTime endTime) throws RemoteException {
        HecDataManager dataManager = this.getDataManager(dssId.getFileName());
        return dataManager.getTimeSeriesExtents(dssId.getDSSPath(), startTime, endTime);
    }

    @Override
    public int getTSRecordInfo(DSSIdentifier dssId, HecTime startTime, HecTime endTime, stringContainer units, stringContainer type) throws RemoteException {
        HecDataManager dataManager = this.getDataManager(dssId.getFileName());
        if (dssId.getDSSPath() != null) {
            dataManager.setPathname(dssId.getDSSPath());
        }
        return dataManager.getTSRecordInfo(startTime, endTime, units, type);
    }

    @Override
    public TextContainer readTextData(DSSIdentifier dssId) throws RemoteException {
        HecDataManager dataManager = this.getDataManager(dssId.getFileName());
        HecDssText dssDataSet = dataManager.createTextObject(dssId.getDSSPath());
        if (!(dssDataSet instanceof HecDssText)) {
            throw new RemoteException("readTextData: Error", new IllegalArgumentException(dssId.getDSSPath() + " Data Set is not a HecDssText. Its " + (HecDataManager)dssDataSet != null ? dssDataSet.getClass().getName() : "null"));
        }
        if (dssDataSet == null) {
            return null;
        }
        HecDssText dssText = dssDataSet;
        TextContainer tc = new TextContainer();
        dssText.read(tc);
        return tc;
    }

    @Override
    public int writeTextData(DSSIdentifier dssId, TextContainer textContainer) throws RemoteException {
        HecDataManager dataManager = this.getDataManager(dssId.getFileName());
        HecDssText dssDataSet = dataManager.createTextObject(dssId.getDSSPath());
        if (!(dssDataSet instanceof HecDssText)) {
            throw new RemoteException("writeTextData: Error", new IllegalArgumentException(dssId.getDSSPath() + " Data Set is not a HecDssText. Its " + (HecDataManager)dssDataSet != null ? dssDataSet.getClass().getName() : "null"));
        }
        if (dssDataSet == null) {
            return -2;
        }
        HecDssText dssText = dssDataSet;
        return dssText.write(textContainer);
    }

    @Override
    public int writeTextData(DSSIdentifier dssId, String text) throws RemoteException {
        ((MarkingClassLogger.Api)LOGGER.atFine()).log("Write text data: %s path: %s text: %s", (Object)LazyArgs.lazy(() -> dssId.getFileName()), (Object)LazyArgs.lazy(() -> dssId.getDSSPath()), (Object)text);
        HecDataManager dataManager = this.getDataManager(dssId.getFileName());
        ((MarkingClassLogger.Api)LOGGER.atFine()).log("dataManager: %s", (Object)dataManager);
        HecDssText dssDataSet = dataManager.createTextObject(dssId.getDSSPath());
        ((MarkingClassLogger.Api)LOGGER.atFine()).log("dssDataSet: %s", (Object)dssDataSet);
        if (!(dssDataSet instanceof HecDssText)) {
            throw new RemoteException("writeTextData: Error", new IllegalArgumentException(dssId.getDSSPath() + " Data Set is not a HecDssText. Its " + (HecDataManager)dssDataSet != null ? dssDataSet.getClass().getName() : "null"));
        }
        if (dssDataSet == null) {
            return -2;
        }
        ((MarkingClassLogger.Api)LOGGER.atFine()).log("Attempting write.");
        HecDssText dssText = dssDataSet;
        int status = dssText.write(text);
        ((MarkingClassLogger.Api)LOGGER.atFine()).log("Status of write: %s", status);
        return status;
    }

    @Override
    public DssFileContainer readFileData(DSSIdentifier dssId) throws RemoteException {
        HecDssFileStore dataManager = new HecDssFileStore();
        dataManager.setDSSFileName(dssId.getFileName());
        dataManager.setPathname(dssId.getDSSPath());
        DssFileContainer fileContainer = new DssFileContainer();
        dataManager.read(fileContainer);
        return fileContainer;
    }

    @Override
    public int writeFileData(DssFileContainer dssFileContainer) throws RemoteException {
        HecDssFileStore dataManager = new HecDssFileStore();
        return dataManager.write(dssFileContainer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(DSSIdentifier dssId) {
        HecDataManager dataManager = this.getDataManager(dssId.getFileName());
        try {
            boolean doesExist = dataManager.recordExists(dssId.getDSSPath());
            if (doesExist) {
                boolean bl = true;
                return bl;
            }
            HecTimeSeries timeSeries = null;
            try {
                timeSeries = this.getTimeSeries(dataManager, dssId.getDSSPath());
                if (timeSeries == null) {
                    boolean bl = doesExist;
                    return bl;
                }
            }
            catch (Exception e) {
                boolean bl = false;
                return bl;
            }
            timeSeries.setReadPreviousSubsquent(dssId.getReadPrevious(), dssId.getReadSubsequent());
            if (dssId.getStartTime() != null && dssId.getEndTime() != null) {
                timeSeries.setStartTime(dssId.getStartTime());
                timeSeries.setEndTime(dssId.getEndTime());
            } else if (dssId.getTimeWindow() != null) {
                timeSeries.setTimeWindow(dssId.getTimeWindow());
            }
            doubleArrayContainer dataArray = new doubleArrayContainer();
            int numread = timeSeries.read(dataArray);
            if (numread > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            dataManager.done();
        }
    }

    @Override
    public Vector searchDSSPaths(DSSIdentifier dssId, String scanstring) throws RemoteException {
        Vector pathnameList = new Vector();
        if (dssId == null || scanstring == null) {
            return pathnameList;
        }
        HecDssCatalog dssCatalog = new HecDssCatalog();
        String filePath = this.processPath(dssId.getFileName());
        int openStatus = dssCatalog.setDSSFileName(filePath, true);
        if (openStatus < 0) {
            return pathnameList;
        }
        dssCatalog.searchDSSPaths(scanstring, pathnameList);
        dssCatalog.done();
        dssCatalog = null;
        return pathnameList;
    }

    @Override
    public Vector searchDSSCatalog(DSSIdentifier dssId, String scanstring) throws RemoteException {
        Vector pathnameList = new Vector();
        if (dssId == null || scanstring == null) {
            return pathnameList;
        }
        HecDssCatalog dssCatalog = new HecDssCatalog();
        String filePath = this.processPath(dssId.getFileName());
        int openStatus = dssCatalog.setDSSFileName(filePath, true);
        if (openStatus < 0) {
            return pathnameList;
        }
        dssCatalog.searchDSSCatalog(scanstring, pathnameList);
        dssCatalog.done();
        dssCatalog = null;
        return pathnameList;
    }

    @Override
    public String[] getPathnameList(DSSIdentifier dssId, boolean forceUpdate) throws RemoteException {
        if (dssId == null) {
            return null;
        }
        HecDssCatalog dssCatalog = new HecDssCatalog();
        String filePath = this.processPath(dssId.getFileName());
        int openStatus = dssCatalog.setDSSFileName(filePath, true);
        if (openStatus < 0) {
            return null;
        }
        String[] paths = dssCatalog.getPathnameList(forceUpdate);
        dssCatalog.done();
        dssCatalog = null;
        return paths;
    }

    @Override
    public Vector searchDSSPaths(DSSIdentifier dssId, String partA, String partB, String partC, String partD, String partE, String partF) {
        Vector pathnameList = new Vector();
        if (dssId == null) {
            return pathnameList;
        }
        HecDssCatalog dssCatalog = new HecDssCatalog();
        String filePath = this.processPath(dssId.getFileName());
        int openStatus = dssCatalog.setDSSFileName(filePath, true);
        if (openStatus < 0) {
            return pathnameList;
        }
        dssCatalog.searchDSSPaths(partA, partB, partC, partD, partE, partF, pathnameList);
        dssCatalog.done();
        dssCatalog = null;
        return pathnameList;
    }

    @Override
    public Vector searchDSSPaths(DSSIdentifier dssId) {
        if (dssId == null) {
            return null;
        }
        Vector pathNames = DSSPathname.parseDssPath((String)dssId.getDSSPath());
        if (pathNames == null) {
            return null;
        }
        pathNames.trimToSize();
        Object[] parts = new String[6];
        pathNames.copyInto(parts);
        return this.searchDSSPaths(dssId, (String)parts[0], (String)parts[1], (String)parts[2], (String)parts[3], (String)parts[4], (String)parts[5]);
    }

    @Override
    public Vector<CondensedReference> getCondensedCatalog(String fileName) throws RemoteException {
        HecDSSUtilities utilities = new HecDSSUtilities();
        utilities.setDSSFileName(fileName);
        return utilities.getCondensedCatalog();
    }

    @Override
    public int numberRecords(String DSSFileName) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDataManager dataManager = this.getDataManager(DSSFileName);
        return dataManager.numberRecords();
    }

    @Override
    public int recordType(String DSSFileName, String pathname) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDataManager dataManager = this.getDataManager(DSSFileName);
        return dataManager.recordType(pathname);
    }

    @Override
    public int recordType(DSSIdentifier dssId) {
        HecDataManager dataManager = this.getDataManager(dssId.getFileName());
        return dataManager.recordType(dssId.getDSSPath());
    }

    @Override
    public Map<String, Integer> recordTypes(String DSSFileName, String[] pathnames) {
        HecDataManager dataManager = this.getDataManager(DSSFileName);
        return dataManager.recordTypes(pathnames);
    }

    @Override
    public void setMessageLevel(int level) {
        HecDataManager.setMessageLevel((int)level);
    }

    @Override
    public void setUnit(int unit) {
        HecDataManager.setUnit((int)unit);
    }

    @Override
    public void close(String dssFileName) {
        HecDataManager dataManager = this.getDataManager(dssFileName);
        dataManager.close();
    }

    @Override
    public boolean fileOpened(String DSSFileName) {
        if (DSSFileName == null) {
            return false;
        }
        HecDataManager dataManager = this.getDataManager(DSSFileName);
        boolean opened = dataManager.fileOpened();
        return opened;
    }

    @Override
    public boolean recordExists(String DSSFileName, String pathname) {
        if (DSSFileName == null) {
            return false;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.recordExists(pathname);
    }

    @Override
    public boolean fileAccessible(String DSSFileName) {
        if (DSSFileName == null) {
            return false;
        }
        HecDataManager dataManager = this.getDataManager(DSSFileName);
        boolean opened = dataManager.fileAccessible();
        return opened;
    }

    @Override
    public int setDSSFileName(String dssFileName, boolean fileMustExist) {
        HecDataManager dataManager = this.getDataManager(dssFileName);
        return 0;
    }

    @Override
    public int setDSSFileName(String dssFileName, boolean fileMustExist, int version) {
        HecDataManager dataManager = this.getDataManager(dssFileName, version);
        return 0;
    }

    @Override
    public boolean writeAccess(String DSSFileName) {
        if (DSSFileName == null) {
            return false;
        }
        HecDataManager dataManager = this.getDataManager(DSSFileName);
        return dataManager.writeAccess();
    }

    @Override
    public boolean checkForSevereError(String DSSFileName) throws RemoteException {
        if (DSSFileName == null) {
            return false;
        }
        HecDataManager dataManager = this.getDataManager(DSSFileName);
        if (dataManager == null) {
            return false;
        }
        return dataManager.checkForSevereFileError();
    }

    @Override
    public boolean checkForSevereError() throws RemoteException {
        return HecDataManager.checkForSevereError();
    }

    @Override
    public void clearSevereError() throws RemoteException {
        String dssFileName = HecDataManager.defaultDSSFileName();
        if (dssFileName == null) {
            return;
        }
        HecDataManager dataManager = this.getDataManager(dssFileName);
        dataManager.clearSevereError(true);
    }

    @Override
    public void clearSevereError(String DSSFileName) throws RemoteException {
        if (DSSFileName == null) {
            return;
        }
        HecDataManager dataManager = this.getDataManager(DSSFileName);
        dataManager.clearSevereError(true);
    }

    @Override
    public DSSErrorMessage lastSevereErrorMessage(String DSSFileName) throws RemoteException {
        if (DSSFileName == null) {
            return null;
        }
        HecDataManager dataManager = this.getDataManager(DSSFileName);
        return dataManager.lastSevereErrorMessage();
    }

    @Override
    public DSSErrorMessage lastSevereErrorMessage() throws RemoteException {
        String dssFileName = HecDataManager.defaultDSSFileName();
        if (dssFileName == null) {
            return null;
        }
        HecDataManager dataManager = this.getDataManager(dssFileName);
        return dataManager.lastSevereErrorMessage();
    }

    @Override
    public List<DSSErrorMessage> allSevereErrorMessages() throws RemoteException {
        String dssFileName = HecDataManager.defaultDSSFileName();
        if (dssFileName == null) {
            return null;
        }
        HecDataManager dataManager = this.getDataManager(dssFileName);
        return dataManager.allSevereErrorMessages();
    }

    @Override
    public void cancelProcess(String DSSFileName) {
        if (DSSFileName == null) {
            return;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        dataManager.cancelProcess();
    }

    public void cancelSqueeze(String DSSFileName) {
        if (DSSFileName == null) {
            return;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        dataManager.cancelSqueeze();
    }

    @Override
    public int copyFile(String DSSFileName, String secondDSSFilename) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.copyFile(secondDSSFilename);
    }

    @Override
    public int copyRecordsFrom(String fromDSSFilename, String toDSSFilename, List<String> pathnameList) {
        if (fromDSSFilename == null || toDSSFilename == null || pathnameList == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(fromDSSFilename);
        return dataManager.copyRecordsFrom(toDSSFilename, pathnameList);
    }

    @Override
    public int copyRecordsInto(String DSSFileName, String fromDSSFilename, List<String> pathnameList) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.copyRecordsInto(fromDSSFilename, pathnameList);
    }

    @Override
    public int delete(String DSSFileName, List<String> pathnameList) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.delete(pathnameList);
    }

    @Override
    public int duplicateRecords(String DSSFileName, List<String> pathnameList, List<String> newPathnameList) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.duplicateRecords(pathnameList, newPathnameList);
    }

    @Override
    public int renameRecords(String DSSFileName, List<String> pathnameList, List<String> newPathnameList) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.renameRecords(pathnameList, newPathnameList);
    }

    @Override
    public int squeeze(String DSSFileName) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.squeeze();
    }

    @Override
    public int undoLastDelete(String DSSFileName) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.undoLastDelete();
    }

    @Override
    public int undelete(String DSSFileName, List<String> pathnames) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.undelete(pathnames);
    }

    public Vector getLastDeletePathnames(String DSSFileName) {
        if (DSSFileName == null) {
            return new Vector();
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.getLastDeletePathnames();
    }

    @Override
    public int checkAllPathnames(String DSSFileName) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.checkAllPathnames();
    }

    @Override
    public int checkLinks(String DSSFileName) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.checkLinks();
    }

    @Override
    public int checkPathnameBins(String DSSFileName) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.checkPathnameBins();
    }

    @Override
    public int fileStats(String DSSFileName) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.fileStats();
    }

    @Override
    public int createNewCatalog(String DSSFileName, int catalogType) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.createNewCatalog(catalogType);
    }

    @Override
    public String getCatalogName(String DSSFileName, int catalogType) {
        if (DSSFileName == null) {
            return "";
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.getCatalogName(catalogType);
    }

    @Override
    public boolean isCatalogValid(String DSSFileName) {
        if (DSSFileName == null) {
            return false;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.isCatalogValid();
    }

    @Override
    public void done(String DSSFileName) {
        if (DSSFileName == null) {
            return;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        dataManager.done();
    }

    @Override
    public void getProcessStatus(String DSSFileName, int[] numberRecs, int[] currentRec) {
        if (DSSFileName == null) {
            return;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        dataManager.getProcessStatus(numberRecs, currentRec);
    }

    @Override
    public void setInterrupt(String DSSFileName, boolean interrupt) {
        if (DSSFileName == null) {
            return;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        dataManager.setInterrupt(interrupt);
    }

    @Override
    public void clearStatus(String DSSFileName) {
        if (DSSFileName == null) {
            return;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        dataManager.clearStatus();
    }

    @Override
    public int forceMultiUserAccess(String DSSFileName) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDSSUtilities dataManager = this.getHecDSSUtilities(DSSFileName);
        return dataManager.forceMultiUserAccess();
    }

    @Override
    public int zinqir(String DSSFileName, String parameter) {
        if (DSSFileName == null) {
            return -1;
        }
        HecDataManager dataManager = this.getDataManager(DSSFileName);
        return dataManager.zinqir(parameter);
    }

    @Override
    public ResultZinqir zinqir(String DSSFileName, String parameter, stringContainer alpha, int[] number) {
        if (DSSFileName == null) {
            return null;
        }
        HecDataManager dataManager = this.getDataManager(DSSFileName);
        if (dataManager == null) {
            return null;
        }
        dataManager.zinqir(parameter, alpha, number);
        return new ResultZinqir(alpha.toString(), number[0]);
    }

    @Override
    public ResultZquery zquery(String parameter, stringContainer alpha, int[] number) {
        Heclib.zquery((String)parameter, (stringContainer)alpha, (int[])number);
        return new ResultZquery(alpha.toString(), number[0]);
    }

    @Override
    public void zset(String parameter, String alpha, int number) {
        HecDataManager.zset((String)parameter, (String)alpha, (int)number);
    }

    @Override
    @Deprecated
    public DataSetTx readDataSet(String dssfile, String dsspath, TimeZone tz, DataSetTxTemplate datatemplate, DataSetTxTemplate derivetemplate) throws FileNotFoundException, DSSTimeSeriesReadException {
        return this.readDataSet(dssfile, dsspath, tz, null, datatemplate, derivetemplate);
    }

    @Override
    public TimeSeries readDataSet(String dssfile, String dsspath, TimeZone tz, TimeSeriesTemplate datatemplate, TimeSeriesTemplate derivetemplate) throws FileNotFoundException, DSSTimeSeriesReadException {
        return this.readDataSet(dssfile, dsspath, tz, null, datatemplate, derivetemplate);
    }

    @Override
    @Deprecated
    public DataSetTx readDataSet(String dssfile, String dsspath, TimeZone tz, TimeZone tzOverride, DataSetTxTemplate datatemplate, DataSetTxTemplate derivetemplate) throws FileNotFoundException, DSSTimeSeriesReadException {
        if (datatemplate == null) {
            throw new DSSTimeSeriesReadException("Time series derive template is undefined.");
        }
        long startTime = datatemplate.getStartTime();
        long endTime = datatemplate.getEndTime();
        return this.readDataSet(dssfile, startTime, endTime, dsspath, tz, tzOverride, datatemplate, derivetemplate);
    }

    @Override
    public TimeSeries readDataSet(String dssfile, String dsspath, TimeZone tz, TimeZone tzOverride, TimeSeriesTemplate datatemplate, TimeSeriesTemplate derivetemplate) throws FileNotFoundException, DSSTimeSeriesReadException {
        if (datatemplate == null) {
            throw new DSSTimeSeriesReadException("Time series derive template is undefined.");
        }
        long startTime = datatemplate.getStartTime();
        long endTime = datatemplate.getEndTime();
        return this.readDataSet(dssfile, startTime, endTime, dsspath, tz, tzOverride, datatemplate, derivetemplate);
    }

    @Override
    @Deprecated
    public DataSetTx readDataSet(String dssfile, long startTime, long endTime, String dsspath, TimeZone tz) throws FileNotFoundException, DSSTimeSeriesReadException {
        return this.readDataSet(dssfile, startTime, endTime, dsspath, tz, null, (DataSetTxTemplate)null, null);
    }

    @Override
    public TimeSeries readTimeSeries(String dssfile, long startTime, long endTime, String dsspath, TimeZone tz) throws FileNotFoundException, DSSTimeSeriesReadException {
        return this.readDataSet(dssfile, startTime, endTime, dsspath, tz, null, (TimeSeriesTemplate)null, null);
    }

    @Override
    @Deprecated
    public DataSetTx readDataSet(String dssfile, long startTime, long endTime, String dsspath, TimeZone tz, TimeZone timeZoneOverride) throws FileNotFoundException, DSSTimeSeriesReadException {
        return this.readDataSet(dssfile, startTime, endTime, dsspath, tz, timeZoneOverride, (DataSetTxTemplate)null, (DataSetTxTemplate)null);
    }

    @Override
    public TimeSeries readTimeSeries(String dssfile, long startTime, long endTime, String dsspath, TimeZone tz, TimeZone timeZoneOverride) throws FileNotFoundException, DSSTimeSeriesReadException {
        return this.readDataSet(dssfile, startTime, endTime, dsspath, tz, timeZoneOverride, (TimeSeriesTemplate)null, null);
    }

    private DataSetTx readDataSet(String dssfile, long startTime, long endTime, String dsspath, TimeZone timeZone, TimeZone timeZoneOverride, DataSetTxTemplate datatemplate, DataSetTxTemplate derivetemplate) throws FileNotFoundException, DSSTimeSeriesReadException {
        TimeSeries timeSeries;
        TimeSeriesTemplate dataTimeSeriesTemplate = null;
        TimeSeriesTemplate deriveTimeSeriesTemplate = null;
        if (datatemplate != null) {
            dataTimeSeriesTemplate = datatemplate.getTimeSeriesTemplate();
        }
        if (derivetemplate != null) {
            deriveTimeSeriesTemplate = derivetemplate.getTimeSeriesTemplate();
        }
        if ((timeSeries = this.readDataSet(dssfile, startTime, endTime, dsspath, timeZone, timeZoneOverride, dataTimeSeriesTemplate, deriveTimeSeriesTemplate)) != null) {
            return new DataSetTx(timeSeries);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TimeSeries readDataSet(String dssfile, long startTime, long endTime, String dsspath, TimeZone timeZone, TimeZone timeZoneOverride, TimeSeriesTemplate datatemplate, TimeSeriesTemplate derivetemplate) throws FileNotFoundException, DSSTimeSeriesReadException {
        if (dssfile == null) {
            throw new FileNotFoundException("DSS filepath is undefined.");
        }
        if (dsspath == null) {
            throw new DSSTimeSeriesReadException("DSS path is undefined.");
        }
        DSSTimeSeries dssts = new DSSTimeSeries();
        try {
            dssfile = this.processPath(dssfile);
            dssts.setDSSFileName(dssfile);
            TimeSeries dsstx = null;
            try {
                dsstx = dsspath == null ? dssts.readAndChangeUnits(datatemplate, timeZone, timeZoneOverride) : (datatemplate == null ? dssts.readTimeSeries(dsspath, startTime, endTime, timeZone, timeZoneOverride) : dssts.readAndChangeUnits(datatemplate, timeZone, timeZoneOverride, dsspath));
            }
            catch (DSSTimeSeriesNoDataFoundException | DataSetTxEmptyException e) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)LOGGER.atFine()).withCause(e)).log();
            }
            catch (DataSetIllegalArgumentException | DataSetTxException | UtcIntervalOffsetMismatchException | mil.army.usace.hec.metadata.DataSetException e) {
                throw new DSSTimeSeriesReadException((Exception)e);
            }
            catch (DSSTimeSeriesReadException e) {
                throw e;
            }
            if (dsstx != null && derivetemplate != null) {
                try {
                    dsstx = new TimeSeriesDerive().derive(dsstx, derivetemplate);
                }
                catch (mil.army.usace.hec.metadata.DataSetException e) {
                    throw new DSSTimeSeriesReadException((Exception)((Object)e));
                }
            }
            ((MarkingClassLogger.Api)LOGGER.atFine()).log("Returning %s", (Object)dsstx);
            TimeSeries timeSeries = dsstx;
            return timeSeries;
        }
        finally {
            dssts.done();
        }
    }

    @Override
    public ExtractStatistic writeDataSet(String dssfile, DataSetTx dataset, DataSetTxTemplate derive, String dsspath, String dssType, TimeZone tz, int rule, boolean overrideProtection, ExtractStatistic es) throws FileNotFoundException, DataSetTxEmptyException, DSSTimeSeriesWriteException {
        TimeSeries timeSeries = dataset == null ? null : dataset.getTimeSeries();
        TimeSeriesTemplate timeSeriesTemplate = derive == null ? null : derive.getTimeSeriesTemplate();
        TimeSeriesStoreRule timeSeriesStoreRule = Arrays.stream(TimeSeriesStoreRule.values()).filter(t -> rule == t.getRuleConstant()).findFirst().orElse(TimeSeriesStoreRule.REPLACE_ALL);
        return this.writeDataSet(dssfile, timeSeries, timeSeriesTemplate, dsspath, dssType, tz, timeSeriesStoreRule, overrideProtection, es);
    }

    @Override
    public ExtractStatistic writeDataSet(String dssfile, TimeSeries dataset, TimeSeriesTemplate derive, String dsspath, String dssType, TimeZone tz, TimeSeriesStoreRule rule, boolean overrideProtection, ExtractStatistic es) throws FileNotFoundException, DataSetTxEmptyException, DSSTimeSeriesWriteException {
        return this.writeDataSet(dssfile, dataset, derive, dsspath, dssType, tz, null, rule, overrideProtection, es);
    }

    @Override
    public ExtractStatistic writeDataSet(String dssfile, DataSetTx dataset, DataSetTxTemplate derive, String dsspath, String dssType, TimeZone timeZone, TimeZone timeZoneOverride, int rule, boolean overrideProtection, ExtractStatistic es) throws FileNotFoundException, DataSetTxEmptyException, DSSTimeSeriesWriteException {
        TimeSeriesTemplate timeSeriesTemplate = derive == null ? null : derive.getTimeSeriesTemplate();
        TimeSeries timeSeries = dataset == null ? null : dataset.getTimeSeries();
        TimeSeriesStoreRule timeSeriesStoreRule = Arrays.stream(TimeSeriesStoreRule.values()).filter(t -> rule == t.getRuleConstant()).findFirst().orElse(TimeSeriesStoreRule.REPLACE_ALL);
        return this.writeDataSet(dssfile, timeSeries, timeSeriesTemplate, dsspath, dssType, timeZone, timeZoneOverride, timeSeriesStoreRule, overrideProtection, es);
    }

    @Override
    public ExtractStatistic writeDataSet(String dssfile, TimeSeries dataset, TimeSeriesTemplate derive, String dsspath, String dssType, TimeZone timeZone, TimeZone timeZoneOverride, TimeSeriesStoreRule rule, boolean overrideProtection, ExtractStatistic es) throws FileNotFoundException, DataSetTxEmptyException, DSSTimeSeriesWriteException {
        TimeZone tz;
        if (dssfile == null) {
            throw new FileNotFoundException("DSS File cannot be null.");
        }
        if (dataset == null) {
            throw new DataSetTxEmptyException("Cannot store a null data set.");
        }
        dssfile = this.processPath(dssfile);
        DSSTimeSeriesTranslator dssRead = new DSSTimeSeriesTranslator();
        dssRead.setDSSFileName(dssfile);
        TimeSeries dsstx = null;
        if (rule != TimeSeriesStoreRule.REPLACE_ALL) {
            try {
                int mlvl;
                if (derive != null) {
                    if (dsspath == null) {
                        dsspath = DSSTimeSeriesUtil.getDefaultPathname((TimeSeriesTemplate)derive);
                    }
                    mlvl = dssRead.getMessageLevel();
                    DSSTimeSeriesTranslator.setMessageLevel((int)1);
                    dsstx = dssRead.readTimeSeries(dsspath, derive.getTimeSeriesIdentifier(), derive.getStartTime(), derive.getEndTime(), timeZone, timeZoneOverride);
                    DSSTimeSeriesTranslator.setMessageLevel((int)mlvl);
                } else {
                    if (dsspath == null) {
                        dsspath = DSSTimeSeriesUtil.getDefaultPathname((TimeSeriesIdentifier)dataset.getTimeSeriesIdentifier());
                    }
                    mlvl = dssRead.getMessageLevel();
                    DSSTimeSeriesTranslator.setMessageLevel((int)1);
                    dsstx = dssRead.readTimeSeries(dsspath, dataset.getTimeSeriesIdentifier(), dataset.getStartTime().toInstant().toEpochMilli(), dataset.getEndTime().toInstant().toEpochMilli(), timeZone, timeZoneOverride);
                    DSSTimeSeriesTranslator.setMessageLevel((int)mlvl);
                }
            }
            catch (DSSTimeSeriesNoDataFoundException | DataSetTxEmptyException e) {
                ((MarkingClassLogger.Api)LOGGER.atFine()).withCause(e);
            }
            catch (DataSetIllegalArgumentException | DSSTimeSeriesReadException | DataSetTxException | UtcIntervalOffsetMismatchException e) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)LOGGER.atFine()).withCause(e)).log("writeDataSet: Exception: ");
                throw new DSSTimeSeriesWriteException((Exception)e);
            }
            catch (DataSetException | mil.army.usace.hec.metadata.DataSetException e) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)LOGGER.atFine()).withCause(e)).log("writeDataSet: Exception: ");
                throw new DSSTimeSeriesWriteException((Exception)e);
            }
            finally {
                dssRead.done();
            }
        }
        try {
            Units dssUnits;
            Units writeUnits;
            if (dsstx != null && !(writeUnits = derive != null ? derive.getUnits() : dataset.getUnits()).equals((Object)(dssUnits = dsstx.getUnits()))) {
                String sb = "Error while attempting to write out to a DSS file: " + dssfile + "\n  Data type of record being written does not match data type of record stored in file.\n  DSS Pathname of record being written: " + dsspath + "\n  Record type being written: " + writeUnits + "\n  Record type on disk: " + dssUnits;
                throw new UnitsConversionException(sb);
            }
            if (derive != null) {
                dataset = new TimeSeriesDerive().derive(dataset, derive);
            }
        }
        catch (mil.army.usace.hec.metadata.DataSetException e) {
            ((MarkingClassLogger.Api)LOGGER.atFine()).withCause((Throwable)e);
            throw new DSSTimeSeriesWriteException((Exception)((Object)e));
        }
        try {
            dsstx = dsstx != null ? TimeSeriesCombine.combine((TimeSeries)dsstx, (TimeSeries)dataset, (TimeSeriesStoreRule)rule, (boolean)overrideProtection, (long)60000L, (TimeComparisonMethod)TimeComparisonMethod.COMPARE_TRUNCATED_TIMES) : dataset;
        }
        catch (mil.army.usace.hec.metadata.DataSetException e) {
            throw new DSSTimeSeriesWriteException((Exception)((Object)e));
        }
        TimeZone timeZone2 = tz = timeZoneOverride != null ? timeZoneOverride : timeZone;
        if (tz == null) {
            tz = TimeZone.getDefault();
        }
        DSSTimeSeriesTranslator dssWrite = new DSSTimeSeriesTranslator();
        dssWrite.setDSSFileName(dssfile);
        int status = 0;
        try {
            status = dsspath == null && dssType == null ? dssWrite.write(dsstx, tz) : (dssType == null ? dssWrite.write(dsstx, tz, dsspath) : dssWrite.write(dsstx, tz, dsspath, dssType));
        }
        catch (DataSetIllegalArgumentException | DataSetTxException | mil.army.usace.hec.metadata.DataSetIllegalArgumentException | DataSetTimeSeriesException e) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)LOGGER.atFine()).withCause(e)).log("");
            throw new DSSTimeSeriesWriteException((Exception)e);
        }
        finally {
            dssWrite.done();
        }
        if (es != null) {
            es.setNumberWrittenValues(dsstx.getNumberValues());
            es.setNumberMissingValues(dsstx.getTimeSeriesStatistics().getNumberValuesMissing());
        }
        return es;
    }

    protected HecDataManager getDataManager(String fileName) {
        String filePath = this.processPath(fileName);
        HecDataManager dataManager = new HecDataManager(filePath);
        return dataManager;
    }

    protected HecDataManager getDataManager(String fileName, int version) {
        String filePath = this.processPath(fileName);
        HecDataManager dataManager = new HecDataManager(filePath, version);
        return dataManager;
    }

    protected HecDssCatalog getDSSFileAccess(String fileName) {
        String filePath = this.processPath(fileName);
        HecDssCatalog dssFileAccess = new HecDssCatalog(filePath);
        return dssFileAccess;
    }

    protected HecDSSUtilities getHecDSSUtilities(String fileName) {
        HecDSSUtilities dataManager = new HecDSSUtilities();
        String filePath = this.processPath(fileName);
        dataManager.setDSSFileName(filePath);
        return dataManager;
    }

    protected synchronized String processPath(String relativePath) {
        if (relativePath == null || relativePath.length() < 1) {
            return null;
        }
        Object truePath = null;
        truePath = (relativePath = RMAIO.parsePathName((String)relativePath)).substring(1, 2).equals(abs) ? relativePath : (relativePath.substring(0, 1).equals(sep) ? relativePath : (this._workspacePath == null || !this._workspacePath.equals("") ? this._workspacePath + sep + relativePath : relativePath));
        return truePath;
    }

    protected HecTimeSeries getTimeSeries(HecDataManager dataManager, String dssPath) throws IllegalArgumentException {
        String fileName = dataManager.DSSFileName();
        HecDataManager dssDataSet = dataManager.createObject(dssPath);
        if (!(dssDataSet instanceof HecTimeSeries)) {
            throw new IllegalArgumentException(fileName + ":" + dssPath + " Data Set is not a HecTimeSeries. Its " + (dssDataSet != null ? dssDataSet.getClass().getName() : "null"));
        }
        HecTimeSeries timeSeries = (HecTimeSeries)dssDataSet;
        return timeSeries;
    }

    public static void main(String[] args) {
        try {
            DSSFileManager fm = new DSSFileManager();
            Object stringUrl = null;
            int port = 8089;
            try {
                stringUrl = "//";
                stringUrl = (String)stringUrl + InetAddress.getLocalHost().getHostAddress();
                stringUrl = (String)stringUrl + ":" + port + "/";
            }
            catch (Exception e) {
                System.out.println("Exception trying to get LocalHost");
                System.out.println(e.getMessage() + "...." + e.toString());
                e.printStackTrace();
            }
            fm.rebindServer((String)stringUrl);
        }
        catch (Exception e) {
            System.out.println("Exception starting DSSFileManager " + e);
            e.printStackTrace();
        }
    }

    @Override
    public boolean[] convertHrapToShg(DSSIdentifier outDssId, Vector inDssIdList, String site, Object uiWrapper) throws RemoteException {
        Remote remote = null;
        if (uiWrapper instanceof RemoteWrapper) {
            remote = ((RemoteWrapper)uiWrapper).getRemote();
        }
        RmiProgress ui = null;
        if (remote instanceof RmiProgress) {
            ui = (RmiProgress)remote;
        }
        if (outDssId == null) {
            System.out.println("convertHrapToShg: no output DSS file");
            if (ui != null) {
                try {
                    ui.printErrorMessage("No output DSS file specified");
                }
                catch (RemoteException re) {
                    System.out.println("convertHrapToShg: rmi error on printErrorMessage() " + re);
                }
            }
            return null;
        }
        if (inDssIdList == null || inDssIdList.size() < 1) {
            System.out.println("convertHrapToShg: null or empty input DSSIdentifier list");
            if (ui != null) {
                try {
                    ui.printErrorMessage("Null or empty input DSSIdentifier list");
                }
                catch (RemoteException re) {
                    System.out.println("convertHrapToShg: rmi error on printErrorMessage() " + re);
                }
            }
            return null;
        }
        HrapConvertTable converter = new HrapConvertTable(ui);
        int size = inDssIdList.size();
        boolean[] retVal = new boolean[size + 1];
        boolean success = true;
        HecTime startTime = new HecTime();
        HecTime endTime = new HecTime();
        int increment = 99 / size;
        int progress = 0;
        for (int i = 0; i < size; ++i) {
            Object obj = inDssIdList.elementAt(i);
            retVal[i + 1] = true;
            if (!(obj instanceof DSSIdentifier)) {
                System.out.println("convertHrapToShg: object in list at pos " + i + " invalid type " + obj.getClass());
                if (ui != null) {
                    try {
                        ui.printWarningMessage("Invalid specifier in DSSIdentifier list");
                        ui.setProgress(progress += increment);
                    }
                    catch (RemoteException re) {
                        System.out.println("convertHrapToShg: rmi error on printWarningMessage() " + re);
                    }
                }
                retVal[i + 1] = false;
                success = false;
                continue;
            }
            DSSIdentifier dssId = (DSSIdentifier)obj;
            Vector results = this.getGriddedData(dssId);
            String path = dssId.getDSSPath();
            String file = dssId.getFileName();
            if (ui != null) {
                try {
                    ui.printMessage("Converting " + file + ":" + path);
                }
                catch (RemoteException re) {
                    System.out.println("convertHrapToShg: rmi error on printMessage() " + re);
                }
            }
            if (results == null || results.size() < 2) {
                System.out.println("convertHrapToShg: got bad results back for " + file + ":" + path);
                if (ui != null) {
                    try {
                        ui.printWarningMessage("Failed to get GriddedData for " + file + ":" + path);
                        ui.setProgress(progress += increment);
                    }
                    catch (RemoteException re) {
                        System.out.println("convertHrapToShg: rmi error on printWarningMessage() " + re);
                    }
                }
                retVal[i + 1] = false;
                success = false;
                continue;
            }
            if (!(results.elementAt(0) instanceof HrapInfo) || !(results.elementAt(1) instanceof GridData)) {
                System.out.println("convertHrapToShg: unexpected object in results list for " + file + ":" + path);
                if (ui != null) {
                    try {
                        ui.printWarningMessage("Invalid data for " + file + ":" + path);
                        ui.setProgress(progress += increment);
                    }
                    catch (RemoteException re) {
                        System.out.println("convertHrapToShg: rmi error on printWarningMessage() " + re);
                    }
                }
                retVal[i + 1] = false;
                success = false;
                continue;
            }
            AlbersInfo outInfo = new AlbersInfo();
            GridData outData = new GridData();
            int rv = converter.convertHrapToShg((HrapInfo)results.elementAt(0), (GridData)results.elementAt(1), outInfo, outData, site);
            if (rv != 0) {
                System.out.println("convertHrapToShg: conversion failed for " + file + ":" + path);
                if (ui != null) {
                    try {
                        ui.printErrorMessage("Conversion failed for " + file + ":" + path);
                        ui.setProgress(progress += increment);
                    }
                    catch (RemoteException re) {
                        System.out.println("convertHrapToShg: rmi error on printErrorMessage() " + re);
                    }
                }
                retVal[i + 1] = false;
                success = false;
                continue;
            }
            if (ui != null) {
                try {
                    ui.printMessage("Converted " + file + ":" + path);
                    ui.setProgress(progress += increment);
                }
                catch (RemoteException re) {
                    System.out.println("convertHrapToShg: rmi error on printMessage() " + re);
                }
            }
            GridInfo.getStartTimeFromPath((String)path, (HecTime)startTime);
            GridInfo.getEndTimeFromPath((String)path, (HecTime)endTime);
            outDssId.setStartTime(startTime);
            outDssId.setEndTime(endTime);
            outData.updateStatistics();
            if (this.storeGriddedData(outDssId, (GridInfo)outInfo, outData) == 0) continue;
            System.out.println("convertHrapToShg: store of SHG data failed");
            if (ui != null) {
                try {
                    ui.printErrorMessage("Failed to save SHG data for " + outDssId.getFileName() + ":" + outDssId.getDSSPath());
                }
                catch (RemoteException re) {
                    System.out.println("convertHrapToShg: rmi error on printErrorMessage() " + re);
                }
            }
            retVal[i + 1] = false;
            success = false;
        }
        retVal[0] = success;
        return retVal;
    }

    @Override
    public double[] getGriddedDataMinMax(Vector dssIds) throws RemoteException {
        double[] minMaxValues = new double[]{Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY};
        if (dssIds == null || dssIds.size() < 1) {
            return minMaxValues;
        }
        double minValue = Double.MAX_VALUE;
        double maxValue = Double.MIN_VALUE;
        for (int i = 0; i < dssIds.size(); ++i) {
            Object obj = dssIds.elementAt(i);
            if (obj == null) continue;
            if (!(obj instanceof DSSIdentifier)) {
                System.out.println("getGriddedDataMinMax: invalid object in list " + obj.getClass());
                continue;
            }
            DSSIdentifier dssId = (DSSIdentifier)obj;
            Vector results = this.getGriddedData(dssId);
            if (results == null || results.size() < 2) {
                System.out.println("getGriddedDataMinMax: no results for " + dssId.toString());
                continue;
            }
            GridInfo gridInfo = (GridInfo)results.elementAt(0);
            double val = gridInfo.getMinDataValue();
            if (val < minValue) {
                minValue = val;
            }
            if (!((val = (double)gridInfo.getMaxDataValue()) > maxValue)) continue;
            maxValue = val;
        }
        minMaxValues[0] = minValue;
        minMaxValues[1] = maxValue;
        return minMaxValues;
    }

    @Override
    public boolean exportFromDSS(String outputFile, int exportFileType, DSSIdentifier inID, HecTime start, HecTime end, String gridTypeName) throws ExportException {
        int rv = -1;
        if (outputFile == null || outputFile.length() < 0) {
            System.out.println("exportFromDSS: empty output file name");
            throw new ExportException("Output File Name is null or empty");
        }
        if (inID == null) {
            System.out.println("exportFromDSS: null input DSSIdentifier");
            throw new ExportException("Input DSSIdentifier is null");
        }
        Vector pathNames = DSSPathname.parseDssPath((String)inID.getDSSPath());
        if (pathNames == null || pathNames.size() < 6) {
            System.out.println("exportFromDSS: invalid path name '" + inID.getDSSPath() + "'");
            throw new ExportException("Invalid output DSS path '" + inID.getDSSPath() + "'");
        }
        String site = (String)pathNames.elementAt(1);
        try {
            switch (exportFileType) {
                case 3: {
                    Dss2AscGrid exporter = new Dss2AscGrid(outputFile, inID, start, end, gridTypeName);
                    exporter.dump();
                    rv = exporter.getStatus();
                }
            }
            return rv == 0;
        }
        catch (Exception e) {
            System.out.println("exportFromDSS: Exception during export " + e);
            e.printStackTrace();
            return false;
        }
    }

    @Override
    protected Remote getClientSideProxies(Remote remote) {
        try {
            Remote server = super.getClientSideProxies(remote);
            ((MarkingClassLogger.Api)LOGGER.atFine()).log("getClientSideProxies: %s", (Object)this.getUrl());
            Class[] interfaces = new Class[]{DSSManager.class, RmiLoginListener.class};
            ClassLoader classLoader = server.getClass().getClassLoader();
            server = (DSSManager)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new ReconnectProxy(server, this.getUrl()));
            server = (DSSManager)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new NotifyUserProxy(server, this._ipUrl));
            return server;
        }
        catch (IllegalArgumentException | RemoteException e) {
            throw new IllegalStateException("getClientSideProxies: failed to create proxy", e);
        }
    }

    @Override
    public HecTime[] getGridTimeRange(DSSIdentifier dssId) {
        if (dssId == null) {
            return null;
        }
        HecTime start = new HecTime();
        HecTime end = new HecTime();
        Vector dssPaths = this.searchDSSPaths(dssId);
        HecTime tmp = new HecTime();
        DSSPathname pathname = new DSSPathname();
        if (dssPaths == null) {
            return null;
        }
        int size = dssPaths.size();
        for (int i = 0; i < size; ++i) {
            pathname.setPathname((String)dssPaths.get(i));
            tmp.set(pathname.dPart());
            if (!start.isDefined() || tmp.lessThan(start)) {
                start.set(tmp);
            }
            if (end.isDefined() && !tmp.greaterThan(end)) continue;
            end.set(tmp);
        }
        if (size > 0) {
            HecTime[] times = new HecTime[]{start, end};
            return times;
        }
        System.out.println("getGridTimeRange:got no records back for on " + dssId);
        return null;
    }

    @Override
    public boolean shutdown(int shutDownType, int waitSeconds, String userId) throws RemoteException {
        String host = "unknown";
        try {
            host = DSSFileManager.getClientHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println(this.getName() + " told to shutDown in " + waitSeconds + " seconds from host " + host + " user " + userId);
        this.shutdown(waitSeconds);
        return true;
    }

    @Override
    public TimeSeriesContainer[] getGridTSInfo(HecTime startTime, HecTime endTime, String timeStep, String dsspath, List<String> filenames, boolean isCwmsGridset, boolean instantaneous, boolean refreshInfo, String baseFilename) {
        long entries;
        System.out.println("getGridTSInfo:generating TS info for " + dsspath + " start=" + startTime + " end=" + endTime + " timestep=" + timeStep + " instantaneous=" + instantaneous + " isCwmsNaming=" + isCwmsGridset + " files=" + filenames);
        if (filenames == null || filenames.size() == 0) {
            System.out.println("getGridTSInfo:***WARNING no DSS filenames specified");
            return null;
        }
        if (dsspath == null || dsspath.length() == 0) {
            System.out.println("getGridTSInfo:***WARNING no DSS pathname specified");
            return null;
        }
        if (startTime == null || !startTime.isDefined()) {
            System.out.println("getGridTSInfo:***WARNING no start time specified");
            return null;
        }
        if (endTime == null || !endTime.isDefined()) {
            System.out.println("getGridTSInfo:***WARNING no end time specified");
            return null;
        }
        if (timeStep == null || timeStep.length() == 0) {
            System.out.println("getGridTSInfo:***WARNING no timestep specified");
            return null;
        }
        HecTime diff = new HecTime(startTime);
        String s = diff.toString();
        int multiplier = 1;
        if (timeStep.equals("3 Hours")) {
            entries = (endTime.getTimeInMillis() - startTime.getTimeInMillis()) / 10800000L;
            diff.setTimeIncrement(2);
            multiplier = 3;
        } else if (timeStep.equals("6 Hours")) {
            entries = (endTime.getTimeInMillis() - startTime.getTimeInMillis()) / 21600000L;
            diff.setTimeIncrement(2);
            multiplier = 6;
        } else if (timeStep.equals("12 Hours")) {
            entries = (endTime.getTimeInMillis() - startTime.getTimeInMillis()) / 43200000L;
            diff.setTimeIncrement(2);
            multiplier = 12;
        } else if (timeStep.equals("1 Day")) {
            entries = (endTime.getTimeInMillis() - startTime.getTimeInMillis()) / 86400000L;
            diff.setTimeIncrement(2);
            multiplier = 24;
        } else if (timeStep.equals("1 Week")) {
            entries = (endTime.getTimeInMillis() - startTime.getTimeInMillis()) / 604800000L;
            diff.setTimeIncrement(2);
            multiplier = 168;
        } else if (timeStep.indexOf("Minutes") > 0) {
            String minutes = RMAIO.getType((String)timeStep, (String)" ");
            multiplier = RMAIO.parseInt((String)minutes, (int)1);
            entries = (endTime.getTimeInMillis() - startTime.getTimeInMillis()) / (long)(60000 * multiplier);
            diff.setTimeIncrement(1);
        } else {
            entries = (endTime.getTimeInMillis() - startTime.getTimeInMillis()) / 3600000L;
            diff.setTimeIncrement(2);
        }
        DSSPathname pathname = new DSSPathname(dsspath);
        String filename = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy.MM");
        TimeZone tz = TimeZone.getDefault();
        if (isCwmsGridset) {
            filename = this.getGridBaseFileName(baseFilename);
        }
        if (filenames == null || filenames.size() == 0) {
            System.out.println("getGridTSInfo:empty or null DSS file name");
            return null;
        }
        DSSIdentifier dssId = new DSSIdentifier(filename, dsspath);
        try {
            HecMath minMath = HecMath.generateRegularIntervalTimeSeries((String)startTime.toString(), (String)endTime.toString(), (String)timeStep, (double)Double.NEGATIVE_INFINITY);
            HecMath maxMath = HecMath.generateRegularIntervalTimeSeries((String)startTime.toString(), (String)endTime.toString(), (String)timeStep, (double)Double.NEGATIVE_INFINITY);
            HecMath meanMath = HecMath.generateRegularIntervalTimeSeries((String)startTime.toString(), (String)endTime.toString(), (String)timeStep, (double)Double.NEGATIVE_INFINITY);
            HecMath missingMath = HecMath.generateRegularIntervalTimeSeries((String)startTime.toString(), (String)endTime.toString(), (String)timeStep, (double)Double.NEGATIVE_INFINITY);
            DSSPathname tmpPathname = new DSSPathname();
            TimeSeriesContainer minTsc = (TimeSeriesContainer)minMath.getData();
            System.out.println("getGridTSInfo:have " + minTsc.values.length + " steps");
            tmpPathname.setPathname(minTsc.fullName);
            minTsc.version = "MIN";
            tmpPathname.setEPart(minTsc.version);
            tmpPathname.setBPart(pathname.getBPart());
            tmpPathname.setCPart(pathname.getCPart());
            minTsc.fullName = tmpPathname.getPathname();
            minTsc.parameter = pathname.cPart();
            TimeSeriesContainer maxTsc = (TimeSeriesContainer)maxMath.getData();
            maxTsc.version = "MAX";
            tmpPathname.setEPart(maxTsc.version);
            maxTsc.fullName = tmpPathname.getPathname();
            maxTsc.parameter = pathname.cPart();
            TimeSeriesContainer meanTsc = (TimeSeriesContainer)meanMath.getData();
            meanTsc.version = "MEAN";
            tmpPathname.setEPart(meanTsc.version);
            meanTsc.fullName = tmpPathname.getPathname();
            meanTsc.parameter = pathname.cPart();
            TimeSeriesContainer missingTsc = (TimeSeriesContainer)missingMath.getData();
            missingTsc.version = "MISSING";
            missingTsc.parameter = pathname.cPart();
            tmpPathname.setEPart(missingTsc.version);
            missingTsc.fullName = tmpPathname.getPathname();
            Vector data = null;
            int idx = 0;
            boolean _unitsNotSet = true;
            while (diff.lessThanEqualTo(endTime)) {
                if (!instantaneous) {
                    diff.showTimeAsBeginningOfDay(true);
                }
                pathname.setDPart(diff.date(104) + ":" + RMAIO.removeChar((String)diff.time(), (char)':'));
                if (isCwmsGridset) {
                    long millis = diff.getTimeInMillis();
                    millis = tz.getOffset(millis);
                    int mins = (int)millis / 1000;
                    Date dt = diff.getJavaDate(mins /= 60);
                    String monthFileName = filename + sdf.format(dt) + ".dss";
                    dssId.setFileName(monthFileName);
                    System.out.println("getGridTSInfo:checking cwms filename " + monthFileName);
                }
                dssId.setStartTime(new HecTime(diff));
                diff.showTimeAsBeginningOfDay(false);
                diff.add(1 * multiplier);
                if (!instantaneous) {
                    pathname.setEPart(diff.date(104) + ":" + RMAIO.removeChar((String)diff.time(), (char)':'));
                    dssId.setEndTime(new HecTime(diff));
                }
                dssId.setDSSPath(pathname.getPathname());
                for (int i = 0; i < filenames.size(); ++i) {
                    if (!isCwmsGridset) {
                        filename = filenames.get(i);
                        dssId.setFileName(filename);
                    }
                    if (dsspath != null && dsspath.trim().length() > 0 && filename != null && filename.trim().length() > 0) {
                        data = this.getGriddedData(dssId, false, ((MarkingClassLogger.Api)GRID_UTIL_LOGGER.atFine()).isEnabled());
                    }
                    if (data != null && data.size() > 0) {
                        GridInfo info = (GridInfo)data.get(0);
                        if (info != null) {
                            if (_unitsNotSet) {
                                int type = info.getDataType();
                                String typeStr = "";
                                switch (type) {
                                    case 0: {
                                        typeStr = "PER-AVER";
                                        break;
                                    }
                                    case 1: {
                                        typeStr = "PER-CUM";
                                        break;
                                    }
                                    case 2: {
                                        typeStr = "INST-VAL";
                                        break;
                                    }
                                    case 3: {
                                        typeStr = "INST_CUM";
                                        break;
                                    }
                                    case 4: {
                                        typeStr = "FREQ";
                                    }
                                }
                                minTsc.units = info.getDataUnits();
                                minTsc.type = typeStr;
                                maxTsc.units = info.getDataUnits();
                                maxTsc.type = typeStr;
                                meanTsc.units = info.getDataUnits();
                                meanTsc.type = typeStr;
                                missingTsc.units = info.getDataUnits();
                                missingTsc.type = typeStr;
                                _unitsNotSet = false;
                            }
                            minTsc.values[idx] = info.getMinDataValue();
                            maxTsc.values[idx] = info.getMaxDataValue();
                            meanTsc.values[idx] = info.getMeanValue();
                            if (RMAConst.isMissingValue((float)info.getMinDataValue()) || info.getMinDataValue() > info.getMaxDataValue() || RMAConst.isUndefinedValue((float)info.getMinDataValue()) || (double)info.getMinDataValue() == -1.0E38) {
                                missingTsc.values[idx] = 1.0;
                                break;
                            }
                            missingTsc.values[idx] = -3.4028234663852886E38;
                            break;
                        }
                        minTsc.values[idx] = -3.4028234663852886E38;
                        maxTsc.values[idx] = -3.4028234663852886E38;
                        meanTsc.values[idx] = -3.4028234663852886E38;
                        missingTsc.values[idx] = 1.0;
                        break;
                    }
                    minTsc.values[idx] = -3.4028234663852886E38;
                    maxTsc.values[idx] = -3.4028234663852886E38;
                    meanTsc.values[idx] = -3.4028234663852886E38;
                    missingTsc.values[idx] = 1.0;
                }
                ++idx;
            }
            TimeSeriesContainer[] tscarray = new TimeSeriesContainer[]{minTsc, maxTsc, meanTsc, missingTsc};
            System.out.println("getGridTSInfo:done generating TS info for " + dsspath + " returning " + minTsc.numberValues + " values");
            return tscarray;
        }
        catch (HecMathException e) {
            System.out.println("getGridTSInfo: HecMathException " + e);
            e.printStackTrace();
            System.out.println("getGridTSInfo:error generating TS info for " + dsspath);
            return null;
        }
    }

    private String getGridBaseFileName(String fileprefix) {
        String cwmsHome = null;
        try {
            cwmsHome = System.getProperty("CWMS_HOME");
        }
        catch (Exception e) {
            System.out.println("getGridBaseFileName: Error getting CWMS_HOME " + e);
        }
        if (cwmsHome == null) {
            System.out.println("getFilesFromFileList: WARNING no CWMS_HOME set");
            cwmsHome = System.getProperty("CWMS_HOME");
            if (cwmsHome == null) {
                cwmsHome = System.getProperty("user.dir");
            }
        }
        Object dbDir = "/dated/db/grid";
        try {
            dbDir = System.getProperty("griddedDataDirectory");
        }
        catch (Exception e) {
            System.out.println(this.getName() + "getGridBaseFileName: Error getting 'griddedDataDirectory' Error:" + e);
        }
        if (dbDir == null) {
            dbDir = "/dated/db/grid";
        }
        if (((String)(dbDir = ((String)dbDir).replace('\\', '/'))).charAt(0) != "/".charAt(0)) {
            dbDir = "/" + (String)dbDir;
        }
        if (((String)dbDir).charAt(((String)dbDir).length() - 1) != "/".charAt(0)) {
            dbDir = (String)dbDir + "/";
        }
        String cwmsDbDir = cwmsHome + (String)dbDir + fileprefix + ".";
        return cwmsDbDir;
    }

    @Override
    public String getStatusString(int statusType) {
        return "OK";
    }

    @Override
    public synchronized void setDssFileSizeHuge(String dssFilename) {
        if (dssFilename == null || dssFilename.length() == 0) {
            return;
        }
        HecDSSFileAccess.zset((String)"SIZE", (String)"SUPER", (int)0);
        HecDataManager dataManager = this.getDataManager(dssFilename);
    }

    @Override
    public String[] getCollectionList(DSSIdentifier dssId) {
        String[] collectionArray = new String[]{};
        if (dssId == null) {
            return collectionArray;
        }
        HecDssCatalog dssFileAccess = this.getDSSFileAccess(dssId.getFileName());
        collectionArray = dssFileAccess.getCollectionList(dssId.getDSSPath());
        dssFileAccess.done();
        dssFileAccess = null;
        return collectionArray;
    }

    @Override
    public String[] getCollectionSequenceList(DSSIdentifier dssId) {
        String[] collectionSeqArray = new String[]{};
        if (dssId == null) {
            return collectionSeqArray;
        }
        HecDssCatalog dssFileAccess = this.getDSSFileAccess(dssId.getFileName());
        collectionSeqArray = dssFileAccess.getCollectionSequenceList(dssId.getDSSPath());
        dssFileAccess.done();
        dssFileAccess = null;
        return collectionSeqArray;
    }

    @Override
    public int getCollectionSize(DSSIdentifier dssId) {
        int collectionSize = 0;
        if (dssId == null) {
            return collectionSize;
        }
        HecDssCatalog dssFileAccess = this.getDSSFileAccess(dssId.getFileName());
        collectionSize = dssFileAccess.getCollectionSize(dssId.getDSSPath());
        dssFileAccess.done();
        dssFileAccess = null;
        return collectionSize;
    }

    static {
        HecDSSFileAccess.catchSevereErrors();
        HecDSSFileAccess.zset((String)"HANDLE", (String)"ON", (int)0);
    }
}

