/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.server;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.Serializable;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import javax.net.ssl.SSLContext;
import mil.army.usace.hec.rmi.server.PortRange;

public class LimitedPortServerSocketFactory
implements RMIServerSocketFactory,
RMIClientSocketFactory,
Serializable {
    static final long serialVersionUID = 7218987574031087979L;
    private static final Object OBJLOCK = new Object();
    private static transient int[] _srvrRange;
    private static transient int[] _clntRange;
    private static int _srvrCurrent;
    private static int _clntCurrent;
    private transient SSLContext _sslContext;
    private transient InetAddress _bindAddr;
    private static boolean _debug;
    private static transient boolean _initd;
    private static int _ssrequest;
    private static int _srequest;
    private static long connectTimeout;

    public LimitedPortServerSocketFactory() {
        block3: {
            if (!_debug) {
                _debug = Boolean.getBoolean("hec.rmi.server.logCalls");
            }
            try {
                this._bindAddr = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                if (_srvrRange == null && _clntRange == null) break block3;
                System.out.println("LimitedPortServerSocketFactory: UnknownHostException " + e);
            }
        }
        _initd = true;
    }

    public LimitedPortServerSocketFactory(InetAddress bindAddr) {
        this();
        this._bindAddr = bindAddr;
    }

    public LimitedPortServerSocketFactory(SSLContext sslContext) {
        this._sslContext = sslContext;
    }

    public static void setDebug(boolean debug) {
        _debug = debug;
    }

    private static long getConnectTimeout() {
        return Long.getLong("hec.rmi.server.connectTimeout", 5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServerSocket createServerSocket(int port) throws IOException {
        int request = _ssrequest++;
        if (_debug) {
            System.out.println("createServerSocket(" + request + "): request for port " + port);
        }
        if (port != 0) {
            return this.generateServerSocket(port);
        }
        if (_srvrRange == null) {
            if (this._bindAddr != null) {
                if (_debug) {
                    System.out.println("createServerSocket(" + request + "): no range. returning " + this._bindAddr.getHostName() + ":" + port);
                }
                return new ServerSocket(port, 50, this._bindAddr);
            }
            if (_debug) {
                System.out.println("createServerSocket(" + request + "): no range. returning " + port);
            }
            return this.generateServerSocket(port);
        }
        Object object = OBJLOCK;
        synchronized (object) {
            if (_srvrCurrent > _srvrRange[1]) {
                _srvrCurrent = _srvrRange[0];
            }
            if (_debug) {
                System.out.println("createServerSocket(" + request + "): port range is " + _srvrRange[0] + " to " + _srvrRange[1]);
            }
            ServerSocket socket = null;
            int start = _srvrCurrent;
            while (true) {
                try {
                    if (_debug) {
                        System.out.println("createServerSocket(" + request + "): trying port " + _srvrCurrent);
                    }
                    if (this._bindAddr != null) {
                        if (_debug) {
                            System.out.println("createServerSocket(" + request + "): using address " + this._bindAddr);
                        }
                        socket = new ServerSocket(_srvrCurrent++, 50, this._bindAddr);
                    } else {
                        socket = this.generateServerSocket(_srvrCurrent++);
                    }
                    if (_debug) {
                        System.out.println("createServerSocket(" + request + "): request was for " + port + " returning " + socket.getInetAddress().toString() + ":" + socket.getLocalPort());
                    }
                    return socket;
                }
                catch (IOException ioe) {
                    if (_debug) {
                        System.out.println("createServerSocket(" + request + "):Error trying port " + (_srvrCurrent - 1) + " Error:" + ioe);
                    }
                    if (ioe instanceof BindException) {
                        if (_debug) {
                            System.out.println("createServerSocket(" + request + "): port " + (_srvrCurrent - 1) + " already in use");
                        }
                        if (++_srvrCurrent <= _srvrRange[1]) continue;
                        _srvrCurrent = _srvrRange[0];
                        continue;
                    }
                    throw ioe;
                    if (socket == null && _srvrCurrent != start) continue;
                    return socket;
                }
                break;
            }
        }
    }

    private ServerSocket generateServerSocket(int port) throws IOException {
        if (this._sslContext != null) {
            this._sslContext.getServerSocketFactory().createServerSocket(port);
        }
        return new ServerSocket(port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket createSocketAsync(String host, int port) throws IOException {
        Socket initialSocket = null;
        AsyncConnector connector = new AsyncConnector(host, port);
        Object initialFailure = null;
        try {
            AsyncConnector asyncConnector = connector;
            synchronized (asyncConnector) {
                Thread t = new Thread((Runnable)connector, "CreateSocket(" + host + ")");
                t.start();
                try {
                    long now = System.currentTimeMillis();
                    long deadline = now + connectTimeout;
                    do {
                        connector.wait(deadline - now);
                    } while ((initialSocket = this.checkConnector(connector)) == null && (now = System.currentTimeMillis()) < deadline);
                }
                catch (InterruptedException e) {
                    throw new InterruptedIOException("interrupted while waiting for connector");
                }
            }
            if (initialSocket == null) {
                throw new NoRouteToHostException("connect timed out: " + host);
            }
            return initialSocket;
        }
        catch (Exception e) {
            System.out.println("createSocket:failed to create socket to host " + host);
            connector.notUsed();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            throw new IOException(e);
        }
    }

    Socket checkConnector(AsyncConnector connector) throws IOException {
        Exception e = connector.getException();
        if (e != null) {
            e.fillInStackTrace();
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new Error("internal error: unexpected checked exception: " + e.toString());
        }
        return connector.getSocket();
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        int start;
        int request = _srequest++;
        if (_debug) {
            System.out.println("createSocket(" + request + "): *** start request for " + host + ":" + port + " ***");
        }
        if (!_initd) {
            System.out.println("createSocket:*********Socket Factory has not been initd ");
            new Throwable("Socket Factory has not been init'd").printStackTrace();
        }
        if (_clntRange == null) {
            if (_debug) {
                System.out.println("createSocket(" + request + "): No range. returning " + host + ":" + port);
            }
            Socket sock = this.generateSocket();
            InetSocketAddress theirSa = new InetSocketAddress(host, port);
            sock.connect(theirSa, (int)connectTimeout);
            return sock;
        }
        int current = start = this.getNextClientPort();
        Socket socket = null;
        BindException lastBe = null;
        do {
            try {
                if (_debug) {
                    System.out.println("createSocket(" + request + "): trying local port " + current);
                }
                socket = this.generateSocket();
                InetSocketAddress mysa = new InetSocketAddress(this._bindAddr, current);
                socket.bind(mysa);
                InetSocketAddress theirSa = new InetSocketAddress(host, port);
                socket.connect(theirSa, (int)connectTimeout);
                socket.setSoLinger(true, 0);
                socket.setReuseAddress(true);
            }
            catch (IOException ioe) {
                if (_debug) {
                    System.out.println("createSocket(" + request + "): IOException on " + host + ":" + port + " local port=" + current + " Error:" + ioe);
                }
                if (ioe instanceof BindException) {
                    lastBe = (BindException)ioe;
                    current = this.getNextClientPort();
                    socket = null;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                }
                throw ioe;
            }
        } while (socket == null && current != start);
        if (_debug && socket != null) {
            System.out.println("createSocket(" + request + "): **** Endreturning remote= " + host + " port=" + port + " local=" + socket.getLocalAddress() + " port=" + socket.getLocalPort() + " ****");
        }
        if (socket == null) {
            System.out.println("createSocket:ERROR socket is null for host=" + host + " port=" + port);
            if (lastBe != null) {
                throw lastBe;
            }
        }
        return socket;
    }

    private Socket generateSocket() throws IOException {
        if (this._sslContext != null) {
            return this._sslContext.getSocketFactory().createSocket();
        }
        return new Socket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNextClientPort() {
        Object object = OBJLOCK;
        synchronized (object) {
            if (_clntCurrent > _clntRange[1]) {
                _clntCurrent = _clntRange[0];
                if (_debug) {
                    System.out.println("getNextClientPort:wrapped. returning " + _clntCurrent);
                }
                return _clntCurrent;
            }
            ++_clntCurrent;
            if (_debug) {
                System.out.println("getNextClientPort:returning " + _clntCurrent);
            }
            return _clntCurrent;
        }
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        if (that != null && that.getClass().equals(this.getClass())) {
            return true;
        }
        if (_debug) {
            System.out.println("LimitedPortServerSocketFactory.equals:socket factories are not equal that=" + that.getClass().getName() + " this=" + this.getClass().getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    private Object readResolve() {
        if (_debug) {
            System.out.println("LimitedPortServerSocketFactory.readResolve: loading Rmi Port range...");
        }
        if ((_srvrRange = PortRange.getPortRange("Server")) != null) {
            _srvrCurrent = _srvrRange[0];
        }
        if ((_clntRange = PortRange.getPortRange("Client")) != null) {
            _clntCurrent = _clntRange[0];
        }
        try {
            this._bindAddr = InetAddress.getLocalHost();
        }
        catch (UnknownHostException e) {
            System.out.println("readResolve: UnknownHostException " + e);
            e.printStackTrace();
        }
        _initd = true;
        return this;
    }

    static {
        _debug = false;
        _initd = false;
        _ssrequest = 0;
        _srequest = 0;
        if (_debug) {
            System.out.println("LimitedPortServerSocketFactory: loading Rmi Port range...");
        }
        if ((_srvrRange = PortRange.getPortRange("Server")) != null) {
            _srvrCurrent = _srvrRange[0];
        }
        if ((_clntRange = PortRange.getPortRange("Client")) != null) {
            _clntCurrent = _clntRange[0];
        }
        connectTimeout = LimitedPortServerSocketFactory.getConnectTimeout();
    }

    private class AsyncConnector
    implements Runnable {
        private String host;
        private int port;
        private Exception exception = null;
        private Socket socket = null;
        private boolean cleanUp = false;

        AsyncConnector(String host, int port) {
            this.host = host;
            this.port = port;
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkConnect(host, port);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Socket temp = LimitedPortServerSocketFactory.this.createSocket(this.host, this.port);
                AsyncConnector asyncConnector = this;
                synchronized (asyncConnector) {
                    this.socket = temp;
                    this.notify();
                }
                asyncConnector = this;
                synchronized (asyncConnector) {
                    if (this.cleanUp) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                AsyncConnector asyncConnector = this;
                synchronized (asyncConnector) {
                    this.exception = e;
                    this.notify();
                }
            }
        }

        private synchronized Exception getException() {
            return this.exception;
        }

        private synchronized Socket getSocket() {
            return this.socket;
        }

        synchronized void notUsed() {
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.cleanUp = true;
        }
    }
}

