/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class PortRange {
    private static final String PROP_FILE_NAME = "RmiPorts.properties";
    private static final String ALLUSER_DIR = "profile.allusers.local";
    private static final String WILDCARD = ".*";
    private static final String ANY_IPS = "Any";
    private static final int MAX_PORT_NUM = 65535;
    public static final String CLIENT = "Client";
    public static final String SERVER = "Server";
    private static String _prefix = null;
    private static String _propFilename;
    private static transient String[] _ipAddr;
    private static transient boolean _loaded;
    private static Properties _clientProps;
    private static Properties _serverProps;
    private static boolean _debug;

    private static void initProps() {
        if (_propFilename == null) {
            return;
        }
        try {
            File f;
            if (_serverProps == null) {
                _serverProps = new Properties();
            }
            if (_clientProps == null) {
                _clientProps = new Properties();
            }
            if (!(f = new File(_propFilename)).exists()) {
                return;
            }
            if (_debug) {
                System.out.println("PortRange.initProps:reading " + f.getAbsolutePath());
            }
            Properties loadProps = new Properties();
            loadProps.load(new FileInputStream(_propFilename));
            if (_debug) {
                System.out.println("PortRange.initProps:table read:");
                PortRange.dumpTable(loadProps);
            }
            _clientProps.putAll((Map<?, ?>)loadProps);
            _serverProps.putAll((Map<?, ?>)loadProps);
            PortRange.cleanProps(_clientProps, CLIENT);
            PortRange.cleanProps(_serverProps, SERVER);
            if (_debug) {
                System.out.println("PortRange.initProps: Client table");
                PortRange.dumpTable(_clientProps);
                System.out.println("PortRange.initProps: Server table");
                PortRange.dumpTable(_serverProps);
            }
        }
        catch (IOException ioe) {
            System.out.println("PortRange.initProps: Error Reading " + _propFilename + " Error:" + ioe);
        }
    }

    private static void dumpTable(Properties props) {
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            System.out.println("\t" + key + "=" + props.get(key));
        }
    }

    private PortRange() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] getPortRange(String side) {
        if (!_loaded) {
            return null;
        }
        Object ipAddr = _ipAddr[0] + "." + _ipAddr[1] + "." + _ipAddr[2] + "." + _ipAddr[3];
        int[] range = null;
        Properties props = _serverProps;
        if (CLIENT.equalsIgnoreCase(side)) {
            props = _clientProps;
        }
        try {
            if (_debug) {
                System.out.println("getPortRange: checking " + (String)ipAddr + " for " + side);
            }
            if ((range = PortRange.getRange((String)ipAddr, props)) != null) {
                int[] nArray = range;
                return nArray;
            }
            ipAddr = _ipAddr[0] + "." + _ipAddr[1] + "." + _ipAddr[2] + WILDCARD;
            if (_debug) {
                System.out.println("getPortRange: checking " + (String)ipAddr);
            }
            if ((range = PortRange.getRange((String)ipAddr, props)) != null) {
                int[] nArray = range;
                return nArray;
            }
            ipAddr = _ipAddr[0] + "." + _ipAddr[1] + WILDCARD;
            if (_debug) {
                System.out.println("getPortRange: checking " + (String)ipAddr);
            }
            if ((range = PortRange.getRange((String)ipAddr, props)) != null) {
                int[] nArray = range;
                return nArray;
            }
            ipAddr = _ipAddr[0] + WILDCARD;
            if (_debug) {
                System.out.println("getPortRange: checking " + (String)ipAddr);
            }
            if ((range = PortRange.getRange((String)ipAddr, props)) != null) {
                int[] nArray = range;
                return nArray;
            }
            ipAddr = ANY_IPS;
            if (_debug) {
                System.out.println("getPortRange: checking " + (String)ipAddr);
            }
            if ((range = PortRange.getRange((String)ipAddr, props)) != null) {
                int[] nArray = range;
                return nArray;
            }
        }
        finally {
            if (_debug && range != null) {
                System.out.println("getPortRange: range for IPAddress " + (String)ipAddr + " is " + range[0] + " to " + range[1] + " for " + side);
            }
        }
        if (_debug) {
            System.out.println("getPortRange: no port range found for " + side);
        }
        return range;
    }

    private static int[] getRange(String ipAddr, Properties props) {
        String range = props.getProperty(ipAddr);
        if (range != null) {
            return PortRange.parseRange(range);
        }
        return null;
    }

    private static int[] parseRange(String range) {
        if (range == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(range, "-;,/");
        if (tokenizer.countTokens() == 0) {
            System.out.println("parseRange: invalid port range found " + range);
            return null;
        }
        int[] ports = new int[2];
        String s = tokenizer.nextToken();
        ports[0] = RMAIO.parseInt((String)s);
        if (tokenizer.hasMoreTokens()) {
            s = tokenizer.nextToken();
            ports[1] = RMAIO.parseInt((String)s);
        } else {
            ports[1] = 65535;
        }
        if (RMAConst.isUndefinedValue((int)ports[0]) || RMAConst.isUndefinedValue((int)ports[1])) {
            System.out.println("parseRange: invalid port(s) " + ports[0] + " or " + ports[1]);
            return null;
        }
        if (ports[0] > ports[1]) {
            int tmp = ports[0];
            ports[0] = ports[1];
            ports[1] = tmp;
        }
        if (ports[0] > 65535 || ports[0] < 0) {
            System.out.println("parseRange: invalid starting port " + ports[0] + " must be between 0 and 65535");
            return null;
        }
        if (ports[1] > 65535 || ports[1] < 0) {
            System.out.println("parseRange: invalid ending port " + ports[0] + " must be between 0 and 65535");
            return null;
        }
        return ports;
    }

    private static void cleanProps(Properties props, String prefix) {
        Object obj;
        if (prefix == null || ((String)prefix).length() == 0) {
            return;
        }
        if (_prefix != null) {
            prefix = _prefix + "." + (String)prefix;
        }
        Set<Object> e = props.keySet();
        Iterator<Object> i = e.iterator();
        while (i.hasNext()) {
            obj = i.next();
            if (((String)obj).startsWith((String)prefix)) continue;
            i.remove();
        }
        i = e.iterator();
        int offset = ((String)prefix).length() + 1;
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        while (i.hasNext()) {
            String string = (String)i.next();
            obj = props.getProperty(string);
            String string2 = string.substring(offset);
            newMap.put(string2, obj);
        }
        props.clear();
        e = newMap.keySet();
        for (String string : e) {
            obj = newMap.get(string);
            props.setProperty(string, (String)obj);
        }
    }

    public static void setPrefix(String prefix) {
        if (_debug) {
            System.out.println("PortRange.setPrefix: set to " + prefix);
        }
        _prefix = prefix;
        PortRange.initProps();
    }

    public static void main(String[] args) {
        _debug = true;
        int[] range = PortRange.getPortRange(SERVER);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        _loaded = false;
        _debug = false;
        Class<PortRange> clazz = PortRange.class;
        synchronized (PortRange.class) {
            File f;
            _debug = Boolean.getBoolean("hec.rmi.server.logCalls");
            _propFilename = System.getProperty(PROP_FILE_NAME);
            if (_debug && _propFilename != null) {
                System.out.println("PortRange:RmiProp file specified in SysProp. File=" + _propFilename);
            }
            if (_propFilename == null && !(f = new File(_propFilename = PROP_FILE_NAME)).exists()) {
                _propFilename = System.getProperty(ALLUSER_DIR);
                _propFilename = _propFilename == null ? System.getProperty("CWMS_HOME") + "/config/properties/RmiPorts.properties" : _propFilename + "/RmiPorts.properties";
                f = new File(_propFilename);
                if (_debug) {
                    System.out.println("PortRange: checking file " + f.getAbsoluteFile());
                }
                if (!f.exists()) {
                    _propFilename = null;
                }
            }
            if (_propFilename != null) {
                PortRange.initProps();
                try {
                    InetAddress iaddr = InetAddress.getLocalHost();
                    String ipAddr = iaddr.getHostAddress();
                    StringTokenizer tokenizer = new StringTokenizer(ipAddr, ".");
                    if (tokenizer.countTokens() >= 4) {
                        _ipAddr = new String[4];
                        for (int i = 0; i < 4; ++i) {
                            PortRange._ipAddr[i] = tokenizer.nextToken();
                        }
                        _loaded = true;
                    } else {
                        System.out.println("PortRange.<init>: Error parsing IPAddress " + ipAddr);
                    }
                }
                catch (UnknownHostException e) {
                    System.out.println("PortRange.<init>: Error get Inet Address " + e);
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }
}

