/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.server;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.rmi.NoSuchObjectException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.RemoteServer;
import java.rmi.server.ServerCloneException;
import java.rmi.server.UnicastRemoteObject;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.Naming;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.server.LimitedPortServerSocketFactory;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.RmiPortsLoggingMarker;

public class PortableRmiObject
extends RemoteServer {
    private static final long serialVersionUID = 4974527148936298033L;
    private static final MarkingClassLogger LOGGER = MarkingClassLogger.forMarkingClass(RmiPortsLoggingMarker.class);
    public static final String NEXT_PORT_PROP = "nextPortOffset";
    private static int _staticBindPort = 0;
    protected String stringUrl;
    protected String name;
    protected boolean networked;
    protected Vector<RemoteWrapper> _remoteObjects;
    protected RemoteWrapper _fmWrapper;
    protected RemoteWrapper _remoteReferenceWrap;
    protected String _ipUrl = null;
    protected int port = 0;
    protected int bindPort = _staticBindPort;

    protected PortableRmiObject() throws RemoteException {
        this(8089);
    }

    protected PortableRmiObject(int registryPort) throws RemoteException {
        this.setNetworked(false);
        this.name = "rmiobject(" + this.getClass().getName() + ")";
        String hostname = System.getProperty("java.rmi.server.hostname");
        try {
            if (hostname == null) {
                hostname = InetAddress.getLocalHost().getHostAddress();
            }
        }
        catch (Exception e) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Exception trying to get LocalHost: " + e.getMessage());
            hostname = "localhost";
        }
        this.port = registryPort;
        this.stringUrl = "//" + hostname + ":" + this.port + "/";
        this._remoteObjects = new Vector();
        this._remoteReferenceWrap = new RemoteWrapper(this);
    }

    public void rebindServer(String s) {
        this.stringUrl = s;
        this._ipUrl = this.getIPUrl(this.stringUrl);
        Remote server = this.exportServer();
        if (server == null) {
            ((MarkingClassLogger.Api)LOGGER.atWarning()).log("Failed to export Server on " + this.stringUrl);
        }
        this.rebindServer();
    }

    protected String getIPUrl(String url) {
        String noSpaceName = this.name.replace(' ', '_');
        String completeUrl = url + noSpaceName;
        return RMAIO.getIPUrl((String)completeUrl);
    }

    protected Remote getClientSideProxies(Remote server) {
        return server;
    }

    protected void rebindServer() {
        Remote server = this.getClientSideProxies(this);
        try {
            String noSpaceName = this.name.replace(' ', '_');
            Naming.rebind(this.stringUrl + noSpaceName, server);
        }
        catch (IOException | RuntimeException e) {
            try {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)LOGGER.atInfo()).withCause((Throwable)e)).log("Could not access an existing RMI registry. Creating registry on port: " + this.port);
                try {
                    Registry reg = LocateRegistry.getRegistry(this.port);
                    String[] arry = reg.list();
                    if (arry == null) {
                        ((MarkingClassLogger.Api)LOGGER.atInfo()).log("Creating registry on " + this.port);
                        LocateRegistry.createRegistry(this.port);
                        Naming.rebind(this.stringUrl + this.name, server);
                        ((MarkingClassLogger.Api)LOGGER.atInfo()).log("rebinding to " + this.stringUrl + this.name);
                    }
                }
                catch (IOException | RuntimeException e2) {
                    ((MarkingClassLogger.Api)((MarkingClassLogger.Api)LOGGER.atInfo()).withCause((Throwable)e2)).log("Could not access the RMI registry. Creating registry on port: " + this.port);
                    LocateRegistry.createRegistry(this.port);
                    Naming.rebind(this.stringUrl + this.name, server);
                    ((MarkingClassLogger.Api)LOGGER.atInfo()).log("rebinding to " + this.stringUrl + this.name);
                }
            }
            catch (IOException | RuntimeException p) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)LOGGER.atWarning()).withCause((Throwable)p)).log("Could not connect to an existing RMI registry and was unable to create a new registry.");
            }
        }
    }

    public void unbindServer() throws RemoteException {
        Registry reg = LocateRegistry.getRegistry(this.port);
        String nameNoSpaces = this.name.replace(' ', '_');
        try {
            reg.unbind(nameNoSpaces);
        }
        catch (IOException | RuntimeException | NotBoundException e) {
            throw new RemoteException("Error unbinding server: " + nameNoSpaces + " at port: " + this.port, e);
        }
    }

    private void exportObjects() throws RemoteException {
        for (int ii = 0; ii < this._remoteObjects.size(); ++ii) {
            RemoteWrapper remoteWrapper = this._remoteObjects.elementAt(ii);
            Remote remote = remoteWrapper.getRemote();
            if (remote instanceof PortableRmiObject && !remoteWrapper.getExported()) {
                PortableRmiObject pro = (PortableRmiObject)remote;
                pro.setNetworked(true);
                Remote remoteRef = pro.exportServer();
                remoteWrapper.setRemote(remoteRef);
                remoteWrapper.setExported(true);
                continue;
            }
            remoteWrapper.export();
        }
    }

    public Remote exportServer() {
        try {
            Remote remoteReference = UnicastRemoteObject.exportObject((Remote)this, this.bindPort);
            this._remoteReferenceWrap.setRemote(remoteReference);
            this._remoteReferenceWrap.setExported(true);
            this.setNetworked(true);
            this.exportObjects();
            return remoteReference;
        }
        catch (Exception e) {
            MarkingClassLogger.Api api = (MarkingClassLogger.Api)LOGGER.atWarning();
            if (!e.toString().endsWith("object already exported")) {
                api = (MarkingClassLogger.Api)api.withCause((Throwable)e);
            }
            api.log("Exception with exportObject on PortableRmiObject (" + this.stringUrl + ")" + this + " Error:" + e);
            return null;
        }
    }

    public RmiFileManager getFileManager() throws RemoteException {
        if (this._fmWrapper != null) {
            return (RmiFileManager)this._fmWrapper.getRemote();
        }
        return null;
    }

    public void setFileManager(RemoteWrapper wrapper) {
        this._fmWrapper = wrapper;
    }

    public RemoteWrapper getRemoteReference() {
        return this._remoteReferenceWrap;
    }

    public void addRemoteWrapper(RemoteWrapper remoteWrapper) throws RemoteException {
        if (this.networked) {
            Remote remote = remoteWrapper.getRemote();
            if (remote instanceof PortableRmiObject && !remoteWrapper.getExported()) {
                PortableRmiObject pro = (PortableRmiObject)remote;
                pro.setNetworked(true);
                Remote remoteRef = pro.exportServer();
                remoteWrapper.setRemote(remoteRef);
                remoteWrapper.setExported(true);
            } else {
                remoteWrapper.export(RMISocketFactory.getSocketFactory(), RMISocketFactory.getSocketFactory());
            }
        }
        this._remoteObjects.addElement(remoteWrapper);
    }

    public void removeRemoteWrapper(RemoteWrapper remoteWrapper) {
        this._remoteObjects.removeElement(remoteWrapper);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String s) throws RemoteException {
        this.name = s;
    }

    public String getUrl() throws RemoteException {
        return this.stringUrl;
    }

    public void setUrl(String s) throws RemoteException {
        this.stringUrl = s;
        this.setRmiPort(s);
    }

    public void setBindPort(int port) {
        this.bindPort = port;
    }

    public int getBindPort() {
        return this.bindPort;
    }

    public String getHost() {
        int endOfHostname;
        StringBuffer sb = new StringBuffer();
        int startOfHostname = 0;
        if (this.stringUrl.indexOf("//") == 0) {
            startOfHostname = 2;
        }
        if ((endOfHostname = this.stringUrl.indexOf(58)) == -1 && (endOfHostname = this.stringUrl.lastIndexOf(47)) == -1) {
            endOfHostname = this.stringUrl.length();
        }
        sb.append(this.stringUrl.substring(startOfHostname, endOfHostname));
        return sb.toString();
    }

    public int getPort() {
        return this.port;
    }

    public void setRmiPort(String url) {
        if (url == null || url.isEmpty()) {
            return;
        }
        try {
            String tmp = url.substring(0, url.lastIndexOf(47));
            tmp = tmp.substring(tmp.lastIndexOf(58) + 1);
            this.port = Integer.parseInt(tmp);
        }
        catch (Exception e) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("setRmiPort: error with url " + url + " " + e.getMessage());
        }
    }

    public int getRmiPort() {
        return this.port;
    }

    public int getNextPortOffset() {
        return Integer.getInteger(NEXT_PORT_PROP, 50);
    }

    public void setNetworked(boolean tf) {
        this.networked = tf;
    }

    public boolean getNetworked() {
        return this.networked;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.reexport();
    }

    public Object clone() throws CloneNotSupportedException {
        try {
            PortableRmiObject cloned = (PortableRmiObject)super.clone();
            cloned.reexport();
            return cloned;
        }
        catch (RemoteException e) {
            throw new ServerCloneException("Clone failed", e);
        }
    }

    private void reexport() throws RemoteException {
        UnicastRemoteObject.exportObject((Remote)this, this.port);
    }

    public static Remote exportObject(Remote obj) throws RemoteException {
        return UnicastRemoteObject.exportObject(obj, 0);
    }

    public static boolean unexportObject(Remote obj, boolean force) throws NoSuchObjectException {
        return UnicastRemoteObject.unexportObject(obj, force);
    }

    public static void setStaticBindPort(int port) {
        _staticBindPort = port;
    }

    static {
        if (((MarkingClassLogger.Api)LOGGER.atFine()).isEnabled()) {
            LimitedPortServerSocketFactory.setDebug(true);
        }
    }
}

