/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.server;

import com.google.common.flogger.FluentLogger;
import hec.lang.NamedType;
import hec.properties.SystemProperties;
import hec.script.ScriptEngine;
import java.lang.reflect.InvocationTargetException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import mil.army.usace.hec.rmi.csinterface.Naming;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.server.PortableRmiObject;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import mil.army.usace.hec.rmi.server.SinglePortServerSocketFactory;
import mil.army.usace.hec.rmi.server.StatusReportingServer;
import rma.util.RMAConst;
import rma.util.RMAIO;

public class RMIServer
extends NamedType {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    protected static final int SCRIPT_FAILURE_NO_SCRIPT = 100;
    protected PortableRmiObject _server;
    private String _inetaddr;
    public static String stringUrl;
    protected static int port;
    public RemoteWrapper fmWrapper;
    protected static boolean _runningScript;

    public RMIServer() {
        if (port == 0) {
            port = 8089;
        }
        if (!_runningScript) {
            String hostname = System.getProperty("java.rmi.server.hostname");
            try {
                stringUrl = "//";
                stringUrl = hostname != null ? stringUrl + hostname : stringUrl + InetAddress.getLocalHost().getHostAddress();
                stringUrl = stringUrl + ":" + port + "/";
            }
            catch (UnknownHostException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Exception trying to get LocalHost");
            }
            String osName = System.getProperty("os.name").toLowerCase();
            if (osName.startsWith("windows")) {
                try {
                    this._inetaddr = System.getProperty("java.rmi.server.hostname");
                    if (this._inetaddr == null) {
                        this._inetaddr = InetAddress.getLocalHost().getHostAddress();
                        Properties props = System.getProperties();
                        props.put("java.rmi.server.hostname", this._inetaddr);
                        System.setProperties(props);
                    }
                }
                catch (Exception e) {
                    ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error setting property java.rmi.server.hostname  ");
                }
            } else {
                this._inetaddr = "";
            }
            try {
                RmiFileManager fmi = (RmiFileManager)Naming.lookup(stringUrl + "FileManager");
                this.fmWrapper = new RemoteWrapper(fmi);
                this.fmWrapper.setExported(true);
            }
            catch (Exception e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFine()).withCause((Throwable)e)).log("RMIServer:failed to lookup RmiFileManager");
            }
        } else {
            ((FluentLogger.Api)LOGGER.atInfo()).log("RMIServer:creating RmiFileManagerImpl");
            try {
                Class<?> c = Class.forName("mil.army.usace.hec.rmi.server.RmiFileManagerImpl");
                RmiFileManager fmi = (RmiFileManager)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.fmWrapper = new RemoteWrapper(fmi);
                this.fmWrapper.setExported(true);
            }
            catch (ReflectiveOperationException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("RMIServer:failed to create RmiFileManager");
            }
        }
        SystemProperties.load();
    }

    protected void setServer(PortableRmiObject server) {
        this._server = server;
        this._server.setFileManager(this.fmWrapper);
    }

    protected void startServer() {
        if (stringUrl == null || _runningScript) {
            return;
        }
        try {
            this._server.rebindServer(stringUrl);
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error rebinding server: " + stringUrl);
        }
    }

    public static int getBindPort(String[] args) {
        int bindport = 0;
        for (int idx = 0; idx < args.length; ++idx) {
            if (!args[idx].startsWith("-b")) continue;
            if (args[idx].length() == 2) {
                if (args[idx + 1] == null || args[idx + 1].equals("")) continue;
                bindport = RMAIO.parseInt((String)args[idx + 1], (int)0);
                SinglePortServerSocketFactory.setPort(bindport);
                PortableRmiObject.setStaticBindPort(bindport);
                return bindport;
            }
            bindport = RMAIO.parseInt((String)args[idx].substring(2));
            SinglePortServerSocketFactory.setPort(bindport);
            PortableRmiObject.setStaticBindPort(bindport);
            return bindport;
        }
        return bindport;
    }

    public static int setRmiPort(String[] args) {
        int p = -1;
        for (int idx = 0; idx < args.length; ++idx) {
            if (!args[idx].startsWith("-p")) continue;
            if (args[idx].length() == 2) {
                if (args[idx + 1] == null || args[idx + 1].equals("")) continue;
                port = Integer.parseInt(args[idx + 1]);
                break;
            }
            port = Integer.parseInt(args[idx].substring(2));
            break;
        }
        if (port == 0) {
            port = 8089;
        }
        if (port != 8089) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("Rmi Registry Port is set to " + port);
            return port;
        }
        return -1;
    }

    public static String getURL() {
        return stringUrl;
    }

    public static void main(String[] args) {
        RMIServer authenticationServer = new RMIServer();
        try {
            authenticationServer.startServer();
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atSevere()).withCause((Throwable)e)).log("Error starting server");
        }
    }

    public PortableRmiObject getRMIObj() {
        return this._server;
    }

    protected void startStatusReporting(StatusReportingServer impl, String propName) {
        if (impl == null) {
            return;
        }
        int status = RMAIO.parseInt((String)System.getProperty(propName));
        if (RMAConst.isUndefinedValue((int)status)) {
            impl.startStatusReporting();
        } else {
            impl.startStatusReporting(status);
        }
    }

    protected static int launchScript(String jythonFile, String[] args) throws Throwable {
        if (jythonFile == null || jythonFile.length() == 0) {
            return 100;
        }
        try {
            if (args != null) {
                ScriptEngine.init((String[])args);
            }
            return ScriptEngine.engine().execute(jythonFile, System.getProperty("user.name"), RMAIO.getFileNameNoExtension((String)jythonFile));
        }
        catch (Throwable e) {
            if (e instanceof InvocationTargetException) {
                e = ((InvocationTargetException)e).getTargetException();
            }
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause(e)).log("launchScript:Error running " + jythonFile);
            throw e;
        }
    }

    static {
        port = 0;
        _runningScript = false;
    }
}

