/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.server;

import java.io.Serializable;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import mil.army.usace.hec.rmi.server.PortableRmiObject;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.RmiPortsLoggingMarker;

public class RemoteWrapper
implements Serializable {
    static final long serialVersionUID = 6032384406087218574L;
    private static final MarkingClassLogger LOGGER = MarkingClassLogger.forMarkingClass(RmiPortsLoggingMarker.class);
    private static RMIServerSocketFactory _serverSocketFactory = null;
    private static RMIClientSocketFactory _clientSocketFactory = null;
    public Remote remote = null;
    private transient Object expObjectRef;
    public String name = null;
    public boolean exported = false;
    protected int _bindPort = 0;

    public RemoteWrapper() {
    }

    public RemoteWrapper(Remote obj) {
        this();
        this.setRemote(obj);
    }

    public void setRemote(Remote obj) {
        this.remote = obj;
    }

    public Remote getRemote() {
        return this.remote;
    }

    public void setName(String s) {
        this.name = s;
    }

    public String getName() {
        return this.name;
    }

    public void setExported(boolean e) {
        this.exported = e;
    }

    public boolean getExported() {
        return this.exported;
    }

    public void export(RMIClientSocketFactory rcsf, RMIServerSocketFactory rssf) throws RemoteException {
        if (!this.exported) {
            Remote newRemote = UnicastRemoteObject.exportObject(this.remote, this._bindPort, rcsf, rssf);
            this.expObjectRef = this.remote;
            this.setRemote(newRemote);
            this.exported = true;
        }
    }

    public void export() throws RemoteException {
        this.export(_clientSocketFactory, _serverSocketFactory);
    }

    public boolean unexportObject(Remote remoteObj, boolean force) {
        if (this.exported) {
            try {
                return PortableRmiObject.unexportObject(remoteObj, force);
            }
            catch (RuntimeException | RemoteException e) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("unexportObject: error unexporting " + e);
            }
        }
        return false;
    }

    public Object getObject() {
        return this.expObjectRef;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteWrapper) {
            RemoteWrapper rmt = (RemoteWrapper)obj;
            Remote remote = rmt.getRemote();
            return this.remote.equals(remote);
        }
        return false;
    }

    public void setBindPort(int port) {
        this._bindPort = port;
    }

    public int getBindPort() {
        return this._bindPort;
    }

    public static void setClientSocketFactory(RMIClientSocketFactory csf) {
        _clientSocketFactory = csf;
    }

    public static void setServerSocketFactory(RMIServerSocketFactory ssf) {
        _serverSocketFactory = ssf;
    }

    public String toString() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        if (this.remote != null) {
            return this.remote.toString();
        }
        return super.toString();
    }
}

