/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.server;

import codebase.Code4jni;
import codebase.Data4;
import codebase.Data4jni;
import codebase.Error4entry;
import codebase.Error4field;
import codebase.Error4file;
import codebase.Error4locked;
import codebase.Error4message;
import codebase.Error4tagName;
import codebase.Error4unexpected;
import codebase.Error4unique;
import codebase.Error4usage;
import codebase.Field4deleteFlag;
import codebase.Field4info;
import codebase.Tag4info;
import hec.io.RmiFileInfo;
import hec.io.dbf.DBFHeader;
import hec.io.dbf.DbfException;
import hec.io.dbf.DbfNestedException;
import hec.io.dbf.DbfQueryResultSet;
import hec.io.dbf.DbfRecordIndexSet;
import hec.io.dbf.DbfRecordQuery;
import hec.io.dbf.DbfRecordQueryException;
import hec.io.dbf.DbfRecordSet;
import hec.io.dbf.DbfResultSet;
import hec.io.dbf.DbfUtil;
import hec.io.dbf.DbfWriteResultSet;
import hec.io.dbf.DeleteRecordHandler;
import hec.io.dbf.Field4infoContainer;
import hec.io.dbf.IndexTagKeyNotFoundException;
import hec.io.dbf.QueryRecordHandler;
import hec.io.dbf.RecordHandler;
import hec.io.dbf.Tag4infoContainer;
import hec.io.dbf.WriteRecordHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import mil.army.usace.hec.rmi.csinterface.RmiDbfFile;
import mil.army.usace.hec.rmi.csinterface.RmiFileCallBack;
import mil.army.usace.hec.rmi.server.RmiFileImpl;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.CodebaseLoggingMarker;

public class RmiDbfFileImpl
extends RmiFileImpl
implements RmiDbfFile,
Serializable {
    private static final MarkingClassLogger CODEBASE_LOGGER = MarkingClassLogger.forMarkingClass(CodebaseLoggingMarker.class);
    public static final String[] INDEX_EXTENSIONS = new String[]{".mdx"};
    boolean _data4Allocated = false;
    boolean _data4Opened = false;
    DBFHeader _header;
    Data4jni _data4Jni;
    static Code4jni _code4Jni;

    public RmiDbfFileImpl(String owner, String fileName, String relativePath) {
        super(owner, fileName, relativePath);
        this._writeToTmp = false;
    }

    @Override
    public synchronized void setSafety(boolean tf) {
        _code4Jni.safety(tf);
    }

    @Override
    public synchronized void setAccessMode(byte b) throws Error4usage {
        _code4Jni.accessMode(b);
    }

    @Override
    public boolean getSafety() {
        return _code4Jni.safety();
    }

    @Override
    public byte getAccessMode() {
        return _code4Jni.accessMode();
    }

    @Override
    public synchronized DBFHeader getHeader() {
        if (this._header == null) {
            if (!this.exists()) {
                return null;
            }
            this._header = DbfUtil.readHeader((File)this);
        }
        return this._header;
    }

    public int getRecordCount() {
        DBFHeader header = this.getHeader();
        return header.getNumRecords();
    }

    @Override
    public RmiFileInfo getFileInfo() {
        RmiFileInfo info = new RmiFileInfo();
        info.fileName = this.getFileName();
        info.lockedBy = this.getLockedBy();
        info.editLockedBy = this.getEditLockedBy();
        info.truePath = this.getTruePath();
        info.user = this.getUser();
        info.callbackCnt = this.getCallBackCount();
        info.refCount = this._refCount.size();
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this._callBackObjects.size(); ++i) {
            String s = ((RmiFileCallBack)this._callBackObjects.get(i)).toString();
            int idx = s.indexOf("endpoint:[");
            if (idx > -1) {
                int idx2 = s.indexOf("]", idx);
                if (idx2 > -1) {
                    s = s.substring(idx + 10, idx2);
                    v.add(s);
                    continue;
                }
                v.add(s);
                continue;
            }
            v.add(s);
        }
        info.callbacks = v;
        info.referenceUsers = (Vector)this._refCount.clone();
        return info;
    }

    @Override
    public synchronized boolean delete() {
        boolean tf;
        if (this._data4Allocated) {
            try {
                ((MarkingClassLogger.Api)CODEBASE_LOGGER.atFine()).log("DATA 4 IS CLOSING");
                this._data4Jni.close();
            }
            catch (Exception e) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)CODEBASE_LOGGER.atFine()).withCause((Throwable)e)).log();
            }
            finally {
                this._data4Allocated = false;
                this._data4Opened = false;
            }
        }
        if (tf = super.delete()) {
            String thisNoExt = RMAIO.getPathNoExtension((String)this.getAbsolutePath());
            String dbtPath = thisNoExt + ".dbt";
            File dbtFile = new File(dbtPath);
            if (dbtFile.exists()) {
                dbtFile.delete();
            }
            for (int ii = 0; ii < INDEX_EXTENSIONS.length; ++ii) {
                String indexPath = thisNoExt + INDEX_EXTENSIONS[ii];
                File indexFile = new File(indexPath);
                if (!indexFile.exists()) continue;
                indexFile.delete();
            }
        }
        return tf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void createDbfFile(DBFHeader header, Tag4infoContainer tagContainer) throws IOException, Error4usage, Error4unexpected, Error4field, Error4message, Error4file {
        this.initData4();
        byte b = 0;
        try {
            b = this.getAccessMode();
            _code4Jni.accessMode((byte)1);
            Field4infoContainer fieldContainer = DbfUtil.buildField4infoContainer((DBFHeader)header);
            String path = this.getPath();
            if (RMAIO.getOSType() == 1 || RMAIO.getOSType() == 0) {
                path = path.replace('/', '\\');
            }
            if (tagContainer != null && fieldContainer != null) {
                Tag4info tag4info = tagContainer.getTag4info();
                Field4info f4info = fieldContainer.getField4info();
                ((MarkingClassLogger.Api)CODEBASE_LOGGER.atFine()).log("Creating Dbf File: %s", (Object)path);
                this._data4Jni.create(path, f4info, tag4info);
                this._data4Opened = true;
            } else if (fieldContainer != null) {
                Field4info f4info = fieldContainer.getField4info();
                this._data4Jni.create(path, f4info);
                this._data4Opened = true;
            }
        }
        finally {
            this.setAccessMode(b);
        }
        this._header = header;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean createIndex(String indexFileName, Tag4infoContainer tagContainer) throws IOException, Error4usage, Error4unexpected, Error4unique, Error4file, Error4message {
        this.initData4();
        this.openDbfFile();
        byte b = 0;
        try {
            b = this.getAccessMode();
            if (RMAIO.getOSType() == 1 || RMAIO.getOSType() == 0) {
                indexFileName = indexFileName.replace('/', '\\');
            }
            Tag4info indexTags = tagContainer.getTag4info();
            _code4Jni.accessMode((byte)1);
            this._data4Jni.createIndex(indexFileName, indexTags);
        }
        finally {
            this.setAccessMode(b);
        }
        return true;
    }

    @Override
    public synchronized boolean pack() throws IOException, Error4usage, Error4unexpected, Error4file, Error4locked, Error4message, Error4unique {
        this.initData4();
        this.openDbfFile();
        this._data4Jni.pack();
        return true;
    }

    @Override
    public synchronized DbfResultSet deleteRecords(DbfRecordIndexSet recordIndexSet) throws IOException, Error4usage, Error4unexpected, Error4message, Error4field, Error4file, Error4tagName, Error4locked, Error4tagName, Error4unique, Error4entry {
        this.initData4();
        this.openDbfFile();
        DbfResultSet resultSet = new DbfResultSet(recordIndexSet);
        Field4deleteFlag deleteFlag = new Field4deleteFlag((Data4)this._data4Jni);
        Vector<Field4deleteFlag> fieldObjects = new Vector<Field4deleteFlag>(1);
        fieldObjects.add(deleteFlag);
        DeleteRecordHandler recordHandler = new DeleteRecordHandler(this._data4Jni, recordIndexSet, resultSet, fieldObjects);
        this.processRecords(recordIndexSet, (RecordHandler)recordHandler);
        return resultSet;
    }

    @Override
    public synchronized DbfQueryResultSet queryRecords(DbfRecordQuery query) throws IOException, Error4usage, Error4unexpected, Error4message, Error4field, Error4file, Error4tagName, Error4locked, Error4tagName, Error4unique, Error4entry {
        this.initData4();
        this.openDbfFile();
        DbfQueryResultSet resultSet = new DbfQueryResultSet(query);
        String[] fieldNames = query.getFieldNames();
        Vector fieldObjects = null;
        fieldObjects = DbfUtil.buildField4Objects((Data4)this._data4Jni, (DBFHeader)this.getHeader(), (String[])fieldNames);
        QueryRecordHandler recordHandler = new QueryRecordHandler(this._data4Jni, query, resultSet, fieldObjects);
        this.processRecords((DbfRecordIndexSet)query, (RecordHandler)recordHandler);
        return resultSet;
    }

    @Override
    public synchronized DbfWriteResultSet writeRecords(DbfRecordSet recordSet) throws IOException, Error4usage, Error4unexpected, Error4message, Error4field, Error4file, Error4tagName, Error4locked, Error4tagName, Error4unique, Error4entry {
        this.initData4();
        this.openDbfFile();
        DbfWriteResultSet resultSet = new DbfWriteResultSet((DbfRecordIndexSet)recordSet);
        String[] fieldNames = recordSet.getFieldNames();
        Vector fieldObjects = null;
        fieldObjects = DbfUtil.buildField4Objects((Data4)this._data4Jni, (DBFHeader)this.getHeader(), (String[])fieldNames);
        WriteRecordHandler recordHandler = new WriteRecordHandler(this._data4Jni, recordSet, resultSet, fieldObjects);
        this.processRecords((DbfRecordIndexSet)recordSet, (RecordHandler)recordHandler);
        return resultSet;
    }

    @Override
    public void close(String userId) throws IOException {
        this.close();
    }

    public synchronized void close() throws IOException {
        if (!this._data4Allocated) {
            return;
        }
        try {
            this._data4Jni.close();
        }
        catch (Exception e) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)CODEBASE_LOGGER.atFine()).withCause((Throwable)e)).log();
        }
        finally {
            this._data4Allocated = false;
            this._data4Opened = false;
        }
    }

    @Override
    public synchronized void unreferenced() {
        try {
            this.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initData4() throws IOException, Error4usage, Error4unexpected, Error4file, Error4message {
        if (this._data4Allocated) {
            return;
        }
        this._data4Jni = new Data4jni(_code4Jni);
        this._data4Allocated = true;
    }

    private void openDbfFile() throws IOException, Error4usage, Error4unexpected, Error4file, Error4message {
        if (this._data4Opened) {
            return;
        }
        if (!this.exists()) {
            throw new FileNotFoundException(this.getPath());
        }
        if (RMAIO.getOSType() == 1 || RMAIO.getOSType() == 0) {
            this._data4Jni.open(this.getPath().replace('/', '\\'));
        } else {
            this._data4Jni.open(this.getPath());
        }
        this._data4Opened = true;
    }

    private synchronized boolean openIndex(String indexFileName) throws IOException, FileNotFoundException, Error4message, Error4usage, Error4unexpected, Error4file {
        this.initData4();
        this.openDbfFile();
        if (indexFileName != null && (RMAIO.getOSType() == 1 || RMAIO.getOSType() == 0)) {
            indexFileName = indexFileName.replace('/', '\\');
        }
        this._data4Jni.openIndex(indexFileName);
        return true;
    }

    private void processRecords(DbfRecordIndexSet recordIndexSet, RecordHandler recordHandler) throws IOException, Error4usage, Error4unexpected, Error4message, Error4field, Error4file, Error4tagName, Error4locked, Error4tagName, Error4unique, Error4entry {
        if (recordIndexSet.hasIndex()) {
            block13: {
                if (recordIndexSet.getIndexFileName() != null) {
                    try {
                        this.openIndex(recordIndexSet.getIndexFileName());
                    }
                    catch (Error4file e) {
                        if (_code4Jni.getLastError() == -69) break block13;
                        ((MarkingClassLogger.Api)((MarkingClassLogger.Api)CODEBASE_LOGGER.atFine()).withCause((Throwable)e)).log();
                        DbfNestedException dbfe = new DbfNestedException((Exception)((Object)e));
                        recordHandler.getResultSet().add(dbfe);
                        return;
                    }
                }
            }
            this._data4Jni.select(recordIndexSet.getIndexTagName());
            if (this._data4Jni.top() == 3 && recordHandler instanceof QueryRecordHandler) {
                return;
            }
            int recNo = this._data4Jni.recNo();
            Serializable[] tagKeys = recordIndexSet.getIndexTagKeys();
            if (tagKeys == null || tagKeys.length < 1) {
                this.processAllRecords(recordHandler);
            } else {
                for (int ii = 0; ii < tagKeys.length; ++ii) {
                    boolean found;
                    boolean bl = found = this._data4Jni.seek(tagKeys[ii].toString()) == 0;
                    if (found) {
                        recNo = this._data4Jni.recNo();
                    } else {
                        recNo = Integer.MIN_VALUE;
                        if (recordHandler instanceof QueryRecordHandler) {
                            recordHandler.getResultSet().add((DbfException)new IndexTagKeyNotFoundException(tagKeys[ii].toString()));
                            continue;
                        }
                    }
                    recordHandler.process(ii, recNo, tagKeys[ii]);
                }
            }
        } else {
            this._data4Jni.select(null);
            if (this._data4Jni.top() == 3) {
                return;
            }
            this.processAllRecords(recordHandler);
        }
    }

    private void processAllRecords(RecordHandler recordHandler) throws IOException, Error4usage, Error4unexpected, Error4message, Error4field, Error4file, Error4tagName, Error4locked, Error4tagName, Error4unique, Error4entry {
        if (!(recordHandler instanceof QueryRecordHandler)) {
            return;
        }
        int recNo = this._data4Jni.recNo();
        recordHandler.process(Integer.MIN_VALUE, recNo, null);
        while (this._data4Jni.skip() != 3) {
            try {
                recNo = this._data4Jni.recNo();
                recordHandler.process(Integer.MIN_VALUE, recNo, null);
            }
            catch (Exception e) {
                ((MarkingClassLogger.Api)((MarkingClassLogger.Api)CODEBASE_LOGGER.atFine()).withCause((Throwable)e)).log();
                DbfRecordQueryException dqe = new DbfRecordQueryException(null, e);
                recordHandler.getResultSet().add((DbfNestedException)dqe);
            }
        }
    }

    static {
        try {
            _code4Jni = new Code4jni();
            _code4Jni.safety(true);
            _code4Jni.accessMode((byte)0);
        }
        catch (Exception e) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)CODEBASE_LOGGER.atFine()).withCause((Throwable)e)).log();
        }
    }
}

