/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.server;

import com.google.common.flogger.LazyArgs;
import com.google.common.flogger.StackSize;
import hec.io.FileListener;
import hec.io.FileLock;
import hec.io.FileMonitor;
import hec.io.RmiFileInfo;
import hec.io.RmiFileSizeInfo;
import hec.lang.NoSuchObjectException;
import hec.util.CRC32Util;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.net.InetAddress;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.server.Unreferenced;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import mil.army.usace.hec.rmi.csinterface.RmiFile;
import mil.army.usace.hec.rmi.csinterface.RmiFileCallBack;
import mil.army.usace.hec.rmi.server.RmiFileSocketFactory;
import mil.army.usace.hec.rmi.server.SocketConnectionThread;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.ManagerLoadingLoggingMarker;

public class RmiFileImpl
extends File
implements RmiFile,
Serializable,
Unreferenced,
FileListener {
    private static final MarkingClassLogger MANAGER_LOADING_LOGGER = MarkingClassLogger.forMarkingClass(ManagerLoadingLoggingMarker.class);
    public static final String CREATEBAK_PROP = "RmiFile.createBackup";
    public static final String CREATETMP_PROP = "RmiFile.writeToTmp";
    public static final String INTERNOWNER_PROP = "RmiFile.internOwner";
    private static FileMonitor _fileMonitor = new FileMonitor(10000L);
    public static final int BUFFER_SIZE = 32768;
    boolean _appendingWrite = false;
    protected static final String TMP_EXTENSION = ".tmp";
    protected static final String BAK_EXTENSION = ".bak";
    protected String _owner;
    protected String _relativePath;
    protected Vector<RmiFileCallBack> _callBackObjects = new Vector();
    protected Vector<String> _refCount = new Vector();
    protected static boolean _createBackups = true;
    protected static boolean _writeToTmpDefault = true;
    protected boolean _writeToTmp = _writeToTmpDefault;
    protected static boolean _debug = false;
    protected transient SocketConnectionThread _socket = null;
    protected static RmiFileSocketFactory _socketFactory;
    protected Vector _readLockList = new Vector();
    protected FileLock _writeLock = null;
    protected FileLock _editLock = null;
    private boolean _networked;
    private static byte[] _unzippedByteArray;
    private static byte[] _zippedByteArray;
    private List<Serializable> _callbackHandles = new ArrayList<Serializable>();

    public RmiFileImpl(String owner, String fileName, String relativePath) {
        super(fileName);
        this._owner = owner;
        if (Boolean.getBoolean(INTERNOWNER_PROP) && this._owner != null) {
            this._owner = this._owner.intern();
        }
        this._relativePath = relativePath;
        if (this.exists()) {
            _fileMonitor.addFile((File)this, (FileListener)this);
        }
    }

    @Override
    public void unreferenced() {
        this.notify("unbound");
        _fileMonitor.removeFile((File)this);
    }

    @Override
    public String getFileName() {
        String name = this.getName();
        int index = name.lastIndexOf("/");
        return index < 0 ? name : name.substring(index + 1);
    }

    @Override
    public String getRelativePath() {
        return this._relativePath;
    }

    @Override
    public String getTruePath() {
        return super.getPath();
    }

    @Override
    public boolean getIsDirectory() {
        return this.isDirectory();
    }

    @Override
    public boolean closeAndUnlock(FileLock fLock) throws IOException {
        boolean b = this.unlock(fLock);
        this.close(this._owner);
        return b;
    }

    @Override
    public boolean delete() {
        if (super.delete()) {
            this.notify("Deleted");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close(String userId) throws IOException {
        if (!this._writeToTmp) {
            return;
        }
        if (this.isDirectory()) {
            return;
        }
        String tmpFileName = this.getPath() + TMP_EXTENSION;
        File tmpFile = new File(tmpFileName);
        if (tmpFile.exists()) {
            RmiFileImpl rmiFileImpl = this;
            synchronized (rmiFileImpl) {
                if (_createBackups) {
                    String bakFileName = this.getPath() + BAK_EXTENSION;
                    File bakFile = new File(bakFileName);
                    if (bakFile.exists()) {
                        bakFile.delete();
                    }
                    this.renameTo(bakFile);
                } else if (this.exists() && !this.delete()) {
                    System.out.println("WARNING: close() - delete() returned failure.");
                }
                if (!tmpFile.renameTo(this)) {
                    String msg = "close() - " + tmpFile.getPath() + ".renameTo(" + this.getPath() + ") failed";
                    System.out.println("WARNING: " + msg);
                    throw new IOException(msg);
                }
                this._appendingWrite = false;
            }
            if (_fileMonitor.contains((File)this)) {
                _fileMonitor.updateLastModified((File)this, this.lastModified());
            } else {
                _fileMonitor.addFile((File)this, (FileListener)this);
            }
            this.notify("Modified|" + userId);
        } else if (_debug) {
            System.out.println("WARNING: close() can't find " + tmpFileName + " so no backup or rename will occur.");
        }
    }

    @Override
    public void append() {
        this._appendingWrite = true;
    }

    @Override
    public void overwrite() {
        this._appendingWrite = false;
    }

    @Override
    public void setUser(String newOwner) {
        this._owner = newOwner;
        if (Boolean.getBoolean(INTERNOWNER_PROP) && this._owner != null) {
            this._owner = this._owner.intern();
        }
    }

    @Override
    public String getUser() {
        return this._owner;
    }

    @Override
    public synchronized byte[] getByteArray(String userId) {
        return this.getByteArray(false, userId);
    }

    @Override
    public synchronized byte[] getByteArray(boolean compress, String userId) {
        this.addRefCount(userId);
        try {
            FileInputStream fis = new FileInputStream(this);
            int available = fis.available();
            byte[] byteArray = new byte[available];
            fis.read(byteArray);
            fis.close();
            if (compress) {
                return this.zip(byteArray);
            }
            return byteArray;
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("getByteArray: File Not Found: " + this.getPath());
            System.out.println(fnfe.getMessage());
        }
        catch (IOException ioe) {
            System.out.println("getByteArray: File IO Exception: " + this.getPath());
            System.out.println(ioe.getMessage());
            ioe.printStackTrace(System.out);
        }
        return new byte[0];
    }

    @Override
    public synchronized byte[] getByteArray(long off, int len, String userId) {
        return this.getByteArray(off, len, false, userId);
    }

    @Override
    public synchronized byte[] getByteArray(long off, int len, boolean compress, String userId) {
        this.addRefCount(userId);
        try {
            FileInputStream fis = new FileInputStream(this);
            long available = this.length();
            long wants = off + (long)len;
            if (_debug) {
                System.out.println(this.getPath() + ".getByteArray off=" + off + " len=" + len + " avail=" + available);
            }
            long newLen = len;
            if (available < wants) {
                newLen = available - off;
            }
            byte[] byteArray = new byte[(int)newLen];
            fis.skip(off);
            fis.read(byteArray);
            fis.close();
            if (compress) {
                byteArray = this.zip(byteArray);
            }
            if (_debug) {
                System.out.println(this.getPath() + ".getByteArray: returning " + byteArray.length + " of " + len + " available");
            }
            return byteArray;
        }
        catch (FileNotFoundException fnfe) {
            System.out.println("getByteArray:File Not Found: " + this.getPath());
            System.out.println(fnfe.getMessage());
        }
        catch (IOException ioe) {
            System.out.println("getByteArray:File IO Exception: " + this.getPath());
            System.out.println(ioe.getMessage());
            ioe.printStackTrace(System.out);
        }
        return null;
    }

    @Override
    public boolean setByteArray(byte[] byteArray, String userId) {
        return this.setByteArray(byteArray, false, userId);
    }

    @Override
    public synchronized boolean setByteArray(byte[] byteArray, boolean compressed, String userId) {
        Object tmpFileName;
        this.addRefCount(userId);
        Object object = tmpFileName = this._writeToTmp ? this.getPath() + TMP_EXTENSION : this.getPath();
        if (this.isDirectory()) {
            System.out.println("************ RMI File : \"" + (String)tmpFileName + "\". Is a Directory ************");
            return false;
        }
        try {
            FileOutputStream fos = new FileOutputStream((String)tmpFileName);
            if (compressed) {
                byteArray = this.unzip(byteArray);
            }
            fos.write(byteArray);
            fos.close();
            return true;
        }
        catch (Exception e) {
            System.out.println(e);
            if (!this.isFile()) {
                System.out.println("********** RMI File : \"" + (String)tmpFileName + "\". Is not a File **********");
                return false;
            }
            if (!this.canWrite()) {
                System.out.println("********** RMI File : \"" + (String)tmpFileName + "\" is *READ-ONLY*. **********");
                return false;
            }
            e.printStackTrace(System.out);
            return false;
        }
    }

    protected void copyFile(File src, File dest) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(src));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(dest));
        int len = 1024;
        byte[] b = new byte[len];
        int ibytes = 0;
        ibytes = in.read(b, 0, len);
        while (ibytes > -1) {
            out.write(b, 0, ibytes);
            ibytes = in.read(b, 0, len);
        }
        out.flush();
        in.close();
        out.close();
    }

    @Override
    public boolean appendByteArray(byte[] byteArray, String userId) {
        return this.appendByteArray(byteArray, false, userId);
    }

    @Override
    public synchronized boolean appendByteArray(byte[] byteArray, boolean compressed, String userId) {
        this.addRefCount(userId);
        Object tmpFileName = this._writeToTmp ? this.getPath() + TMP_EXTENSION : this.getPath();
        try {
            File tmpFile;
            if (this._writeToTmp && this._appendingWrite && !(tmpFile = new File((String)tmpFileName)).exists()) {
                this.copyFile(this, tmpFile);
            }
            RandomAccessFile raFile = new RandomAccessFile((String)tmpFileName, "rw");
            long length = raFile.length();
            raFile.seek(length);
            if (compressed) {
                byteArray = this.unzip(byteArray);
            }
            raFile.write(byteArray);
            raFile.close();
            return true;
        }
        catch (Exception e) {
            System.out.println(e);
            if (!this.isFile()) {
                System.out.println("********** RMI File : \"" + (String)tmpFileName + "\". Is not a File **********");
                return false;
            }
            if (!this.canWrite()) {
                System.out.println("********** RMI File : \"" + (String)tmpFileName + "\" is *READ-ONLY*. **********");
                return false;
            }
            e.printStackTrace(System.out);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Deprecated
    public void setCallBack(Serializable callbackHandle) {
        if (callbackHandle == null) {
            return;
        }
        List<Serializable> list = this._callbackHandles;
        synchronized (list) {
            if (this._callbackHandles.contains(callbackHandle)) {
                return;
            }
            this._callbackHandles.add(callbackHandle);
        }
    }

    @Override
    public void setCallBack(final RmiFileCallBack callBack) {
        if (callBack == null) {
            return;
        }
        Thread t = new Thread(this.getName() + ".setCallBack"){

            @Override
            public void run() {
                int callbackHashcode;
                RmiFileImpl.this._callBackObjects.add(callBack);
                if (_debug) {
                    System.out.println(RmiFileImpl.this.getPath() + " setCallBack " + RmiFileImpl.this._callBackObjects.size());
                }
                try {
                    callbackHashcode = callBack.getCBHashCode();
                }
                catch (Exception e) {
                    if (_debug) {
                        System.out.println("setCallBack: RMI Error getting callback's hashcode " + e);
                    }
                    return;
                }
                int cnt = 0;
                for (int i = RmiFileImpl.this._callBackObjects.size() - 1; i >= 0; --i) {
                    RmiFileCallBack otherCb = RmiFileImpl.this._callBackObjects.get(i);
                    if (otherCb == null) continue;
                    try {
                        if (otherCb.getCBHashCode() != callbackHashcode || ++cnt <= 1) continue;
                        if (_debug) {
                            System.out.println(RmiFileImpl.this.getPath() + " setCallBack: duplicate callback");
                        }
                        RmiFileImpl.this._callBackObjects.remove(callBack);
                        return;
                    }
                    catch (RemoteException re) {
                        if (_debug) {
                            System.out.println(RmiFileImpl.this.getPath() + " setCallBack: found bad callback");
                        }
                        RmiFileImpl.this._callBackObjects.remove(i);
                    }
                }
            }
        };
        t.start();
    }

    @Override
    public int getCallBackCount() {
        return this._callBackObjects.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCallBack(String callbackHandle) {
        List<Serializable> list = this._callbackHandles;
        synchronized (list) {
            this._callbackHandles.remove(callbackHandle);
        }
    }

    @Override
    public void removeCallBack(RmiFileCallBack callBack) {
        Iterator<RmiFileCallBack> iter = this._callBackObjects.iterator();
        while (iter.hasNext()) {
            boolean found;
            RmiFileCallBack cb = iter.next();
            try {
                found = callBack.equals(cb);
            }
            catch (Exception e) {
                if (_debug) {
                    System.out.println("removeCallback(" + this.getPath() + "):Error checking on callback " + e);
                }
                iter.remove();
                continue;
            }
            if (!found) continue;
            try {
                cb.removeCallbackInterface();
            }
            catch (RemoteException re) {
                System.out.println("removeCallBack:RMI Error (probably OK) removing callback for " + this.getPath() + " Error:" + re);
            }
            if (_debug) {
                System.out.println("Removing callback for " + this.getPath());
            }
            iter.remove();
            break;
        }
    }

    @Override
    public void notify(String message) {
        ((MarkingClassLogger.Api)MANAGER_LOADING_LOGGER.atFine()).log("notify(%s) %s networked=%s", (Object)LazyArgs.lazy(() -> this.getAbsolutePath()), (Object)message, (Object)this._networked);
        if (!this._networked) {
            new Notifier(message, this._callBackObjects).run();
        } else if (this._callBackObjects != null && !this._callBackObjects.isEmpty()) {
            ((MarkingClassLogger.Api)((MarkingClassLogger.Api)MANAGER_LOADING_LOGGER.atWarning()).withStackTrace(StackSize.MEDIUM)).log("Remote file notifier callbacks are not supported for RmiFileImpl");
        }
    }

    @Override
    public boolean canReadFile() throws RemoteException {
        return super.canRead();
    }

    protected String setLockedBy(FileLock fLock) {
        String notifyMsg = null;
        if (fLock == null) {
            return notifyMsg;
        }
        if (this._writeLock == null || this._writeLock.getUserId().equals(fLock.getUserId())) {
            switch (fLock.getLockType()) {
                case 5: {
                    this._writeLock.decrementRefCount();
                    if (this._writeLock.getRefCount() > 0) {
                        if (!_debug) break;
                        System.out.println(this.getName() + ".setLockedBy: unlocked. Locks left " + this._writeLock.getRefCount());
                        break;
                    }
                }
                case 2: {
                    if (_debug) {
                        System.out.println(this.getName() + ".setLockedBy: write unlock " + this._writeLock);
                    }
                    this._writeLock = null;
                    notifyMsg = this.getPath() + "|Unlocked|" + this.getUserId(fLock);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    if (this._writeLock == null) {
                        this._writeLock = fLock;
                        notifyMsg = this.getPath() + "|Write Locked by|" + this.getUserId(fLock);
                    }
                    this._writeLock.incrementRefCount();
                    if (!_debug) break;
                    System.out.println(this.getName() + ".setLockedBy: now locked by " + this._writeLock);
                }
            }
        }
        return notifyMsg;
    }

    protected String setEditLockedBy(FileLock fLock) {
        String notifyMsg = null;
        if (fLock == null) {
            return notifyMsg;
        }
        if (this._editLock == null || this._editLock.getUserId().equals(fLock.getUserId())) {
            switch (fLock.getLockType()) {
                case 7: {
                    this._editLock.decrementRefCount();
                    if (this._editLock.getRefCount() > 0) {
                        if (!_debug) break;
                        System.out.println(this.getName() + ".setEditLockedBy: unlocked. Locks left " + this._editLock.getRefCount());
                        break;
                    }
                }
                case 2: {
                    if (_debug) {
                        System.out.println(this.getName() + ".setEditLockedBy: edit unlock " + this._editLock);
                    }
                    this._editLock = null;
                    notifyMsg = this.getPath() + "|Unlocked|" + this.getUserId(fLock);
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    if (this._editLock == null) {
                        this._editLock = fLock;
                        notifyMsg = this.getPath() + "|Edit Locked by|" + this.getUserId(this._editLock);
                    }
                    this._editLock.incrementRefCount();
                    if (!_debug) break;
                    System.out.println(this.getName() + ".setEditLockedBy: now locked by " + this._editLock);
                }
            }
        }
        return notifyMsg;
    }

    @Override
    public String getEditLockedBy() {
        if (this._editLock != null) {
            return this._editLock.getUserId();
        }
        return "";
    }

    @Override
    public String getLockedBy() {
        if (this._writeLock != null) {
            return this._writeLock.getUserId();
        }
        return "";
    }

    public boolean hasWriteLock() {
        return this._writeLock != null;
    }

    @Override
    public void addRefCount(String userId) {
        if (userId == null || userId.equals(System.getProperty("user.name"))) {
            return;
        }
        if (this._refCount.contains(userId)) {
            return;
        }
        this._refCount.add(userId);
    }

    @Override
    public boolean removeRefCount(String userId) {
        this._refCount.removeElement(userId);
        return this._refCount.isEmpty();
    }

    @Override
    public int refCount() {
        return this._refCount.size();
    }

    @Override
    public Vector getRefCount() {
        return this._refCount;
    }

    @Override
    public boolean fileExists() {
        return super.exists();
    }

    @Override
    public boolean getIsFile() {
        return super.isFile();
    }

    @Override
    public boolean canWriteFile() {
        return super.canWrite();
    }

    @Override
    public boolean fmkdirs() {
        return super.mkdirs();
    }

    @Override
    public String getAbsolutePath() {
        return super.getAbsolutePath();
    }

    @Override
    public String lnSeparator() {
        return System.getProperty("line.separator");
    }

    @Override
    public long modifiedTime() {
        return super.lastModified();
    }

    @Override
    public long fileSize() {
        long size = super.length();
        return size;
    }

    @Override
    public long getCheckSum() {
        CRC32Util crc = new CRC32Util();
        try {
            crc.computeFileCRC32(this.getPath());
        }
        catch (IOException e) {
            return -1L;
        }
        return crc.getFileCRC();
    }

    @Override
    public String getHostAndPort(String clientUserId) {
        Object hostname = null;
        try {
            hostname = System.getProperty("java.rmi.server.hostname");
            if (hostname == null) {
                hostname = InetAddress.getLocalHost().getHostAddress();
            }
            if (this._socket == null || this._socket.isAlive()) {
                this._socket = _socketFactory.getServerConnection(clientUserId);
            }
            hostname = (String)hostname + ":" + this._socket.getPort();
        }
        catch (Exception e) {
            System.out.println("Exception trying to get LocalHost");
            System.out.println(e.getMessage() + "...." + e.toString());
            e.printStackTrace(System.out);
            return hostname;
        }
        return hostname;
    }

    @Override
    public boolean isLocked() {
        return this._writeLock != null || this._readLockList.size() != 0;
    }

    public boolean isEditLocked() {
        return this._editLock != null || this._readLockList.size() != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLockableBy(FileLock fLock) {
        if (fLock == null || fLock.getUserId() == null) {
            return false;
        }
        Vector vector = this._readLockList;
        synchronized (vector) {
            if (this._writeLock != null) {
                return this._writeLock.getUserId().equals(fLock.getUserId());
                {
                }
            }
            if (this._editLock != null) {
                if (this._editLock.getUserId().equals(fLock.getUserId())) {
                    return true;
                }
                return fLock.getLockType() == 3;
                {
                }
            }
            int size = this._readLockList.size();
            if (size < 1) {
                return true;
            }
            if (size == 1 && fLock.getLockType() == 4) {
                FileLock fl = (FileLock)this._readLockList.get(0);
                return fl.getUserId().equals(fLock.getUserId());
                {
                }
            }
            if (size > 1 && fLock.getLockType() == 4) {
                return false;
            }
            return size > 1 && fLock.getLockType() != 4;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean addLock(FileLock fLock) {
        String notifyMsg;
        block69: {
            FileLock fl;
            int size;
            block68: {
                int lockType;
                block67: {
                    block64: {
                        block65: {
                            block66: {
                                boolean bl;
                                if (fLock == null || fLock.getUserId() == null) {
                                    System.out.println("addLock: null FileLock or userId");
                                    return false;
                                }
                                if (FileLock.isUnlockType((int)fLock.getLockType())) {
                                    return this.unlock(fLock);
                                }
                                notifyMsg = null;
                                try {
                                    Vector vector = this._readLockList;
                                    // MONITORENTER : vector
                                    lockType = fLock.getLockType();
                                    if (this._writeLock == null) break block64;
                                    if (_debug) {
                                        System.out.println(this.getName() + ".addLock: already have writeLock " + this._writeLock);
                                    }
                                    if (!this._writeLock.getUserId().equals(fLock.getUserId())) break block65;
                                    if (lockType == 4) {
                                        notifyMsg = this.setLockedBy(fLock);
                                        if (_debug) {
                                            System.out.println(this.getName() + ".addLock: user already has write lock");
                                        }
                                        boolean bl2 = true;
                                        // MONITOREXIT : vector
                                        if (notifyMsg == null) return bl2;
                                        this.notify(notifyMsg);
                                        return bl2;
                                    }
                                    if (lockType != 6) break block66;
                                    notifyMsg = this.setEditLockedBy(fLock);
                                    if (_debug) {
                                        System.out.println(this.getName() + ".addLock: added edit lock");
                                    }
                                    bl = true;
                                }
                                catch (Throwable throwable) {
                                    if (notifyMsg == null) throw throwable;
                                    this.notify(notifyMsg);
                                    throw throwable;
                                }
                                if (notifyMsg == null) return bl;
                                this.notify(notifyMsg);
                                return bl;
                            }
                            this.addReadLock(fLock);
                            boolean bl = true;
                            // MONITOREXIT : vector
                            if (notifyMsg == null) return bl;
                            this.notify(notifyMsg);
                            return bl;
                        }
                        if (_debug) {
                            System.out.println(this.getName() + ".addLock: write locked by " + this._writeLock + " not " + fLock);
                        }
                        boolean bl = false;
                        // MONITOREXIT : vector
                        if (notifyMsg == null) return bl;
                        this.notify(notifyMsg);
                        return bl;
                    }
                    if (this._editLock != null) {
                        if (_debug) {
                            System.out.println(this.getName() + ".addLock: already have editLock " + this._editLock);
                        }
                        if (this._editLock.getUserId().equals(fLock.getUserId())) {
                            if (lockType == 4) {
                                notifyMsg = this.setLockedBy(fLock);
                                if (_debug) {
                                    System.out.println(this.getName() + ".addLock: user already has edit lock");
                                }
                                boolean bl = true;
                                // MONITOREXIT : vector
                                if (notifyMsg == null) return bl;
                                this.notify(notifyMsg);
                                return bl;
                            }
                            if (lockType != 6) {
                                this.addReadLock(fLock);
                                boolean bl = true;
                                // MONITOREXIT : vector
                                if (notifyMsg == null) return bl;
                                this.notify(notifyMsg);
                                return bl;
                            }
                            notifyMsg = this.setEditLockedBy(fLock);
                            if (_debug) {
                                System.out.println(this.getName() + ".addLock: added edit lock");
                            }
                            boolean bl = true;
                            // MONITOREXIT : vector
                            if (notifyMsg == null) return bl;
                            this.notify(notifyMsg);
                            return bl;
                        }
                        if (lockType == 6 || lockType == 4) {
                            if (_debug) {
                                System.out.println(this.getName() + ".addLock: edit locked by " + this._writeLock + " not " + fLock);
                            }
                            boolean bl = false;
                            // MONITOREXIT : vector
                            if (notifyMsg == null) return bl;
                            this.notify(notifyMsg);
                            return bl;
                        }
                        if (lockType == 4) {
                            if (_debug) {
                                System.out.println(this.getName() + ".addLock: edit locked by " + this._editLock + " not " + fLock);
                            }
                            boolean bl = false;
                            // MONITOREXIT : vector
                            if (notifyMsg == null) return bl;
                            this.notify(notifyMsg);
                            return bl;
                        }
                    }
                    size = this._readLockList.size();
                    if (_debug) {
                        System.out.println(this.getName() + ".addLock: have " + size + " read locks");
                    }
                    if (size == 0) {
                        if (lockType == 4) {
                            notifyMsg = this.setLockedBy(fLock);
                        } else if (lockType == 6) {
                            notifyMsg = this.setEditLockedBy(fLock);
                        } else {
                            this.addReadLock(fLock);
                        }
                        boolean bl = true;
                        // MONITOREXIT : vector
                        if (notifyMsg == null) return bl;
                        this.notify(notifyMsg);
                        return bl;
                    }
                    if (size == 1) {
                        fl = (FileLock)this._readLockList.get(0);
                        if (fl.getUserId().equals(fLock.getUserId())) {
                            if (_debug) {
                                System.out.println(this.getName() + ".addLock: user already has readLock");
                            }
                            if (lockType == 3) {
                                this.addReadLock(fLock);
                                if (_debug) {
                                    System.out.println(this.getName() + ".addLock: cnt=1 added read lock " + fLock);
                                }
                                boolean bl = true;
                                // MONITOREXIT : vector
                                if (notifyMsg == null) return bl;
                                this.notify(notifyMsg);
                                return bl;
                            }
                            if (lockType == 4) {
                                notifyMsg = this.setLockedBy(fLock);
                                if (_debug) {
                                    System.out.println(this.getName() + ".addLock: cnt=1 added Write lock " + fLock);
                                }
                                boolean bl = true;
                                // MONITOREXIT : vector
                                if (notifyMsg == null) return bl;
                                this.notify(notifyMsg);
                                return bl;
                            }
                            if (lockType == 6) {
                                notifyMsg = this.setEditLockedBy(fLock);
                                if (_debug) {
                                    System.out.println(this.getName() + ".addLock: cnt=1 added Edit lock " + fLock);
                                }
                                boolean bl = true;
                                // MONITOREXIT : vector
                                if (notifyMsg == null) return bl;
                                this.notify(notifyMsg);
                                return bl;
                            }
                        } else if (lockType == 4) {
                            if (_debug) {
                                System.out.println(this.getName() + ".addLock: have a read lock " + this._readLockList.get(0) + " can't grant write locks");
                            }
                            boolean bl = false;
                            // MONITOREXIT : vector
                            if (notifyMsg == null) return bl;
                            this.notify(notifyMsg);
                            return bl;
                        }
                    }
                    if (size > 1 && lockType == 4) {
                        if (_debug) {
                            System.out.println(this.getName() + ".addLock: have read locks can't grant write locks");
                        }
                        boolean bl = false;
                        // MONITOREXIT : vector
                        if (notifyMsg == null) return bl;
                        this.notify(notifyMsg);
                        return bl;
                    }
                    if (lockType != 3) break block67;
                    break block68;
                }
                if (lockType == 6) {
                    notifyMsg = this.setEditLockedBy(fLock);
                    if (_debug) {
                        System.out.println(this.getName() + size + ".addLock: added edit lock " + fLock);
                    }
                }
                break block69;
            }
            for (int i = 0; i < size; ++i) {
                fl = (FileLock)this._readLockList.get(i);
                if (!fl.getUserId().equals(fLock.getUserId())) continue;
                fl.incrementRefCount();
                if (_debug) {
                    System.out.println(this.getName() + ".addLock: user already has read lock");
                }
                boolean bl = true;
                // MONITOREXIT : vector
                if (notifyMsg == null) return bl;
                this.notify(notifyMsg);
                return bl;
            }
            this.addReadLock(fLock);
            if (_debug) {
                System.out.println(this.getName() + size + ".addLock: added read lock " + fLock);
            }
        }
        boolean bl = true;
        // MONITOREXIT : vector
        if (notifyMsg == null) return bl;
        this.notify(notifyMsg);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean unlock(FileLock fLock) {
        int size;
        String notifyMsg;
        boolean rv;
        block29: {
            rv = false;
            if (fLock == null) {
                return rv;
            }
            notifyMsg = null;
            Vector vector = this._readLockList;
            // MONITORENTER : vector
            if (_debug) {
                System.out.println(this.getName() + ".unlock trying " + fLock);
            }
            if ((size = this._readLockList.size()) != 0 || this._writeLock != null || this._editLock != null) break block29;
            if (_debug) {
                System.out.println(this.getName() + ".unlock: no locks to unlock");
            }
            boolean bl = rv;
            // MONITOREXIT : vector
            if (notifyMsg == null) return bl;
            this.notify(notifyMsg);
            return bl;
        }
        int lockType = fLock.getLockType();
        if (lockType == 2 || lockType == 5 || lockType == 7) {
            if (lockType == 2 || lockType == 5) {
                if (_debug) {
                    System.out.println(this.getName() + ".unlock: writeLock is " + this._writeLock);
                }
                if (this._writeLock != null) {
                    if (this._writeLock.getUserId().equals(fLock.getUserId())) {
                        notifyMsg = this.setLockedBy(fLock);
                        rv = true;
                    }
                    if (lockType == 5) {
                        boolean bl = rv;
                        // MONITOREXIT : vector
                        if (notifyMsg == null) return bl;
                        this.notify(notifyMsg);
                        return bl;
                    }
                }
            }
            if (lockType == 2 || lockType == 7) {
                if (_debug) {
                    System.out.println(this.getName() + ".unlock: editLock is " + this._editLock);
                }
                if (this._editLock != null) {
                    if (this._editLock.getUserId().equals(fLock.getUserId())) {
                        notifyMsg = this.setEditLockedBy(fLock);
                        rv = true;
                    }
                    if (lockType == 7) {
                        boolean bl = rv;
                        // MONITOREXIT : vector
                        if (notifyMsg == null) return bl;
                        this.notify(notifyMsg);
                        return bl;
                    }
                }
            }
        }
        try {
            int i = size - 1;
            while (true) {
                if (i < 0) {
                    // MONITOREXIT : vector
                    if (notifyMsg == null) return rv;
                    this.notify(notifyMsg);
                    return rv;
                }
                FileLock fl = (FileLock)this._readLockList.get(i);
                if (fl.getUserId().equals(fLock.getUserId())) {
                    if (fLock.getLockType() == 2) {
                        this._readLockList.remove(i);
                        rv = true;
                    } else {
                        fl.decrementRefCount();
                        if (fl.getRefCount() == 0) {
                            this._readLockList.remove(i);
                            rv = true;
                        }
                    }
                    if (_debug) {
                        System.out.println(this.getName() + ".unlock: removed " + fl + " locks left " + this._readLockList.size());
                    }
                }
                --i;
            }
        }
        catch (Throwable throwable) {
            if (notifyMsg == null) throw throwable;
            this.notify(notifyMsg);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getLocked(String userId) {
        if (userId == null) {
            return 0;
        }
        Vector vector = this._readLockList;
        synchronized (vector) {
            if (this._writeLock != null) {
                if (this._writeLock.getUserId().equals(userId)) {
                    return 4;
                }
                return 0;
            }
            if (this._editLock != null) {
                if (this._writeLock.getUserId().equals(userId)) {
                    return 6;
                }
                return 0;
            }
            int size = this._readLockList.size();
            for (int i = 0; i < size; ++i) {
                FileLock fl = (FileLock)this._readLockList.get(i);
                if (!fl.getUserId().equals(userId)) continue;
                return 3;
            }
        }
        return 0;
    }

    protected void addReadLock(FileLock fLock) {
        int size = this._readLockList.size();
        String userId = fLock.getUserId();
        for (int i = 0; i < size; ++i) {
            FileLock fl = (FileLock)this._readLockList.get(i);
            if (!fl.getUserId().equals(userId)) continue;
            fLock.incrementRefCount();
            if (_debug) {
                System.out.println(this.getName() + ".addReadLock: incremented read lock " + fLock);
            }
            return;
        }
        fLock.incrementRefCount();
        this._readLockList.add(fLock);
        if (_debug) {
            System.out.println(this.getName() + ".addReadLock: added read lock " + fLock);
        }
    }

    @Override
    public Vector getLockers() {
        Vector<FileLock> v = new Vector<FileLock>(this._readLockList.size() + 2);
        if (this._writeLock != null) {
            v.add(this._writeLock);
        }
        if (this._editLock != null) {
            v.add(this._editLock);
        }
        v.addAll(this._readLockList);
        if (_debug) {
            System.out.println(this.getName() + ".getLockers: returning " + v.size());
        }
        return v;
    }

    @Override
    public RmiFileSizeInfo getFileSizeInfo() {
        RmiFileSizeInfo info = new RmiFileSizeInfo();
        return this.getFileSizeInfo(info);
    }

    protected RmiFileSizeInfo getFileSizeInfo(RmiFileSizeInfo info) {
        info.lastModDate = this.lastModified();
        info.length = this.length();
        info.checkSum = this.getCheckSum();
        return info;
    }

    @Override
    public RmiFileInfo getFileInfo() {
        RmiFileInfo info = new RmiFileInfo();
        this.getFileSizeInfo((RmiFileSizeInfo)info);
        info.fileName = this.getFileName();
        info.lockedBy = this.getLockedBy();
        info.editLockedBy = this.getEditLockedBy();
        info.truePath = this.getTruePath();
        info.user = this.getUser();
        info.callbackCnt = this.getCallBackCount();
        info.refCount = this._refCount.size();
        Vector<String> v = new Vector<String>();
        for (int i = 0; i < this._callBackObjects.size(); ++i) {
            String s = this._callBackObjects.get(i).toString();
            int idx = s.indexOf("endpoint:[");
            if (idx > -1) {
                int idx2 = s.indexOf("]", idx);
                if (idx2 > -1) {
                    s = s.substring(idx + 10, idx2);
                    v.add(s);
                    continue;
                }
                v.add(s);
                continue;
            }
            v.add(s);
        }
        info.callbacks = v;
        info.referenceUsers = (Vector)this._refCount.clone();
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] unzip(byte[] zipped) {
        if (zipped == null || zipped.length == 0) {
            return zipped;
        }
        byte[] byArray = _unzippedByteArray;
        synchronized (_unzippedByteArray) {
            Inflater _inflater = new Inflater();
            _inflater.setInput(zipped);
            int totalOut = 0;
            try {
                totalOut = _inflater.inflate(_unzippedByteArray);
            }
            catch (DataFormatException dfe) {
                System.out.println("unzip: error unzipping: " + dfe);
                _inflater.end();
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            _inflater.end();
            byte[] newUnZipped = new byte[totalOut];
            System.arraycopy(_unzippedByteArray, 0, newUnZipped, 0, totalOut);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return newUnZipped;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected byte[] zip(byte[] unzipped) {
        if (unzipped == null || unzipped.length == 0) {
            return unzipped;
        }
        Deflater _deflater = new Deflater(1);
        _deflater.setInput(unzipped);
        _deflater.finish();
        byte[] byArray = _zippedByteArray;
        synchronized (_zippedByteArray) {
            int deflateCnt = _deflater.deflate(_zippedByteArray);
            byte[] actualDeflated = new byte[deflateCnt];
            System.arraycopy(_zippedByteArray, 0, actualDeflated, 0, deflateCnt);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            _deflater.end();
            return actualDeflated;
        }
    }

    @Override
    public void writeFloat(long bytePos, float f) throws IOException {
        String tmpFileName;
        File tmpFile;
        if (this._writeToTmp && (tmpFile = new File(tmpFileName = this.getPath() + TMP_EXTENSION)).exists()) {
            throw new IllegalStateException("Unable to write to this file because a Stream is currently writing.");
        }
        RandomAccessFile raFile = new RandomAccessFile(this, "rw");
        raFile.seek(bytePos);
        raFile.writeFloat(f);
    }

    @Override
    public void writeBytes(long bytePos, byte[] bytes) throws IOException {
        String tmpFileName;
        File tmpFile;
        if (this._writeToTmp && (tmpFile = new File(tmpFileName = this.getPath() + TMP_EXTENSION)).exists()) {
            throw new IllegalStateException("Unable to write to this file because a Stream is currently writing.");
        }
        RandomAccessFile raFile = new RandomAccessFile(this, "rw");
        raFile.seek(bytePos);
        raFile.write(bytes, 0, bytes.length);
    }

    private String getUserId(FileLock fLock) {
        if (fLock == null) {
            return System.getProperty("user.name");
        }
        return fLock.getUserId();
    }

    public void fileChanged(File file) {
        this.notify("Modified");
    }

    public void setNetworked(boolean networked) {
        this._networked = networked;
    }

    static {
        _unzippedByteArray = new byte[32768];
        _zippedByteArray = new byte[32768];
        String createBackups = System.getProperty(CREATEBAK_PROP, "true");
        _createBackups = Boolean.valueOf(createBackups);
        String writeToTmp = System.getProperty(CREATETMP_PROP, "true");
        _writeToTmpDefault = Boolean.valueOf(writeToTmp);
        _socketFactory = RmiFileSocketFactory.getInstance();
        if (!_writeToTmpDefault) {
            _createBackups = false;
        }
        if (!_createBackups) {
            System.out.println("RmiFile: not creating backups");
        }
        _debug = Boolean.getBoolean("hec.io.FileLock.debug");
    }

    public class Notifier
    implements Runnable {
        private String _msg;
        private Vector<RmiFileCallBack> _callbacks;

        public Notifier(String message, Vector<RmiFileCallBack> callBackObjects) {
            this._msg = message;
            this._callbacks = callBackObjects;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (_debug) {
                System.out.println("Notifier.run:msg=" + this._msg);
            }
            if (_debug) {
                System.out.println(RmiFileImpl.this.getPath() + " Notifier.run:have " + this._callbacks.size() + " to notify");
            }
            Vector<RmiFileCallBack> vector = this._callbacks;
            synchronized (vector) {
                Iterator<RmiFileCallBack> iter = this._callbacks.iterator();
                while (iter.hasNext()) {
                    RmiFileCallBack callBack = iter.next();
                    try {
                        callBack.notify(this._msg);
                    }
                    catch (ConnectException ce) {
                        if (_debug) {
                            System.out.println(RmiFileImpl.this.getPath() + " RMI connect error with rmi file call back  " + ce);
                            ce.printStackTrace(System.out);
                        }
                        iter.remove();
                    }
                    catch (RemoteException re) {
                        System.out.println(RmiFileImpl.this.getPath() + " RMI Error with rmi file call back  " + re);
                        if (_debug) {
                            re.printStackTrace(System.out);
                        }
                        iter.remove();
                    }
                    catch (NoSuchObjectException nse) {
                        iter.remove();
                    }
                    catch (Exception e) {
                        System.out.println(RmiFileImpl.this.getPath() + " Error with rmi file call back " + e);
                        if (_debug) {
                            e.printStackTrace(System.out);
                        }
                        iter.remove();
                    }
                }
            }
            if (_debug) {
                System.out.println("Notifier.run:done. msg=" + this._msg);
            }
        }
    }
}

