/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.server;

import com.google.common.flogger.FluentLogger;
import com.google.common.flogger.LazyArgs;
import hec.io.FileLock;
import hec.io.FileLockInfo;
import hec.io.FileOffsetError;
import hec.io.FileOffsets;
import hec.io.HecFile;
import hec.io.Identifier;
import hec.io.StatusObject;
import hec.model.FileChangeInfo;
import hec.server.ServerFileListener;
import hec.server.TimeWindowFileReader;
import hec.util.FileUtilities;
import hec.util.ZipUtility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import mil.army.usace.hec.rmi.admin.FileManagerStatus;
import mil.army.usace.hec.rmi.csinterface.RmiFile;
import mil.army.usace.hec.rmi.csinterface.RmiFileManager;
import mil.army.usace.hec.rmi.csinterface.RmiLoginListener;
import mil.army.usace.hec.rmi.io.HecFileImpl;
import mil.army.usace.hec.rmi.io.dbf.DbfFile;
import mil.army.usace.hec.rmi.io.dbf.DbfIdentifier;
import mil.army.usace.hec.rmi.proxy.LogProxy;
import mil.army.usace.hec.rmi.proxy.NotifyUserProxy;
import mil.army.usace.hec.rmi.proxy.ReconnectProxy;
import mil.army.usace.hec.rmi.server.RemoteWrapper;
import mil.army.usace.hec.rmi.server.RmiFileImpl;
import mil.army.usace.hec.rmi.server.StatusReportingServer;
import rma.util.RMAIO;
import rma.util.WildCardFileFilter;
import rma.util.logging.MarkingClassLogger;
import rma.util.logging.marking.FileLockingLoggingMarker;

public class RmiFileManagerImpl
extends StatusReportingServer
implements RmiFileManager {
    private static final MarkingClassLogger FILE_LOCKING_LOGGER = MarkingClassLogger.forMarkingClass(FileLockingLoggingMarker.class);
    private static final MarkingClassLogger STATUS_REPORTING_LOGGER = MarkingClassLogger.forMarkingClass(StatusReportingServer.class);
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    public static String sep = "/";
    public static String abs = ":";
    public static String ext = ".";
    protected static Hashtable _fileWrappers = new Hashtable();
    protected String _workingDirectory = "";
    private Identifier _myId = new Identifier("FileManager.state");
    transient String _rmiObjName = "FileManager";
    transient ServerFileListener _fileListener = new ServerFileListener();

    public RmiFileManagerImpl(int port) throws RemoteException {
        super(port);
        this.setName(this._rmiObjName);
        ((FluentLogger.Api)LOGGER.atFine()).log("Starting RmiFileManager()");
    }

    @Override
    protected MarkingClassLogger getStatusLogger() {
        return STATUS_REPORTING_LOGGER;
    }

    public RmiFileManagerImpl() throws RemoteException {
        this(8089);
    }

    @Override
    public Identifier openFile(String user, Identifier openFileId) throws RemoteException {
        return this.openFile(openFileId, new FileLock(user, 0));
    }

    @Override
    public Identifier openAndLockFile(Identifier openFileId, FileLock flock) throws RemoteException {
        return this.openFile(openFileId, flock);
    }

    private synchronized Identifier openFile(Identifier openFileId, FileLock fLock) throws RemoteException {
        if (fLock == null) {
            return null;
        }
        String user = fLock.getUserId();
        if (openFileId == null) {
            return null;
        }
        String relativePath = openFileId.getPath();
        String truePath = this.processPath(relativePath);
        if (truePath == null) {
            return null;
        }
        File checkFile = new File(truePath);
        if (!checkFile.canRead()) {
            return null;
        }
        Identifier idToReturn = openFileId instanceof DbfIdentifier ? new DbfIdentifier((DbfIdentifier)openFileId) : new Identifier(openFileId);
        RemoteWrapper openWrapper = this.findFileWrapper(truePath);
        if (openWrapper == null) {
            openWrapper = new RemoteWrapper();
            this.buildFileWrapper(openWrapper, user, openFileId, truePath, relativePath);
            this.putFileWrapper(truePath, openWrapper);
            this.addRemoteWrapper(openWrapper);
        } else if (fLock.getLockType() != 0 && !this.changeLockStatus(openFileId, fLock)) {
            return null;
        }
        File file = new File(truePath);
        idToReturn.initToFile(file);
        this.setFile(idToReturn, openWrapper, user);
        Remote remoteRef = openWrapper.getRemote();
        if (remoteRef instanceof RmiFile) {
            RmiFile fileInterface = (RmiFile)remoteRef;
            try {
                fileInterface.addRefCount(user);
            }
            catch (RemoteException e) {
                ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("openFile:RemoteException");
            }
        } else {
            ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atInfo()).log("%s remoteRef is a %s", (Object)truePath, (Object)remoteRef);
        }
        return idToReturn;
    }

    @Override
    public synchronized Identifier newFile(String user, Identifier newFileId) throws RemoteException {
        String relativePath = newFileId.getPath();
        String truePath = this.processPath(relativePath);
        if (truePath == null) {
            return null;
        }
        File checkFile = new File(truePath);
        if (checkFile.exists()) {
            return null;
        }
        boolean isDirectory = newFileId._directory;
        this.checkFile(isDirectory, truePath);
        Identifier idToReturn = newFileId instanceof DbfIdentifier ? new DbfIdentifier((DbfIdentifier)newFileId) : new Identifier(newFileId);
        File file = new File(truePath);
        idToReturn.initToFile(file);
        RemoteWrapper fileWrapper = this.findFileWrapper(truePath);
        if (fileWrapper == null) {
            RemoteWrapper newFileWrapper = new RemoteWrapper();
            this.buildFileWrapper(newFileWrapper, user, newFileId, truePath, relativePath);
            ((RmiFile)newFileWrapper.getRemote()).addRefCount(user);
            this.putFileWrapper(truePath, newFileWrapper);
            this.addRemoteWrapper(newFileWrapper);
            this.setFile(idToReturn, newFileWrapper, user);
        } else {
            this.setFile(idToReturn, fileWrapper, user);
            ((RmiFile)fileWrapper.getRemote()).addRefCount(user);
        }
        return idToReturn;
    }

    private void setFile(Identifier idToReturn, RemoteWrapper fileWrapper, String clientUserId) {
        if (idToReturn == null || fileWrapper == null) {
            return;
        }
        if (idToReturn instanceof DbfIdentifier) {
            idToReturn.setFile((HecFile)new DbfFile(fileWrapper, clientUserId));
        } else {
            idToReturn.setFile((HecFile)new HecFileImpl(fileWrapper, clientUserId));
        }
    }

    @Override
    @Deprecated
    public String[] list(String dirName) throws RemoteException {
        String truePath = this.processPath(dirName);
        if (truePath == null) {
            return null;
        }
        File dir = new File(truePath);
        if (dir.isDirectory()) {
            return dir.list();
        }
        return null;
    }

    @Override
    @Deprecated
    public String[] list(String dirName, String stringFilter) throws RemoteException {
        String truePath = this.processPath(dirName);
        if (truePath == null) {
            return null;
        }
        WildCardFileFilter filter = new WildCardFileFilter(stringFilter);
        filter.setAcceptDirectories(false);
        File dir = new File(truePath);
        if (dir.isDirectory()) {
            return dir.list((FilenameFilter)filter);
        }
        return null;
    }

    @Override
    public synchronized Vector<Identifier> getRemoteFileIDList(String user, String dirName, Vector filtersList) throws RemoteException {
        Vector<Identifier> vectorList = new Vector<Identifier>();
        if (filtersList == null) {
            return vectorList;
        }
        int size = filtersList.size();
        for (int i = 0; i < size; ++i) {
            Object filter = filtersList.get(i);
            if (filter == null) continue;
            vectorList.addAll(this.getRemoteFileIDList(user, dirName, filter.toString()));
        }
        vectorList.trimToSize();
        return vectorList;
    }

    @Override
    public synchronized Vector<Identifier> getRemoteFileIDList(String user, String dirName, Vector filtersList, boolean recurse) throws RemoteException {
        Vector<Identifier> vectorList = new Vector<Identifier>();
        if (filtersList == null || filtersList.isEmpty()) {
            String filter = null;
            vectorList.addAll(this.getRemoteFileIDList(user, dirName, filter, recurse));
        } else {
            int size = filtersList.size();
            for (int i = 0; i < size; ++i) {
                Object filter = filtersList.get(i);
                if (filter == null) continue;
                vectorList.addAll(this.getRemoteFileIDList(user, dirName, filter.toString(), recurse));
            }
        }
        vectorList.trimToSize();
        return vectorList;
    }

    @Override
    public Vector<Identifier> getRemoteFileIDList(String user, String dirName, String stringFilter) throws RemoteException {
        File dir;
        String truePath = this.processPath(dirName);
        Vector<Identifier> vectorList = new Vector<Identifier>();
        if (truePath == null) {
            return vectorList;
        }
        WildCardFileFilter filter = null;
        if (stringFilter != null) {
            filter = new WildCardFileFilter(stringFilter);
        }
        if ((dir = new File(truePath)) == null) {
            return vectorList;
        }
        if (dir.isDirectory()) {
            String[] stringList = null;
            stringList = filter == null ? dir.list() : dir.list((FilenameFilter)filter);
            if (stringList == null) {
                return vectorList;
            }
            vectorList.ensureCapacity(stringList.length);
            if (truePath.endsWith(sep)) {
                truePath = truePath.substring(0, truePath.length() - 1);
            }
            for (int ii = 0; ii < stringList.length; ++ii) {
                String fileRelativePath = truePath + sep + stringList[ii];
                Identifier pathId = new Identifier(fileRelativePath);
                pathId.setName(stringList[ii]);
                File file = new File(fileRelativePath);
                pathId.initToFile(file);
                vectorList.addElement(pathId);
            }
        }
        vectorList.trimToSize();
        return vectorList;
    }

    public Vector<Identifier> getRemoteFileIDList(String user, String dirName, String stringFilter, boolean recurse) throws RemoteException {
        File dir;
        String truePath = this.processPath(dirName);
        Vector<Identifier> vectorList = new Vector<Identifier>();
        if (truePath == null) {
            return vectorList;
        }
        WildCardFileFilter filter = null;
        if (stringFilter != null) {
            filter = new WildCardFileFilter(stringFilter);
        }
        if ((dir = new File(truePath)) == null) {
            return vectorList;
        }
        if (dir.isDirectory()) {
            String[] stringList = filter == null ? dir.list() : dir.list((FilenameFilter)filter);
            if (stringList == null) {
                return vectorList;
            }
            vectorList.ensureCapacity(stringList.length);
            if (truePath.endsWith(sep)) {
                truePath = truePath.substring(0, truePath.length() - 1);
            }
            for (int ii = 0; ii < stringList.length; ++ii) {
                String fileRelativePath = truePath + sep + stringList[ii];
                Identifier pathId = new Identifier(fileRelativePath);
                pathId.setName(stringList[ii]);
                File file = new File(fileRelativePath);
                pathId.initToFile(file);
                vectorList.addElement(pathId);
                if (!recurse || !pathId.isDirectory()) continue;
                Vector<Identifier> remoteFileIDList = this.getRemoteFileIDList(user, fileRelativePath, stringFilter, recurse);
                vectorList.addAll(remoteFileIDList);
            }
        }
        vectorList.trimToSize();
        return vectorList;
    }

    @Override
    public byte[] getCompressedFileNamesAndInfo(String user, String baseDir, String[] exclusionExtensions) throws RemoteException {
        String[] names = this.getFileNamesInfo(user, baseDir, exclusionExtensions);
        if (names == null || names.length == 0) {
            return null;
        }
        int size = 1000;
        if (names.length > 2 && (size = names.length * (names[0].length() + names[1].length())) < 1000) {
            size = 1000;
        }
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < names.length; ++i) {
            sb.append(names[i]);
            sb.append("\n");
        }
        byte[] compressedNames = ZipUtility.zip((byte[])sb.toString().getBytes());
        return compressedNames;
    }

    protected String[] getFileNamesInfo(String user, String baseDir, String[] exclusionExtensions) {
        File file = new File(baseDir);
        if (file == null) {
            return null;
        }
        baseDir = file.getAbsolutePath();
        Vector files = FileUtilities.listAllFiles((File)file);
        Vector<CallSite> names = new Vector<CallSite>();
        for (int i = 0; i < files.size(); ++i) {
            file = (File)files.elementAt(i);
            if (!file.isFile()) continue;
            String name = file.getAbsolutePath();
            boolean exclusionFile = false;
            for (int j = 0; j < exclusionExtensions.length; ++j) {
                if (!name.endsWith(exclusionExtensions[j])) continue;
                exclusionFile = true;
                break;
            }
            if (exclusionFile) continue;
            long time = file.lastModified();
            long size = file.length();
            if (name.startsWith(baseDir)) {
                name = baseDir.length() < name.length() ? name.substring(baseDir.length() + 1) : "";
            }
            String result = time + " " + size + " " + name;
            names.add((CallSite)((Object)result));
        }
        return names.toArray(new String[0]);
    }

    @Override
    public String[] getAllFileNames(String user, String baseDir) {
        File file = new File(baseDir);
        if (file == null) {
            return null;
        }
        baseDir = file.getAbsolutePath();
        Vector files = FileUtilities.listAllFiles((File)file);
        Vector<String> names = new Vector<String>();
        for (int i = 0; i < files.size(); ++i) {
            file = (File)files.elementAt(i);
            String name = file.getAbsolutePath();
            names.add(name);
        }
        return names.toArray(new String[0]);
    }

    @Override
    public Vector<Identifier> getRemoteDriveIDList(String user) throws RemoteException {
        Vector<Identifier> driveList = new Vector<Identifier>();
        File[] rootList = File.listRoots();
        for (int i = 0; i < rootList.length; ++i) {
            Identifier pathId = new Identifier(rootList[i].getPath());
            driveList.addElement(pathId);
        }
        driveList.trimToSize();
        return driveList;
    }

    @Override
    public Vector getLockers(Identifier lockFileId) throws RemoteException {
        String relativePath = lockFileId.getPath();
        relativePath = relativePath.replace('\\', '/');
        String truePath = this.processPath(relativePath);
        ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atFine()).log("Getting lockers for %s", (Object)truePath);
        if (truePath == null) {
            return null;
        }
        RmiFileImpl fileInterface = this.findFileInterface(truePath);
        if (fileInterface == null) {
            ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atFine()).log("failed to find fileInterface for %s", (Object)truePath);
            return null;
        }
        return fileInterface.getLockers();
    }

    @Override
    public String getEditLockedBy(Identifier lockFileId) throws RemoteException {
        if (lockFileId == null) {
            return "";
        }
        String relativePath = lockFileId.getPath();
        String truePath = this.processPath(relativePath);
        ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atFine()).log("Checking edit locked status on %s", (Object)truePath);
        if (truePath == null) {
            return null;
        }
        RmiFileImpl fileInterface = this.findFileInterface(truePath);
        if (fileInterface == null) {
            return null;
        }
        String lockedBy = fileInterface.getEditLockedBy();
        ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atFine()).log("%s is edit locked by %s", (Object)truePath, (Object)lockedBy);
        return lockedBy;
    }

    @Override
    public List getLockedFiles(int lockType) {
        ArrayList<FileLockInfo> lockedFiles = new ArrayList<FileLockInfo>();
        if (lockType != 6 && lockType != 4) {
            return lockedFiles;
        }
        Enumeration e = _fileWrappers.elements();
        String lockedBy = null;
        while (e.hasMoreElements()) {
            Object remoteObj;
            RemoteWrapper openWrapper = (RemoteWrapper)e.nextElement();
            if (openWrapper == null || !((remoteObj = this.networked ? openWrapper.getObject() : openWrapper.getRemote()) instanceof RmiFileImpl)) continue;
            RmiFileImpl fileImpl = (RmiFileImpl)remoteObj;
            if (lockType == 6) {
                lockedBy = fileImpl.getEditLockedBy();
            } else if (lockType == 4) {
                lockedBy = fileImpl.getLockedBy();
            }
            if (lockedBy == null || lockedBy.length() == 0) continue;
            FileLockInfo lockInfo = new FileLockInfo(fileImpl.getPath(), lockedBy);
            lockedFiles.add(lockInfo);
        }
        return lockedFiles;
    }

    @Override
    public String getLockedBy(Identifier lockFileId) throws RemoteException {
        if (lockFileId == null) {
            return "";
        }
        String relativePath = lockFileId.getPath();
        String truePath = this.processPath(relativePath);
        ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atFine()).log("Checking locked status on %s", (Object)truePath);
        if (truePath == null) {
            return null;
        }
        RmiFileImpl fileInterface = this.findFileInterface(truePath);
        if (fileInterface == null) {
            return null;
        }
        String lockedBy = fileInterface.getLockedBy();
        ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atFine()).log("%s is edit locked by %s", (Object)truePath, (Object)lockedBy);
        return lockedBy;
    }

    @Override
    public Vector<RemoteWrapper> getRemoteObjects() throws RemoteException {
        return this._remoteObjects;
    }

    @Override
    public boolean removeReference(Identifier id, String userId) {
        RmiFileImpl fileImpl;
        if (id == null || userId == null) {
            return false;
        }
        String truepath = this.processPath(id.getPath());
        RemoteWrapper wrapper = this.findFileWrapper(truepath);
        if (wrapper == null) {
            return false;
        }
        Object remoteObj = this.networked ? wrapper.getObject() : wrapper.getRemote();
        if (remoteObj instanceof RmiFileImpl && (fileImpl = (RmiFileImpl)remoteObj).refCount() == 0) {
            fileImpl.unreferenced();
            ((FluentLogger.Api)LOGGER.atFiner()).log("removeReference: removed %s from list of open files", (Object)truepath);
            this._remoteObjects.remove(wrapper);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlockAll(String userId) throws RemoteException {
        RmiFileImpl fileInterface;
        if (userId == null || userId.equals("")) {
            return;
        }
        this._fileListener.clearAllListenersForUser(userId);
        boolean refCntEmpty = false;
        ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atFine()).log("Unlocking all for %s", (Object)userId);
        FileLock fLock = new FileLock(userId, 2);
        Enumeration e = _fileWrappers.elements();
        while (e.hasMoreElements()) {
            Object remoteObj;
            RemoteWrapper openWrapper = (RemoteWrapper)e.nextElement();
            if (openWrapper == null || !((remoteObj = this.networked ? openWrapper.getObject() : openWrapper.getRemote()) instanceof RmiFileImpl)) continue;
            fileInterface = (RmiFileImpl)remoteObj;
            refCntEmpty = fileInterface.removeRefCount(userId);
            String lockedBy = fileInterface.getLockedBy();
            if (fileInterface == null || !fileInterface.unlock(fLock)) continue;
            ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atFine()).log("unlocking file %s for user %s", (Object)fileInterface.getRelativePath(), (Object)userId);
        }
        int removeCnt = 0;
        ArrayList<RmiFileImpl> unreferencedFiles = new ArrayList<RmiFileImpl>();
        Hashtable hashtable = _fileWrappers;
        synchronized (hashtable) {
            Set s = _fileWrappers.entrySet();
            Iterator i = s.iterator();
            while (i.hasNext()) {
                Object remoteObj;
                RemoteWrapper openWrapper;
                Map.Entry entry = i.next();
                if (entry == null || (openWrapper = (RemoteWrapper)entry.getValue()) == null || !((remoteObj = this.networked ? openWrapper.getObject() : openWrapper.getRemote()) instanceof RmiFileImpl) || (fileInterface = (RmiFileImpl)remoteObj) == null || fileInterface.refCount() != 0) continue;
                i.remove();
                ++removeCnt;
                unreferencedFiles.add(fileInterface);
                this._remoteObjects.remove(openWrapper);
            }
        }
        for (int u = 0; u < unreferencedFiles.size(); ++u) {
            ((RmiFileImpl)unreferencedFiles.get(u)).unreferenced();
        }
        ((FluentLogger.Api)LOGGER.atFine()).log("unlockAll:Removed %d files for %s", removeCnt, (Object)userId);
        this.runGC();
    }

    private void runGC() {
        Thread t = new Thread(){

            @Override
            public void run() {
                System.gc();
                System.gc();
            }
        };
        t.setPriority(4);
        t.start();
    }

    @Override
    public boolean lockFile(Identifier lockFileId, FileLock fLock) throws RemoteException {
        return this.changeLockStatus(lockFileId, fLock);
    }

    @Override
    public boolean unlockFile(Identifier unlockFileId, FileLock fLock) throws RemoteException {
        return this.changeLockStatus(unlockFileId, fLock);
    }

    @Override
    public int getLocked(String userId, Identifier fileId) throws RemoteException {
        if (fileId == null || userId == null) {
            return 0;
        }
        String relativePath = fileId.getPath();
        String truePath = this.processPath(relativePath);
        if (truePath == null) {
            return 0;
        }
        RmiFileImpl fileInterface = this.findFileInterface(truePath);
        if (fileInterface == null) {
            ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atInfo()).log("Didn't find existing fileInterface for %s", (Object)truePath);
            return 0;
        }
        return fileInterface.getLocked(userId);
    }

    @Override
    public boolean removeFile(String userId, Identifier removeFileId) throws RemoteException {
        String lockedBy = this.getLockedBy(removeFileId);
        if (lockedBy != null && lockedBy.length() > 1 && !lockedBy.equals(userId)) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("removeFile(): file %s is currently locked by %s", (Object)removeFileId.getPath(), (Object)lockedBy);
            return false;
        }
        String relativePath = removeFileId.getPath();
        String truePath = this.processPath(relativePath);
        if (truePath == null) {
            return false;
        }
        RemoteWrapper wrapper = this.findFileWrapper(truePath);
        if (wrapper == null) {
            ((FluentLogger.Api)LOGGER.atFine()).log("removeFile(): Didn't find existing remotewrapper for %s", (Object)truePath);
            return false;
        }
        RmiFile fileInterface = (RmiFile)wrapper.getRemote();
        Vector refCnt = fileInterface.getRefCount();
        if (refCnt != null && !refCnt.isEmpty()) {
            ((FluentLogger.Api)LOGGER.atFine()).log("removeFile(): %s still has reference to it", (Object)truePath);
            return false;
        }
        _fileWrappers.remove(truePath);
        if (fileInterface instanceof RmiFileImpl) {
            ((RmiFileImpl)fileInterface).unreferenced();
        }
        return true;
    }

    private synchronized boolean changeLockStatus(Identifier fileId, FileLock flock) throws RemoteException {
        if (fileId == null || flock == null) {
            return false;
        }
        String relativePath = fileId.getPath();
        if (relativePath == null) {
            return false;
        }
        relativePath = relativePath.replace('\\', '/');
        String truePath = this.processPath(relativePath);
        ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atFine()).log("request %s for %s", (Object)flock, (Object)LazyArgs.lazy(() -> fileId.getPath()));
        if (truePath == null) {
            return false;
        }
        RmiFileImpl fileInterface = this.findFileInterface(truePath);
        int lockType = flock.getLockType();
        if (fileInterface == null && (lockType == 3 || lockType == 4 || lockType == 6)) {
            if (this.openFile(flock.getUserId(), fileId) == null) {
                ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atWarning()).log("Failed to find existing file for %s, Lock failed for %s", (Object)truePath, (Object)flock);
                return false;
            }
            fileInterface = this.findFileInterface(truePath);
            if (fileInterface == null) {
                ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atWarning()).log("Didn't find existing FileInterface for %s, Lock failed for %s", (Object)truePath, (Object)flock);
                return false;
            }
        } else if (fileInterface == null) {
            ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atInfo()).log("Didn't find existing fileInterface for %s, Unlock failed for %s", (Object)truePath, (Object)flock);
            return false;
        }
        if (FileLock.isUnlockType((int)lockType)) {
            fileInterface.unlock(flock);
            return true;
        }
        if (fileInterface.addLock(flock)) {
            ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atFine()).log("%s lock granted for %s", (Object)fileInterface.getName(), (Object)flock);
            return true;
        }
        this.saveState(this._myId);
        String lockersInfo = RmiFileManagerImpl.getLockersInfo(fileInterface);
        ((MarkingClassLogger.Api)FILE_LOCKING_LOGGER.atWarning()).log("%s lock denied for %s, %s locked info:\n%s", (Object)fileInterface.getName(), (Object)flock, (Object)fileInterface.getName(), (Object)lockersInfo);
        return false;
    }

    private static String getLockersInfo(RmiFileImpl fileInterface) {
        StringBuilder sb = new StringBuilder();
        Vector lockers = fileInterface.getLockers();
        if (lockers != null) {
            for (int i = 0; i < lockers.size(); ++i) {
                sb.append("\t:").append(lockers.get(i)).append("\n");
            }
        }
        return sb.toString();
    }

    protected String processPath(String relativePath) {
        if (relativePath == null || relativePath.length() < 1) {
            return null;
        }
        Object truePath = null;
        relativePath = RMAIO.parsePathName((String)relativePath);
        if ((relativePath = relativePath.replace('\\', "/".charAt(0))).substring(0, 1).equals(abs)) {
            String clip = System.getProperty("user.dir");
            int skip = abs.length() + clip.length();
            truePath = relativePath.substring(skip);
        } else {
            truePath = relativePath.substring(0, 1).equals(sep) ? relativePath : relativePath;
        }
        if (Character.isLetter(((String)truePath).charAt(0))) {
            String s = ((String)truePath).substring(0, 1).toUpperCase();
            truePath = s + ((String)truePath).substring(1);
        }
        return truePath;
    }

    protected synchronized void checkFile(boolean isDirectory, String fileName) {
        fileName = RMAIO.replace((String)fileName, (String)"//", (String)"/");
        StringTokenizer st = new StringTokenizer(fileName);
        Object path = "";
        if (fileName.charAt(0) == "/".charAt(0)) {
            path = "/";
        }
        while (st.hasMoreTokens()) {
            File file = new File((String)(path = (String)path + st.nextToken(sep)));
            if (file.isFile()) {
                return;
            }
            if (!file.exists()) {
                if (((String)path).equals(fileName)) {
                    if (isDirectory) {
                        file.mkdir();
                    }
                    return;
                }
                file.mkdir();
            }
            path = (String)path + sep;
        }
    }

    protected synchronized void buildFileWrapper(RemoteWrapper fileWrapper, String user, Identifier id, String truePath, String relativePath) {
        try {
            String extension = RMAIO.getFileExtension((String)relativePath);
            Object[] args = new String[]{user, truePath, relativePath};
            Object obj = Identifier.instantiateRmiFile((Identifier)id, (String)extension, (Object[])args);
            if (obj instanceof RmiFileImpl) {
                RmiFileImpl file = (RmiFileImpl)obj;
                file.setNetworked(this.getNetworked());
                fileWrapper.setRemote(file);
                fileWrapper.setBindPort(0);
                fileWrapper.setName(file.getRelativePath());
            }
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("Error building file wrapper for %s %s", (Object)truePath, (Object)relativePath);
        }
    }

    @Override
    public boolean copyFile(Identifier oldPath, Identifier newPath) throws RemoteException {
        if (oldPath == null || newPath == null) {
            return false;
        }
        return this.copyFile(oldPath.getPath(), newPath.getPath(), newPath._directory);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean copyFile(String oldPath, String newPath, boolean isDirectory) {
        File src = new File(oldPath);
        File dest = new File(newPath);
        if (src.equals(dest)) {
            return true;
        }
        try {
            FileInputStream fis = new FileInputStream(oldPath);
            try (BufferedInputStream in = new BufferedInputStream(fis);){
                try {
                    this.checkFile(isDirectory, newPath);
                    try (FileOutputStream fos = new FileOutputStream(newPath);
                         BufferedOutputStream out = new BufferedOutputStream(fos);){
                        int len = 1024;
                        byte[] b = new byte[len];
                        int ibytes = in.read(b, 0, len);
                        while (ibytes > -1) {
                            out.write(b, 0, ibytes);
                            ibytes = in.read(b, 0, len);
                        }
                        out.flush();
                        return true;
                    }
                }
                catch (IOException eio) {
                    ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)eio)).log("copyFile: IOException copying file %s to %s", (Object)oldPath, (Object)newPath);
                    boolean bl = false;
                    in.close();
                    fis.close();
                    return bl;
                }
            }
            finally {
                try {
                    fis.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (FileNotFoundException e) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("copyFile: source file not found %s. Error:%s", (Object)oldPath, (Object)e);
            return false;
        }
        catch (IOException eio) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("copyFile: IOException copying file %s to %s. Error:%s", (Object)oldPath, (Object)newPath, (Object)eio);
            return false;
        }
    }

    @Override
    public boolean copyDirectory(Identifier srcId, Identifier destId) {
        return this.copyDirectory(srcId, destId, true);
    }

    @Override
    public boolean copyDirectory(Identifier srcId, Identifier destId, boolean recurse) {
        if (srcId == null || destId == null) {
            return false;
        }
        File srcDir = new File(srcId.getPath());
        if (!srcDir.isDirectory()) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("copyDirectory: src dir %s isn't a directory", (Object)srcDir.getAbsolutePath());
            return false;
        }
        File destDir = new File(destId.getPath());
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        if (!destDir.isDirectory()) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("copyDirectory: dest dir %s isn't a directory", (Object)destDir.getAbsolutePath());
            return false;
        }
        return this.copyDirectory(srcDir, destDir, recurse);
    }

    @Override
    public int copyDirectory(Identifier srcId, Identifier destId, String[] filters) {
        if (srcId == null || destId == null || filters == null) {
            return -1;
        }
        File srcDir = new File(srcId.getPath());
        if (!srcDir.isDirectory()) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("copyDirectory: src dir %s isn't a directory", (Object)srcDir.getAbsolutePath());
            return -2;
        }
        File destDir = new File(destId.getPath());
        if (!destDir.exists()) {
            destDir.mkdirs();
        }
        if (!destDir.isDirectory()) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("copyDirectory: dest dir %s isn't a directory", (Object)destDir.getAbsolutePath());
            return -3;
        }
        int cnt = 0;
        for (int i = 0; i < filters.length; ++i) {
            cnt += this.copyDirectory(srcDir, destDir, filters[i]);
        }
        return cnt;
    }

    private boolean copyDirectory(File srcDir, File destDir, boolean recurse) {
        File[] srcFiles = srcDir.listFiles();
        if (srcFiles == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("copyDirectory: src dir %s is empty", (Object)srcDir.getAbsolutePath());
            return true;
        }
        for (int i = 0; i < srcFiles.length; ++i) {
            String fileName = srcFiles[i].getName();
            File newDest = new File(destDir, fileName);
            if (srcFiles[i].isDirectory()) {
                if (!recurse) continue;
                newDest.mkdirs();
                if (this.copyDirectory(srcFiles[i], newDest, recurse)) continue;
                return false;
            }
            if (this.copyFile(srcFiles[i].getAbsolutePath(), newDest.getAbsolutePath(), false)) continue;
            return false;
        }
        return true;
    }

    private int copyDirectory(File srcDir, File destDir, String filter) {
        File[] srcFiles = srcDir.listFiles((FilenameFilter)new WildCardFileFilter(filter));
        if (srcFiles == null) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("copyDirectory: src dir %s is empty", (Object)srcDir.getAbsolutePath());
            return 0;
        }
        int cnt = 0;
        for (int i = 0; i < srcFiles.length; ++i) {
            String fileName = srcFiles[i].getName();
            File newDest = new File(destDir, fileName);
            if (srcFiles[i].isDirectory()) {
                newDest.mkdirs();
                return cnt += this.copyDirectory(srcFiles[i], newDest, filter);
            }
            if (!this.copyFile(srcFiles[i].getAbsolutePath(), newDest.getAbsolutePath(), false)) continue;
            ++cnt;
        }
        return cnt;
    }

    private RmiFileImpl findFileInterface(String truePath) {
        String relPath;
        RmiFileImpl fileInterface;
        RemoteWrapper openWrapper = (RemoteWrapper)_fileWrappers.get(truePath = truePath.replace('\\', '/'));
        if (openWrapper == null) {
            return null;
        }
        if (openWrapper.getRemote() == null) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("Null wrapper found for path %s", (Object)truePath);
            return null;
        }
        Object remoteObj = this.networked ? openWrapper.getObject() : openWrapper.getRemote();
        if (remoteObj instanceof RmiFileImpl && (fileInterface = (RmiFileImpl)remoteObj) != null && (relPath = fileInterface.getAbsolutePath()) != null && (relPath = relPath.replace('\\', '/')).equals(truePath)) {
            return fileInterface;
        }
        return null;
    }

    private void putFileWrapper(String truePath, RemoteWrapper openWrapper) {
        _fileWrappers.put(truePath, openWrapper);
    }

    private RemoteWrapper findFileWrapper(String truePath) {
        if (truePath == null) {
            return null;
        }
        RemoteWrapper openWrapper = (RemoteWrapper)_fileWrappers.get(truePath = truePath.replace('\\', '/'));
        if (openWrapper == null) {
            return null;
        }
        Object remoteObj = this.networked ? openWrapper.getObject() : openWrapper.getRemote();
        if (remoteObj instanceof RmiFileImpl) {
            RmiFileImpl fileInterface = (RmiFileImpl)remoteObj;
            String path = fileInterface.getAbsolutePath();
            if ((path = path.replace('\\', '/')) != null && path.equals(truePath)) {
                return openWrapper;
            }
        }
        return null;
    }

    private boolean saveState(Identifier id) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Identifier renameFile(String user, Identifier existingId, Identifier destId) throws RemoteException {
        if (user == null || existingId == null || destId == null) {
            return null;
        }
        String relativePath = existingId.getPath();
        String truePath = this.processPath(relativePath);
        if (truePath == null) {
            return null;
        }
        File checkFile = new File(truePath);
        if (!checkFile.canRead()) {
            return null;
        }
        RemoteWrapper openWrapper = this.findFileWrapper(truePath);
        if (openWrapper != null) {
            FileLock flock = new FileLock(user, 4);
            if (this.changeLockStatus(existingId, flock)) {
                boolean renamed = false;
                try {
                    RmiFileImpl rmiFile = this.networked ? (RmiFileImpl)openWrapper.getObject() : (RmiFileImpl)openWrapper.getRemote();
                    relativePath = destId.getPath();
                    String trueNewPath = this.processPath(relativePath);
                    if (trueNewPath == null) {
                        Identifier identifier = null;
                        return identifier;
                    }
                    File destFile = new File(trueNewPath);
                    if (rmiFile.renameTo(destFile)) {
                        destId = this.openFile(user, destId);
                        renamed = true;
                        Identifier identifier = destId;
                        return identifier;
                    }
                }
                finally {
                    this.changeLockStatus(existingId, FileLock.getUnlockForLock((FileLock)flock));
                    if (renamed) {
                        _fileWrappers.remove(truePath);
                    }
                }
            }
        } else if (checkFile.renameTo(new File(destId.getPath()))) {
            return this.openFile(user, destId);
        }
        return null;
    }

    @Override
    public boolean deleteFile(String path) {
        String truePath = this.processPath(path);
        if (truePath == null) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("deleteFile: failed to find true path for %s", (Object)path);
            return false;
        }
        RmiFileImpl rmifile = this.findFileInterface(truePath);
        boolean deleted = false;
        if (rmifile == null) {
            File file = new File(path);
            deleted = file.delete();
        } else {
            deleted = rmifile.delete();
        }
        if (deleted && rmifile != null) {
            _fileWrappers.remove(rmifile);
        }
        return deleted;
    }

    @Override
    public boolean shutdown(int shutDownType, int waitSeconds, String userId) throws RemoteException {
        String host = "unknown";
        try {
            host = RmiFileManagerImpl.getClientHost();
        }
        catch (Exception e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("shutdown: failed to get client host.");
        }
        ((FluentLogger.Api)LOGGER.atInfo()).log("%s told to shutDown in %d seconds from host %s user %s", (Object)this.getName(), (Object)waitSeconds, (Object)host, (Object)userId);
        this.shutdown(waitSeconds);
        return true;
    }

    @Override
    public StringBuilder getStatus(StringBuilder sb) {
        if (sb == null) {
            sb = new StringBuilder();
        }
        sb.append("Total Files=");
        sb.append(_fileWrappers.size());
        sb.append(";Number of Write Locked Files=");
        Enumeration e = _fileWrappers.elements();
        int lockedByCnt = 0;
        long lastLockedTime = -1L;
        for (int i = 0; i < _fileWrappers.size(); ++i) {
            RmiFileImpl fileInterface;
            Object remoteObj;
            RemoteWrapper openWrapper = (RemoteWrapper)e.nextElement();
            if (openWrapper == null || openWrapper.getRemote() == null || !((remoteObj = this.networked ? openWrapper.getObject() : openWrapper.getRemote()) instanceof RmiFileImpl) || (fileInterface = (RmiFileImpl)remoteObj).getLockedBy() == null || !fileInterface.hasWriteLock()) continue;
            ++lockedByCnt;
            long lockedTime = fileInterface._writeLock.getLockedTime();
            if (lockedTime <= lastLockedTime) continue;
            lastLockedTime = lockedTime;
        }
        sb.append(lockedByCnt);
        if (lastLockedTime > -1L) {
            sb.append(";Time of last write lock=");
            sb.append(new Date(lastLockedTime));
        }
        sb.append(";");
        try {
            StatusObject status = this.getStatusObject(0);
            String statusString = status.toString();
            sb.append(statusString.replace('\n', ';'));
        }
        catch (RemoteException re) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atFinest()).withCause((Throwable)re)).log("getStatus: failed to get status");
        }
        return sb;
    }

    @Override
    public String getStatusString(int statusType) throws RemoteException {
        if (this.isShuttingDown()) {
            return "Shutting Down";
        }
        int size = _fileWrappers.size();
        String fileStr = " Files";
        if (size == 0) {
            return "OK";
        }
        if (size == 1) {
            fileStr = " File";
        }
        return size + fileStr;
    }

    @Override
    public StatusObject getStatusObject(int statusType) throws RemoteException {
        FileManagerStatus fms = new FileManagerStatus();
        fms.setFileList(this.getFileWrappersTable());
        fms.setStartTime(this.getControllableServerStartTime());
        fms.setFileManager(this);
        return fms;
    }

    @Override
    public String[] directoryListing(String directoryPath) {
        if (directoryPath == null) {
            return new String[0];
        }
        File f = new File(directoryPath);
        return f.list();
    }

    @Override
    public boolean fileExists(String path) {
        if (path == null) {
            return false;
        }
        File file = new File(path);
        return file.exists();
    }

    @Override
    @Deprecated
    public boolean fileExists(Identifier id) throws RemoteException {
        if (id == null) {
            return false;
        }
        return this.fileExists(id.getPath());
    }

    @Override
    public Vector getFileWrappers() throws RemoteException {
        Vector v = new Vector();
        Enumeration e = _fileWrappers.elements();
        for (int i = 0; i < _fileWrappers.size(); ++i) {
            v.add(e.nextElement());
        }
        return v;
    }

    @Override
    public Hashtable getFileWrappersTable() throws RemoteException {
        return (Hashtable)_fileWrappers.clone();
    }

    @Override
    protected Remote getClientSideProxies(Remote remote) {
        try {
            Remote server = super.getClientSideProxies(remote);
            ((FluentLogger.Api)LOGGER.atFine()).log("getClientSideProxies: %s", (Object)this.getUrl());
            Class[] interfaces = new Class[]{RmiFileManager.class, RmiLoginListener.class};
            ClassLoader classLoader = server.getClass().getClassLoader();
            server = (RmiFileManager)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new ReconnectProxy(server, this.getServerUrl()));
            server = (RmiFileManager)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new NotifyUserProxy(server, this._ipUrl));
            if (Boolean.getBoolean("hec.rmi.server.logCalls")) {
                server = (RmiFileManager)Proxy.newProxyInstance(RmiFileManager.class.getClassLoader(), interfaces, (InvocationHandler)new LogProxy(server));
            }
            return server;
        }
        catch (IllegalArgumentException | RemoteException e) {
            throw new IllegalStateException("getClientSideProxies: failed to create proxy", e);
        }
    }

    @Override
    public boolean filesEqual(String firstFile, String secondFile) {
        if (firstFile == null && secondFile == null) {
            return true;
        }
        if (firstFile == null || secondFile == null) {
            return false;
        }
        File file1 = new File(firstFile);
        File file2 = new File(secondFile);
        return file1.equals(file2);
    }

    @Override
    public boolean deleteDirectory(String dirToDelete) {
        if (dirToDelete == null) {
            return false;
        }
        File f = new File(dirToDelete);
        return this.deleteDir(f);
    }

    private boolean deleteDir(File dir) {
        File candir;
        try {
            candir = dir.getCanonicalFile();
        }
        catch (IOException e) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("deleteDir:failed to get CanonicalFile for %s Error:%s", (Object)dir.getAbsolutePath(), (Object)e);
            return false;
        }
        ((FluentLogger.Api)LOGGER.atFine()).log("deleteDir:deleting %s", (Object)candir.getAbsolutePath());
        if (!candir.equals(dir.getAbsoluteFile())) {
            ((FluentLogger.Api)LOGGER.atInfo()).log("deleteDir:trying to delete symbolic path %s real path=%s", (Object)dir.getAbsolutePath(), (Object)candir.getAbsolutePath());
            return false;
        }
        File[] files = candir.listFiles();
        int deleteFileCnt = 0;
        int deleteDirCnt = 0;
        if (files != null) {
            ((FluentLogger.Api)LOGGER.atFine()).log("deleteDir:found %d items to delete in %s", files.length, (Object)dir.getAbsolutePath());
            for (int i = 0; i < files.length; ++i) {
                boolean deleted;
                File file = files[i];
                String path = this.processPath(file.getAbsolutePath());
                RmiFileImpl rmiFile = this.findFileInterface(path);
                if (rmiFile != null) {
                    deleted = rmiFile.delete();
                    if (!deleted && !file.isDirectory()) {
                        ((FluentLogger.Api)LOGGER.atInfo()).log("deleteDir:Failed to delete file %s", (Object)rmiFile.getAbsolutePath());
                    } else {
                        ++deleteFileCnt;
                    }
                } else {
                    deleted = file.delete();
                    if (!deleted && !file.isDirectory()) {
                        ((FluentLogger.Api)LOGGER.atInfo()).log("deleteDir:failed to delete file %s", (Object)file.getAbsolutePath());
                    } else {
                        ++deleteFileCnt;
                    }
                }
                if (deleted || !file.isDirectory()) continue;
                if (!this.deleteDir(file)) {
                    ((FluentLogger.Api)LOGGER.atInfo()).log("deleteDir:failed to delete directory %s", (Object)file.getAbsolutePath());
                    continue;
                }
                ++deleteDirCnt;
            }
        }
        ((FluentLogger.Api)LOGGER.atFine()).log("deleteDir:deleted %d files and %d directories", deleteFileCnt, deleteDirCnt);
        return dir.delete();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Identifier zipFiles(String destZipFile, boolean useFolderNames, String baseDir, List<String> files2Zip, boolean deleteSrcFiles, String userId) throws RemoteException {
        if (destZipFile == null) return null;
        if (files2Zip == null) return null;
        if (files2Zip.isEmpty()) {
            return null;
        }
        try {
            JarOutputStream zout = new JarOutputStream(new FileOutputStream(destZipFile));
            try {
                int size = files2Zip.size();
                long bytes = 0L;
                int len = 0;
                int fileCnt = 0;
                byte[] b = new byte[1024];
                ZipEntry e = new ZipEntry("META_INF/");
                e.setTime(System.currentTimeMillis());
                e.setSize(0L);
                e.setCrc(0L);
                try {
                    ((ZipOutputStream)zout).putNextEntry(e);
                }
                catch (IOException e2) {
                    ((FluentLogger.Api)LOGGER.atWarning()).log("zipFiles: IOException %s", (Object)e2);
                }
                e = new ZipEntry("manifest.mf");
                e.setTime(System.currentTimeMillis());
                try {
                    ((ZipOutputStream)zout).putNextEntry(e);
                    zout.closeEntry();
                }
                catch (IOException e2) {
                    ((FluentLogger.Api)LOGGER.atWarning()).log("zipFiles: IOException %s", (Object)e2);
                }
                for (int i = 0; i < size; ++i) {
                    String name = files2Zip.get(i);
                    if (name == null || name.length() == 0) continue;
                    String zipFileName = useFolderNames ? (baseDir != null ? RMAIO.getRelativePath((String)baseDir, (String)name) : name) : RMAIO.getFileFromPath((String)name);
                    try {
                        try (FileInputStream in = new FileInputStream(name);){
                            File f = new File(name);
                            long fsize = f.isDirectory() ? 0L : f.length();
                            ZipEntry fileEntry = new ZipEntry(zipFileName);
                            fileEntry.setTime(f.lastModified());
                            if (fsize == 0L) {
                                fileEntry.setMethod(0);
                                fileEntry.setSize(0L);
                                fileEntry.setCrc(0L);
                            }
                            try {
                                ((ZipOutputStream)zout).putNextEntry(fileEntry);
                                len = 0;
                                while ((len = in.read(b)) != -1) {
                                    zout.write(b, 0, len);
                                    bytes += (long)len;
                                }
                                zout.closeEntry();
                                ++fileCnt;
                                if (deleteSrcFiles && !f.delete()) {
                                    ((FluentLogger.Api)LOGGER.atInfo()).log("zipFiles:failed to delete src file %s", (Object)f.getAbsolutePath());
                                }
                            }
                            catch (ZipException ze) {
                                ((FluentLogger.Api)LOGGER.atWarning()).log("zipFiles: Error creating Image file. Error:%s", (Object)ze);
                            }
                            catch (IOException ioe) {
                                ((FluentLogger.Api)LOGGER.atWarning()).log("zipFiles: Error creating Image file %s. Error:%s", (Object)destZipFile, (Object)ioe);
                                Identifier identifier = null;
                                in.close();
                                zout.close();
                                return identifier;
                            }
                        }
                        continue;
                    }
                    catch (FileNotFoundException e1) {
                        ((FluentLogger.Api)LOGGER.atWarning()).log("zipFile: FileNotFoundException");
                    }
                }
                ((FluentLogger.Api)LOGGER.atFine()).log("zipFiles:zipped %d files into %s", fileCnt, (Object)destZipFile);
                return this.openFile(userId, new Identifier(destZipFile));
            }
            finally {
                try {
                    zout.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
        catch (FileNotFoundException nfe) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("zipFiles: Failed to find file %s Error:%s", (Object)destZipFile, (Object)nfe);
            return null;
        }
        catch (IOException e) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)e)).log("zipFiles: IOException creating file %s Error:%s", (Object)destZipFile, (Object)e);
            return null;
        }
    }

    @Override
    public List<Identifier> unzipFile(String fileName, String baseDir, String userId) {
        ArrayList<Identifier> files = new ArrayList<Identifier>();
        int fileCnt = 0;
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(fileName));
             ZipInputStream zin = new ZipInputStream(in);){
            ZipEntry e;
            while ((e = zin.getNextEntry()) != null) {
                if (!this.unzip(zin, files, RMAIO.makeAbsolutePath((String)baseDir, (String)e.getName()), userId)) continue;
                ++fileCnt;
            }
        }
        catch (FileNotFoundException nfe) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("unzipFile: ERROR failed to find file %s", (Object)fileName);
        }
        catch (IOException ioe) {
            ((FluentLogger.Api)LOGGER.atWarning()).log("unzipFile: ERROR reading %s Error:%s", (Object)fileName, (Object)ioe);
        }
        return files;
    }

    private boolean unzip(ZipInputStream zin, List<Identifier> files, String file, String userId) throws IOException {
        File f = new File(file);
        if (!f.exists()) {
            f.getParentFile().mkdirs();
        }
        if (file.endsWith("/")) {
            return f.mkdir();
        }
        try (FileOutputStream out = new FileOutputStream(file);){
            int len;
            byte[] b = new byte[1024];
            while ((len = zin.read(b)) != -1) {
                out.write(b, 0, len);
            }
        }
        if (f.exists()) {
            Identifier id = new Identifier(file);
            if ((id = this.openFile(userId, id)) != null) {
                files.add(id);
            }
        }
        return true;
    }

    @Override
    public boolean isDirectory(String path) {
        if (path == null) {
            return false;
        }
        File f = new File(path);
        return f.isDirectory();
    }

    @Override
    public int getNextPortOffset() {
        return Integer.getInteger("nextPortOffset", super.getNextPortOffset() + 3);
    }

    @Override
    public boolean startListeningForFileChanges(String folderPath, String userId) {
        if (folderPath == null) {
            return false;
        }
        String truePath = this.processPath(folderPath);
        return this._fileListener.addListener(userId, truePath);
    }

    @Override
    public boolean stopListeningForFileChanges(String folderPath, String userId) {
        if (folderPath == null) {
            return false;
        }
        String truePath = this.processPath(folderPath);
        return this._fileListener.removeListener(userId, truePath);
    }

    @Override
    public List<FileChangeInfo> checkForFileChanges(String userId) {
        return this._fileListener.checkForFileChanges(userId);
    }

    @Override
    public FileOffsets getLogfileTimeOffsets(String filePath, String start, String end) {
        String truePath = this.processPath(filePath);
        if (truePath == null) {
            return null;
        }
        long startOffset = FileOffsetError.INVALID_ARGUMENTS.getErrorCode();
        TimeWindowFileReader timeWindowFileReader = new TimeWindowFileReader();
        if (start != null && start.length() > 0) {
            startOffset = timeWindowFileReader.findStartOffset(new File(truePath), start);
        }
        long endOffset = FileOffsetError.INVALID_ARGUMENTS.getErrorCode();
        if (end != null && end.length() > 0) {
            long binarySearchStart = startOffset > 0L ? startOffset : 0L;
            endOffset = timeWindowFileReader.findEndOffset(new File(truePath), end, binarySearchStart);
        }
        return new FileOffsets(startOffset, endOffset);
    }
}

