/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.server;

import com.google.common.flogger.FluentLogger;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import mil.army.usace.hec.rmi.server.SocketConnectionThread;

public final class RmiFileSocketFactory {
    private static final FluentLogger LOGGER = FluentLogger.forEnclosingClass();
    private static RmiFileSocketFactory _socketFactory;
    private static int MAX_SOCKETS;
    private final List<SocketConnectionThread> _sockets = new CopyOnWriteArrayList<SocketConnectionThread>();

    private RmiFileSocketFactory() {
    }

    public static synchronized RmiFileSocketFactory getInstance() {
        if (_socketFactory == null) {
            _socketFactory = new RmiFileSocketFactory();
        }
        return _socketFactory;
    }

    public synchronized SocketConnectionThread getServerConnection(String clientUserId) {
        if (this._sockets.size() < 1) {
            return this.newSocketConnection(clientUserId);
        }
        int size = this._sockets.size();
        for (int i = size - 1; i >= 0; --i) {
            SocketConnectionThread sc = this._sockets.get(i);
            if (sc != null && sc.isAlive()) {
                return sc;
            }
            if (sc == null || sc.isAlive()) continue;
            this._sockets.remove(sc);
        }
        return this.newSocketConnection(clientUserId);
    }

    private SocketConnectionThread newSocketConnection(String clientUserId) {
        try {
            SocketConnectionThread sc = new SocketConnectionThread(0, clientUserId);
            sc.getServerSocket().setSoTimeout(600000);
            sc.start();
            return sc;
        }
        catch (Exception se) {
            ((FluentLogger.Api)((FluentLogger.Api)LOGGER.atWarning()).withCause((Throwable)se)).log("Error creating new socket connection");
            return null;
        }
    }

    public synchronized void returnServerConnection(SocketConnectionThread sc) {
        if (sc != null && this._sockets.size() < MAX_SOCKETS) {
            this._sockets.add(sc);
        } else if (sc != null) {
            sc.close();
        }
    }

    static {
        MAX_SOCKETS = 5;
    }
}

