/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.server;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.BindException;
import java.net.ServerSocket;
import java.rmi.server.RMIServerSocketFactory;
import mil.army.usace.hec.rmi.server.PortRange;
import rma.util.RMAIO;

public class SinglePortRangedServerSocketFactory
implements RMIServerSocketFactory {
    private static boolean _debug = false;
    private static int _port = 0;
    private static int[] _range;
    private static boolean _portSet;
    private static int _startPort;

    private static File getLastPortFile(boolean mustExist) {
        String path = "$CWMS_HOME/users/lastRmiPortUsed";
        path = RMAIO.parsePathName((String)path);
        File f = new File(path);
        if (mustExist && !f.exists()) {
            return null;
        }
        return f;
    }

    private static void getLastPortUsed() {
        block10: {
            if (_range == null) {
                return;
            }
            File f = SinglePortRangedServerSocketFactory.getLastPortFile(true);
            if (f == null) {
                return;
            }
            if (_debug) {
                System.out.println("getLastPortUsed: reading " + f.getPath());
            }
            try {
                BufferedReader reader = new BufferedReader(new FileReader(f));
                String line = reader.readLine();
                if (_debug) {
                    System.out.println("getLastPortUsed: read [" + line + "]");
                }
                reader.close();
                if (line != null) {
                    int port = RMAIO.parseInt((String)line, (int)-1);
                    if (port == -1) {
                        return;
                    }
                    if (++port >= _range[0] && port <= _range[1]) {
                        _startPort = port;
                        if (_debug) {
                            System.out.println("getLastPortUsed: startPort set to " + _startPort);
                        }
                    }
                }
            }
            catch (IOException ioe) {
                if (!_debug) break block10;
                System.out.println("getLastPortUsed: IOError reading " + f.getPath() + " Error:" + ioe);
            }
        }
    }

    private static void saveLastPortUsed() {
        block4: {
            File f = SinglePortRangedServerSocketFactory.getLastPortFile(false);
            if (f == null) {
                return;
            }
            if (_debug) {
                System.out.println("saveLastPortUsed: writing port " + _port);
            }
            try {
                BufferedWriter writer = new BufferedWriter(new FileWriter(f));
                RMAIO.fout((BufferedWriter)writer, (String)String.valueOf(_port));
                writer.close();
            }
            catch (IOException ioe) {
                if (!_debug) break block4;
                System.out.println("saveLastPortUsed: Error writing to " + f.getPath() + " Error:" + ioe);
            }
        }
    }

    @Override
    public synchronized ServerSocket createServerSocket(int port) throws IOException {
        if (_debug) {
            System.out.println("createServerSocket: request for " + port);
        }
        if (_portSet) {
            if (_debug) {
                System.out.println("createServerSocket: request was for " + _port + " returning ServerSocket on port " + _port);
            }
            return new ServerSocket(_port);
        }
        if (!_portSet && _range != null) {
            ServerSocket socket = null;
            int start = _startPort != -1 ? _startPort : _range[0];
            while (true) {
                if (_debug) {
                    System.out.println("createServerSocket: port not set. Trying " + start);
                }
                try {
                    socket = new ServerSocket(start);
                    _port = start;
                    _portSet = true;
                    SinglePortRangedServerSocketFactory.saveLastPortUsed();
                    if (_debug) {
                        System.out.println("createServerSocket: request was for " + port + " returning " + socket.getInetAddress().toString() + ":" + socket.getLocalPort());
                    }
                    return socket;
                }
                catch (IOException ioe) {
                    if (_debug) {
                        System.out.println("createServerSocket:Error trying port " + start + " Error:" + ioe);
                    }
                    if (ioe instanceof BindException) {
                        if (_debug) {
                            System.out.println("createServerSocket: port " + start + " already in use");
                        }
                        if (++start <= _range[1]) continue;
                        System.out.println("createServerSocket:ERROR tried all ports between " + _range[0] + " and " + _range[1] + " Nothing available");
                        throw ioe;
                    }
                    throw ioe;
                    if (socket == null) continue;
                }
                break;
            }
        } else if (_range == null) {
            if (_debug) {
                System.out.println("createServerSocket: no range. returning ServerSocket on requested port " + port);
            }
            return new ServerSocket(port);
        }
        System.out.println("createServerSocket: WARNING returning ServerSocket on requested port " + port);
        return new ServerSocket(port);
    }

    public static int getRmiPort() {
        if (_portSet) {
            return _port;
        }
        return 0;
    }

    public boolean equals(Object that) {
        if (that == this) {
            return true;
        }
        return that != null && that.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    static {
        _portSet = false;
        _startPort = -1;
        _debug = Boolean.getBoolean("hec.rmi.server.logCalls");
        System.out.println("SinglePortRangedServerSocketFactory: debug=" + _debug);
        _range = PortRange.getPortRange("Server");
        SinglePortRangedServerSocketFactory.getLastPortUsed();
    }
}

