/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.server;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import mil.army.usace.hec.rmi.server.RmiFileImpl;

public class SocketConnectionThread
extends Thread {
    private final String _clientUserId;
    ServerSocket _serverSocket = null;
    RmiFileImpl _rmiFile;

    public SocketConnectionThread(int port, String clientUserId) throws Exception {
        this._clientUserId = clientUserId;
        try {
            this._serverSocket = new ServerSocket(port);
        }
        catch (Exception e) {
            System.out.println("SocketConnectionThread:<init> error creating socket " + e);
            throw e;
        }
    }

    public synchronized int getPort() {
        if (this._serverSocket != null) {
            return this._serverSocket.getLocalPort();
        }
        return -1;
    }

    public synchronized void close() {
        try {
            this._serverSocket.close();
        }
        catch (IOException ioe) {
            System.out.println("close: IOException closing socket " + ioe);
        }
        this._serverSocket = null;
    }

    public synchronized ServerSocket getServerSocket() {
        return this._serverSocket;
    }

    public void setRmiFile(RmiFileImpl rmiFile) {
        this._rmiFile = rmiFile;
    }

    @Override
    public void run() {
        while (this._serverSocket != null) {
            Socket socket;
            try {
                socket = this._serverSocket.accept();
            }
            catch (Exception e) {
                System.out.println("Error on accept() " + e);
                this.close();
                break;
            }
            DataOutputStream sos = null;
            DataInputStream sis = null;
            try {
                sos = new DataOutputStream(socket.getOutputStream());
                sis = new DataInputStream(socket.getInputStream());
            }
            catch (IOException ioe) {
                System.out.println("run: error getting input or output stream " + ioe);
                continue;
            }
            char c = '\uffff';
            try {
                c = sis.readChar();
            }
            catch (IOException ioe) {
                System.out.println("run: error reading from socket " + ioe);
                continue;
            }
            if (c == 'R') {
                this.readFromFile(sis, sos);
                continue;
            }
            if (c == 'W') {
                this.writeToFile(sis);
                continue;
            }
            System.out.println("unknown command " + c);
        }
    }

    private void writeToFile(DataInputStream sis) {
        char newFile = '\uffff';
        int length = -1;
        try {
            newFile = sis.readChar();
            length = sis.readInt();
        }
        catch (IOException ioe) {
            System.out.println("writeToFile: IOException error reading header info " + ioe);
            return;
        }
        if (newFile == '\uffffffff' || length < 1) {
            System.out.println("writeToFile: invalid header read. newFile Indicator =" + newFile + " length=" + length);
            return;
        }
        byte[] data = new byte[length];
        try {
            int numRead = sis.read(data);
            if (numRead != length) {
                System.out.println("writeToFile: only read " + numRead + " of " + length + " expected");
            }
            if (newFile == 'N') {
                this._rmiFile.setByteArray(data, this._clientUserId);
            } else {
                this._rmiFile.appendByteArray(data, this._clientUserId);
            }
        }
        catch (RemoteException numRead) {
        }
        catch (Exception e) {
            System.out.println("writeToFile: Error reading from socket " + e);
        }
    }

    private void readFromFile(DataInputStream sis, DataOutputStream sos) {
        int offset = -1;
        int len = -1;
        try {
            offset = sis.readInt();
            len = sis.readInt();
        }
        catch (IOException ioe) {
            System.out.println("readFromFile: error reading offset/len from socket " + ioe);
            return;
        }
        if (offset < 0 || len < 1) {
            System.out.println("readFromFile: invalid offset " + offset + " or length " + len + " read from socket");
            return;
        }
        try {
            sos.write(this._rmiFile.getByteArray(offset, len, this._clientUserId));
        }
        catch (RemoteException ioe) {
        }
        catch (Exception e) {
            System.out.println("readFromFile: Error on socket write " + e);
        }
    }
}

