/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.rmi.server;

import com.google.common.flogger.LazyArgs;
import hec.server.MessageReporter;
import java.rmi.RemoteException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.rmi.server.ControllableServerImpl;
import rma.util.RMAConst;
import rma.util.RMAIO;
import rma.util.logging.MarkingClassLogger;

public abstract class StatusReportingServer
extends ControllableServerImpl
implements MessageReporter {
    public static final String STATUS_TYPE = "Status";
    private static final String STATUS_INTERVAL_MINUTES_TYPE = "StatusIntervalMinutes";
    private static final String TERMINATION_TYPE = "Terminated";
    private static final String SHUTTING_DOWN_TYPE = "Shutting Down";
    private static final String STATE_TYPE = "State";
    private static final int DEFAULT_STATUS_INTERVAL_MINUTES = 5;
    private static final String[][] REPLACE_CODES = new String[][]{{"\n", "^LF"}, {"\t", "^HT"}, {"\r", "^CR"}, {"\b", "^BS"}};
    private static final DateTimeFormatter LOCAL_DATE_FORMAT = DateTimeFormatter.ofPattern("ddMMMyyyy HH:mm:ss z").withZone(ZoneId.systemDefault());
    private static final DateTimeFormatter UTC_DATE_FORMAT = DateTimeFormatter.ofPattern("ddMMMyyyy HH:mm:ss z").withZone(NumericalConstants.UTC_ZONEID);
    private ScheduledExecutorService _statusExecutor;

    protected StatusReportingServer() throws RemoteException {
    }

    protected StatusReportingServer(int rmiPort) throws RemoteException {
        super(rmiPort);
    }

    protected abstract MarkingClassLogger getStatusLogger();

    protected abstract StringBuilder getStatus(StringBuilder var1);

    protected StringBuilder getCurrentState(StringBuilder sb) {
        if (this.isShuttingDown()) {
            sb.append("Server=Shutting down;");
        } else if (this.isPaused()) {
            sb.append("Server=Paused;");
        } else {
            sb.append("Server=Running;");
        }
        return sb;
    }

    protected String getStatusReportingName() {
        return this.getName() + "@" + this.getHost() + ":" + this.getPort();
    }

    public synchronized void startStatusReporting(int statusIntervalMinutes) {
        if (this._statusExecutor != null) {
            this._statusExecutor.shutdown();
        }
        this._statusExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
            Thread thread = new Thread(r, this.getClass().getSimpleName() + " Thread");
            thread.setDaemon(true);
            return thread;
        });
        this._statusExecutor.scheduleAtFixedRate(this::reportStatus, statusIntervalMinutes, statusIntervalMinutes, TimeUnit.MINUTES);
        ((MarkingClassLogger.Api)this.getStatusLogger().atInfo()).log("%s", (Object)LazyArgs.lazy(() -> StatusReportingServer.constructMessage(this.getStatusReportingName(), STATUS_INTERVAL_MINUTES_TYPE, "StatusIntervalMinutes=" + statusIntervalMinutes + " minutes")));
    }

    void reportStatus() {
        StringBuilder sb = this.getStatus(new StringBuilder());
        ((MarkingClassLogger.Api)this.getStatusLogger().atInfo()).log("%s", (Object)LazyArgs.lazy(() -> StatusReportingServer.constructMessage(this.getStatusReportingName(), STATUS_TYPE, sb.toString())));
    }

    public void startStatusReporting() {
        int status = RMAIO.parseInt((String)System.getProperty("message.StatusIntervalMinutes"));
        if (RMAConst.isUndefinedValue((int)status)) {
            status = 5;
        }
        this.startStatusReporting(status);
    }

    public synchronized void stopStatusReporting() {
        if (this._statusExecutor != null) {
            this._statusExecutor.shutdown();
        }
    }

    public void addErrorMessage(Object type, Object o) {
        if (type == null || o == null) {
            return;
        }
        StringBuilder sb = this.getCurrentState(new StringBuilder()).append(o);
        ((MarkingClassLogger.Api)this.getStatusLogger().atWarning()).log("%s", (Object)LazyArgs.lazy(() -> StatusReportingServer.constructMessage(this.getStatusReportingName(), type.toString(), sb.toString())));
    }

    public void addInformationMessage(Object o) {
        if (o == null) {
            return;
        }
        StringBuilder sb = this.getCurrentState(new StringBuilder()).append(o);
        ((MarkingClassLogger.Api)this.getStatusLogger().atInfo()).log("%s", (Object)LazyArgs.lazy(() -> StatusReportingServer.constructMessage(this.getStatusReportingName(), STATE_TYPE, sb.toString())));
    }

    @Override
    protected void shutdown(int waitSeconds) {
        this.stopStatusReporting();
        String statusReportingName = this.getStatusReportingName();
        ((MarkingClassLogger.Api)this.getStatusLogger().atWarning()).log("%s", (Object)LazyArgs.lazy(() -> StatusReportingServer.constructMessage(statusReportingName, TERMINATION_TYPE, statusReportingName)));
        super.shutdown(waitSeconds);
    }

    protected void shutdownInitiated() {
        super.fireShutdownInitiatedEvent();
        String statusReportingName = this.getStatusReportingName();
        ((MarkingClassLogger.Api)this.getStatusLogger().atWarning()).log("%s", (Object)LazyArgs.lazy(() -> StatusReportingServer.constructMessage(statusReportingName, SHUTTING_DOWN_TYPE, statusReportingName)));
    }

    public static String constructMessage(String src, String typeAndAggData, String body) {
        for (int i = 0; i < REPLACE_CODES[0].length; ++i) {
            body = body.replace(REPLACE_CODES[i][0], REPLACE_CODES[i][1]);
        }
        Instant now = Instant.now();
        return "UTCTime=" + UTC_DATE_FORMAT.format(now) + ";LocalTime=" + LOCAL_DATE_FORMAT.format(now) + ";From=" + src + ";MessageLength=" + body.length() + ";MessageType=" + typeAndAggData + ";Message=" + body;
    }
}

