/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata;

import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class Duration
implements Serializable {
    private static final long serialVersionUID = -8085466617451057908L;
    private final TimeOfRecord _timeOfRecord;
    private final String _durationName;
    private final int _minutes;

    Duration(String durationName, int minutes, TimeOfRecord timeOfRecord) {
        this._durationName = durationName;
        this._minutes = minutes;
        this._timeOfRecord = timeOfRecord;
    }

    public final int getSeconds() {
        return (int)TimeUnit.MINUTES.toSeconds(this._minutes);
    }

    public final int getMinutes() {
        return this._minutes;
    }

    public final boolean isEndOfPeriod() {
        return this._timeOfRecord == TimeOfRecord.EOP;
    }

    public TimeOfRecord getTimeOfRecord() {
        return this._timeOfRecord;
    }

    public final String toString() {
        if (this.isEndOfPeriod()) {
            return this.getDurationName();
        }
        return this.getDurationName() + "BOP";
    }

    String getDurationName() {
        return this._durationName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Duration duration = (Duration)o;
        return this.getMinutes() == duration.getMinutes() && this.getTimeOfRecord() == duration.getTimeOfRecord();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getTimeOfRecord(), this.getMinutes()});
    }

    public static enum TimeOfRecord {
        BOP("BOP"),
        EOP("EOP");

        private final String _name;

        private TimeOfRecord(String name) {
            this._name = name;
        }

        public String toString() {
            return this._name;
        }
    }
}

