/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mil.army.usace.hec.metadata.Duration;

public final class DurationFactory {
    private static final Duration NO_DURATION = new Duration("0", 0, Duration.TimeOfRecord.EOP);
    private static final Duration NO_DURATION_BOP = new Duration("0", 0, Duration.TimeOfRecord.BOP);
    private static final Duration D_1_MINUTE_BOP = new Duration("1Minute", 1, Duration.TimeOfRecord.BOP);
    private static final Duration D_2_MINUTES_BOP = new Duration("2Minutes", 2, Duration.TimeOfRecord.BOP);
    private static final Duration D_3_MINUTES_BOP = new Duration("3Minutes", 3, Duration.TimeOfRecord.BOP);
    private static final Duration D_4_MINUTES_BOP = new Duration("4Minutes", 4, Duration.TimeOfRecord.BOP);
    private static final Duration D_5_MINUTES_BOP = new Duration("5Minutes", 5, Duration.TimeOfRecord.BOP);
    private static final Duration D_6_MINUTES_BOP = new Duration("6Minutes", 6, Duration.TimeOfRecord.BOP);
    private static final Duration D_8_MINUTES_BOP = new Duration("8Minutes", 8, Duration.TimeOfRecord.BOP);
    private static final Duration D_10_MINUTES_BOP = new Duration("10Minutes", 10, Duration.TimeOfRecord.BOP);
    private static final Duration D_12_MINUTES_BOP = new Duration("12Minutes", 12, Duration.TimeOfRecord.BOP);
    private static final Duration D_15_MINUTES_BOP = new Duration("15Minutes", 15, Duration.TimeOfRecord.BOP);
    private static final Duration D_20_MINUTES_BOP = new Duration("20Minutes", 20, Duration.TimeOfRecord.BOP);
    private static final Duration D_30_MINUTES_BOP = new Duration("30Minutes", 30, Duration.TimeOfRecord.BOP);
    private static final Duration D_1_HOUR_BOP = new Duration("1Hour", (int)TimeUnit.HOURS.toMinutes(1L), Duration.TimeOfRecord.BOP);
    private static final Duration D_2_HOURS_BOP = new Duration("2Hours", (int)TimeUnit.HOURS.toMinutes(2L), Duration.TimeOfRecord.BOP);
    private static final Duration D_3_HOURS_BOP = new Duration("3Hours", (int)TimeUnit.HOURS.toMinutes(3L), Duration.TimeOfRecord.BOP);
    private static final Duration D_4_HOURS_BOP = new Duration("4Hours", (int)TimeUnit.HOURS.toMinutes(4L), Duration.TimeOfRecord.BOP);
    private static final Duration D_6_HOURS_BOP = new Duration("6Hours", (int)TimeUnit.HOURS.toMinutes(6L), Duration.TimeOfRecord.BOP);
    private static final Duration D_8_HOURS_BOP = new Duration("8Hours", (int)TimeUnit.HOURS.toMinutes(8L), Duration.TimeOfRecord.BOP);
    private static final Duration D_12_HOURS_BOP = new Duration("12Hours", (int)TimeUnit.HOURS.toMinutes(12L), Duration.TimeOfRecord.BOP);
    private static final Duration D_1_DAY_BOP = new Duration("1Day", (int)TimeUnit.DAYS.toMinutes(1L), Duration.TimeOfRecord.BOP);
    private static final Duration D_2_DAYS_BOP = new Duration("2Days", (int)TimeUnit.DAYS.toMinutes(2L), Duration.TimeOfRecord.BOP);
    private static final Duration D_3_DAYS_BOP = new Duration("3Days", (int)TimeUnit.DAYS.toMinutes(3L), Duration.TimeOfRecord.BOP);
    private static final Duration D_4_DAYS_BOP = new Duration("4Days", (int)TimeUnit.DAYS.toMinutes(4L), Duration.TimeOfRecord.BOP);
    private static final Duration D_5_DAYS_BOP = new Duration("5Days", (int)TimeUnit.DAYS.toMinutes(5L), Duration.TimeOfRecord.BOP);
    private static final Duration D_6_DAYS_BOP = new Duration("6Days", (int)TimeUnit.DAYS.toMinutes(6L), Duration.TimeOfRecord.BOP);
    private static final Duration D_1_WEEK_BOP = new Duration("1Week", (int)TimeUnit.DAYS.toMinutes(7L), Duration.TimeOfRecord.BOP);
    private static final Duration D_1_MONTH_BOP = new Duration("1Month", (int)TimeUnit.DAYS.toMinutes(30L), Duration.TimeOfRecord.BOP);
    private static final Duration D_1_YEAR_BOP = new Duration("1Year", (int)TimeUnit.DAYS.toMinutes(365L), Duration.TimeOfRecord.BOP);
    private static final Duration D_1_DECADE_BOP = new Duration("1Decade", (int)TimeUnit.DAYS.toMinutes(3650L), Duration.TimeOfRecord.BOP);
    private static final Duration D_1_MINUTE = new Duration("1Minute", 1, Duration.TimeOfRecord.EOP);
    private static final Duration D_2_MINUTES = new Duration("2Minutes", 2, Duration.TimeOfRecord.EOP);
    private static final Duration D_3_MINUTES = new Duration("3Minutes", 3, Duration.TimeOfRecord.EOP);
    private static final Duration D_4_MINUTES = new Duration("4Minutes", 4, Duration.TimeOfRecord.EOP);
    private static final Duration D_5_MINUTES = new Duration("5Minutes", 5, Duration.TimeOfRecord.EOP);
    private static final Duration D_6_MINUTES = new Duration("6Minutes", 6, Duration.TimeOfRecord.EOP);
    private static final Duration D_8_MINUTES = new Duration("8Minutes", 8, Duration.TimeOfRecord.EOP);
    private static final Duration D_10_MINUTES = new Duration("10Minutes", 10, Duration.TimeOfRecord.EOP);
    private static final Duration D_12_MINUTES = new Duration("12Minutes", 12, Duration.TimeOfRecord.EOP);
    private static final Duration D_15_MINUTES = new Duration("15Minutes", 15, Duration.TimeOfRecord.EOP);
    private static final Duration D_20_MINUTES = new Duration("20Minutes", 20, Duration.TimeOfRecord.EOP);
    private static final Duration D_30_MINUTES = new Duration("30Minutes", 30, Duration.TimeOfRecord.EOP);
    private static final Duration D_1_HOUR = new Duration("1Hour", (int)TimeUnit.HOURS.toMinutes(1L), Duration.TimeOfRecord.EOP);
    private static final Duration D_2_HOURS = new Duration("2Hours", (int)TimeUnit.HOURS.toMinutes(2L), Duration.TimeOfRecord.EOP);
    private static final Duration D_3_HOURS = new Duration("3Hours", (int)TimeUnit.HOURS.toMinutes(3L), Duration.TimeOfRecord.EOP);
    private static final Duration D_4_HOURS = new Duration("4Hours", (int)TimeUnit.HOURS.toMinutes(4L), Duration.TimeOfRecord.EOP);
    private static final Duration D_6_HOURS = new Duration("6Hours", (int)TimeUnit.HOURS.toMinutes(6L), Duration.TimeOfRecord.EOP);
    private static final Duration D_8_HOURS = new Duration("8Hours", (int)TimeUnit.HOURS.toMinutes(8L), Duration.TimeOfRecord.EOP);
    private static final Duration D_12_HOURS = new Duration("12Hours", (int)TimeUnit.HOURS.toMinutes(12L), Duration.TimeOfRecord.EOP);
    private static final Duration D_1_DAY = new Duration("1Day", (int)TimeUnit.DAYS.toMinutes(1L), Duration.TimeOfRecord.EOP);
    private static final Duration D_2_DAYS = new Duration("2Days", (int)TimeUnit.DAYS.toMinutes(2L), Duration.TimeOfRecord.EOP);
    private static final Duration D_3_DAYS = new Duration("3Days", (int)TimeUnit.DAYS.toMinutes(3L), Duration.TimeOfRecord.EOP);
    private static final Duration D_4_DAYS = new Duration("4Days", (int)TimeUnit.DAYS.toMinutes(4L), Duration.TimeOfRecord.EOP);
    private static final Duration D_5_DAYS = new Duration("5Days", (int)TimeUnit.DAYS.toMinutes(5L), Duration.TimeOfRecord.EOP);
    private static final Duration D_6_DAYS = new Duration("6Days", (int)TimeUnit.DAYS.toMinutes(6L), Duration.TimeOfRecord.EOP);
    private static final Duration D_1_WEEK = new Duration("1Week", (int)TimeUnit.DAYS.toMinutes(7L), Duration.TimeOfRecord.EOP);
    private static final Duration D_1_MONTH = new Duration("1Month", (int)TimeUnit.DAYS.toMinutes(30L), Duration.TimeOfRecord.EOP);
    private static final Duration D_1_YEAR = new Duration("1Year", (int)TimeUnit.DAYS.toMinutes(365L), Duration.TimeOfRecord.EOP);
    private static final Duration D_1_DECADE = new Duration("1Decade", (int)TimeUnit.DAYS.toMinutes(3650L), Duration.TimeOfRecord.EOP);
    private static final Set<Duration> STANDARD_DURATIONS = new HashSet<Duration>();

    private DurationFactory() {
        throw new AssertionError((Object)"Utility class");
    }

    public static Predicate<Duration> isEOP() {
        return Duration::isEndOfPeriod;
    }

    public static Predicate<Duration> isBOP() {
        return DurationFactory.isEOP().negate();
    }

    public static Predicate<Duration> equalsMinutes(int minutes) {
        return d -> d.getMinutes() == minutes;
    }

    public static Predicate<Duration> equalsName(String durationName) {
        Predicate<Duration> matchesString = d -> d.toString().equalsIgnoreCase(durationName);
        Predicate<Duration> matchesName = d -> d.getDurationName().equalsIgnoreCase(durationName);
        return matchesString.or(matchesName);
    }

    public static Optional<Duration> findAny(Predicate<Duration> predicate) {
        Set<Duration> matching = DurationFactory.findAll(predicate);
        Optional<Duration> retval = matching.size() == 1 ? Optional.of(matching.iterator().next()) : matching.stream().filter(DurationFactory.isEOP()).findAny();
        return retval;
    }

    public static Set<Duration> findAll(Predicate<Duration> predicate) {
        return STANDARD_DURATIONS.stream().filter(predicate).collect(Collectors.toSet());
    }

    public static Duration noDuration() {
        return NO_DURATION;
    }

    public static Duration noDurationBop() {
        return NO_DURATION_BOP;
    }

    public static Duration d1MinuteBop() {
        return D_1_MINUTE_BOP;
    }

    public static Duration d2MinutesBop() {
        return D_2_MINUTES_BOP;
    }

    public static Duration d3MinutesBop() {
        return D_3_MINUTES_BOP;
    }

    public static Duration d4MinutesBop() {
        return D_4_MINUTES_BOP;
    }

    public static Duration d5MinutesBop() {
        return D_5_MINUTES_BOP;
    }

    public static Duration d6MinutesBop() {
        return D_6_MINUTES_BOP;
    }

    public static Duration d8MinutesBop() {
        return D_8_MINUTES_BOP;
    }

    public static Duration d10MinutesBop() {
        return D_10_MINUTES_BOP;
    }

    public static Duration d12MinutesBop() {
        return D_12_MINUTES_BOP;
    }

    public static Duration d15MinutesBop() {
        return D_15_MINUTES_BOP;
    }

    public static Duration d20MinutesBop() {
        return D_20_MINUTES_BOP;
    }

    public static Duration d30MinutesBop() {
        return D_30_MINUTES_BOP;
    }

    public static Duration d1HourBop() {
        return D_1_HOUR_BOP;
    }

    public static Duration d2HoursBop() {
        return D_2_HOURS_BOP;
    }

    public static Duration d3HoursBop() {
        return D_3_HOURS_BOP;
    }

    public static Duration d4HoursBop() {
        return D_4_HOURS_BOP;
    }

    public static Duration d6HoursBop() {
        return D_6_HOURS_BOP;
    }

    public static Duration d8HoursBop() {
        return D_8_HOURS_BOP;
    }

    public static Duration d12HoursBop() {
        return D_12_HOURS_BOP;
    }

    public static Duration d1DayBop() {
        return D_1_DAY_BOP;
    }

    public static Duration d2DaysBop() {
        return D_2_DAYS_BOP;
    }

    public static Duration d3DaysBop() {
        return D_3_DAYS_BOP;
    }

    public static Duration d4DaysBop() {
        return D_4_DAYS_BOP;
    }

    public static Duration d5DaysBop() {
        return D_5_DAYS_BOP;
    }

    public static Duration d6DaysBop() {
        return D_6_DAYS_BOP;
    }

    public static Duration d1WeekBop() {
        return D_1_WEEK_BOP;
    }

    public static Duration d1MonthBop() {
        return D_1_MONTH_BOP;
    }

    public static Duration d1YearBop() {
        return D_1_YEAR_BOP;
    }

    public static Duration d1DecadeBop() {
        return D_1_DECADE_BOP;
    }

    public static Duration d1Minute() {
        return D_1_MINUTE;
    }

    public static Duration d2Minutes() {
        return D_2_MINUTES;
    }

    public static Duration d3Minutes() {
        return D_3_MINUTES;
    }

    public static Duration d4Minutes() {
        return D_4_MINUTES;
    }

    public static Duration d5Minutes() {
        return D_5_MINUTES;
    }

    public static Duration d6Minutes() {
        return D_6_MINUTES;
    }

    public static Duration d8Minutes() {
        return D_8_MINUTES;
    }

    public static Duration d10Minutes() {
        return D_10_MINUTES;
    }

    public static Duration d12Minutes() {
        return D_12_MINUTES;
    }

    public static Duration d15Minutes() {
        return D_15_MINUTES;
    }

    public static Duration d20Minutes() {
        return D_20_MINUTES;
    }

    public static Duration d30Minutes() {
        return D_30_MINUTES;
    }

    public static Duration d1Hour() {
        return D_1_HOUR;
    }

    public static Duration d2Hours() {
        return D_2_HOURS;
    }

    public static Duration d3Hours() {
        return D_3_HOURS;
    }

    public static Duration d4Hours() {
        return D_4_HOURS;
    }

    public static Duration d6Hours() {
        return D_6_HOURS;
    }

    public static Duration d8Hours() {
        return D_8_HOURS;
    }

    public static Duration d12Hours() {
        return D_12_HOURS;
    }

    public static Duration d1Day() {
        return D_1_DAY;
    }

    public static Duration d2Days() {
        return D_2_DAYS;
    }

    public static Duration d3Days() {
        return D_3_DAYS;
    }

    public static Duration d4Days() {
        return D_4_DAYS;
    }

    public static Duration d5Days() {
        return D_5_DAYS;
    }

    public static Duration d6Days() {
        return D_6_DAYS;
    }

    public static Duration d1Week() {
        return D_1_WEEK;
    }

    public static Duration d1Month() {
        return D_1_MONTH;
    }

    public static Duration d1Year() {
        return D_1_YEAR;
    }

    public static Duration d1Decade() {
        return D_1_DECADE;
    }

    static {
        STANDARD_DURATIONS.add(NO_DURATION);
        STANDARD_DURATIONS.add(NO_DURATION_BOP);
        STANDARD_DURATIONS.add(D_1_MINUTE_BOP);
        STANDARD_DURATIONS.add(D_2_MINUTES_BOP);
        STANDARD_DURATIONS.add(D_3_MINUTES_BOP);
        STANDARD_DURATIONS.add(D_4_MINUTES_BOP);
        STANDARD_DURATIONS.add(D_5_MINUTES_BOP);
        STANDARD_DURATIONS.add(D_6_MINUTES_BOP);
        STANDARD_DURATIONS.add(D_8_MINUTES_BOP);
        STANDARD_DURATIONS.add(D_10_MINUTES_BOP);
        STANDARD_DURATIONS.add(D_12_MINUTES_BOP);
        STANDARD_DURATIONS.add(D_15_MINUTES_BOP);
        STANDARD_DURATIONS.add(D_20_MINUTES_BOP);
        STANDARD_DURATIONS.add(D_30_MINUTES_BOP);
        STANDARD_DURATIONS.add(D_1_HOUR_BOP);
        STANDARD_DURATIONS.add(D_2_HOURS_BOP);
        STANDARD_DURATIONS.add(D_3_HOURS_BOP);
        STANDARD_DURATIONS.add(D_4_HOURS_BOP);
        STANDARD_DURATIONS.add(D_6_HOURS_BOP);
        STANDARD_DURATIONS.add(D_8_HOURS_BOP);
        STANDARD_DURATIONS.add(D_12_HOURS_BOP);
        STANDARD_DURATIONS.add(D_1_DAY_BOP);
        STANDARD_DURATIONS.add(D_2_DAYS_BOP);
        STANDARD_DURATIONS.add(D_3_DAYS_BOP);
        STANDARD_DURATIONS.add(D_4_DAYS_BOP);
        STANDARD_DURATIONS.add(D_5_DAYS_BOP);
        STANDARD_DURATIONS.add(D_6_DAYS_BOP);
        STANDARD_DURATIONS.add(D_1_WEEK_BOP);
        STANDARD_DURATIONS.add(D_1_MONTH_BOP);
        STANDARD_DURATIONS.add(D_1_YEAR_BOP);
        STANDARD_DURATIONS.add(D_1_DECADE_BOP);
        STANDARD_DURATIONS.add(D_1_MINUTE);
        STANDARD_DURATIONS.add(D_2_MINUTES);
        STANDARD_DURATIONS.add(D_3_MINUTES);
        STANDARD_DURATIONS.add(D_4_MINUTES);
        STANDARD_DURATIONS.add(D_5_MINUTES);
        STANDARD_DURATIONS.add(D_6_MINUTES);
        STANDARD_DURATIONS.add(D_8_MINUTES);
        STANDARD_DURATIONS.add(D_10_MINUTES);
        STANDARD_DURATIONS.add(D_12_MINUTES);
        STANDARD_DURATIONS.add(D_15_MINUTES);
        STANDARD_DURATIONS.add(D_20_MINUTES);
        STANDARD_DURATIONS.add(D_30_MINUTES);
        STANDARD_DURATIONS.add(D_1_HOUR);
        STANDARD_DURATIONS.add(D_2_HOURS);
        STANDARD_DURATIONS.add(D_3_HOURS);
        STANDARD_DURATIONS.add(D_4_HOURS);
        STANDARD_DURATIONS.add(D_6_HOURS);
        STANDARD_DURATIONS.add(D_8_HOURS);
        STANDARD_DURATIONS.add(D_12_HOURS);
        STANDARD_DURATIONS.add(D_1_DAY);
        STANDARD_DURATIONS.add(D_2_DAYS);
        STANDARD_DURATIONS.add(D_3_DAYS);
        STANDARD_DURATIONS.add(D_4_DAYS);
        STANDARD_DURATIONS.add(D_5_DAYS);
        STANDARD_DURATIONS.add(D_6_DAYS);
        STANDARD_DURATIONS.add(D_1_WEEK);
        STANDARD_DURATIONS.add(D_1_MONTH);
        STANDARD_DURATIONS.add(D_1_YEAR);
        STANDARD_DURATIONS.add(D_1_DECADE);
    }
}

