/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.interval.CwmsIntervals;
import mil.army.usace.hec.metadata.interval.Dss6Intervals;
import mil.army.usace.hec.metadata.interval.DssIntervals;
import mil.army.usace.hec.metadata.interval.IntervalProvider;
import rma.util.lookup.Lookups;

public final class IntervalFactory {
    private static final boolean USE_NEW_LOCAL_REGULAR_ID = Boolean.getBoolean("cwms.interval.localregular.new.enabled");

    private IntervalFactory() {
        throw new AssertionError((Object)"Utility class");
    }

    public static Predicate<Interval> equalsName(String intervalName) {
        return i -> i.getInterval().equalsIgnoreCase(intervalName);
    }

    public static Predicate<Interval> isRegular() {
        return Interval::isRegular;
    }

    public static Predicate<Interval> isIrregular() {
        return Interval::isIrregular;
    }

    public static Predicate<Interval> equalsMinutes(int minutes) {
        return i -> i.getMinutes() == minutes;
    }

    public static Predicate<Interval> equalsSeconds(int seconds) {
        return i -> i.getSeconds() == seconds;
    }

    public static Optional<Interval> findAny(Predicate<Interval> predicate) {
        return Lookups.forPath((String)"CWMS").lookupAll(IntervalProvider.class).stream().map(IntervalProvider::getIntervals).flatMap(Collection::stream).filter(predicate).findAny();
    }

    public static Optional<Interval> findAnyDss(Predicate<Interval> predicate) {
        return Lookups.forPath((String)"DSS").lookupAll(IntervalProvider.class).stream().map(IntervalProvider::getIntervals).flatMap(Collection::stream).filter(predicate).findAny();
    }

    public static Optional<Interval> findAnyDss6(Predicate<Interval> predicate) {
        return Lookups.forPath((String)"DSS6").lookupAll(IntervalProvider.class).stream().map(IntervalProvider::getIntervals).flatMap(Collection::stream).filter(predicate).findAny();
    }

    public static Set<Interval> findAllDss6(Predicate<Interval> predicate) {
        return Lookups.forPath((String)"DSS6").lookupAll(IntervalProvider.class).stream().map(IntervalProvider::getIntervals).flatMap(Collection::stream).filter(predicate).collect(Collectors.toSet());
    }

    public static Optional<Interval> findAnyDss7(Predicate<Interval> predicate) {
        return Lookups.forPath((String)"DSS7").lookupAll(IntervalProvider.class).stream().map(IntervalProvider::getIntervals).flatMap(Collection::stream).filter(predicate).findAny();
    }

    public static Set<Interval> findAllDss7(Predicate<Interval> predicate) {
        return Lookups.forPath((String)"DSS7").lookupAll(IntervalProvider.class).stream().map(IntervalProvider::getIntervals).flatMap(Collection::stream).filter(predicate).collect(Collectors.toSet());
    }

    public static Set<Interval> findAll(Predicate<Interval> predicate) {
        return Lookups.forPath((String)"CWMS").lookupAll(IntervalProvider.class).stream().map(IntervalProvider::getIntervals).flatMap(Collection::stream).filter(predicate).collect(Collectors.toSet());
    }

    public static Set<Interval> findAllDss(Predicate<Interval> predicate) {
        return Lookups.forPath((String)"DSS").lookupAll(IntervalProvider.class).stream().map(IntervalProvider::getIntervals).flatMap(Collection::stream).filter(predicate).collect(Collectors.toSet());
    }

    public static Interval irregular() {
        return CwmsIntervals.irregular();
    }

    public static Interval regular1Minute() {
        return CwmsIntervals.regular1Minute();
    }

    public static Interval regular2Minutes() {
        return CwmsIntervals.regular2Minutes();
    }

    public static Interval regular3Minutes() {
        return CwmsIntervals.regular3Minutes();
    }

    public static Interval regular4Minutes() {
        return CwmsIntervals.regular4Minutes();
    }

    public static Interval regular5Minutes() {
        return CwmsIntervals.regular5Minutes();
    }

    public static Interval regular6Minutes() {
        return CwmsIntervals.regular6Minutes();
    }

    public static Interval regular8Minutes() {
        return CwmsIntervals.regular8Minutes();
    }

    public static Interval regular10Minutes() {
        return CwmsIntervals.regular10Minutes();
    }

    public static Interval regular12Minutes() {
        return CwmsIntervals.regular12Minutes();
    }

    public static Interval regular15Minutes() {
        return CwmsIntervals.regular15Minutes();
    }

    public static Interval regular20Minutes() {
        return CwmsIntervals.regular20Minutes();
    }

    public static Interval regular30Minutes() {
        return CwmsIntervals.regular30Minutes();
    }

    public static Interval regular1Hour() {
        return CwmsIntervals.regular1Hour();
    }

    public static Interval regular2Hours() {
        return CwmsIntervals.regular2Hours();
    }

    public static Interval regular3Hours() {
        return CwmsIntervals.regular3Hours();
    }

    public static Interval regular4Hours() {
        return CwmsIntervals.regular4Hours();
    }

    public static Interval regular6Hours() {
        return CwmsIntervals.regular6Hours();
    }

    public static Interval regular8Hours() {
        return CwmsIntervals.regular8Hours();
    }

    public static Interval regular12Hours() {
        return CwmsIntervals.regular12Hours();
    }

    public static Interval regular1Day() {
        return CwmsIntervals.regular1Day();
    }

    public static Interval regular2Days() {
        return CwmsIntervals.regular2Days();
    }

    public static Interval regular3Days() {
        return CwmsIntervals.regular3Days();
    }

    public static Interval regular4Days() {
        return CwmsIntervals.regular4Days();
    }

    public static Interval regular5Days() {
        return CwmsIntervals.regular5Days();
    }

    public static Interval regular6Days() {
        return CwmsIntervals.regular6Days();
    }

    public static Interval regular1Week() {
        return CwmsIntervals.regular1Week();
    }

    public static Interval regular1Month() {
        return CwmsIntervals.regular1Month();
    }

    public static Interval regular1Year() {
        return CwmsIntervals.regular1Year();
    }

    public static Interval regular1Decade() {
        return CwmsIntervals.regular1Decade();
    }

    public static Interval localRegular2Hours() {
        return CwmsIntervals.localRegular2Hours();
    }

    public static Interval localRegular3Hours() {
        return CwmsIntervals.localRegular3Hours();
    }

    public static Interval localRegular4Hours() {
        return CwmsIntervals.localRegular4Hours();
    }

    public static Interval localRegular6Hours() {
        return CwmsIntervals.localRegular6Hours();
    }

    public static Interval localRegular8Hours() {
        return CwmsIntervals.localRegular8Hours();
    }

    public static Interval localRegular12Hours() {
        return CwmsIntervals.localRegular12Hours();
    }

    public static Interval localRegular1Day() {
        return CwmsIntervals.localRegular1Day();
    }

    public static Interval localRegular2Days() {
        return CwmsIntervals.localRegular2Days();
    }

    public static Interval localRegular3Days() {
        return CwmsIntervals.localRegular3Days();
    }

    public static Interval localRegular4Days() {
        return CwmsIntervals.localRegular4Days();
    }

    public static Interval localRegular5Days() {
        return CwmsIntervals.localRegular5Days();
    }

    public static Interval localRegular6Days() {
        return CwmsIntervals.localRegular6Days();
    }

    public static Interval localRegular1Week() {
        return CwmsIntervals.localRegular1Week();
    }

    public static Interval localRegular1Month() {
        return CwmsIntervals.localRegular1Month();
    }

    public static Interval localRegular1Year() {
        return CwmsIntervals.localRegular1Year();
    }

    public static Interval localRegular1Decade() {
        return CwmsIntervals.localRegular1Decade();
    }

    public static Interval pseudoRegular1Minute() {
        return CwmsIntervals.pseudoRegular1Minute();
    }

    public static Interval pseudoRegular2Minutes() {
        return CwmsIntervals.pseudoRegular2Minutes();
    }

    public static Interval pseudoRegular3Minutes() {
        return CwmsIntervals.pseudoRegular3Minutes();
    }

    public static Interval pseudoRegular4Minutes() {
        return CwmsIntervals.pseudoRegular4Minutes();
    }

    public static Interval pseudoRegular5Minutes() {
        return CwmsIntervals.pseudoRegular5Minutes();
    }

    public static Interval pseudoRegular6Minutes() {
        return CwmsIntervals.pseudoRegular6Minutes();
    }

    public static Interval pseudoRegular8Minutes() {
        return CwmsIntervals.pseudoRegular8Minutes();
    }

    public static Interval pseudoRegular10Minutes() {
        return CwmsIntervals.pseudoRegular10Minutes();
    }

    public static Interval pseudoRegular12Minutes() {
        return CwmsIntervals.pseudoRegular12Minutes();
    }

    public static Interval pseudoRegular15Minutes() {
        return CwmsIntervals.pseudoRegular15Minutes();
    }

    public static Interval pseudoRegular20Minutes() {
        return CwmsIntervals.pseudoRegular20Minutes();
    }

    public static Interval pseudoRegular30Minutes() {
        return CwmsIntervals.pseudoRegular30Minutes();
    }

    public static Interval pseudoRegular1Hour() {
        return CwmsIntervals.pseudoRegular1Hour();
    }

    public static Interval pseudoRegular2Hours() {
        return CwmsIntervals.pseudoRegular2Hours();
    }

    public static Interval pseudoRegular3Hours() {
        return CwmsIntervals.pseudoRegular3Hours();
    }

    public static Interval pseudoRegular4Hours() {
        return CwmsIntervals.pseudoRegular4Hours();
    }

    public static Interval pseudoRegular6Hours() {
        return CwmsIntervals.pseudoRegular6Hours();
    }

    public static Interval pseudoRegular8Hours() {
        return CwmsIntervals.pseudoRegular8Hours();
    }

    public static Interval pseudoRegular12Hours() {
        return CwmsIntervals.pseudoRegular12Hours();
    }

    public static Interval pseudoRegular1Day() {
        return CwmsIntervals.pseudoRegular1Day();
    }

    public static Interval pseudoRegular2Days() {
        return CwmsIntervals.pseudoRegular2Days();
    }

    public static Interval pseudoRegular3Days() {
        return CwmsIntervals.pseudoRegular3Days();
    }

    public static Interval pseudoRegular4Days() {
        return CwmsIntervals.pseudoRegular4Days();
    }

    public static Interval pseudoRegular5Days() {
        return CwmsIntervals.pseudoRegular5Days();
    }

    public static Interval pseudoRegular6Days() {
        return CwmsIntervals.pseudoRegular6Days();
    }

    public static Interval pseudoRegular1Week() {
        return CwmsIntervals.pseudoRegular1Week();
    }

    public static Interval pseudoRegular1Month() {
        return CwmsIntervals.pseudoRegular1Month();
    }

    public static Interval pseudoRegular1Year() {
        return CwmsIntervals.pseudoRegular1Year();
    }

    public static Interval pseudoRegular1Decade() {
        return CwmsIntervals.pseudoRegular1Decade();
    }

    public static Interval dssIrregular() {
        return DssIntervals.dssIrregular();
    }

    public static Interval dssRegular1Second() {
        return DssIntervals.dssRegular1Second();
    }

    public static Interval dssRegular2Seconds() {
        return DssIntervals.dssRegular2Seconds();
    }

    public static Interval dssRegular3Seconds() {
        return DssIntervals.dssRegular3Seconds();
    }

    public static Interval dssRegular4Seconds() {
        return DssIntervals.dssRegular4Seconds();
    }

    public static Interval dssRegular5Seconds() {
        return DssIntervals.dssRegular5Seconds();
    }

    public static Interval dssRegular6Seconds() {
        return DssIntervals.dssRegular6Seconds();
    }

    public static Interval dssRegular10Seconds() {
        return DssIntervals.dssRegular10Seconds();
    }

    public static Interval dssRegular15Seconds() {
        return DssIntervals.dssRegular15Seconds();
    }

    public static Interval dssRegular20Seconds() {
        return DssIntervals.dssRegular20Seconds();
    }

    public static Interval dssRegular30Seconds() {
        return DssIntervals.dssRegular30Seconds();
    }

    public static Interval dssRegular1Minute() {
        return DssIntervals.dssRegular1Minute();
    }

    public static Interval dssRegular2Minutes() {
        return DssIntervals.dssRegular2Minutes();
    }

    public static Interval dssRegular3Minutes() {
        return DssIntervals.dssRegular3Minutes();
    }

    public static Interval dssRegular4Minutes() {
        return DssIntervals.dssRegular4Minutes();
    }

    public static Interval dssRegular5Minutes() {
        return DssIntervals.dssRegular5Minutes();
    }

    public static Interval dssRegular6Minutes() {
        return DssIntervals.dssRegular6Minutes();
    }

    public static Interval dssRegular10Minutes() {
        return DssIntervals.dssRegular10Minutes();
    }

    public static Interval dssRegular12Minutes() {
        return DssIntervals.dssRegular12Minutes();
    }

    public static Interval dssRegular15Minutes() {
        return DssIntervals.dssRegular15Minutes();
    }

    public static Interval dssRegular20Minutes() {
        return DssIntervals.dssRegular20Minutes();
    }

    public static Interval dssRegular30Minutes() {
        return DssIntervals.dssRegular30Minutes();
    }

    public static Interval dssRegular1Hour() {
        return DssIntervals.dssRegular1Hour();
    }

    public static Interval dssRegular2Hours() {
        return DssIntervals.dssRegular2Hours();
    }

    public static Interval dssRegular3Hours() {
        return DssIntervals.dssRegular3Hours();
    }

    public static Interval dssRegular4Hours() {
        return DssIntervals.dssRegular4Hours();
    }

    public static Interval dssRegular6Hours() {
        return DssIntervals.dssRegular6Hours();
    }

    public static Interval dssRegular8Hours() {
        return DssIntervals.dssRegular8Hours();
    }

    public static Interval dssRegular12Hours() {
        return DssIntervals.dssRegular12Hours();
    }

    public static Interval dssRegular1Day() {
        return DssIntervals.dssRegular1Day();
    }

    public static Interval dssRegular1Week() {
        return DssIntervals.dssRegular1Week();
    }

    public static Interval dssRegular1Month() {
        return DssIntervals.dssRegular1Month();
    }

    public static Interval dssRegular1Year() {
        return DssIntervals.dssRegular1Year();
    }

    public static Interval dssPseudoRegular1Second() {
        return DssIntervals.dssPseudoRegular1Second();
    }

    public static Interval dssPseudoRegular2Seconds() {
        return DssIntervals.dssPseudoRegular2Seconds();
    }

    public static Interval dssPseudoRegular3Seconds() {
        return DssIntervals.dssPseudoRegular3Seconds();
    }

    public static Interval dssPseudoRegular4Seconds() {
        return DssIntervals.dssPseudoRegular4Seconds();
    }

    public static Interval dssPseudoRegular5Seconds() {
        return DssIntervals.dssPseudoRegular5Seconds();
    }

    public static Interval dssPseudoRegular6Seconds() {
        return DssIntervals.dssPseudoRegular6Seconds();
    }

    public static Interval dssPseudoRegular10Seconds() {
        return DssIntervals.dssPseudoRegular10Seconds();
    }

    public static Interval dssPseudoRegular15Seconds() {
        return DssIntervals.dssPseudoRegular15Seconds();
    }

    public static Interval dssPseudoRegular20Seconds() {
        return DssIntervals.dssPseudoRegular20Seconds();
    }

    public static Interval dssPseudoRegular30Seconds() {
        return DssIntervals.dssPseudoRegular30Seconds();
    }

    public static Interval dssPseudoRegular1Minute() {
        return DssIntervals.dssPseudoRegular1Minute();
    }

    public static Interval dssPseudoRegular2Minutes() {
        return DssIntervals.dssPseudoRegular2Minutes();
    }

    public static Interval dssPseudoRegular3Minutes() {
        return DssIntervals.dssPseudoRegular3Minutes();
    }

    public static Interval dssPseudoRegular4Minutes() {
        return DssIntervals.dssPseudoRegular4Minutes();
    }

    public static Interval dssPseudoRegular5Minutes() {
        return DssIntervals.dssPseudoRegular5Minutes();
    }

    public static Interval dssPseudoRegular6Minutes() {
        return DssIntervals.dssPseudoRegular6Minutes();
    }

    public static Interval dssPseudoRegular10Minutes() {
        return DssIntervals.dssPseudoRegular10Minutes();
    }

    public static Interval dssPseudoRegular12Minutes() {
        return DssIntervals.dssPseudoRegular12Minutes();
    }

    public static Interval dssPseudoRegular15Minutes() {
        return DssIntervals.dssPseudoRegular15Minutes();
    }

    public static Interval dssPseudoRegular20Minutes() {
        return DssIntervals.dssPseudoRegular20Minutes();
    }

    public static Interval dssPseudoRegular30Minutes() {
        return DssIntervals.dssPseudoRegular30Minutes();
    }

    public static Interval dssPseudoRegular1Hour() {
        return DssIntervals.dssPseudoRegular1Hour();
    }

    public static Interval dssPseudoRegular2Hours() {
        return DssIntervals.dssPseudoRegular2Hours();
    }

    public static Interval dssPseudoRegular3Hours() {
        return DssIntervals.dssPseudoRegular3Hours();
    }

    public static Interval dssPseudoRegular4Hours() {
        return DssIntervals.dssPseudoRegular4Hours();
    }

    public static Interval dssPseudoRegular6Hours() {
        return DssIntervals.dssPseudoRegular6Hours();
    }

    public static Interval dssPseudoRegular8Hours() {
        return DssIntervals.dssPseudoRegular8Hours();
    }

    public static Interval dssPseudoRegular12Hours() {
        return DssIntervals.dssPseudoRegular12Hours();
    }

    public static Interval dssPseudoRegular1Day() {
        return DssIntervals.dssPseudoRegular1Day();
    }

    public static Interval dssPseudoRegular1Week() {
        return DssIntervals.dssPseudoRegular1Week();
    }

    public static Interval dssPseudoRegular1Month() {
        return DssIntervals.dssPseudoRegular1Month();
    }

    public static Interval dssPseudoRegular1Year() {
        return DssIntervals.dssPseudoRegular1Year();
    }

    public static Interval dss6Regular1Year() {
        return Dss6Intervals.dss6Regular1Year();
    }

    public static Interval dss6Regular1Mon() {
        return Dss6Intervals.dss6Regular1Mon();
    }

    public static Interval dss6RegularTriMonth() {
        return Dss6Intervals.dss6RegularTriMonth();
    }

    public static Interval dss6RegularSemiMonth() {
        return Dss6Intervals.dss6RegularSemiMonth();
    }

    public static Interval dss6Regular1Week() {
        return Dss6Intervals.dss6Regular1Week();
    }

    public static Interval dss6Regular1Day() {
        return Dss6Intervals.dss6Regular1Day();
    }

    public static Interval dss6Regular12Hours() {
        return Dss6Intervals.dss6Regular12Hours();
    }

    public static Interval dss6Regular8Hours() {
        return Dss6Intervals.dss6Regular8Hours();
    }

    public static Interval dss6Regular6Hours() {
        return Dss6Intervals.dss6Regular6Hours();
    }

    public static Interval dss6Regular4Hours() {
        return Dss6Intervals.dss6Regular4Hours();
    }

    public static Interval dss6Regular3Hours() {
        return Dss6Intervals.dss6Regular3Hours();
    }

    public static Interval dss6Regular2Hours() {
        return Dss6Intervals.dss6Regular2Hours();
    }

    public static Interval dss6Regular1Hour() {
        return Dss6Intervals.dss6Regular1Hour();
    }

    public static Interval dss6Regular30Minutes() {
        return Dss6Intervals.dss6Regular30Minutes();
    }

    public static Interval dss6Regular20Minutes() {
        return Dss6Intervals.dss6Regular20Minutes();
    }

    public static Interval dss6Regular15Minutes() {
        return Dss6Intervals.dss6Regular15Minutes();
    }

    public static Interval dss6Regular12Minutes() {
        return Dss6Intervals.dss6Regular12Minutes();
    }

    public static Interval dss6Regular10Minutes() {
        return Dss6Intervals.dss6Regular10Minutes();
    }

    public static Interval dss6Regular6Minutes() {
        return Dss6Intervals.dss6Regular6Minutes();
    }

    public static Interval dss6Regular5Minutes() {
        return Dss6Intervals.dss6Regular5Minutes();
    }

    public static Interval dss6Regular4Minutes() {
        return Dss6Intervals.dss6Regular4Minutes();
    }

    public static Interval dss6Regular3Minutes() {
        return Dss6Intervals.dss6Regular3Minutes();
    }

    public static Interval dss6Regular2Minutes() {
        return Dss6Intervals.dss6Regular2Minutes();
    }

    public static Interval dss6Regular1Minute() {
        return Dss6Intervals.dss6Regular1Minute();
    }

    public static Interval dss6IrregularCentury() {
        return Dss6Intervals.dss6IrregularCentury();
    }

    public static Interval dss6IrregularDecade() {
        return Dss6Intervals.dss6IrregularDecade();
    }

    public static Interval dss6IrregularYear() {
        return Dss6Intervals.dss6IrregularYear();
    }

    public static Interval dss6IrregularMonth() {
        return Dss6Intervals.dss6IrregularMonth();
    }

    public static Interval dss6IrregularDay() {
        return Dss6Intervals.dss6IrregularDay();
    }

    public static boolean useNewLocalRegularId() {
        return USE_NEW_LOCAL_REGULAR_ID;
    }
}

