/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata;

import java.io.Serializable;
import java.time.Duration;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.TemporalAmount;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import mil.army.usace.hec.metadata.IllegalIntervalOffsetException;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalOffsetPart;

public final class IntervalOffset
implements Serializable {
    public static final int NO_OFFSET = Integer.MIN_VALUE;
    public static final String NO_OFFSET_STRING = "N/A";
    public static final int UNDEFINED_OFFSET = Integer.MAX_VALUE;
    public static final String UNDEFINED_OFFSET_STRING = "UNDEFINED";
    private static final long serialVersionUID = 687139346755105016L;
    private final int _offsetSeconds;

    private IntervalOffset(int offsetSeconds) {
        this._offsetSeconds = offsetSeconds;
    }

    public static IntervalOffset fromSeconds(int offsetSeconds) {
        return new IntervalOffset(offsetSeconds);
    }

    public static IntervalOffset fromString(String intervalOffsetString) throws IllegalIntervalOffsetException {
        IntervalOffset retval = IntervalOffset.zeroOffset();
        if (!"0".equals(intervalOffsetString)) {
            if (intervalOffsetString.equalsIgnoreCase(NO_OFFSET_STRING)) {
                retval = IntervalOffset.noOffset();
            } else if (intervalOffsetString.equalsIgnoreCase(UNDEFINED_OFFSET_STRING)) {
                retval = IntervalOffset.undefinedOffset();
            } else {
                try {
                    List parts = Arrays.stream(PartCharacter.values()).map(partCharacter -> IntervalOffset.patternMatchPart(intervalOffsetString, partCharacter)).filter(Objects::nonNull).collect(Collectors.toList());
                    if (parts.isEmpty()) {
                        String error = "Invalid interval offset, " + intervalOffsetString + ".";
                        throw new IllegalIntervalOffsetException(error);
                    }
                    retval = IntervalOffset.fromSeconds(IntervalOffset.computeIntervalOffset(parts));
                }
                catch (NumberFormatException ex) {
                    String error = "Invalid interval offset, " + intervalOffsetString + ".";
                    throw new IllegalIntervalOffsetException(error);
                }
            }
        }
        return retval;
    }

    public static IntervalOffset convertIntervalOffset(IntervalOffset fromIntervalOffset, Interval interval, ZoneId fromZoneId, ZonedDateTime forZonedDateTime) {
        int toIntervalOffsetSeconds;
        if (interval.isIrregular()) {
            return IntervalOffset.noOffset();
        }
        int fromIntervalOffsetSeconds = Math.abs(fromIntervalOffset.getOffsetSeconds());
        ZoneOffset fromZoneOffset = fromZoneId.getRules().getOffset(forZonedDateTime.toInstant());
        ZoneOffset toZoneOffset = forZonedDateTime.getZone().getRules().getOffset(forZonedDateTime.toInstant());
        for (toIntervalOffsetSeconds = fromIntervalOffsetSeconds - (fromZoneOffset.getTotalSeconds() - toZoneOffset.getTotalSeconds()); toIntervalOffsetSeconds < 0; toIntervalOffsetSeconds += interval.getSeconds()) {
        }
        toIntervalOffsetSeconds %= interval.getSeconds();
        if (!interval.isRegular()) {
            toIntervalOffsetSeconds *= -1;
        }
        return IntervalOffset.fromSeconds(toIntervalOffsetSeconds);
    }

    private static IntervalOffsetPart patternMatchPart(String intervalOffsetString, PartCharacter partCharacter) {
        IntervalOffsetPart intervalOffsetPart = null;
        Matcher matcher = Pattern.compile("-?\\d*" + partCharacter.getCharacter()).matcher(intervalOffsetString);
        if (matcher.find()) {
            String group = matcher.group();
            String digit = group.replace("" + partCharacter.getCharacter(), "");
            int value = Integer.parseInt(digit);
            intervalOffsetPart = new IntervalOffsetPart(value, partCharacter.getCharacter(), partCharacter.getTemporalAmount(Math.abs(value)));
        } else {
            Matcher aliasMatcher = Pattern.compile("-?\\d*" + partCharacter.getAlias()).matcher(intervalOffsetString);
            if (aliasMatcher.find()) {
                String group = aliasMatcher.group();
                String digit = group.replace("" + partCharacter.getAlias(), "");
                int value = Integer.parseInt(digit);
                intervalOffsetPart = new IntervalOffsetPart(value, partCharacter.getCharacter(), partCharacter.getTemporalAmount(Math.abs(value)));
            }
        }
        return intervalOffsetPart;
    }

    public static int computeIntervalOffset(List<? extends IntervalOffsetPart> partsList) {
        int intervalOffset = 0;
        boolean foundDefinedPart = false;
        boolean hasNegative = false;
        for (IntervalOffsetPart intervalOffsetPart : partsList) {
            int partOffset = intervalOffsetPart.getOffset();
            if (partOffset == Integer.MAX_VALUE) continue;
            intervalOffset += Math.abs(partOffset);
            foundDefinedPart = true;
            if (partOffset >= 0) continue;
            hasNegative = true;
        }
        if (!foundDefinedPart) {
            intervalOffset = Integer.MAX_VALUE;
        }
        if (hasNegative) {
            intervalOffset *= -1;
        }
        return intervalOffset;
    }

    public static IntervalOffset undefinedOffset() {
        return IntervalOffset.fromSeconds(Integer.MAX_VALUE);
    }

    public static IntervalOffset noOffset() {
        return IntervalOffset.fromSeconds(Integer.MIN_VALUE);
    }

    public static IntervalOffset zeroOffset() {
        return IntervalOffset.fromSeconds(0);
    }

    public static String getIntervalOffsetString(int offsetSeconds) {
        switch (offsetSeconds) {
            case -2147483648: {
                return NO_OFFSET_STRING;
            }
            case 0x7FFFFFFF: {
                return UNDEFINED_OFFSET_STRING;
            }
        }
        int years = offsetSeconds / 31536000;
        int remainder = offsetSeconds % 31536000;
        int months = remainder / 2592000;
        int days = (remainder %= 2592000) / 86400;
        int hours = (remainder %= 86400) / 3600;
        int minutes = (remainder %= 3600) / 60;
        int seconds = remainder % 60;
        StringBuilder sb = new StringBuilder();
        IntervalOffset.buildOffsetString(sb, years, PartCharacter.YEAR.getCharacter() + " ");
        IntervalOffset.buildOffsetString(sb, months, PartCharacter.MONTH.getCharacter() + " ");
        IntervalOffset.buildOffsetString(sb, days, PartCharacter.DAY.getCharacter() + " ");
        IntervalOffset.buildOffsetString(sb, hours, PartCharacter.HOUR.getCharacter() + " ");
        IntervalOffset.buildOffsetString(sb, minutes, PartCharacter.MINUTE.getCharacter() + " ");
        IntervalOffset.buildOffsetString(sb, seconds, PartCharacter.SECOND.getCharacter() + " ");
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        } else {
            sb.append("0s");
        }
        return sb.toString();
    }

    private static void buildOffsetString(StringBuilder sb, int val, String label) {
        if (val != 0) {
            sb.append(val);
            sb.append(label);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalOffset that = (IntervalOffset)o;
        return this._offsetSeconds == that._offsetSeconds;
    }

    public int hashCode() {
        return Objects.hash(this._offsetSeconds);
    }

    public List<IntervalOffsetPart> buildPartsList(int offset) {
        ArrayList<IntervalOffsetPart> retval = new ArrayList<IntervalOffsetPart>();
        switch (offset) {
            case -2147483648: 
            case 0x7FFFFFFF: {
                break;
            }
            default: {
                int years = offset / 31536000;
                int remainder = offset % 31536000;
                int months = remainder / 2592000;
                int days = (remainder %= 2592000) / 86400;
                int hours = (remainder %= 86400) / 3600;
                int minutes = (remainder %= 3600) / 60;
                int seconds = remainder % 60;
                retval.add(new IntervalOffsetPart(years, PartCharacter.YEAR.getCharacter(), Period.ofYears(Math.abs(years))));
                retval.add(new IntervalOffsetPart(months, PartCharacter.MONTH.getCharacter(), Period.ofMonths(Math.abs(months))));
                retval.add(new IntervalOffsetPart(days, PartCharacter.DAY.getCharacter(), Period.ofDays(Math.abs(days))));
                retval.add(new IntervalOffsetPart(hours, PartCharacter.HOUR.getCharacter(), Duration.ofHours(Math.abs(hours))));
                retval.add(new IntervalOffsetPart(minutes, PartCharacter.MINUTE.getCharacter(), Duration.ofMinutes(Math.abs(minutes))));
                retval.add(new IntervalOffsetPart(seconds, PartCharacter.SECOND.getCharacter(), Duration.ofSeconds(Math.abs(seconds))));
            }
        }
        return retval;
    }

    public String getIntervalOffsetString() {
        int offset = this.getOffsetSeconds();
        return IntervalOffset.getIntervalOffsetString(offset);
    }

    public String toString() {
        return this.getIntervalOffsetString();
    }

    public long getOffsetMillis() {
        int offsetSeconds = this.getOffsetSeconds();
        return TimeUnit.SECONDS.toMillis(offsetSeconds);
    }

    public int getOffsetSeconds() {
        return this._offsetSeconds;
    }

    public List<TemporalAmount> getOffsets() {
        ArrayList<TemporalAmount> retval = new ArrayList<TemporalAmount>();
        for (IntervalOffsetPart intervalOffsetParts : this.buildPartsList(this._offsetSeconds)) {
            TemporalAmount temporalAmount = intervalOffsetParts.getTemporalAmount();
            retval.add(temporalAmount);
        }
        return retval;
    }

    public long getOffsetMinutes() {
        if (this.isDefined()) {
            return this.getOffsetSeconds() / 60;
        }
        return this.getOffsetSeconds();
    }

    public static IntervalOffset fromMinutes(long minutes) {
        if (IntervalOffset.isDefined((int)minutes)) {
            return IntervalOffset.fromSeconds((int)(minutes * 60L));
        }
        return new IntervalOffset((int)minutes);
    }

    public boolean isDefined() {
        return IntervalOffset.isDefined(this.getOffsetSeconds());
    }

    public boolean isUndefined() {
        return !this.isDefined();
    }

    public boolean isNoOffset() {
        return IntervalOffset.isNoOffset(this.getOffsetSeconds());
    }

    public static boolean isDefined(int offsetSeconds) {
        return offsetSeconds != Integer.MIN_VALUE && offsetSeconds != Integer.MAX_VALUE;
    }

    public static boolean isNoOffset(int offsetSeconds) {
        return offsetSeconds == Integer.MIN_VALUE;
    }

    private static enum PartCharacter {
        YEAR('Y', 'y', Period::ofYears),
        MONTH('M', 'M', Period::ofMonths),
        DAY('D', 'd', Period::ofDays),
        HOUR('h', 'H', Duration::ofHours),
        MINUTE('m', 'm', Duration::ofMinutes),
        SECOND('s', 'S', Duration::ofSeconds);

        private final char _character;
        private final char _alias;
        private final Function<Integer, TemporalAmount> _temporalAmountFunction;

        private PartCharacter(char character, char alias, Function<Integer, TemporalAmount> temporalAmountFunction) {
            this._character = character;
            this._alias = alias;
            this._temporalAmountFunction = temporalAmountFunction;
        }

        private char getAlias() {
            return this._alias;
        }

        private char getCharacter() {
            return this._character;
        }

        TemporalAmount getTemporalAmount(int value) {
            return this._temporalAmountFunction.apply(value);
        }
    }
}

