/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata;

import java.time.temporal.TemporalAmount;
import java.util.Objects;

public class IntervalOffsetPart {
    private final TemporalAmount _temporalAmount;
    private final int _digits;
    private final char _letter;

    public IntervalOffsetPart(int digits, char type, TemporalAmount temporalAmount) {
        this._digits = digits;
        this._letter = type;
        this._temporalAmount = temporalAmount;
    }

    public IntervalOffsetPart(IntervalOffsetPart intervalOffsetPart) {
        this._digits = intervalOffsetPart._digits;
        this._letter = intervalOffsetPart._letter;
        this._temporalAmount = intervalOffsetPart._temporalAmount;
    }

    TemporalAmount getTemporalAmount() {
        return this._temporalAmount;
    }

    public final char getType() {
        return this._letter;
    }

    public final int getDigits() {
        return this._digits;
    }

    public final int getOffset() {
        if (this._digits == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        int base = this.getBase();
        return base * this._digits;
    }

    public final int getBase() {
        int retval;
        switch (this._letter) {
            case 'Y': 
            case 'y': {
                retval = 31536000;
                break;
            }
            case 'M': {
                retval = 2592000;
                break;
            }
            case 'D': 
            case 'd': {
                retval = 86400;
                break;
            }
            case 'H': 
            case 'h': {
                retval = 3600;
                break;
            }
            case 'm': {
                retval = 60;
                break;
            }
            case 'S': 
            case 's': {
                retval = 1;
                break;
            }
            default: {
                retval = 0;
            }
        }
        return retval;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalOffsetPart that = (IntervalOffsetPart)o;
        return this.getOffset() == that.getOffset();
    }

    public int hashCode() {
        return Objects.hash(this.getOffset());
    }
}

