/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata;

import java.io.Serializable;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class LocationID
implements Serializable {
    private static final long serialVersionUID = 7043710881605234732L;
    private final String _baseLocation;
    private final String _subLocation;
    private final String _location;
    private final ZoneId _zoneId;

    public LocationID() {
        this("", (ZoneId)null);
    }

    public LocationID(String location) {
        this(location, (ZoneId)null);
    }

    public LocationID(String location, ZoneId zoneId) {
        this._zoneId = zoneId;
        this._location = location;
        int index = location.indexOf("-");
        if (index != -1) {
            this._baseLocation = location.substring(0, index).trim();
            this._subLocation = location.substring(index + 1).trim();
        } else {
            this._baseLocation = location;
            this._subLocation = "";
        }
    }

    public LocationID(String baseLocation, String subLocation) {
        this(baseLocation, subLocation, NumericalConstants.UTC_ZONEID);
    }

    public LocationID(String baseLocation, String subLocation, ZoneId zoneId) {
        this._baseLocation = baseLocation.trim();
        if (subLocation != null && !"".equals(subLocation)) {
            this._subLocation = subLocation.trim();
            this._location = this._baseLocation + "-" + this._subLocation;
        } else {
            this._subLocation = "";
            this._location = this._baseLocation;
        }
        this._zoneId = zoneId;
    }

    public LocationID(LocationID locationID) {
        this._baseLocation = locationID._baseLocation;
        this._subLocation = locationID._subLocation;
        this._location = locationID._location;
        this._zoneId = locationID._zoneId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocationID that = (LocationID)o;
        return this.getLocation().equalsIgnoreCase(that.getLocation()) && Objects.equals(this.getZoneId(), that.getZoneId());
    }

    public int hashCode() {
        return Objects.hash(this.getLocation().toLowerCase(), this.getZoneId());
    }

    public String toString() {
        return this._location;
    }

    public String getLocation() {
        return this._location;
    }

    public String getSubLocation() {
        return this._subLocation;
    }

    public String getBaseLocation() {
        return this._baseLocation;
    }

    public boolean hasSubLocation() {
        return this._subLocation != null && !"".equals(this._subLocation);
    }

    public Optional<ZoneId> getZoneId() {
        return Optional.ofNullable(this._zoneId);
    }
}

