/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata;

import java.io.Serializable;
import java.util.Optional;
import mil.army.usace.hec.metadata.XMLUtilities;
import org.jdom.Element;

public class OfficeId
implements Serializable {
    public static final String DB_OFFICE_ID = "db_office_id";
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String TYPE = "office_type";
    public static final String REPORTS_TO = "reports_to";
    private static final long serialVersionUID = 5113810008162179095L;
    private final String _officeId;
    private final String _officeName;
    private final String _officeType;
    private final String _reportsToOffice;

    public OfficeId(String officeId, String officeName) {
        this(officeId, officeName, null, null);
    }

    public OfficeId(OfficeId dbOfficeId) {
        this._officeId = dbOfficeId._officeId;
        this._officeName = dbOfficeId._officeName;
        this._officeType = dbOfficeId._officeType;
        this._reportsToOffice = dbOfficeId._reportsToOffice;
    }

    public OfficeId(String officeId) {
        this(officeId, "");
    }

    public OfficeId(String officeId, String officeName, String officeType, String reportToOfficeId) {
        this._officeId = officeId;
        this._officeName = officeName;
        this._officeType = officeType;
        this._reportsToOffice = reportToOfficeId;
    }

    public static OfficeId parse(Element element) {
        if (element == null) {
            return null;
        }
        String officeId = element.getAttributeValue(ID);
        if (officeId == null) {
            return null;
        }
        Element child = element.getChild(NAME);
        String officeName = "";
        if (child != null) {
            officeName = child.getText();
        }
        String type = element.getAttributeValue(TYPE);
        String reportsTo = element.getAttributeValue(REPORTS_TO);
        return new OfficeId(officeId, officeName, type, reportsTo);
    }

    public final String getOfficeId() {
        return this._officeId;
    }

    public final String getOfficeName() {
        return this._officeName;
    }

    public final void buildElement(Element dbOfficeElement) {
        if (dbOfficeElement == null) {
            return;
        }
        String officeId = this.getOfficeId();
        if (officeId != null) {
            dbOfficeElement.setAttribute(ID, officeId);
            this.getOfficeType().ifPresent(officeType -> dbOfficeElement.setAttribute(TYPE, officeType));
            this.getReportsToOffice().ifPresent(reportsTo -> dbOfficeElement.setAttribute(REPORTS_TO, reportsTo));
        }
        if (this._officeName != null && !this._officeName.isEmpty()) {
            Element child = XMLUtilities.getOrCreateChild(dbOfficeElement, NAME);
            child.setText(this._officeName);
        } else {
            dbOfficeElement.removeChild(NAME);
        }
    }

    public final Optional<String> getOfficeType() {
        return Optional.ofNullable(this._officeType);
    }

    public final Optional<String> getReportsToOffice() {
        return Optional.ofNullable(this._reportsToOffice);
    }

    public final int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._officeId == null ? 0 : this._officeId.toUpperCase().hashCode());
        return result;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OfficeId other = (OfficeId)obj;
        return this._officeId == null ? other._officeId == null : this._officeId.equalsIgnoreCase(other._officeId);
    }

    public final String toString() {
        return this._officeId;
    }
}

