/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata;

import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.UnitUtil;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.resourceservices.ParameterLookup;

public class Parameter
implements Serializable {
    public static final int UNDEF_PARAMETER_ID = -1;
    public static final int PARAMID_PERCENT = Parameter.generateParameterId(0, 65535);
    public static final int PARAMID_AREA = Parameter.generateParameterId(1, 65535);
    public static final int PARAMID_CONC = Parameter.generateParameterId(3, 65535);
    public static final int PARAMID_COUNT = Parameter.generateParameterId(5, 65535);
    public static final int PARAMID_CURRENCY = Parameter.generateParameterId(6, 65535);
    public static final int PARAMID_DEPTH = Parameter.generateParameterId(7, 65535);
    public static final int PARAMID_ELEV = Parameter.generateParameterId(9, 65535);
    public static final int PARAMID_EVAP = Parameter.generateParameterId(11, 65535);
    public static final int PARAMID_EVAPRATE = Parameter.generateParameterId(12, 65535);
    public static final int PARAMID_FLOW = Parameter.generateParameterId(13, 65535);
    public static final int PARAMID_LENGTH = Parameter.generateParameterId(15, 65535);
    public static final int PARAMID_OPENING = Parameter.generateParameterId(16, 65535);
    public static final int PARAMID_PERCRATE = Parameter.generateParameterId(17, 65535);
    public static final int PARAMID_PERC = Parameter.generateParameterId(45, 65535);
    public static final int PARAMID_PRECIP = Parameter.generateParameterId(20, 65535);
    public static final int PARAMID_STAGE = Parameter.generateParameterId(24, 65535);
    public static final int PARAMID_STOR = Parameter.generateParameterId(25, 65535);
    public static final int PARAMID_TEMP = Parameter.generateParameterId(26, 65535);
    public static final int PARAMID_WIDTH = Parameter.generateParameterId(31, 65535);
    public static final int PARAMID_LOSSDEFICIT = Parameter.generateParameterId(33, 65535);
    public static final int PARAMID_LOSSRATE = Parameter.generateParameterId(32, 65535);
    public static final int PARAMID_POWER = Parameter.generateParameterId(19, 65535);
    public static final int PARAMID_ENERGY = Parameter.generateParameterId(10, 65535);
    public static final int PARAMID_TRAVEL = Parameter.generateParameterId(34, 65535);
    public static final int PARAMID_SPINRATE = Parameter.generateParameterId(35, 65535);
    public static final int PARAMID_SPEED = Parameter.generateParameterId(23, 65535);
    public static final int PARAMID_FLOWPERAREA = Parameter.generateParameterId(36, 65535);
    public static final int PARAMID_MELTRATE = Parameter.generateParameterId(38, 65535);
    public static final int PARAMID_PENALTY = Parameter.generateParameterId(39, 65535);
    public static final int PARAMID_THICKNESS = Parameter.generateParameterId(27, 65535);
    public static final int PARAMID_SEDIMENT_DISCHARGE = Parameter.generateParameterId(46, 65535);
    public static final int PARAMID_SED_SIZE = Parameter.generateParameterId(47, 65535);
    public static final int PARAMID_BOTTOM_LENGTH = Parameter.generateParameterId(48, 65535);
    public static final int PARAMID_DEPOSITION = Parameter.generateParameterId(49, 65535);
    public static final int PARAMID_VOLUME = Parameter.generateParameterId(50, 65535);
    public static final int PARAMID_SED_LOAD = Parameter.generateParameterId(51, 65535);
    public static final int PARAMID_DISTANCE = Parameter.generateParameterId(43, 65535);
    public static final int PARAMID_RATE_OF_RISE = Parameter.generateParameterId(52, 65535);
    public static final int PARAMID_GROWTH_RATE = Parameter.generateParameterId(53, 65535);
    public static final int PARAMID_DENSITY = Parameter.generateParameterId(55, 65535);
    public static final int PARAMID_EXTINCTION = Parameter.generateParameterId(56, 65535);
    public static final int PARAMID_SHADE_FRAC = Parameter.generateParameterId(57, 65535);
    public static final int PARAMID_SUSP_SOLIDS = Parameter.generateParameterId(58, 65535);
    public static final int PARAMID_PRESSURE = Parameter.generateParameterId(21, 65535);
    public static final int PARAMID_TIMING = Parameter.generateParameterId(28, 65535);
    public static final int PARAMID_ATI = Parameter.generateParameterId(59, 65535);
    public static final int PARAMID_COLDRATE = Parameter.generateParameterId(60, 65535);
    public static final int PARAMID_COEFF = Parameter.generateParameterId(61, 65535);
    public static final int PARAMID_PROBABILITY = Parameter.generateParameterId(62, 65535);
    public static final int PARAMID_AREABASIN = Parameter.generateParameterId(PARAMID_AREA, 0);
    public static final int PARAMID_AREAIMPACTED = Parameter.generateParameterId(PARAMID_AREA, 1);
    public static final int PARAMID_AREARESERVOIR = Parameter.generateParameterId(PARAMID_AREA, 2);
    public static final int PARAMID_AREASURFACE = Parameter.generateParameterId(PARAMID_AREA, 3);
    public static final int PARAMID_SALINITY = Parameter.generateParameterId(PARAMID_CONC, 0);
    public static final int PARAMID_STORKAF = Parameter.generateParameterId(PARAMID_STOR, 0);
    public static final int PARAMID_FLOWKAF = Parameter.generateParameterId(13, 0);
    public static final int PARAMID_COSTKAF = Parameter.generateParameterId(PARAMID_CURRENCY, 0);
    public static final int PARAMID_AREAKA = Parameter.generateParameterId(PARAMID_AREA, 4);
    public static final int PARAMID_TIMING_OFFSET = Parameter.generateParameterId(PARAMID_TIMING, 0);
    public static final int PARAMID_TIMING_PERIOD = Parameter.generateParameterId(PARAMID_TIMING, 1);
    private static final long serialVersionUID = 7786026790168793992L;
    private static final Logger LOGGER = Logger.getLogger(Parameter.class.getName());
    private String _baseParameter = "";
    private String _baseParameterUnits = "undef";
    private String _subParameter = "";

    public Parameter() {
    }

    public Parameter(String parameter) throws DataSetIllegalArgumentException {
        this(ParameterLookup.parseBaseParameter(parameter), ParameterLookup.parseSubParameter(parameter));
    }

    public Parameter(String baseParameter, String subParameter) throws DataSetIllegalArgumentException {
        this.setParameter(baseParameter, subParameter);
    }

    public Parameter(Parameter parameter) {
        this._baseParameter = parameter._baseParameter;
        this._baseParameterUnits = parameter._baseParameterUnits;
        this._subParameter = parameter._subParameter;
    }

    public static Parameter getParameterForUnitsString(String units) {
        Parameter retval = null;
        String parameterForUnitsString = ParameterLookup.getParameterForUnitsString(units);
        if (parameterForUnitsString != null) {
            try {
                retval = new Parameter(parameterForUnitsString);
            }
            catch (DataSetIllegalArgumentException e) {
                LOGGER.log(Level.FINE, e, () -> "Unable to find parameter for units: " + units);
            }
        }
        return retval;
    }

    public static Parameter getParameter(int paramID) throws DataSetIllegalArgumentException {
        String fullName = ParameterLookup.getFullParamString(paramID);
        return new Parameter(fullName);
    }

    public static int generateParameterId(int paramIndex, int altSubParamIndex) {
        return altSubParamIndex << 16 & 0xFFFF0000 | 0xFFFF & paramIndex;
    }

    public void setParameter(String baseParameter, String subParameter) throws DataSetIllegalArgumentException {
        this.setBaseParameter(baseParameter);
        this.setSubParameter(subParameter);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._baseParameter == null ? 0 : this._baseParameter.toUpperCase().hashCode());
        result = 31 * result + (this._subParameter == null ? 0 : this._subParameter.toUpperCase().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this._baseParameter == null ? other._baseParameter != null : !this._baseParameter.equalsIgnoreCase(other._baseParameter)) {
            return false;
        }
        if (this._subParameter == null) {
            return other._subParameter == null;
        }
        return this._subParameter.equalsIgnoreCase(other._subParameter);
    }

    public boolean baseParameterMatches(Parameter parameter) {
        return this._baseParameter.equalsIgnoreCase(parameter._baseParameter);
    }

    public String toString() {
        return this.getParameter();
    }

    public Units getDefaultUnits() {
        Units units;
        try {
            units = new Units(this.getUnitsString());
        }
        catch (DataSetIllegalArgumentException e) {
            LOGGER.log(Level.FINE, e, () -> "Unable to parse units from string + " + this.getUnitsString());
            units = null;
        }
        return units;
    }

    public String getUnitsString() {
        return this.getUnitsStringForSystem(2);
    }

    public String getParameter() {
        if (this._subParameter == null || this._subParameter.isEmpty()) {
            return this._baseParameter;
        }
        return this._baseParameter + "-" + this._subParameter;
    }

    public void setParameter(String parameter) throws DataSetIllegalArgumentException {
        this.setParameter(ParameterLookup.parseBaseParameter(parameter), ParameterLookup.parseSubParameter(parameter));
    }

    public String getSubParameter() {
        return this._subParameter;
    }

    public void setSubParameter(String subParameter) {
        this._subParameter = subParameter.trim();
    }

    public String getBaseParameter() {
        return this._baseParameter;
    }

    public void setBaseParameter(String baseParameter) throws DataSetIllegalArgumentException {
        if (ParameterLookup.isNotValid(baseParameter)) {
            throw new DataSetIllegalArgumentException("Base parameter name: \"" + baseParameter + "\" is not valid.");
        }
        this._baseParameter = ParameterLookup.getBaseParameterProperCase(baseParameter.trim());
        this._baseParameterUnits = ParameterLookup.getUnitsStringForSystem(this._baseParameter, 2);
    }

    public boolean hasSubParameter() {
        return this._subParameter != null && !"".equals(this._subParameter);
    }

    public int getParameterId() {
        return ParameterLookup.getParameterId(this._baseParameter, this._subParameter);
    }

    public String getUnitsStringForSystem(int unitSystem) {
        if (!UnitUtil.isValidUnitsSystem(unitSystem)) {
            throw new IllegalArgumentException("ERROR: <getUnitsStringForSystem()> invalid unit system");
        }
        int index = ParameterLookup.getBaseParameterIndex(this.getBaseParameter());
        if (index == -1) {
            return "undef";
        }
        return ParameterLookup.getUnitsStringForSystem(index, this._subParameter, unitSystem);
    }
}

