/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;

public class ParameterType
implements Serializable {
    public static final String INST = "Inst";
    public static final String TOTAL = "Total";
    public static final String MAX = "Max";
    public static final String MIN = "Min";
    public static final String AVE = "Ave";
    public static final String CONST = "Const";
    private static final ParameterType INST_TYPE;
    private static final ParameterType TOTAL_TYPE;
    private static final ParameterType MAX_TYPE;
    private static final ParameterType MIN_TYPE;
    private static final ParameterType AVE_TYPE;
    private static final ParameterType CONST_TYPE;
    private static final long serialVersionUID = -5201680547958331896L;
    private static final String[] TYPES;
    private static final List<ParameterType> PARAMETER_TYPES;
    private final String _type;

    private ParameterType(String type) throws DataSetIllegalArgumentException {
        this._type = Arrays.stream(TYPES).filter(s -> s.equalsIgnoreCase(type)).findAny().orElseThrow(() -> new DataSetIllegalArgumentException("Parameter type name: \"" + type + "\" is not valid."));
    }

    private ParameterType(ParameterType parameterType) {
        this._type = parameterType._type;
    }

    public static ParameterType from(String description) throws DataSetIllegalArgumentException {
        return new ParameterType(description);
    }

    public static ParameterType averageType() {
        return AVE_TYPE;
    }

    public static ParameterType instantaneousType() {
        return INST_TYPE;
    }

    public static ParameterType totalType() {
        return TOTAL_TYPE;
    }

    public static ParameterType constantType() {
        return CONST_TYPE;
    }

    public static ParameterType mininmumType() {
        return MIN_TYPE;
    }

    public static ParameterType maximumType() {
        return MAX_TYPE;
    }

    public static String[] getAvailableParameterTypes() {
        return (String[])TYPES.clone();
    }

    public static List<ParameterType> getAllParameterTypes() {
        return Collections.unmodifiableList(PARAMETER_TYPES);
    }

    public int hashCode() {
        return this._type.toUpperCase().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterType other = (ParameterType)obj;
        return Objects.equals(this._type, other._type) || this._type != null && this._type.equalsIgnoreCase(other._type);
    }

    public String toString() {
        return this._type;
    }

    public String getParameterType() {
        return this._type;
    }

    public boolean isInstantaneous() {
        return INST.equalsIgnoreCase(this._type);
    }

    public boolean isTotal() {
        return TOTAL.equalsIgnoreCase(this._type);
    }

    public boolean isAverage() {
        return AVE.equalsIgnoreCase(this._type);
    }

    public boolean isMinimum() {
        return this._type.equalsIgnoreCase(MIN);
    }

    public boolean isMaximum() {
        return this._type.equalsIgnoreCase(MAX);
    }

    static {
        TYPES = new String[]{INST, TOTAL, MAX, MIN, AVE, CONST};
        try {
            INST_TYPE = new ParameterType(INST);
            TOTAL_TYPE = new ParameterType(TOTAL);
            MAX_TYPE = new ParameterType(MAX);
            MIN_TYPE = new ParameterType(MIN);
            AVE_TYPE = new ParameterType(AVE);
            CONST_TYPE = new ParameterType(CONST);
        }
        catch (DataSetIllegalArgumentException ex) {
            throw new IllegalArgumentException("Error in static initialization of ParameterType defaults", ex);
        }
        PARAMETER_TYPES = Arrays.asList(INST_TYPE, TOTAL_TYPE, MAX_TYPE, MIN_TYPE, AVE_TYPE, CONST_TYPE);
    }
}

