/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.Units;
import mil.army.usace.hec.metadata.UnitsConversionException;
import mil.army.usace.hec.metadata.constants.NumericalConstants;
import mil.army.usace.hec.metadata.math.RpnFunction;
import mil.army.usace.hec.metadata.resourceservices.ParameterLookup;

public final class UnitUtil {
    public static final String FILEPATH = "config/db/definitions/unitConversions.def";
    public static final String FILEURL = "hec/heclib/util/unitConversions.def";
    private static final Logger LOGGER = Logger.getLogger(UnitUtil.class.getName());
    private static final NavigableMap<String, NavigableSet<String>> _unitMap = new TreeMap<String, NavigableSet<String>>();
    private static final Map<String, Map<String, ConvFunction>> _unitConvFrom = new HashMap<String, Map<String, ConvFunction>>();
    private static final Map<String, String> _aliasToUnitMap = new HashMap<String, String>();
    public static final String UNDEFINED_UNITS = "undef";
    public static final int UNDEF_ID = 0;
    public static final String SI = "SI";
    public static final int SI_ID = 2;
    public static final String ENGLISH = "English";
    public static final int ENGLISH_ID = 1;
    public static final int AS_STORED_ID = 3;
    public static final String AS_STORED = "As Stored";
    public static final String ERROR_VALID_UNIT_SYSTEMS = "(2) SI (1) English";
    private static String[] UNITS = null;
    private static Map<String, Double> lookupConversionFactor = null;
    private static Map<String, String> unitAliasTable = null;

    private UnitUtil() {
        throw new AssertionError((Object)"Utility class");
    }

    private static void loadDefaultUnits() {
        String[] unitSystems;
        unitAliasTable = UnitUtil.getUnitsAliasTable();
        String[] unitsTemp = UnitUtil.getUnitTypes();
        String[] scalarUnits = new String[]{"m", "mm", "m2", "cms", "in", "ft", "ac-ft", "cfs"};
        int numberMatches = 0;
        for (String item : unitsTemp) {
            for (String scalarUnit : scalarUnits) {
                if (!item.equals(scalarUnit)) continue;
                ++numberMatches;
            }
        }
        String[] unitsComb = new String[unitsTemp.length + scalarUnits.length - numberMatches];
        int k = 0;
        String[] stringArray = unitsTemp;
        int n = stringArray.length;
        for (int item = 0; item < n; ++item) {
            String s;
            unitsComb[k] = s = stringArray[item];
            ++k;
        }
        for (String scalarUnit : scalarUnits) {
            boolean noMatch = true;
            for (String s : unitsTemp) {
                if (!s.equals(scalarUnit)) continue;
                noMatch = false;
                break;
            }
            if (!noMatch) continue;
            unitsComb[k] = scalarUnit;
            ++k;
        }
        UNITS = new String[unitsComb.length + 1];
        UnitUtil.UNITS[0] = UNDEFINED_UNITS;
        System.arraycopy(unitsComb, 0, UNITS, 1, unitsComb.length);
        lookupConversionFactor = new HashMap<String, Double>();
        String ftToIn = "ft>in";
        String inToFt = "in>ft";
        double ftToInFactor = 12.0;
        double inToFtFactor = 1.0 / ftToInFactor;
        lookupConversionFactor.put(ftToIn, ftToInFactor);
        lookupConversionFactor.put(inToFt, inToFtFactor);
        String ftToM = "ft>m";
        String mToFt = "m>ft";
        double ftToMFactor = 0.3048;
        double mToFtFactor = 1.0 / ftToMFactor;
        lookupConversionFactor.put(ftToM, ftToMFactor);
        lookupConversionFactor.put(mToFt, mToFtFactor);
        String mmToM = "mm>m";
        String mToMM = "m>mm";
        double mmToMFactor = 0.001;
        double mToMMFactor = 1000.0;
        lookupConversionFactor.put(mmToM, mmToMFactor);
        lookupConversionFactor.put(mToMM, mToMMFactor);
        String ft2ToM2 = "ft2>m2";
        String m2ToFt2 = "m2>ft2";
        double ft2ToM2Factor = Math.pow(0.3048, 2.0);
        double m2ToFt2Factor = 1.0 / ft2ToM2Factor;
        lookupConversionFactor.put(ft2ToM2, ft2ToM2Factor);
        lookupConversionFactor.put(m2ToFt2, m2ToFt2Factor);
        String acreToFt2 = "acre>ft2";
        String ft2ToAcre = "ft2>acre";
        double acreToFt2Factor = 43560.0;
        double ft2ToAcreFactor = 1.0 / acreToFt2Factor;
        lookupConversionFactor.put(acreToFt2, acreToFt2Factor);
        lookupConversionFactor.put(ft2ToAcre, ft2ToAcreFactor);
        String hectareToAcre = "ha>acre";
        String acreToHectare = "acre>ha";
        double hectareToAcreFactor = 2.471054;
        double acreToHectareFactor = 1.0 / hectareToAcreFactor;
        lookupConversionFactor.put(hectareToAcre, hectareToAcreFactor);
        lookupConversionFactor.put(acreToHectare, acreToHectareFactor);
        String ftpsTomps = "ft/s>m/s";
        String mpsToftps = "m/s>ft/s";
        lookupConversionFactor.put(ftpsTomps, ftToMFactor);
        lookupConversionFactor.put(mpsToftps, mToFtFactor);
        String inToMm = "in>mm";
        String mmToIn = "mm>in";
        double inToMmFactor = 25.4;
        double mmToInFactor = 1.0 / inToMmFactor;
        lookupConversionFactor.put(inToMm, inToMmFactor);
        lookupConversionFactor.put(mmToIn, mmToInFactor);
        String cfsToCms = "cfs>cms";
        String cmsToCfs = "cms>cfs";
        double cfsToCmsFactor = ftToMFactor * ftToMFactor * ftToMFactor;
        double cmsToCfsFactor = 1.0 / cfsToCmsFactor;
        lookupConversionFactor.put(cfsToCms, cfsToCmsFactor);
        lookupConversionFactor.put(cmsToCfs, cmsToCfsFactor);
        String acre_ftToM3 = "ac-ft>m3";
        String m3ToAcre_ft = "m3>ac-ft";
        double acre_ftToM3Factor = 43560.0 * ftToMFactor * ftToMFactor * ftToMFactor;
        double m3ToAcre_ftFactor = 1.0 / acre_ftToM3Factor;
        lookupConversionFactor.put(acre_ftToM3, acre_ftToM3Factor);
        lookupConversionFactor.put(m3ToAcre_ft, m3ToAcre_ftFactor);
        for (String unitSystem : unitSystems = UnitUtil.getUnitSystems()) {
            String[] unitsFrom;
            for (String s : unitsFrom = UnitUtil.getUnitsForSystem(unitSystem)) {
                String[] unitsTo;
                for (String value : unitsTo = UnitUtil.getUnitsToConvertTo(unitSystem, s)) {
                    RpnFunction convFunction;
                    int indexPeriod = value.indexOf(46);
                    String unitTo = value;
                    String toUnit = unitTo.substring(indexPeriod + 1);
                    String toSystem = unitTo.substring(0, indexPeriod);
                    if (s.equals(toUnit) || (convFunction = UnitUtil.getConvFunction(unitSystem, s, toSystem, toUnit)) == null) continue;
                    String rpnStr = convFunction.getFunctionString();
                    int firstBarIndex = rpnStr.indexOf(124);
                    int secondBarIndex = rpnStr.indexOf(124, firstBarIndex + 1);
                    int lastBarIndex = rpnStr.lastIndexOf(124);
                    if (!rpnStr.endsWith("|*") || secondBarIndex != lastBarIndex) continue;
                    Double factor = Double.valueOf(rpnStr.substring(firstBarIndex + 1, secondBarIndex));
                    String key = s + ">" + toUnit;
                    Double fac = lookupConversionFactor.get(key);
                    if (fac != null) {
                        lookupConversionFactor.remove(key);
                    }
                    lookupConversionFactor.put(key, factor);
                }
            }
        }
    }

    public static String[] getUnitSystems() {
        Set unitSystems = _unitMap.keySet();
        String[] retval = new String[unitSystems.size()];
        unitSystems.toArray(retval);
        return retval;
    }

    public static Map<String, String> getUnitsAliasTable() {
        return new ConcurrentHashMap<String, String>(_aliasToUnitMap);
    }

    public static String[] getUnitTypes() {
        TreeSet unitTypes = new TreeSet();
        _unitMap.forEach((unitSystem, unitSet) -> unitTypes.addAll(unitSet));
        String[] retval = new String[unitTypes.size()];
        unitTypes.toArray(retval);
        return retval;
    }

    public static String[] getUnitsForSystem(String forSys) {
        NavigableSet systemUnits = _unitMap.getOrDefault(forSys, new TreeSet());
        String[] retval = new String[systemUnits.size()];
        systemUnits.toArray(retval);
        return retval;
    }

    public static String[] getUnitsToConvertTo(String fromSys, String fromUnit) {
        UnitType ut = new UnitType(fromSys, fromUnit);
        NavigableSet<String> utTo = UnitUtil.getUnitsToConvertTo(ut);
        String[] retArray = new String[utTo.size()];
        utTo.toArray(retArray);
        return retArray;
    }

    public static RpnFunction getConvFunction(String fromSys, String fromId, String toSys, String toId) {
        UnitType fromUt = new UnitType(fromSys, fromId);
        UnitType toUt = new UnitType(toSys, toId);
        return UnitUtil.getConvFunction(fromUt, toUt);
    }

    public static void loadUnitResources() {
        boolean loadedUnits = false;
        StringBuilder attemptedFilePaths = new StringBuilder();
        int failedCount = 1;
        String systemHome = UnitUtil.getSystemHomeDirectory();
        if (systemHome != null && systemHome.length() > 0) {
            StringBuilder sb = new StringBuilder(systemHome);
            if (sb.charAt(sb.length() - 1) != '/') {
                sb.append('/');
            }
            sb.append(FILEPATH);
            attemptedFilePaths.append(failedCount).append(": ").append(sb.toString()).append("\n");
            ++failedCount;
            loadedUnits = UnitUtil.loadFromFile(sb.toString());
        } else {
            attemptedFilePaths.append(failedCount).append(": ").append("CWMS_HOME undefined will look in heclib.jar file.\n");
            ++failedCount;
        }
        if (!loadedUnits) {
            attemptedFilePaths.append(failedCount).append(": ").append(FILEURL);
            loadedUnits = UnitUtil.loadFromUrl(FILEURL);
        }
        if (!loadedUnits) {
            String unableToLoadMessage = "Could not load unit definition and conversion file, checked the following paths:\n" + attemptedFilePaths.toString();
            LOGGER.info(unableToLoadMessage);
        }
    }

    private static String getSystemHomeDirectory() {
        String systemHome = System.getProperty("CWMS_HOME");
        if (systemHome == null) {
            systemHome = System.getProperty("$CWMS_HOME");
        }
        return systemHome;
    }

    public static boolean loadFromUrl(String filepath) {
        boolean retval;
        block14: {
            retval = false;
            if (filepath != null && !filepath.trim().isEmpty()) {
                try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(filepath);){
                    if (is == null) break block14;
                    try (BufferedReader br = new BufferedReader(new InputStreamReader(is));){
                        retval = UnitUtil.loadFromReader(br);
                    }
                }
                catch (IOException ioe) {
                    LOGGER.log(Level.INFO, "Error loading unit definition and conversion file.", ioe);
                }
            }
        }
        return retval;
    }

    public static boolean loadFromFile(String filepath) {
        boolean bl;
        if (filepath == null || filepath.trim().isEmpty()) {
            return false;
        }
        LOGGER.log(Level.FINE, "Unit.loadFromFile: loading from {0}", filepath);
        File file = new File(filepath);
        if (!file.canRead()) {
            LOGGER.log(Level.FINE, "Unable to read unit resource file: {0}", filepath);
            return false;
        }
        BufferedReader br = new BufferedReader(new FileReader(file));
        try {
            bl = UnitUtil.loadFromReader(br);
        }
        catch (Throwable throwable) {
            try {
                try {
                    br.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                String error = String.format("Unable to load unit definition and conversion file: %s", filepath);
                LOGGER.log(Level.INFO, error, e);
                return false;
            }
        }
        br.close();
        return bl;
    }

    public static boolean loadFromReader(BufferedReader br) {
        if (br == null) {
            return false;
        }
        try {
            String line = br.readLine();
            while (line != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("//")) {
                    line = br.readLine();
                    continue;
                }
                if (line.indexOf(62) == -1) {
                    UnitUtil.parseUnitDefinition(line);
                } else {
                    UnitUtil.parseUnitConversion(line);
                }
                line = br.readLine();
            }
            return true;
        }
        catch (IOException exception) {
            LOGGER.log(Level.INFO, "Error loading unit definition and conversion file.", exception);
            return false;
        }
    }

    private static void parseUnitDefinition(String line) {
        StringTokenizer st = new StringTokenizer(line, ";", false);
        if (st.countTokens() >= 2) {
            String system = st.nextToken();
            String type = st.nextToken();
            UnitUtil.addUnit(system, type);
            _aliasToUnitMap.put(type, type);
            while (st.hasMoreTokens()) {
                String alias = st.nextToken();
                _aliasToUnitMap.put(alias, type);
            }
        }
    }

    private static void parseUnitConversion(String line) {
        String fromSys = null;
        String fromType = null;
        String toSys = null;
        String toType = null;
        String func = null;
        double val = Double.NEGATIVE_INFINITY;
        StringTokenizer lineSplit = new StringTokenizer(line, ">", false);
        if (lineSplit.countTokens() >= 2) {
            StringTokenizer toSplit;
            StringTokenizer fromSplit = new StringTokenizer(lineSplit.nextToken(), ";", false);
            if (fromSplit.countTokens() == 2) {
                fromSys = fromSplit.nextToken();
                fromType = fromSplit.nextToken();
            }
            if ((toSplit = new StringTokenizer(lineSplit.nextToken(), ";", false)).countTokens() >= 3) {
                toSys = toSplit.nextToken();
                toType = toSplit.nextToken();
                func = toSplit.nextToken();
                val = NumericalConstants.parseDouble(func);
            }
        }
        if (fromSys != null && fromType != null && toSys != null && toType != null) {
            if (val != Double.NEGATIVE_INFINITY) {
                UnitUtil.addConvFunction(fromSys, fromType, toSys, toType, val);
            } else {
                UnitUtil.addConvFunction(fromSys, fromType, toSys, toType, func);
            }
        } else {
            LOGGER.log(Level.FINE, "Unit resource file line failed to parse: {0}", line);
        }
    }

    public static void addUnit(String unitSys, String unitId) {
        UnitType ut = new UnitType(unitSys, unitId);
        UnitUtil.addUnit(ut);
    }

    public static boolean doesUnitExist(String unitSys, String unitId) {
        UnitType ut = new UnitType(unitSys, unitId);
        return UnitUtil.doesUnitExist(ut);
    }

    public static void addConvFunction(String fromSys, String fromId, String toSys, String toId, String strFunction) {
        UnitType fromUt = new UnitType(fromSys, fromId);
        UnitType toUt = new UnitType(toSys, toId);
        RpnFunction function = new RpnFunction(strFunction);
        UnitUtil.addConvFunction(fromUt, toUt, function);
    }

    public static void addConvFunction(String fromSys, String fromId, String toSys, String toId, RpnFunction function) {
        UnitType fromUt = new UnitType(fromSys, fromId);
        UnitType toUt = new UnitType(toSys, toId);
        UnitUtil.addConvFunction(fromUt, toUt, function);
    }

    public static void addConvFunction(String fromSys, String fromId, String toSys, String toId, double factor) {
        UnitType fromUt = new UnitType(fromSys, fromId);
        UnitType toUt = new UnitType(toSys, toId);
        StringBuilder sbFunction = new StringBuilder();
        sbFunction.append("Arg 0|");
        sbFunction.append(factor);
        sbFunction.append("|*");
        RpnFunction function = new RpnFunction(sbFunction.toString());
        UnitUtil.addConvFunction(fromUt, toUt, function);
        sbFunction.setLength(0);
        sbFunction.append("Arg 0|");
        sbFunction.append(1.0 / factor);
        sbFunction.append("|*");
        RpnFunction inverseFunction = new RpnFunction(sbFunction.toString());
        UnitUtil.addConvFunction(toUt, fromUt, inverseFunction);
    }

    private static NavigableSet<String> getUnitsToConvertTo(UnitType ut) {
        TreeSet<String> retval = new TreeSet<String>();
        Map<String, ConvFunction> unitConvMap = _unitConvFrom.get(ut.key());
        if (unitConvMap != null) {
            for (ConvFunction convFunction : unitConvMap.values()) {
                retval.add(convFunction.getTo().toString());
            }
        }
        return retval;
    }

    private static RpnFunction getConvFunction(UnitType fromUt, UnitType toUt) {
        RpnFunction rpnFunction;
        ConvFunction convFunction;
        RpnFunction retval = null;
        Map<String, ConvFunction> functionMap = _unitConvFrom.get(fromUt.key());
        if (functionMap != null && (convFunction = functionMap.get(toUt.key())) != null && (rpnFunction = convFunction.getFunction()) != null) {
            retval = new RpnFunction(rpnFunction.getFunctionString());
        }
        return retval;
    }

    private static void addUnit(UnitType unitType) {
        if (!UnitUtil.doesUnitExist(unitType)) {
            String unitSystem = unitType.getUnitSystem();
            NavigableSet unitSet = _unitMap.getOrDefault(unitSystem, new TreeSet());
            unitSet.add(unitType.getUnitId());
            _unitMap.put(unitSystem, unitSet);
            String sbFunction = "Arg 0|1.0|*";
            RpnFunction function = new RpnFunction(sbFunction);
            UnitUtil.addConvFunction(unitType, unitType, function);
        }
    }

    private static boolean doesUnitExist(UnitType ut) {
        boolean retval = false;
        String system = ut.getUnitSystem();
        NavigableSet unitTypes = _unitMap.getOrDefault(system, new TreeSet());
        if (unitTypes.contains(ut.getUnitId())) {
            retval = true;
        }
        return retval;
    }

    private static void addConvFunction(UnitType fromUt, UnitType toUt, RpnFunction function) {
        if (!UnitUtil.doesUnitExist(fromUt)) {
            UnitUtil.addUnit(fromUt);
        }
        if (!UnitUtil.doesUnitExist(toUt)) {
            UnitUtil.addUnit(toUt);
        }
        UnitUtil.addConvFunctionBase(fromUt, toUt, function);
    }

    private static void addConvFunctionBase(UnitType fromUt, UnitType toUt, RpnFunction function) {
        Map functionMap = _unitConvFrom.getOrDefault(fromUt.key(), new HashMap());
        ConvFunction cf = new ConvFunction(toUt, function);
        functionMap.put(toUt.key(), cf);
        _unitConvFrom.put(fromUt.key(), functionMap);
    }

    public static String getUnitsForAlias(String alias) {
        if (alias == null) {
            return null;
        }
        return unitAliasTable.get(alias);
    }

    public static String[] getAvailableUnits() {
        if (UNITS == null) {
            UnitUtil.loadDefaultUnits();
        }
        return UNITS;
    }

    public static boolean isValidUnitsSystem(int system) {
        return system == 2 || system == 1;
    }

    public static int getUnitSystemForUnits(String unitStr) {
        int unitSys = 0;
        if (unitStr == null || unitStr.length() < 1) {
            return unitSys;
        }
        String units = UnitUtil.getUnitsForAlias(unitStr);
        if (units == null || units.length() < 1) {
            return unitSys;
        }
        boolean foundInEnglish = false;
        for (String s : UnitUtil.getUnitsForSystem(ENGLISH)) {
            if (!s.equalsIgnoreCase(units)) continue;
            unitSys = 1;
            foundInEnglish = true;
            break;
        }
        if (!foundInEnglish) {
            for (String s : UnitUtil.getUnitsForSystem(SI)) {
                if (!s.equalsIgnoreCase(units)) continue;
                unitSys = 2;
                break;
            }
        }
        return unitSys;
    }

    public static double convertUnits(double x, String fromUnits, String toUnits) throws UnitsConversionException {
        if (fromUnits != null && fromUnits.equals(toUnits)) {
            return x;
        }
        double[] y = new double[]{x};
        UnitUtil.convertUnits(y, fromUnits, toUnits);
        return y[0];
    }

    public static String getUnitsStringForUnitsId(int unitsId) {
        switch (unitsId) {
            case 1: {
                return ENGLISH;
            }
            case 2: {
                return SI;
            }
        }
        return UNDEFINED_UNITS;
    }

    public static String getUnitsInUnitSystem(String unitsSystem, String unitsFrom) throws UnitsConversionException {
        String temp = unitAliasTable.get(unitsFrom);
        if (temp != null) {
            unitsFrom = temp;
        }
        String unitsInSystem = UNDEFINED_UNITS;
        String[] systemsArray = UnitUtil.getUnitSystems();
        if (systemsArray.length > 0) {
            String unitSysFrom = systemsArray[0];
            for (String s : systemsArray) {
                if (!UnitUtil.doesUnitExist(s, unitsFrom)) continue;
                unitSysFrom = s;
            }
            if (unitSysFrom.equalsIgnoreCase(unitsSystem)) {
                unitsInSystem = unitsFrom;
            } else {
                String[] systemAndUnits;
                for (String systemAndUnit : systemAndUnits = UnitUtil.getUnitsToConvertTo(unitSysFrom, unitsFrom)) {
                    int indexPer = systemAndUnit.indexOf(46);
                    String sys = systemAndUnit.substring(0, indexPer);
                    if (!unitsSystem.equalsIgnoreCase(sys)) continue;
                    return systemAndUnit.substring(indexPer + 1);
                }
            }
        }
        return unitsInSystem;
    }

    public static boolean canConvertBetweenUnits(Units fromUnits, Units toUnits) {
        return UnitUtil.canConvertBetweenUnits(fromUnits.toString(), toUnits.toString());
    }

    public static boolean canConvertBetweenUnits(String fromUnits, String toUnits) {
        Double f;
        String temp;
        if (UNITS == null) {
            UnitUtil.loadDefaultUnits();
        }
        if ((temp = unitAliasTable.get(fromUnits)) != null) {
            fromUnits = temp;
        }
        if ((temp = unitAliasTable.get(toUnits)) != null) {
            toUnits = temp;
        }
        if ((f = lookupConversionFactor.get(fromUnits + ">" + toUnits)) == null) {
            String[] systemsArray = UnitUtil.getUnitSystems();
            if (systemsArray.length == 0) {
                return false;
            }
            String unitSysFrom = systemsArray[0];
            for (String value : systemsArray) {
                if (!UnitUtil.doesUnitExist(value, fromUnits)) continue;
                unitSysFrom = value;
            }
            String unitSysTo = systemsArray[0];
            for (String s : systemsArray) {
                if (!UnitUtil.doesUnitExist(s, toUnits)) continue;
                unitSysTo = s;
            }
            RpnFunction convFunction = UnitUtil.getConvFunction(unitSysFrom, fromUnits, unitSysTo, toUnits);
            return convFunction != null;
        }
        return true;
    }

    protected static void convertUnits(double[] x, double factor) {
        for (int i = 0; i < x.length; ++i) {
            if (x[i] == -3.4028234663852886E38) continue;
            x[i] = x[i] * factor;
        }
    }

    public static List<String> getAllUnitsThatCanConvertTo(String unit, String unitSystem) {
        String[] availableUnits;
        ArrayList<String> retval = new ArrayList<String>();
        for (String availableUnit : availableUnits = UnitUtil.getUnitsForSystem(unitSystem)) {
            if (!UnitUtil.canConvertBetweenUnits(availableUnit, unit)) continue;
            retval.add(availableUnit);
        }
        return retval;
    }

    public static String[] getAliasesForUnits(String units) {
        Iterator<String> aliasEnum = unitAliasTable.keySet().iterator();
        ArrayList<String> aliasVect = new ArrayList<String>();
        while (aliasEnum.hasNext()) {
            String alias = aliasEnum.next();
            if (units.equals(alias) || !unitAliasTable.get(alias).equals(units)) continue;
            aliasVect.add(alias);
        }
        String[] aliases = new String[aliasVect.size()];
        aliasVect.toArray(aliases);
        return aliases;
    }

    public static boolean isUnitsInAlias(String units, String aliasUnits) {
        boolean retval = false;
        String[] aliasArray = UnitUtil.getAliasesForUnits(aliasUnits);
        ArrayList<String> aliases = new ArrayList<String>();
        aliases.add(aliasUnits);
        aliases.addAll(Arrays.asList(aliasArray));
        if (aliases.contains(units)) {
            retval = true;
        }
        return retval;
    }

    public static String getBestMatch(String units) {
        if (units == null) {
            return UNDEFINED_UNITS;
        }
        if (UNITS == null) {
            UnitUtil.loadDefaultUnits();
        }
        units = units.trim();
        int inLen = units.length();
        String unitsUp = units.toUpperCase();
        for (String unit : UNITS) {
            if (unit.equalsIgnoreCase(unitsUp)) {
                return unit;
            }
            String[] unitAlias = UnitUtil.getAliasesForUnits(unit);
            if (unitAlias.length <= 0) continue;
            for (String alias : unitAlias) {
                if (!alias.equalsIgnoreCase(unitsUp)) continue;
                return unit;
            }
        }
        int cbMatchLen = 0;
        int cbMatchIdx = -1;
        int cbsMatchLen = 0;
        int cbsMatchIdx = -1;
        int ciMatchLen = 0;
        int ciMatchIdx = -1;
        int cisMatchLen = 0;
        int cisMatchIdx = -1;
        int ciSpread = 10000;
        int cbSpread = 10000;
        for (int i = UNITS.length - 1; i >= 0; --i) {
            String[] aliases = UnitUtil.getAliasesForUnits(UNITS[i]);
            String[] unitAlias = new String[aliases.length + 1];
            unitAlias[0] = UNITS[i];
            for (int ia = 0; ia < aliases.length; ++ia) {
                unitAlias[ia + 1] = aliases[ia];
            }
            for (String alias : unitAlias) {
                String unitsTempUp = alias.toUpperCase();
                boolean startsWithSameLetter = false;
                if (unitsUp.startsWith(unitsTempUp.substring(0, 1))) {
                    startsWithSameLetter = true;
                }
                if (unitsTempUp.startsWith(unitsUp)) {
                    cisMatchIdx = i;
                    cisMatchLen = inLen;
                }
                boolean cbMatch = true;
                int k = 0;
                int cbSprd = 0;
                for (int j = 0; j < unitsTempUp.length(); ++j) {
                    k = unitsUp.indexOf(unitsTempUp.substring(j, j + 1), k);
                    if (k == -1) {
                        cbMatch = false;
                    }
                    cbSprd = cbSprd + k - j;
                }
                boolean ciMatch = true;
                int ciSprd = 0;
                k = 0;
                for (int j = 0; j < unitsUp.length(); ++j) {
                    ciSprd -= k;
                    k = unitsTempUp.indexOf(unitsUp.substring(j, j + 1), k);
                    if (k == -1) {
                        ciMatch = false;
                    }
                    ciSprd = ciSprd + k - j;
                }
                if (cbMatch) {
                    if (unitsTempUp.length() >= cbMatchLen) {
                        cbMatchLen = unitsTempUp.length();
                        cbMatchIdx = i;
                        cbSpread = cbSprd;
                    }
                    if (startsWithSameLetter && cbSprd < cbSpread) {
                        cbsMatchIdx = i;
                        cbsMatchLen = unitsTempUp.length();
                    }
                }
                if (!ciMatch) continue;
                if (unitsTempUp.length() >= ciMatchLen && ciSprd < ciSpread) {
                    ciMatchLen = inLen;
                    ciMatchIdx = i;
                    ciSpread = ciSprd;
                }
                if (!startsWithSameLetter || ciSprd >= ciSpread) continue;
                cisMatchIdx = i;
                cisMatchLen = inLen;
            }
        }
        if (cisMatchLen == inLen && cisMatchLen >= ciMatchLen && cisMatchLen >= cbMatchLen && cisMatchLen >= cbsMatchLen) {
            return UNITS[cisMatchIdx];
        }
        if (cbsMatchLen > 0 && cbsMatchLen >= cbMatchLen && cbsMatchLen >= ciMatchLen) {
            return UNITS[cbsMatchIdx];
        }
        if (ciMatchLen == inLen && ciMatchLen >= cbMatchLen) {
            return UNITS[ciMatchIdx];
        }
        if (cbMatchLen > 0) {
            return UNITS[cbMatchIdx];
        }
        return UNDEFINED_UNITS;
    }

    public static double getScalarFactor(String fromUnits, String toUnits) throws UnitsConversionException {
        Double f;
        String temp;
        if (UNITS == null) {
            UnitUtil.loadDefaultUnits();
        }
        if ((temp = unitAliasTable.get(fromUnits)) != null) {
            fromUnits = temp;
        }
        if ((temp = unitAliasTable.get(toUnits)) != null) {
            toUnits = temp;
        }
        if ((f = lookupConversionFactor.get(fromUnits + ">" + toUnits)) != null) {
            return f;
        }
        return -1.0;
    }

    public static double convertUnits(double x, int paramID, int fromUnitSystem, int toUnitSystem) throws UnitsConversionException {
        double[] y = new double[]{x};
        UnitUtil.convertUnits(y, paramID, fromUnitSystem, toUnitSystem);
        return y[0];
    }

    public static void convertUnits(double[] x, int paramID, int fromUnitSystem, int toUnitSystem) throws UnitsConversionException {
        String fromUnits = ParameterLookup.getUnitsStringForSystem(paramID, fromUnitSystem);
        String toUnits = ParameterLookup.getUnitsStringForSystem(paramID, toUnitSystem);
        UnitUtil.convertUnits(x, fromUnits, toUnits);
    }

    public static void convertUnits(double[] x, String fromUnits, String toUnits) throws UnitsConversionException {
        block11: {
            String temp;
            if (UNITS == null) {
                UnitUtil.loadDefaultUnits();
            }
            if ((temp = unitAliasTable.get(fromUnits)) != null) {
                fromUnits = temp;
            }
            if ((temp = unitAliasTable.get(toUnits)) != null) {
                toUnits = temp;
            }
            if (fromUnits != null && fromUnits.equals(toUnits)) break block11;
            Double f = lookupConversionFactor.get(fromUnits + ">" + toUnits);
            if (f != null) {
                double factor = f;
                for (int i = 0; i < x.length; ++i) {
                    if (x[i] == -3.4028234663852886E38) continue;
                    x[i] = x[i] * factor;
                }
            } else {
                String[] systemsArray = UnitUtil.getUnitSystems();
                if (systemsArray.length == 0) {
                    throw new UnitsConversionException(fromUnits, toUnits);
                }
                String unitSysFrom = systemsArray[0];
                for (String value : systemsArray) {
                    if (!UnitUtil.doesUnitExist(value, fromUnits)) continue;
                    unitSysFrom = value;
                }
                String unitSysTo = systemsArray[0];
                for (String s : systemsArray) {
                    if (!UnitUtil.doesUnitExist(s, toUnits)) continue;
                    unitSysTo = s;
                }
                RpnFunction convFunction = UnitUtil.getConvFunction(unitSysFrom, fromUnits, unitSysTo, toUnits);
                if (convFunction == null) {
                    throw new UnitsConversionException(unitSysFrom, fromUnits, unitSysTo, toUnits);
                }
                double[] z = new double[1];
                for (int i = 0; i < x.length; ++i) {
                    if (x[i] == -3.4028234663852886E38) continue;
                    z[0] = x[i];
                    x[i] = convFunction.calc(z);
                }
            }
        }
    }

    public static double getStorageToFlowConversion(String storageUnits, String flowUnits) throws UnitsConversionException {
        double storageFactor = UnitUtil.convertUnits(1.0, storageUnits, "m3");
        double flowFactor = UnitUtil.convertUnits(1.0, flowUnits, "cms");
        return storageFactor / flowFactor;
    }

    static boolean isNotValid(String units) {
        return !UnitUtil.isValid(units);
    }

    static String getUnitsProperCase(String units) {
        for (String unit : UNITS) {
            if (units.length() != unit.length() || !units.equalsIgnoreCase(unit)) continue;
            return unit;
        }
        return null;
    }

    static boolean isValid(String units) {
        for (String unit : UNITS) {
            if (units.length() != unit.length() || !units.equalsIgnoreCase(unit)) continue;
            return true;
        }
        return false;
    }

    static {
        UnitUtil.loadUnitResources();
        UnitUtil.loadDefaultUnits();
    }

    private static final class UnitType
    implements Comparable<Object> {
        private final String _unitSystem;
        private final String _unitId;

        private UnitType(String unitSystem, String unitId) {
            this._unitSystem = unitSystem;
            this._unitId = unitId;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof UnitType)) {
                return false;
            }
            UnitType ut = (UnitType)obj;
            if (!this._unitSystem.equalsIgnoreCase(ut.getUnitSystem())) {
                return false;
            }
            return this._unitId.equalsIgnoreCase(ut.getUnitId());
        }

        public String toString() {
            return this._unitSystem + "." + this._unitId;
        }

        private String getUnitSystem() {
            return this._unitSystem;
        }

        private String getUnitId() {
            return this._unitId;
        }

        private String key() {
            return this.toString().toUpperCase();
        }

        public int hashCode() {
            return Objects.hash(this._unitSystem, this._unitId);
        }

        @Override
        public int compareTo(Object o) {
            int retval = o instanceof UnitType ? this._unitId.compareTo(((UnitType)o).getUnitId()) : this.toString().compareTo(o.toString());
            return retval;
        }
    }

    private static final class ConvFunction {
        private final UnitType _toUt;
        private final RpnFunction _rpnFunction;

        private ConvFunction(UnitType to, RpnFunction function) {
            this._toUt = to;
            this._rpnFunction = function;
        }

        private UnitType getTo() {
            return this._toUt;
        }

        private RpnFunction getFunction() {
            return this._rpnFunction;
        }
    }
}

