/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata;

import mil.army.usace.hec.metadata.DataSetException;
import mil.army.usace.hec.metadata.Units;

public class UnitsConversionException
extends DataSetException {
    private static final long serialVersionUID = 1298903841566174669L;
    private final String _fromSys;
    private final String _fromUnit;
    private final String _toSys;
    private final String _toUnit;
    private final boolean _usePassedInMessage;

    public UnitsConversionException(Throwable t) {
        super(t);
        this._usePassedInMessage = true;
        this._fromSys = null;
        this._fromUnit = null;
        this._toSys = null;
        this._toUnit = null;
    }

    public UnitsConversionException(Units from, Units to) {
        this._fromUnit = from.toString();
        this._toUnit = to.toString();
        this._usePassedInMessage = false;
        this._fromSys = null;
        this._toSys = null;
    }

    public UnitsConversionException(String fromUnit, String toUnit) {
        this._fromUnit = fromUnit;
        this._toUnit = toUnit;
        this._usePassedInMessage = false;
        this._fromSys = null;
        this._toSys = null;
    }

    public UnitsConversionException(String fromSys, String fromUnit, String toSys, String toUnit) {
        this._fromSys = fromSys;
        this._fromUnit = fromUnit;
        this._toSys = toSys;
        this._toUnit = toUnit;
        this._usePassedInMessage = false;
    }

    public UnitsConversionException(String message) {
        super(message);
        this._usePassedInMessage = true;
        this._fromSys = null;
        this._fromUnit = null;
        this._toSys = null;
        this._toUnit = null;
    }

    @Override
    public String getMessage() {
        if (this._usePassedInMessage) {
            return super.getMessage();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Unit conversion is invalid. Unit: ");
        if (this._fromSys != null) {
            sb.append(this._fromSys);
            sb.append(".");
        }
        sb.append(this._fromUnit);
        sb.append(" cannot be converted to Unit: ");
        if (this._toSys != null) {
            sb.append(this._toSys);
            sb.append(".");
        }
        sb.append(this._toUnit);
        return sb.toString();
    }
}

