/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata;

import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import mil.army.usace.hec.metadata.UnitUtil;
import mil.army.usace.hec.metadata.VerticalDatum;
import mil.army.usace.hec.metadata.VerticalDatumException;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class VerticalDatumContainer
implements VerticalDatum,
Serializable {
    private static final long serialVersionUID = -197382849518138968L;
    public static final String NAVD88 = "NAVD88";
    public static final String NGVD29 = "NGVD29";
    public static final String LOCAL = "LOCAL";
    public static final String UNKNOWN = "UNKNOWN";
    public static final String OTHER = "OTHER";
    public static final String NATIVE = "NATIVE";
    private static final String DATUM_INTERNAL_PATTERN = "(N[GA]VD)(29|88)";
    private static final String DATUM_EXTERNAL_PATTERN = "(N[GA]VD)[ -]?(29|88)";
    private static final String DATUM_INTERNAL_FORMAT = "$1$2";
    private static final String DATUM_EXTERNAL_FORMAT = "$1-$2";
    public String nativeDatum = null;
    public String currentDatum = null;
    public String localDatumName = null;
    public String unit = null;
    public double elevation = -3.4028234663852886E38;
    public double ngvd29Offset = -3.4028234663852886E38;
    public double navd88Offset = -3.4028234663852886E38;
    public boolean ngvd29OffsetIsEstimate = true;
    public boolean navd88OffsetIsEstimate = true;

    public VerticalDatumContainer() {
    }

    public VerticalDatumContainer(String unitStr, String nativeDatumStr, Double elevationValue) throws VerticalDatumException {
        String datum;
        this.unit = unitStr;
        double d = this.elevation = elevationValue == null ? -3.4028234663852886E38 : elevationValue;
        if (nativeDatumStr == null) {
            throw new VerticalDatumException("Cannot set native datum to null");
        }
        this.currentDatum = this.nativeDatum = (datum = VerticalDatumContainer.replaceAll(nativeDatumStr.toUpperCase(), DATUM_EXTERNAL_PATTERN, DATUM_INTERNAL_FORMAT));
        switch (datum) {
            case "NGVD29": {
                this.ngvd29Offset = 0.0;
                this.ngvd29OffsetIsEstimate = false;
                break;
            }
            case "NAVD88": {
                this.navd88Offset = 0.0;
                this.navd88OffsetIsEstimate = false;
                break;
            }
            case "LOCAL": 
            case "UNKNOWN": {
                break;
            }
            default: {
                throw new VerticalDatumException("Unsupported native datum: " + datum);
            }
        }
    }

    public VerticalDatumContainer(String initStr) throws VerticalDatumException {
        this.setVerticalDatumInfo(initStr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getNativeVerticalDatum() throws VerticalDatumException {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            if (this.nativeDatum == null) {
                throw new VerticalDatumException("Native datum is not set");
            }
            return this.nativeDatum.equals(LOCAL) && this.localDatumName != null ? this.localDatumName : this.nativeDatum.replaceAll(DATUM_INTERNAL_PATTERN, DATUM_EXTERNAL_FORMAT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentVerticalDatum() throws VerticalDatumException {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            if (this.currentDatum == null) {
                throw new VerticalDatumException("Current datum is not set");
            }
            return this.currentDatum.replaceAll(DATUM_INTERNAL_PATTERN, DATUM_EXTERNAL_FORMAT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurrentVerticalDatumEstimated() throws VerticalDatumException {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            if (this.currentDatum == null) {
                throw new VerticalDatumException("Current datum is not set");
            }
            return this.currentDatum.equals(NGVD29) && this.ngvd29OffsetIsEstimate || this.currentDatum.equals(NAVD88) && this.navd88OffsetIsEstimate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean toNativeVerticalDatum() throws VerticalDatumException {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            boolean change;
            if (this.nativeDatum == null) {
                throw new VerticalDatumException("Native datum is not set");
            }
            boolean bl = change = !this.currentDatum.equals(this.nativeDatum);
            if (change) {
                switch (this.currentDatum) {
                    case "NGVD29": {
                        if (this.ngvd29Offset == -3.4028234663852886E38) {
                            throw new VerticalDatumException("NGVD29 offset is not set");
                        }
                        if (this.elevation == -3.4028234663852886E38) break;
                        this.elevation -= this.ngvd29Offset;
                        break;
                    }
                    case "NAVD88": {
                        if (this.navd88Offset == -3.4028234663852886E38) {
                            throw new VerticalDatumException("NAVD88 offset is not set");
                        }
                        if (this.elevation == -3.4028234663852886E38) break;
                        this.elevation -= this.navd88Offset;
                        break;
                    }
                    case "UNKNOWN": {
                        break;
                    }
                    default: {
                        if (this.nativeDatum.equals(LOCAL) && VerticalDatumContainer.textEquals(this.currentDatum, this.localDatumName)) break;
                        throw new VerticalDatumException("Unexpected current vertical datum: " + this.currentDatum);
                    }
                }
                this.currentDatum = this.nativeDatum.equals(LOCAL) && this.localDatumName != null ? this.localDatumName : this.nativeDatum;
            }
            return change;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean toNGVD29() throws VerticalDatumException {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            boolean change;
            boolean bl = change = !this.currentDatum.equals(NGVD29);
            if (change) {
                this.toNativeVerticalDatum();
                if (this.elevation != -3.4028234663852886E38) {
                    this.elevation += this.ngvd29Offset;
                }
                this.currentDatum = NGVD29;
            }
            return change;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean toNAVD88() throws VerticalDatumException {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            boolean change;
            boolean bl = change = !this.currentDatum.equals(NAVD88);
            if (change) {
                this.toNativeVerticalDatum();
                if (this.elevation != -3.4028234663852886E38) {
                    this.elevation += this.navd88Offset;
                }
                this.currentDatum = NAVD88;
            }
            return change;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean toVerticalDatum(String datum) throws VerticalDatumException {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            if (datum == null) {
                throw new VerticalDatumException("Null datum specified");
            }
            switch (datum.toUpperCase().replaceAll(DATUM_EXTERNAL_PATTERN, DATUM_INTERNAL_FORMAT)) {
                case "NGVD29": {
                    return this.toNGVD29();
                }
                case "NAVD88": {
                    return this.toNAVD88();
                }
                case "NATIVE": {
                    return this.toNativeVerticalDatum();
                }
                case "LOCAL": {
                    if (!this.nativeDatum.equals(LOCAL)) {
                        throw new VerticalDatumException("Object does not have LOCAL vertical datum");
                    }
                    return this.toNativeVerticalDatum();
                }
                case "UNKNOWN": {
                    return false;
                }
            }
            if (!this.nativeDatum.equals(LOCAL) || !VerticalDatumContainer.textEqualsIgnoreCase(datum, this.localDatumName)) {
                throw new VerticalDatumException("Unexpected datum: " + datum);
            }
            return this.toNativeVerticalDatum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean forceVerticalDatum(String datum) throws VerticalDatumException {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            if (datum == null) {
                throw new VerticalDatumException("Null datum specified");
            }
            boolean change = false;
            switch (datum = datum.toUpperCase().replaceAll(DATUM_EXTERNAL_PATTERN, DATUM_INTERNAL_FORMAT)) {
                case "NGVD29": 
                case "NAVD88": {
                    change = !this.currentDatum.equals(datum);
                    this.currentDatum = datum;
                    break;
                }
                case "NATIVE": {
                    change = !this.currentDatum.equals(this.getNativeVerticalDatum());
                    this.currentDatum = this.getNativeVerticalDatum();
                    break;
                }
                case "LOCAL": {
                    if (!this.nativeDatum.equals(LOCAL)) {
                        throw new VerticalDatumException("Object does not have LOCAL vertical datum");
                    }
                    change = !this.currentDatum.equals(this.getNativeVerticalDatum());
                    return this.toNativeVerticalDatum();
                }
                case "UNKNOWN": {
                    break;
                }
                default: {
                    if (!this.nativeDatum.equals(LOCAL) || !VerticalDatumContainer.textEqualsIgnoreCase(datum, this.localDatumName)) {
                        throw new VerticalDatumException("Unexpected datum: " + datum);
                    }
                    return this.toNativeVerticalDatum();
                }
            }
            return change;
        }
    }

    @Override
    public double getCurrentOffset() throws VerticalDatumException {
        return this.getCurrentOffset(this.unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getCurrentOffset(String unit) throws VerticalDatumException {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            if (this.currentDatum == null) {
                throw new VerticalDatumException("Current datum is not set");
            }
            double offset = 0.0;
            switch (this.currentDatum) {
                case "NGVD29": {
                    offset = this.getNGVD29Offset(unit);
                    break;
                }
                case "NAVD88": {
                    offset = this.getNAVD88Offset(unit);
                }
            }
            return offset;
        }
    }

    @Override
    public double getNGVD29Offset() throws VerticalDatumException {
        return this.getNGVD29Offset(this.unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getNGVD29Offset(String unit) throws VerticalDatumException {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            if (this.ngvd29Offset == -3.4028234663852886E38) {
                throw new VerticalDatumException("NGVD29 offset is not set");
            }
            if (unit == null) {
                throw new VerticalDatumException("Unit is not set");
            }
            double offset = this.ngvd29Offset;
            if (!unit.equals(this.unit)) {
                try {
                    offset = UnitUtil.convertUnits(offset, this.unit, unit);
                }
                catch (Throwable t) {
                    throw new VerticalDatumException(t);
                }
            }
            return offset;
        }
    }

    @Override
    public double getNAVD88Offset() throws VerticalDatumException {
        return this.getNAVD88Offset(this.unit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double getNAVD88Offset(String unit) throws VerticalDatumException {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            if (this.navd88Offset == -3.4028234663852886E38) {
                throw new VerticalDatumException("NAVD88 offset is not set");
            }
            if (unit == null) {
                throw new VerticalDatumException("Unit is not set");
            }
            double offset = this.navd88Offset;
            if (!unit.equals(this.unit)) {
                try {
                    offset = UnitUtil.convertUnits(offset, this.unit, unit);
                }
                catch (Throwable t) {
                    throw new VerticalDatumException(t);
                }
            }
            return offset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNGVD29OffsetEstimated() throws VerticalDatumException {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            if (this.ngvd29Offset == -3.4028234663852886E38) {
                throw new VerticalDatumException("NGVD29 offset is not set");
            }
            return this.ngvd29OffsetIsEstimate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isNAVD88OffsetEstimated() throws VerticalDatumException {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            if (this.navd88Offset == -3.4028234663852886E38) {
                throw new VerticalDatumException("NAVD88 offset is not set");
            }
            return this.navd88OffsetIsEstimate;
        }
    }

    @Override
    public synchronized String getVerticalDatumInfo() {
        return this.toString();
    }

    @Override
    public synchronized void setVerticalDatumInfo(String initStr) throws VerticalDatumException {
        VerticalDatumContainer vdc = new VerticalDatumContainer();
        try {
            String xmlStr;
            initStr = initStr.trim();
            if (initStr.startsWith("<")) {
                xmlStr = initStr;
            } else if (initStr.equalsIgnoreCase(OTHER) || initStr.equalsIgnoreCase(LOCAL)) {
                xmlStr = "<vertical-datum-info>  <native-datum>LOCAL</native-datum></vertical-datum-info>";
            } else if (initStr.length() <= 32) {
                xmlStr = String.format("<vertical-datum-info>  <native-datum>LOCAL</native-datum>  <local-datum-name>%s</local-datum-name></vertical-datum-info>", initStr);
            } else {
                throw new VerticalDatumException("Invalid initialization string: " + initStr);
            }
            xmlStr = VerticalDatumContainer.replaceAll(xmlStr, ">\\s*OTHER\\s*<", ">LOCAL<");
            xmlStr = VerticalDatumContainer.replaceAll(xmlStr, DATUM_EXTERNAL_PATTERN, DATUM_INTERNAL_FORMAT);
            Document doc = new SAXBuilder().build((Reader)new StringReader(xmlStr));
            Element root = doc.getRootElement();
            if (root.getName().equals("vertical-datum-info-set")) {
                List children = root.getChildren("vertical-datum-info");
                if (children.size() != 1) {
                    throw new VerticalDatumException("Root of \"vertical-datum-info-set\" must have exactly one \"vertical-datum-info\" child element");
                }
                root = (Element)children.get(0);
            }
            if (!root.getName().equals("vertical-datum-info")) {
                throw new VerticalDatumException("Expected \"vertical-datum-info\" for root, got \"" + root.getName() + "\"");
            }
            vdc.unit = root.getAttributeValue("unit");
            Element nativeDatumElement = root.getChild("native-datum");
            if (nativeDatumElement != null) {
                vdc.nativeDatum = nativeDatumElement.getTextTrim();
                if (vdc.nativeDatum != null) {
                    vdc.nativeDatum = vdc.nativeDatum.toUpperCase();
                }
            }
            if (vdc.nativeDatum == null) {
                throw new VerticalDatumException("Cannot intialize without a valid <native-datum> element");
            }
            if (vdc.nativeDatum.equals(LOCAL)) {
                try {
                    vdc.localDatumName = root.getChild("local-datum-name").getTextTrim();
                    if (vdc.localDatumName.length() == 0) {
                        vdc.localDatumName = null;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            try {
                vdc.elevation = Double.parseDouble(root.getChild("elevation").getTextTrim());
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            for (Object obj : root.getChildren("offset")) {
                if (!(obj instanceof Element)) continue;
                Element elem = (Element)obj;
                switch (elem.getChild("to-datum").getTextTrim()) {
                    case "NGVD29": {
                        vdc.ngvd29Offset = Double.parseDouble(elem.getChild("value").getTextTrim());
                        vdc.ngvd29OffsetIsEstimate = Boolean.parseBoolean(elem.getAttributeValue("estimate"));
                        break;
                    }
                    case "NAVD88": {
                        vdc.navd88Offset = Double.parseDouble(elem.getChild("value").getTextTrim());
                        vdc.navd88OffsetIsEstimate = Boolean.parseBoolean(elem.getAttributeValue("estimate"));
                    }
                }
                if (vdc.ngvd29Offset == -3.4028234663852886E38 || vdc.navd88Offset == -3.4028234663852886E38) continue;
                break;
            }
            if (vdc.nativeDatum != null) {
                switch (vdc.nativeDatum) {
                    case "NGVD29": {
                        vdc.ngvd29Offset = 0.0;
                        vdc.ngvd29OffsetIsEstimate = false;
                        break;
                    }
                    case "NAVD88": {
                        vdc.navd88Offset = 0.0;
                        vdc.navd88OffsetIsEstimate = false;
                        break;
                    }
                    case "LOCAL": 
                    case "UNKNOWN": {
                        break;
                    }
                    default: {
                        throw new VerticalDatumException("Cannot initialize with <native-datum> element of " + vdc.nativeDatum);
                    }
                }
                vdc.currentDatum = vdc.nativeDatum.equals(LOCAL) && vdc.localDatumName != null ? vdc.localDatumName : vdc.nativeDatum;
            }
            vdc.clone(this);
        }
        catch (Throwable t) {
            if (t instanceof VerticalDatumException) {
                throw (VerticalDatumException)t;
            }
            throw new VerticalDatumException(t);
        }
    }

    public String toString() {
        return this.toXml("  ", 0);
    }

    public String toXml() {
        return this.toXml("  ", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toXml(CharSequence indent, int level) {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < level; ++i) {
                sb.append(indent);
            }
            String prefix = sb.toString();
            sb.delete(0, sb.length());
            sb.append(prefix).append("<vertical-datum-info").append((String)(this.unit == null ? ">\n" : " unit=\"" + this.unit + "\">\n"));
            sb.append(prefix).append(indent).append("<native-datum").append((String)(this.nativeDatum == null ? "/>\n" : ">" + VerticalDatumContainer.replaceAll(this.nativeDatum, LOCAL, OTHER) + "</native-datum>\n"));
            if (VerticalDatumContainer.textEquals(this.nativeDatum, LOCAL)) {
                sb.append(prefix).append(indent).append("<local-datum-name").append((String)(this.localDatumName == null ? "/>\n" : ">" + this.localDatumName + "</local-datum-name>\n"));
            }
            sb.append(prefix).append(indent).append("<elevation").append((String)(this.elevation == -3.4028234663852886E38 ? "/>\n" : ">" + this.elevation + "</elevation>\n"));
            if (this.ngvd29Offset != -3.4028234663852886E38) {
                sb.append(prefix).append(indent).append("<offset estimate=\"").append(this.ngvd29OffsetIsEstimate).append("\">\n");
                sb.append(prefix).append(indent).append(indent).append("<to-datum>NGVD29</to-datum>\n");
                sb.append(prefix).append(indent).append(indent).append("<value>").append(this.ngvd29Offset).append("</value>\n");
                sb.append(prefix).append(indent).append("</offset>\n");
            }
            if (this.navd88Offset != -3.4028234663852886E38) {
                sb.append(prefix).append(indent).append("<offset estimate=\"").append(this.navd88OffsetIsEstimate).append("\">\n");
                sb.append(prefix).append(indent).append(indent).append("<to-datum>NAVD88</to-datum>\n");
                sb.append(prefix).append(indent).append(indent).append("<value>").append(this.navd88Offset).append("</value>\n");
                sb.append(prefix).append(indent).append("</offset>\n");
            }
            sb.append(prefix).append("</vertical-datum-info>\n");
            return sb.toString().replaceAll("(N[AG]VD)(29|88)", DATUM_EXTERNAL_FORMAT);
        }
    }

    public VerticalDatumContainer clone() {
        VerticalDatumContainer vdc = new VerticalDatumContainer();
        this.clone(vdc);
        return vdc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clone(VerticalDatumContainer other) {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            if (other == null) {
                throw new RuntimeException("Cannot clone to null object");
            }
            other.elevation = this.elevation;
            other.unit = this.unit;
            other.nativeDatum = this.nativeDatum;
            other.localDatumName = this.localDatumName;
            other.currentDatum = this.currentDatum;
            other.ngvd29Offset = this.ngvd29Offset;
            other.ngvd29OffsetIsEstimate = this.ngvd29OffsetIsEstimate;
            other.navd88Offset = this.navd88Offset;
            other.navd88OffsetIsEstimate = this.navd88OffsetIsEstimate;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean equals(Object other) {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            boolean same;
            boolean bl = same = other == this;
            if (!same && other instanceof VerticalDatumContainer) {
                VerticalDatumContainer vdc = (VerticalDatumContainer)other;
                same = VerticalDatumContainer.textEquals(vdc.nativeDatum, this.nativeDatum) && VerticalDatumContainer.textEquals(vdc.localDatumName, this.localDatumName) && VerticalDatumContainer.textEquals(vdc.unit, this.unit) && vdc.elevation == this.elevation && vdc.ngvd29Offset == this.ngvd29Offset && vdc.ngvd29OffsetIsEstimate == this.ngvd29OffsetIsEstimate && vdc.navd88Offset == this.navd88Offset && vdc.navd88OffsetIsEstimate == this.navd88OffsetIsEstimate;
            }
            return same;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int hashCode() {
        VerticalDatumContainer verticalDatumContainer = this;
        synchronized (verticalDatumContainer) {
            int hashCode = 0 + this.getClass().getName().hashCode() + 3 * (this.nativeDatum == null ? 1 : this.nativeDatum.hashCode()) + 5 * (this.localDatumName == null ? 1 : this.localDatumName.hashCode()) + 7 * (this.unit == null ? 1 : this.unit.hashCode()) + 11 * (int)(this.elevation * 1000.0) + 13 * (int)(this.navd88Offset * 1000.0) + 17 * (this.navd88OffsetIsEstimate ? 3 : 7) + 19 * (int)(this.ngvd29Offset * 1000.0) + 23 * (this.ngvd29OffsetIsEstimate ? 3 : 7);
            return hashCode;
        }
    }

    public void printToConsole() {
        System.out.println("nativeDatum: " + this.nativeDatum);
        System.out.println("currentDatum: " + this.currentDatum);
        System.out.println("localDatumName: " + this.localDatumName);
        System.out.println("unit: " + this.unit);
        System.out.println("elevation: " + this.elevation);
        System.out.println("ngvd29Offset: " + this.ngvd29Offset);
        System.out.println("navd88Offset: " + this.navd88Offset);
        System.out.println("ngvd29OffsetIsEstimate: " + this.ngvd29OffsetIsEstimate);
        System.out.println("navd88OffsetIsEstimate: " + this.navd88OffsetIsEstimate);
    }

    private static boolean textEquals(CharSequence txt1, CharSequence txt2) {
        if (txt1 == null) {
            if (txt2 == null) {
                return true;
            }
            return txt2.length() == 0;
        }
        if (txt2 == null) {
            return txt1.length() == 0;
        }
        return txt1.equals(txt2);
    }

    private static boolean textEqualsIgnoreCase(CharSequence txt1, CharSequence txt2) {
        return VerticalDatumContainer.textEquals(txt1 == null ? txt1 : txt1.toString().toUpperCase(), txt2 == null ? txt2 : txt2.toString().toUpperCase());
    }

    private static String replaceAll(String str, String old, String replacement) {
        Matcher matcher = Pattern.compile(old, 10).matcher(str);
        StringBuffer sb = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(sb, replacement);
        }
        matcher.appendTail(sb);
        return sb.toString();
    }

    public void setVerticalDatumContainer(VerticalDatumContainer vdc) {
        this.nativeDatum = vdc.nativeDatum;
        this.currentDatum = vdc.currentDatum;
        this.localDatumName = vdc.localDatumName;
        this.unit = vdc.unit;
        this.elevation = vdc.elevation;
        this.ngvd29Offset = vdc.ngvd29Offset;
        this.navd88Offset = vdc.navd88Offset;
        this.ngvd29OffsetIsEstimate = vdc.ngvd29OffsetIsEstimate;
        this.navd88OffsetIsEstimate = vdc.navd88OffsetIsEstimate;
    }

    @Override
    public VerticalDatumContainer getVerticalDatumContainer() {
        return this;
    }

    public final void addOffset(String toDatum, Double value, boolean estimate) throws VerticalDatumException {
        if (toDatum != null) {
            String datum = VerticalDatumContainer.replaceAll(toDatum.toUpperCase(), DATUM_EXTERNAL_PATTERN, DATUM_INTERNAL_FORMAT);
            if (datum.equalsIgnoreCase(this.nativeDatum)) {
                throw new VerticalDatumException("Cannot add offset to native datum: " + this.nativeDatum);
            }
            switch (datum) {
                case "NGVD29": {
                    this.ngvd29Offset = value == null ? -3.4028234663852886E38 : value;
                    this.ngvd29OffsetIsEstimate = estimate;
                    break;
                }
                case "NAVD88": {
                    this.navd88Offset = value == null ? -3.4028234663852886E38 : value;
                    this.navd88OffsetIsEstimate = estimate;
                    break;
                }
                case "UNKNOWN": {
                    break;
                }
                default: {
                    throw new VerticalDatumException("Unsupported datum offset: " + datum);
                }
            }
        }
    }
}

