/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.constants;

import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TimeZone;

public final class NumericalConstants {
    public static final float UNDEFINED_FLOAT = -3.4028235E38f;
    public static final double UNDEFINED_DOUBLE = -3.4028234663852886E38;
    public static final int UNDEFINED_INT = Integer.MIN_VALUE;
    public static final long UNDEFINED_LONG = Long.MIN_VALUE;
    public static final long UNDEFINED_TIME = Long.MIN_VALUE;
    public static final Instant UNDEFINED_INSTANT = Instant.ofEpochMilli(Long.MIN_VALUE);
    private static final Instant NOTVERSIONED_INSTANT = ZonedDateTime.of(1111, 11, 18, 0, 0, 0, 0, ZoneId.of("UTC")).toInstant();
    public static final double UNDEF_DOUBLE = Double.NEGATIVE_INFINITY;
    public static final int UNDEF_INT = Integer.MIN_VALUE;
    public static final double MISSING_DOUBLE = -901.0;
    public static final float HEC_UNDEFINED_FLOAT = -3.4028235E38f;
    public static final double HEC_UNDEFINED_DOUBLE = -3.4028234663852886E38;
    public static final double ORACLE_PRECISION = 1.0E-14;
    public static final double MEASURABLE_VALUE_PRECISION = 1.0E-6;
    public static final TimeZone UTC_TZ = TimeZone.getTimeZone("UTC");
    public static final ZoneId UTC_ZONEID = ZoneId.of("UTC");

    private NumericalConstants() {
        throw new AssertionError((Object)"Utility class");
    }

    public static Instant notVersioned() {
        return NOTVERSIONED_INSTANT;
    }

    public static boolean isNotVersioned(Instant instant) {
        return instant == NOTVERSIONED_INSTANT;
    }

    public static boolean isValidValue(double v) {
        return !Double.isInfinite(v) && !Double.isNaN(v) && v != Double.NEGATIVE_INFINITY && v != -901.0 && v != -3.4028234663852886E38;
    }

    public static boolean isValidValue(Double v) {
        return v != null && NumericalConstants.isValidValue((double)v);
    }

    public static boolean isNotValidValue(double v) {
        return !NumericalConstants.isValidValue(v);
    }

    public static double parseDouble(String str) {
        double val;
        if (str == null) {
            return Double.NEGATIVE_INFINITY;
        }
        String tmp = str;
        if (tmp.length() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        int idx = tmp.indexOf(68);
        if (idx >= 0) {
            tmp = tmp.replace('D', 'E');
        }
        if ((idx = tmp.indexOf(100)) >= 0) {
            tmp = tmp.replace('d', 'E');
        }
        if ((idx = tmp.indexOf(44)) >= 0) {
            tmp = NumericalConstants.removeChar(tmp, ',');
        }
        str = tmp;
        try {
            val = Double.parseDouble(str);
        }
        catch (NumberFormatException e) {
            val = Double.NEGATIVE_INFINITY;
        }
        return val;
    }

    public static SimpleDateFormat sdfFULL() {
        return new SimpleDateFormat("EEE MMM d HH:mm:ss zzz yyyy");
    }

    public static String removeChar(String s, char c) {
        if (s == null) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length());
        buf.setLength(s.length());
        int current = 0;
        int cnt = 0;
        for (int i = 0; i < s.length(); ++i) {
            char cur = s.charAt(i);
            if (cur != c) {
                buf.setCharAt(current, cur);
                ++current;
                continue;
            }
            ++cnt;
        }
        buf.setLength(buf.length() - cnt);
        return buf.toString();
    }

    public static boolean equalsIgnoreCase(String v1, String v2) {
        return v1 == null ? v2 == null : v1.equalsIgnoreCase(v2);
    }

    public static int compareTo(double val, double compareTo, double precision) {
        double diff = compareTo - val;
        if (Math.abs(diff) <= precision) {
            return 0;
        }
        if (val > compareTo) {
            return 1;
        }
        return -1;
    }
}

