/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.forecast;

import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import mil.army.usace.hec.metadata.forecast.ForecastInstance;
import mil.army.usace.hec.metadata.forecast.ForecastInstanceImpl;
import mil.army.usace.hec.metadata.forecast.ForecastSpec;
import mil.army.usace.hec.metadata.web.MediaType;

public final class ForecastInstanceBuilder {
    private final ForecastSpec _forecastSpec;
    private final Instant _forecastDate;
    private final Instant _issueDate;
    private final Map<String, String> _metaData = new HashMap<String, String>();
    private String _forecastNotes;
    private String _forecastFileName;
    private String _forecastFileDescription;
    private Duration _validDuration;
    private Instant _lastDate;
    private Instant _firstDate;
    private MediaType _forecastFileMediaType;

    public ForecastInstanceBuilder(ForecastSpec forecastSpec, Instant forecastDate, Instant issueDate) {
        this._forecastSpec = Objects.requireNonNull(forecastSpec, "Cannot create a forecast instance without a forecast spec");
        this._forecastDate = Objects.requireNonNull(forecastDate, "Cannot create a forecast instance without a forecast date");
        this._issueDate = Objects.requireNonNull(issueDate, "Cannot create a forecast instance without an issue date");
    }

    ForecastSpec getForecastSpec() {
        return this._forecastSpec;
    }

    Instant getForecastDate() {
        return this._forecastDate;
    }

    Instant getIssueDate() {
        return this._issueDate;
    }

    Map<String, String> getMetaData() {
        return this._metaData;
    }

    public ForecastInstanceBuilder metaData(Map<String, String> metaData) {
        this._metaData.clear();
        this._metaData.putAll(metaData);
        return this;
    }

    String getForecastNotes() {
        return this._forecastNotes;
    }

    public ForecastInstanceBuilder forecastNotes(String forecastNotes) {
        this._forecastNotes = forecastNotes;
        return this;
    }

    String getForecastFileName() {
        return this._forecastFileName;
    }

    public ForecastInstanceBuilder forecastFileName(String forecastFileName) {
        this._forecastFileName = forecastFileName;
        return this;
    }

    public MediaType getForecastFileMediaType() {
        return this._forecastFileMediaType;
    }

    public ForecastInstanceBuilder forecastFileMediaType(MediaType mediaType) {
        this._forecastFileMediaType = mediaType;
        return this;
    }

    String getForecastFileDescription() {
        return this._forecastFileDescription;
    }

    public ForecastInstanceBuilder forecastFileDescription(String forecastFileDescription) {
        this._forecastFileDescription = forecastFileDescription;
        return this;
    }

    public ForecastInstanceBuilder firstDate(Instant firstDate) {
        this._firstDate = firstDate;
        return this;
    }

    Instant getFirstDate() {
        return this._firstDate;
    }

    public ForecastInstanceBuilder lastDate(Instant lastDate) {
        this._lastDate = lastDate;
        return this;
    }

    Instant getLastDate() {
        return this._lastDate;
    }

    public ForecastInstanceBuilder validDuration(Duration validDuration) {
        this._validDuration = validDuration;
        return this;
    }

    Duration getValidDuration() {
        return this._validDuration;
    }

    public ForecastInstance build() {
        return new ForecastInstanceImpl(this);
    }
}

