/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.forecast;

import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mil.army.usace.hec.metadata.forecast.ForecastInstance;
import mil.army.usace.hec.metadata.forecast.ForecastInstanceBuilder;
import mil.army.usace.hec.metadata.forecast.ForecastSpec;
import mil.army.usace.hec.metadata.web.MediaType;

final class ForecastInstanceImpl
implements ForecastInstance {
    private final ForecastSpec _forecastSpec;
    private final Instant _forecastDate;
    private final Instant _issueDate;
    private final Map<String, String> _metaData;
    private final String _forecastNotes;
    private final String _forecastFileName;
    private final MediaType _forecastFileMediaType;
    private final String _forecastFileDescription;
    private final Instant _firstDate;
    private final Duration _validDuration;
    private final Instant _lastDate;

    ForecastInstanceImpl(ForecastInstanceBuilder builder) {
        this._forecastSpec = builder.getForecastSpec();
        this._forecastDate = builder.getForecastDate();
        this._issueDate = builder.getIssueDate();
        this._metaData = Collections.unmodifiableMap(builder.getMetaData());
        this._forecastNotes = builder.getForecastNotes();
        this._forecastFileName = builder.getForecastFileName();
        this._forecastFileMediaType = builder.getForecastFileMediaType();
        this._forecastFileDescription = builder.getForecastFileDescription();
        this._firstDate = builder.getFirstDate();
        this._lastDate = builder.getLastDate();
        this._validDuration = builder.getValidDuration();
    }

    @Override
    public ForecastSpec getForecastSpec() {
        return this._forecastSpec;
    }

    @Override
    public Instant getForecastDate() {
        return this._forecastDate;
    }

    @Override
    public Instant getIssueDate() {
        return this._issueDate;
    }

    @Override
    public Optional<Instant> getFirstDate() {
        return Optional.ofNullable(this._firstDate);
    }

    @Override
    public Optional<Instant> getLastDate() {
        return Optional.ofNullable(this._lastDate);
    }

    @Override
    public Optional<Duration> getValidDuration() {
        return Optional.ofNullable(this._validDuration);
    }

    @Override
    public Map<String, String> getMetaData() {
        return new HashMap<String, String>(this._metaData);
    }

    @Override
    public Optional<String> getForecastNotes() {
        return Optional.ofNullable(this._forecastNotes);
    }

    @Override
    public Optional<String> getForecastFileName() {
        return Optional.ofNullable(this._forecastFileName);
    }

    @Override
    public Optional<MediaType> getForecastFileMediaType() {
        return Optional.ofNullable(this._forecastFileMediaType);
    }

    @Override
    public Optional<String> getForecastFileDescription() {
        return Optional.ofNullable(this._forecastFileDescription);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForecastInstanceImpl that = (ForecastInstanceImpl)o;
        return Objects.equals(this._forecastSpec, that._forecastSpec) && Objects.equals(this._forecastDate, that._forecastDate) && Objects.equals(this._issueDate, that._issueDate) && Objects.equals(this._metaData, that._metaData) && Objects.equals(this._forecastNotes, that._forecastNotes) && Objects.equals(this._forecastFileName, that._forecastFileName) && Objects.equals(this._forecastFileMediaType, that._forecastFileMediaType) && Objects.equals(this._forecastFileDescription, that._forecastFileDescription) && Objects.equals(this._firstDate, that._firstDate) && Objects.equals(this._validDuration, that._validDuration) && Objects.equals(this._lastDate, that._lastDate);
    }

    public int hashCode() {
        return Objects.hash(this._forecastSpec, this._forecastDate, this._issueDate, this._metaData, this._forecastNotes, this._forecastFileName, this._forecastFileMediaType, this._forecastFileDescription, this._firstDate, this._validDuration, this._lastDate);
    }
}

