/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.forecast;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import mil.army.usace.hec.metadata.forecast.ForecastSpec;
import mil.army.usace.hec.metadata.forecast.ForecastSpecImpl;
import mil.army.usace.hec.metadata.location.LocationTemplate;

public final class ForecastSpecBuilder {
    private final String _specId;
    private final String _officeId;
    private final Set<String> _timeSeriesIdentifiers = new HashSet<String>();
    private final String _designator;
    private final String _sourceEntity;
    private LocationTemplate _locationTemplate;
    private String _description;

    public ForecastSpecBuilder(String specId, String officeId, String designator, String sourceEntity) {
        this._specId = Objects.requireNonNull(specId, "Cannot create a forecast specification without an id");
        this._officeId = Objects.requireNonNull(officeId, "Cannot create a forecast specification without an office");
        this._designator = Objects.requireNonNull(designator, "Cannot create a forecast specification without a designator");
        this._sourceEntity = Objects.requireNonNull(sourceEntity, "Cannot create a forecast specification without a source entity");
    }

    public ForecastSpecBuilder description(String description) {
        this._description = description;
        return this;
    }

    public ForecastSpecBuilder timeSeriesIdentifiers(Set<String> timeSeriesIdentifiers) {
        this._timeSeriesIdentifiers.clear();
        this._timeSeriesIdentifiers.addAll(timeSeriesIdentifiers);
        return this;
    }

    LocationTemplate locationTemplate() {
        return this._locationTemplate;
    }

    public ForecastSpecBuilder locationTemplate(LocationTemplate locationTemplate) {
        this._locationTemplate = locationTemplate;
        return this;
    }

    String officeId() {
        return this._officeId;
    }

    Set<String> timeSeriesIdentifiers() {
        return this._timeSeriesIdentifiers;
    }

    String description() {
        return this._description;
    }

    String designator() {
        return this._designator;
    }

    String sourceEntity() {
        return this._sourceEntity;
    }

    String specId() {
        return this._specId;
    }

    public ForecastSpec build() {
        return new ForecastSpecImpl(this);
    }
}

