/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.interval;

import java.time.Duration;
import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.TemporalAmount;
import java.util.Date;
import java.util.Objects;
import java.util.TimeZone;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalOffset;

class IrregularInterval
implements Interval {
    private static final long serialVersionUID = -5009703912699723287L;
    private final String _intervalName;

    IrregularInterval(String intervalName) {
        this._intervalName = intervalName;
    }

    public int hashCode() {
        return Objects.hashCode(this.toString());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IrregularInterval)) {
            return false;
        }
        return Objects.equals(this.toString(), o.toString());
    }

    @Override
    public String getInterval() {
        return this._intervalName;
    }

    @Override
    public int getSeconds() {
        return 0;
    }

    @Override
    public boolean isLessThanDecade() {
        return false;
    }

    @Override
    public boolean isLessThanYearly() {
        return false;
    }

    @Override
    public boolean isLessThanMonthly() {
        return false;
    }

    @Override
    public boolean isLessThanWeekly() {
        return false;
    }

    @Override
    public boolean isLessThanDaily() {
        return false;
    }

    @Override
    public boolean isLessThanHourly() {
        return false;
    }

    @Override
    public long getMillis() {
        return 0L;
    }

    @Override
    public int getMinutes() {
        return 0;
    }

    @Override
    public boolean isRegular() {
        return false;
    }

    @Override
    public boolean isIrregular() {
        return true;
    }

    @Override
    public boolean isLocalRegular() {
        return false;
    }

    @Override
    public boolean isHourly() {
        return false;
    }

    @Override
    public boolean isDaily() {
        return false;
    }

    @Override
    public boolean isWeekly() {
        return false;
    }

    @Override
    public boolean isMonthly() {
        return false;
    }

    @Override
    public boolean isYearly() {
        return false;
    }

    @Override
    public int getCalendarField() {
        return 0;
    }

    @Override
    public long getTimeOnPreviousOrCurrentInterval(long time, IntervalOffset intervalOffset, TimeZone timeZone) throws DataSetIllegalArgumentException {
        throw new DataSetIllegalArgumentException("Unable to determine time on previous or current irregular interval");
    }

    @Override
    public long getTimeOnNextOrCurrentInterval(long time, IntervalOffset intervalOffset, TimeZone timeZone) throws DataSetIllegalArgumentException {
        throw new DataSetIllegalArgumentException("Unable to determine time on next or current irregular interval");
    }

    @Override
    public Instant getTimeOnPreviousOrCurrentInterval(Instant time, IntervalOffset intervalOffset, ZoneId timeZone) throws DataSetIllegalArgumentException {
        throw new DataSetIllegalArgumentException("Unable to determine time on previous or current irregular interval");
    }

    @Override
    public Instant getTimeOnNextOrCurrentInterval(Instant time, IntervalOffset intervalOffset, ZoneId timeZone) throws DataSetIllegalArgumentException {
        throw new DataSetIllegalArgumentException("Unable to determine time on next or current irregular interval");
    }

    @Override
    public TemporalAmount getTemporalAmount() {
        return Duration.ZERO;
    }

    @Override
    public long getNextIntervalTime(long time, TimeZone timeZone) throws DataSetIllegalArgumentException {
        throw new DataSetIllegalArgumentException("Unable to determine time on next irregular interval");
    }

    @Override
    public long getNextIntervalTime(long time, long intervals, TimeZone timeZone) throws DataSetIllegalArgumentException {
        throw new DataSetIllegalArgumentException("Unable to determine time on next irregular interval");
    }

    @Override
    public long getPreviousIntervalTime(long time, TimeZone timeZone) throws DataSetIllegalArgumentException {
        throw new DataSetIllegalArgumentException("Unable to determine time on previous irregular interval");
    }

    @Override
    public Instant getNextIntervalTime(Instant time, ZoneId zoneId) throws DataSetIllegalArgumentException {
        throw new DataSetIllegalArgumentException("Unable to determine time on next irregular interval");
    }

    @Override
    public Instant getNextIntervalTime(Instant time, long intervals, ZoneId zoneId) throws DataSetIllegalArgumentException {
        throw new DataSetIllegalArgumentException("Unable to determine time on next irregular interval");
    }

    @Override
    public Instant getPreviousIntervalTime(Instant time, ZoneId zoneId) throws DataSetIllegalArgumentException {
        throw new DataSetIllegalArgumentException("Unable to determine time on previous irregular interval");
    }

    @Override
    public int getCalendarAmount() {
        return 0;
    }

    @Override
    public long calcNumberOfIntervals(Date startTime, Date endTime, IntervalOffset intervalOffset, TimeZone timeZone) throws DataSetIllegalArgumentException {
        throw new DataSetIllegalArgumentException("Cannot calculate total intervals for an irregular interval");
    }

    @Override
    public long calcNumberOfIntervals(Instant startTime, Instant endTime, IntervalOffset intervalOffset, ZoneId zoneId) throws DataSetIllegalArgumentException {
        throw new DataSetIllegalArgumentException("Cannot calculate total intervals for an irregular interval");
    }

    @Override
    public void validateOffset(IntervalOffset intervalOffset) throws DataSetIllegalArgumentException {
        if (!intervalOffset.isNoOffset()) {
            throw new DataSetIllegalArgumentException("Irregular Interval ID: " + this.toString() + " must have no interval offset. Offset provided was: " + intervalOffset);
        }
    }

    @Override
    public int getNumIntervalPoints(long startTime, long endTime, TimeZone timeZone) throws DataSetIllegalArgumentException {
        throw new DataSetIllegalArgumentException("Cannot calculate total intervals for an irregular interval");
    }

    @Override
    public long getNumIntervalPoints(Instant startTime, Instant endTime, ZoneId zoneId) throws DataSetIllegalArgumentException {
        throw new DataSetIllegalArgumentException("Cannot calculate total intervals for an irregular interval");
    }

    public String toString() {
        return this.getInterval();
    }

    @Override
    public boolean isOnInterval(Instant instant, IntervalOffset offset, ZoneId zoneId) {
        return true;
    }
}

