/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.interval;

import java.time.Instant;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.IllegalIntervalOffsetException;
import mil.army.usace.hec.metadata.IntervalFactory;
import mil.army.usace.hec.metadata.IntervalOffset;
import mil.army.usace.hec.metadata.interval.RegularInterval;

class LocalRegularInterval
extends RegularInterval {
    private static final long serialVersionUID = 5866593638931391672L;

    LocalRegularInterval(String intervalName, long minutes, TemporalAmount temporalAmount) {
        super(intervalName, minutes, temporalAmount);
    }

    @Override
    public boolean isRegular() {
        return false;
    }

    @Override
    public boolean isLocalRegular() {
        return true;
    }

    @Override
    public long getPreviousIntervalTime(long time, TimeZone timeZone) {
        ZonedDateTime newZonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), timeZone.toZoneId()).minus(this.getTemporalAmount());
        if (this.isLessThanDaily() && TimeUnit.MILLISECONDS.toHours(this.getMillis()) > 1L) {
            newZonedDateTime = this.adjustDst(newZonedDateTime, newZonedDateTime.getZone().getRules().getOffset(Instant.ofEpochMilli(time)));
        }
        return newZonedDateTime.toInstant().toEpochMilli();
    }

    @Override
    public long getNextIntervalTime(long time, TimeZone timeZone) {
        ZonedDateTime newZonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), timeZone.toZoneId()).plus(this.getTemporalAmount());
        if (this.isLessThanDaily() && TimeUnit.MILLISECONDS.toHours(this.getMillis()) > 1L) {
            newZonedDateTime = this.adjustDst(newZonedDateTime, newZonedDateTime.getZone().getRules().getOffset(Instant.ofEpochMilli(time)));
        }
        return newZonedDateTime.toInstant().toEpochMilli();
    }

    @Override
    public long getNextIntervalTime(long time, long interval, TimeZone timeZone) {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), timeZone.toZoneId());
        for (TemporalUnit unit : this.getTemporalAmount().getUnits()) {
            long incrementAmount = interval * this.getTemporalAmount().get(unit);
            if (incrementAmount == 0L) continue;
            zonedDateTime = zonedDateTime.plus(incrementAmount, unit);
        }
        if (this.isLessThanDaily() && TimeUnit.MILLISECONDS.toHours(this.getMillis()) > 1L) {
            zonedDateTime = this.adjustDst(zonedDateTime, zonedDateTime.getZone().getRules().getOffset(Instant.ofEpochMilli(time)));
        }
        return zonedDateTime.toInstant().toEpochMilli();
    }

    @Override
    public long getTimeOnNextOrCurrentInterval(long time, IntervalOffset intervalOffset, TimeZone timeZone) throws DataSetIllegalArgumentException {
        long millisInInterval = this.getMillis();
        long timeAtTopOfInterval = this.getTimeOnPreviousOrCurrentInterval(time, intervalOffset, timeZone);
        if (time > timeAtTopOfInterval) {
            timeAtTopOfInterval = this.getNextIntervalTime(timeAtTopOfInterval, timeZone);
        }
        return timeAtTopOfInterval;
    }

    @Override
    public Instant getTimeOnPreviousOrCurrentInterval(Instant time, IntervalOffset intervalOffset, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return Instant.ofEpochMilli(this.getTimeOnPreviousOrCurrentInterval(time.toEpochMilli(), intervalOffset, TimeZone.getTimeZone(zoneId)));
    }

    @Override
    public Instant getTimeOnNextOrCurrentInterval(Instant time, IntervalOffset intervalOffset, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return Instant.ofEpochMilli(this.getTimeOnNextOrCurrentInterval(time.toEpochMilli(), intervalOffset, TimeZone.getTimeZone(zoneId)));
    }

    @Override
    public Instant getNextIntervalTime(Instant time, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return Instant.ofEpochMilli(this.getNextIntervalTime(time.toEpochMilli(), TimeZone.getTimeZone(zoneId)));
    }

    @Override
    public Instant getNextIntervalTime(Instant time, long intervals, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return Instant.ofEpochMilli(this.getNextIntervalTime(time.toEpochMilli(), intervals, TimeZone.getTimeZone(zoneId)));
    }

    @Override
    public Instant getPreviousIntervalTime(Instant time, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return Instant.ofEpochMilli(this.getPreviousIntervalTime(time.toEpochMilli(), TimeZone.getTimeZone(zoneId)));
    }

    @Override
    public int getNumIntervalPoints(long startTime, long endTime, TimeZone timeZone) {
        int num = 0;
        while (startTime <= endTime) {
            ++num;
            startTime = this.getNextIntervalTime(startTime, timeZone);
        }
        return num;
    }

    @Override
    public long getNumIntervalPoints(Instant startTime, Instant endTime, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return this.getNumIntervalPoints(startTime.toEpochMilli(), endTime.toEpochMilli(), TimeZone.getTimeZone(zoneId));
    }

    @Override
    public long getTimeOnPreviousOrCurrentInterval(long time, IntervalOffset intervalOffset, TimeZone timeZone) throws DataSetIllegalArgumentException {
        ZonedDateTime zonedDateTime = ZonedDateTime.ofInstant(Instant.ofEpochMilli(time), timeZone.toZoneId());
        ZonedDateTime truncatedTime = this.truncateToInterval(zonedDateTime);
        ZoneOffset firstOffset = truncatedTime.getOffset();
        if (intervalOffset != null) {
            List<TemporalAmount> offsets = intervalOffset.getOffsets();
            for (TemporalAmount offset : offsets) {
                truncatedTime = truncatedTime.plus(offset);
            }
        }
        if ((truncatedTime = this.adjustDst(truncatedTime, firstOffset)).isAfter(zonedDateTime)) {
            return this.getPreviousIntervalTime(truncatedTime.toInstant().toEpochMilli(), timeZone);
        }
        return truncatedTime.toInstant().toEpochMilli();
    }

    private ZonedDateTime adjustDst(ZonedDateTime newZonedDateTime, ZoneOffset originalOffset) {
        ZoneOffset secondOffset = newZonedDateTime.getZone().getRules().getOffset(newZonedDateTime.toInstant());
        if (!originalOffset.equals(secondOffset)) {
            int differenceInSeconds = originalOffset.getTotalSeconds() - secondOffset.getTotalSeconds();
            newZonedDateTime = newZonedDateTime.plusSeconds(differenceInSeconds);
        }
        return newZonedDateTime;
    }

    private ZonedDateTime truncateToInterval(ZonedDateTime zonedDateTime) {
        long remainder;
        if (this.temporalAmountContains(ChronoUnit.YEARS)) {
            remainder = (long)zonedDateTime.getYear() % this.getTemporalAmount().get(ChronoUnit.YEARS);
            zonedDateTime = zonedDateTime.withYear((int)((long)zonedDateTime.getYear() - remainder)).withDayOfYear(1).truncatedTo(ChronoUnit.DAYS);
        }
        if (this.temporalAmountContains(ChronoUnit.MONTHS)) {
            remainder = (long)zonedDateTime.getMonthValue() % this.getTemporalAmount().get(ChronoUnit.MONTHS);
            zonedDateTime = zonedDateTime.withMonth((int)((long)zonedDateTime.getMonthValue() - remainder)).withDayOfMonth(1).truncatedTo(ChronoUnit.DAYS);
        }
        if (this.temporalAmountContains(ChronoUnit.DAYS)) {
            if (this.getTemporalAmount().equals(Period.ofDays(1))) {
                zonedDateTime = zonedDateTime.truncatedTo(ChronoUnit.DAYS);
            } else {
                remainder = (long)zonedDateTime.getDayOfMonth() % this.getTemporalAmount().get(ChronoUnit.DAYS);
                zonedDateTime = zonedDateTime.withDayOfMonth((int)((long)zonedDateTime.getDayOfMonth() - remainder) + 1).truncatedTo(ChronoUnit.DAYS);
            }
        }
        if (this.temporalAmountContains(ChronoUnit.SECONDS)) {
            long intervalSeconds = this.getTemporalAmount().get(ChronoUnit.SECONDS);
            if (TimeUnit.SECONDS.toHours(intervalSeconds) > 0L) {
                long newHour = (long)zonedDateTime.getHour() - (long)zonedDateTime.getHour() % TimeUnit.SECONDS.toHours(intervalSeconds);
                zonedDateTime = zonedDateTime.withHour((int)newHour).truncatedTo(ChronoUnit.HOURS);
            } else if (TimeUnit.SECONDS.toMinutes(intervalSeconds) > 0L) {
                zonedDateTime = zonedDateTime.minusMinutes((long)zonedDateTime.getMinute() % TimeUnit.SECONDS.toMinutes(intervalSeconds)).truncatedTo(ChronoUnit.MINUTES);
            } else if (intervalSeconds != 0L) {
                zonedDateTime = zonedDateTime.minusSeconds((long)zonedDateTime.getSecond() % intervalSeconds).truncatedTo(ChronoUnit.SECONDS);
            }
        }
        return zonedDateTime;
    }

    private boolean temporalAmountContains(ChronoUnit chronoUnit) {
        boolean retval = false;
        if (this.getTemporalAmount().getUnits().contains(chronoUnit)) {
            retval = this.getTemporalAmount().get(chronoUnit) != 0L;
        }
        return retval;
    }

    @Override
    public void validateOffset(IntervalOffset intervalOffset) throws DataSetIllegalArgumentException {
        if (intervalOffset.isNoOffset() || intervalOffset.isDefined() && intervalOffset.getOffsetSeconds() > 0) {
            throw new DataSetIllegalArgumentException("Local Regular Interval ID: " + this.toString() + " must have a negative offset. Offset provided was: " + intervalOffset);
        }
        if (intervalOffset.isDefined() && Math.abs(intervalOffset.getOffsetSeconds()) >= this.getSeconds()) {
            String error = "Interval offset, " + intervalOffset + ", must be less than the Interval, " + this.toString() + ".";
            throw new IllegalIntervalOffsetException(error);
        }
    }

    @Override
    public long calcNumberOfIntervals(Date startTime, Date endTime, IntervalOffset intervalOffset, TimeZone timeZone) throws DataSetIllegalArgumentException {
        long onIntervalStart = this.getTimeOnNextOrCurrentInterval(startTime.getTime(), intervalOffset, timeZone);
        long onIntervalEnd = this.getTimeOnNextOrCurrentInterval(endTime.getTime(), intervalOffset, timeZone);
        int num = 0;
        while (onIntervalStart < onIntervalEnd) {
            ++num;
            onIntervalStart = this.getNextIntervalTime(onIntervalStart, timeZone);
        }
        return num;
    }

    @Override
    public long calcNumberOfIntervals(Instant startTime, Instant endTime, IntervalOffset intervalOffset, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return this.calcNumberOfIntervals(Date.from(startTime), Date.from(endTime), intervalOffset, TimeZone.getTimeZone(zoneId));
    }

    @Override
    public final String getInterval() {
        String retval = IntervalFactory.useNewLocalRegularId() ? super.getInterval() + "Local" : "~" + super.getInterval();
        return retval;
    }
}

