/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.interval;

import java.time.Instant;
import java.time.ZoneId;
import java.time.temporal.TemporalAmount;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.IllegalIntervalOffsetException;
import mil.army.usace.hec.metadata.Interval;
import mil.army.usace.hec.metadata.IntervalOffset;

class RegularInterval
implements Interval {
    private static final long serialVersionUID = -8511673889338772969L;
    private static final Logger LOGGER = Logger.getLogger(RegularInterval.class.getName());
    private final long _intervalMillis;
    private final String _intervalName;
    private final boolean _isHourly;
    private final boolean _isDaily;
    private final boolean _isWeekly;
    private final boolean _isMonthly;
    private final boolean _isYearly;
    private final TemporalAmount _temporalAmount;

    RegularInterval(String intervalName, long millis, TemporalAmount temporalAmount) {
        this._intervalName = intervalName;
        this._intervalMillis = millis;
        this._isYearly = this._intervalMillis >= TimeUnit.DAYS.toMillis(365L);
        this._isMonthly = !this._isYearly && this._intervalMillis >= TimeUnit.DAYS.toMillis(30L);
        this._isWeekly = !this._isMonthly && this._intervalMillis >= TimeUnit.DAYS.toMillis(7L);
        this._isDaily = !this._isWeekly && this._intervalMillis >= TimeUnit.DAYS.toMillis(1L);
        this._isHourly = this._intervalMillis < TimeUnit.DAYS.toMillis(1L);
        this._temporalAmount = temporalAmount;
    }

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegularInterval)) {
            return false;
        }
        RegularInterval that = (RegularInterval)o;
        return this.getMillis() == that.getMillis() && this.toString().equalsIgnoreCase(that.toString());
    }

    public final int hashCode() {
        return Objects.hash(this.getMillis(), this.toString().toLowerCase());
    }

    public final String toString() {
        return this.getInterval();
    }

    @Override
    public String getInterval() {
        return this._intervalName;
    }

    @Override
    public final int getSeconds() {
        return (int)TimeUnit.MILLISECONDS.toSeconds(this._intervalMillis);
    }

    @Override
    public final boolean isLessThanDecade() {
        return this._intervalMillis < 315360000000L;
    }

    @Override
    public final boolean isLessThanYearly() {
        return this._intervalMillis < 31536000000L;
    }

    @Override
    public final boolean isLessThanMonthly() {
        return this._intervalMillis < 2592000000L;
    }

    @Override
    public final boolean isLessThanWeekly() {
        return this._intervalMillis < 604800000L;
    }

    @Override
    public final boolean isLessThanDaily() {
        return this._intervalMillis < 86400000L;
    }

    @Override
    public final boolean isLessThanHourly() {
        return this._intervalMillis < 3600000L;
    }

    @Override
    public final long getMillis() {
        return this._intervalMillis;
    }

    @Override
    public final int getMinutes() {
        return (int)TimeUnit.MILLISECONDS.toMinutes(this._intervalMillis);
    }

    @Override
    public boolean isRegular() {
        return true;
    }

    @Override
    public boolean isIrregular() {
        return false;
    }

    @Override
    public boolean isLocalRegular() {
        return false;
    }

    @Override
    public final boolean isHourly() {
        return this._isHourly;
    }

    @Override
    public final boolean isDaily() {
        return this._isDaily;
    }

    @Override
    public final boolean isWeekly() {
        return this._isWeekly;
    }

    @Override
    public final boolean isMonthly() {
        return this._isMonthly;
    }

    @Override
    public final boolean isYearly() {
        return this._isYearly;
    }

    @Override
    public final int getCalendarField() {
        if (this.isLessThanHourly()) {
            return 12;
        }
        if (this.isLessThanDaily()) {
            return 10;
        }
        if (this.isLessThanWeekly()) {
            return 5;
        }
        if (this.isLessThanMonthly()) {
            return 3;
        }
        if (this.isLessThanYearly()) {
            return 2;
        }
        if (this.isLessThanDecade()) {
            return 1;
        }
        return 1;
    }

    @Override
    public final int getCalendarAmount() {
        if (this.isLessThanHourly()) {
            return (int)TimeUnit.MILLISECONDS.toMinutes(this._intervalMillis);
        }
        if (this.isLessThanDaily()) {
            return (int)TimeUnit.MILLISECONDS.toHours(this._intervalMillis);
        }
        if (this.isLessThanWeekly()) {
            return (int)TimeUnit.MILLISECONDS.toDays(this._intervalMillis);
        }
        if (this.isLessThanDecade()) {
            return 1;
        }
        return 10;
    }

    @Override
    public long getTimeOnPreviousOrCurrentInterval(long time, IntervalOffset intervalOffset, TimeZone timeZone) throws DataSetIllegalArgumentException {
        long offsetTime;
        long millisInInterval = this.getMillis();
        long timeAtTopOfInterval = time;
        if (this.isLessThanMonthly()) {
            long millisInTimeZoneOffset = timeZone.getRawOffset();
            long remainder = (timeAtTopOfInterval += millisInTimeZoneOffset) % millisInInterval;
            if (remainder != 0L) {
                timeAtTopOfInterval = timeAtTopOfInterval < 0L ? (timeAtTopOfInterval -= millisInInterval + remainder) : (timeAtTopOfInterval -= remainder);
            }
            offsetTime = timeAtTopOfInterval -= millisInTimeZoneOffset;
            if (intervalOffset != null && intervalOffset.isDefined() && (offsetTime += intervalOffset.getOffsetMillis()) > time) {
                offsetTime -= millisInInterval;
            }
        } else {
            GregorianCalendar gc = new GregorianCalendar(timeZone);
            gc.setTime(new Date(timeAtTopOfInterval));
            if (!this.isLessThanYearly()) {
                gc.set(2, 0);
            }
            if (!this.isLessThanDecade()) {
                gc.set(1, gc.get(1) / 10 * 10);
            }
            gc.set(5, 1);
            gc.set(11, 0);
            gc.set(12, 0);
            gc.set(13, 0);
            gc.set(14, 0);
            offsetTime = timeAtTopOfInterval = gc.getTimeInMillis();
            if (intervalOffset != null && intervalOffset.isDefined() && (offsetTime += intervalOffset.getOffsetMillis()) > time) {
                gc.setTimeInMillis(offsetTime);
                int calendarAmount = this.getCalendarAmount();
                int calendarField = this.getCalendarField();
                gc.add(calendarField, calendarAmount);
                offsetTime = gc.getTimeInMillis();
            }
        }
        return offsetTime;
    }

    @Override
    public long getTimeOnNextOrCurrentInterval(long time, IntervalOffset intervalOffset, TimeZone timeZone) throws DataSetIllegalArgumentException {
        long millisInInterval = this.getMillis();
        long timeAtTopOfInterval = this.getTimeOnPreviousOrCurrentInterval(time, intervalOffset, timeZone);
        if (time > timeAtTopOfInterval) {
            if (this.isLessThanMonthly()) {
                timeAtTopOfInterval += millisInInterval;
            } else {
                GregorianCalendar gc = new GregorianCalendar(timeZone);
                gc.setTimeInMillis(timeAtTopOfInterval);
                int calendarAmount = this.getCalendarAmount();
                int calendarField = this.getCalendarField();
                gc.add(calendarField, calendarAmount);
                timeAtTopOfInterval = gc.getTimeInMillis();
            }
        }
        return timeAtTopOfInterval;
    }

    @Override
    public long getPreviousIntervalTime(long time, TimeZone timeZone) {
        return this.getTimeAtInterval(time, 1L, timeZone, false);
    }

    @Override
    public Instant getTimeOnPreviousOrCurrentInterval(Instant time, IntervalOffset intervalOffset, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return Instant.ofEpochMilli(this.getTimeOnPreviousOrCurrentInterval(time.toEpochMilli(), intervalOffset, TimeZone.getTimeZone(zoneId)));
    }

    @Override
    public Instant getTimeOnNextOrCurrentInterval(Instant time, IntervalOffset intervalOffset, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return Instant.ofEpochMilli(this.getTimeOnNextOrCurrentInterval(time.toEpochMilli(), intervalOffset, TimeZone.getTimeZone(zoneId)));
    }

    @Override
    public Instant getNextIntervalTime(Instant time, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return Instant.ofEpochMilli(this.getNextIntervalTime(time.toEpochMilli(), TimeZone.getTimeZone(zoneId)));
    }

    @Override
    public Instant getNextIntervalTime(Instant time, long intervals, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return Instant.ofEpochMilli(this.getNextIntervalTime(time.toEpochMilli(), intervals, TimeZone.getTimeZone(zoneId)));
    }

    @Override
    public Instant getPreviousIntervalTime(Instant time, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return Instant.ofEpochMilli(this.getPreviousIntervalTime(time.toEpochMilli(), TimeZone.getTimeZone(zoneId)));
    }

    @Override
    public long getNextIntervalTime(long time, TimeZone timeZone) {
        return this.getTimeAtInterval(time, 1L, timeZone, true);
    }

    @Override
    public long getNextIntervalTime(long time, long intervals, TimeZone timeZone) {
        return this.getTimeAtInterval(time, intervals, timeZone, true);
    }

    private long getTimeAtInterval(long time, long intervals, TimeZone timeZone, boolean next) {
        long timeAtNextInterval;
        if (this.isLessThanMonthly()) {
            long millisInInterval = intervals * this.getMillis();
            if (!next) {
                millisInInterval *= -1L;
            }
            timeAtNextInterval = time + millisInInterval;
        } else {
            GregorianCalendar gc = new GregorianCalendar(timeZone);
            gc.setTimeInMillis(time);
            int calendarField = this.getCalendarField();
            int calendarAmount = this.getCalendarAmount();
            if (!next) {
                calendarAmount *= -1;
            }
            calendarAmount = (int)((long)calendarAmount * intervals);
            gc.add(calendarField, calendarAmount);
            timeAtNextInterval = gc.getTimeInMillis();
        }
        return timeAtNextInterval;
    }

    @Override
    public TemporalAmount getTemporalAmount() {
        return this._temporalAmount;
    }

    @Override
    public int getNumIntervalPoints(long startTime, long endTime, TimeZone timeZone) {
        int num = 0;
        if (this.isLessThanMonthly()) {
            num = (int)((endTime - startTime) / this.getMillis()) + 1;
        } else {
            while (startTime <= endTime) {
                ++num;
                startTime = this.getNextIntervalTime(startTime, timeZone);
            }
        }
        return num;
    }

    @Override
    public long getNumIntervalPoints(Instant startTime, Instant endTime, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return this.getNumIntervalPoints(startTime.toEpochMilli(), endTime.toEpochMilli(), TimeZone.getTimeZone(zoneId));
    }

    @Override
    public long calcNumberOfIntervals(Date startTime, Date endTime, IntervalOffset intervalOffset, TimeZone timeZone) throws DataSetIllegalArgumentException {
        long numberIntervals;
        long onIntervalStart = this.getTimeOnNextOrCurrentInterval(startTime.getTime(), intervalOffset, timeZone);
        long onIntervalEnd = this.getTimeOnNextOrCurrentInterval(endTime.getTime(), intervalOffset, timeZone);
        long msInterval = this.getMillis();
        if (this.isLessThanMonthly()) {
            numberIntervals = (onIntervalEnd - onIntervalStart) / msInterval;
        } else {
            numberIntervals = 0L;
            Date onIntervalEndTime = new Date(onIntervalEnd);
            GregorianCalendar cal = new GregorianCalendar(timeZone);
            cal.setTimeInMillis(onIntervalStart);
            int calFieldType = this.getCalendarField();
            int calFieldIncrement = this.getCalendarAmount();
            while (cal.getTime().before(onIntervalEndTime)) {
                ((Calendar)cal).add(calFieldType, calFieldIncrement);
                ++numberIntervals;
            }
        }
        return numberIntervals;
    }

    @Override
    public long calcNumberOfIntervals(Instant startTime, Instant endTime, IntervalOffset intervalOffset, ZoneId zoneId) throws DataSetIllegalArgumentException {
        return this.calcNumberOfIntervals(Date.from(startTime), Date.from(endTime), intervalOffset, TimeZone.getTimeZone(zoneId));
    }

    @Override
    public void validateOffset(IntervalOffset intervalOffset) throws DataSetIllegalArgumentException {
        if (intervalOffset.isNoOffset() || intervalOffset.isDefined() && intervalOffset.getOffsetSeconds() < 0) {
            throw new DataSetIllegalArgumentException("Local Regular Interval ID: " + this.toString() + " must have a positive offset. Offset provided was: " + intervalOffset);
        }
        if (intervalOffset.isDefined() && intervalOffset.getOffsetSeconds() >= this.getSeconds()) {
            String error = "Interval offset, " + intervalOffset + ", must be less than the Interval, " + this.toString() + ".";
            throw new IllegalIntervalOffsetException(error);
        }
    }

    @Override
    public boolean isOnInterval(Instant instant, IntervalOffset offset, ZoneId zoneId) {
        try {
            return instant.equals(this.getTimeOnPreviousOrCurrentInterval(instant, offset, zoneId));
        }
        catch (DataSetIllegalArgumentException e) {
            LOGGER.log(Level.FINE, e, () -> "Unable to determine if time: " + instant + " matching interval for identifier: " + this);
            return false;
        }
    }
}

