/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.location;

import java.io.Serializable;
import java.util.Comparator;
import java.util.StringTokenizer;
import mil.army.usace.hec.metadata.OfficeId;
import mil.army.usace.hec.metadata.XMLUtilities;
import org.jdom.Element;

public class LocationTemplate
implements Serializable,
Comparable<LocationTemplate> {
    public static final String ID = "id";
    public static final String BASE_LOCATION_ID = "base_location_id";
    public static final String SUB_LOCATION_ID = "sub_location_id";
    public static final String LOCATION_ID = "location_id";
    public static final Comparator<LocationTemplate> LOCATION_TEMPLATE_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(LocationTemplate::getOfficeId, Comparator.nullsFirst(String::compareToIgnoreCase)).thenComparing(LocationTemplate::getLocationId, Comparator.nullsFirst(String::compareToIgnoreCase)));
    private static final long serialVersionUID = -2069347132746007124L;
    private static final String DELIM = ".";
    private OfficeId _dbOfficeId;
    private String _baseLocationId;
    private String _subLocationId;

    public LocationTemplate() {
    }

    public LocationTemplate(String locdescString) {
        this();
        try {
            StringTokenizer st = new StringTokenizer(locdescString);
            String officeId = st.nextToken(DELIM);
            String locationId = st.nextToken(DELIM);
            this.setLocationId(locationId);
            this.setOfficeId(officeId);
        }
        catch (RuntimeException e) {
            String message = "String not delimited correctly  :" + locdescString;
            throw new IllegalArgumentException(message, e);
        }
    }

    public LocationTemplate(LocationTemplate template) {
        this();
        if (template.getDbOfficeId() != null) {
            this._dbOfficeId = new OfficeId(template.getDbOfficeId());
        }
        this._baseLocationId = template._baseLocationId;
        this._subLocationId = template._subLocationId;
    }

    public LocationTemplate(String officeId, String locationId) {
        this();
        this.setLocationId(locationId);
        this.setOfficeId(officeId);
    }

    public LocationTemplate(String officeId, String baseLocationId, String subLocationId) {
        this();
        this.setLocationId(baseLocationId, subLocationId);
        this.setOfficeId(officeId);
    }

    public static LocationTemplate parse(Element locationElement) {
        if (locationElement == null) {
            return null;
        }
        Element child = locationElement.getChild("db_office_id");
        OfficeId dbOfficeId = OfficeId.parse(child);
        String baseLocationId = locationElement.getAttributeValue(BASE_LOCATION_ID);
        if (dbOfficeId == null || baseLocationId == null) {
            return null;
        }
        LocationTemplate locationTempl = new LocationTemplate();
        String subLocationId = locationElement.getAttributeValue(SUB_LOCATION_ID);
        locationTempl.setLocationId(baseLocationId, subLocationId);
        locationTempl.setOfficeId(dbOfficeId.getOfficeId());
        locationTempl.setOfficeName(dbOfficeId.getOfficeName());
        return locationTempl;
    }

    public void buildElement(Element element) {
        if (element != null) {
            String baseLocationId2 = this.getBaseLocationId();
            String subLocationId2 = this.getSubLocationId();
            if (baseLocationId2 == null) {
                baseLocationId2 = "";
            }
            if (subLocationId2 == null) {
                subLocationId2 = "";
            }
            element.setAttribute(BASE_LOCATION_ID, baseLocationId2);
            element.setAttribute(SUB_LOCATION_ID, subLocationId2);
            OfficeId dbOfficeId = this.getDbOfficeId();
            dbOfficeId.buildElement(XMLUtilities.getOrCreateChild(element, "db_office_id"));
        }
    }

    public String toString() {
        return this.getOfficeId() + DELIM + this.getLocationId();
    }

    @Override
    public final int compareTo(LocationTemplate object) {
        return LOCATION_TEMPLATE_COMPARATOR.compare(this, object);
    }

    public boolean equals(Object obj) {
        if (obj instanceof LocationTemplate) {
            LocationTemplate obj2 = (LocationTemplate)obj;
            return 0 == LOCATION_TEMPLATE_COMPARATOR.compare(this, obj2);
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._dbOfficeId == null ? 0 : this._dbOfficeId.hashCode());
        result = 31 * result + (this._baseLocationId == null ? 0 : this._baseLocationId.toUpperCase().hashCode());
        result = 31 * result + (this._subLocationId == null ? 0 : this._subLocationId.toUpperCase().hashCode());
        return result;
    }

    public OfficeId getDbOfficeId() {
        return new OfficeId(this.getOfficeId(), this.getOfficeName());
    }

    public final String getLocationId() {
        Object locId = null;
        if (this._baseLocationId != null) {
            locId = !this.hasSubLocation() ? this._baseLocationId : this._baseLocationId + "-" + this._subLocationId;
        }
        return locId;
    }

    public final void setLocationId(String locationId) {
        if (locationId == null) {
            this._baseLocationId = null;
            this._subLocationId = null;
        } else {
            int fieldIndex = locationId.indexOf("-");
            if (fieldIndex == -1) {
                this._baseLocationId = locationId;
                this._subLocationId = null;
            } else {
                this._baseLocationId = locationId.substring(0, fieldIndex);
                this._subLocationId = locationId.substring(fieldIndex + 1);
            }
        }
    }

    public final void setLocationId(String baseLocationId, String subLocationId) {
        this._baseLocationId = baseLocationId == null ? null : ((baseLocationId = baseLocationId.trim()).length() < 1 ? null : baseLocationId);
        this._subLocationId = subLocationId == null ? null : ((subLocationId = subLocationId.trim()).isEmpty() ? null : subLocationId);
    }

    public final String getOfficeId() {
        if (this._dbOfficeId == null) {
            return null;
        }
        return this._dbOfficeId.getOfficeId();
    }

    public final void setOfficeId(String officeId) {
        if (this._dbOfficeId == null && (officeId == null || officeId.isEmpty())) {
            return;
        }
        this._dbOfficeId = officeId == null ? null : (this._dbOfficeId == null ? new OfficeId(officeId) : new OfficeId(officeId, this._dbOfficeId.getOfficeName()));
    }

    public final String getOfficeName() {
        if (this._dbOfficeId == null) {
            return null;
        }
        return this._dbOfficeId.getOfficeName();
    }

    public final void setOfficeName(String officeName) {
        if (this._dbOfficeId == null && (officeName == null || officeName.isEmpty())) {
            return;
        }
        this._dbOfficeId = this._dbOfficeId == null ? new OfficeId(null, officeName) : new OfficeId(this._dbOfficeId.getOfficeId(), officeName);
    }

    public final String getBaseLocationId() {
        return this._baseLocationId;
    }

    public final void setBaseLocationId(String id) {
        this._baseLocationId = id;
    }

    public LocationTemplate getBaseLocationTemplate() {
        return new LocationTemplate(this.getOfficeId(), this.getBaseLocationId());
    }

    public final boolean hasSubLocation() {
        return this._subLocationId != null && !this._subLocationId.isEmpty();
    }

    public final String getSubLocationId() {
        return this._subLocationId;
    }

    public final void setSubLocationId(String id) {
        this._subLocationId = id == null || id.trim().isEmpty() ? null : id;
    }
}

