/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.math;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.army.usace.hec.metadata.constants.NumericalConstants;

public class RpnFunction {
    private static final Logger LOGGER = Logger.getLogger(RpnFunction.class.getName());
    private static final int OPERATOR = 0;
    private static final int OPERAND = 1;
    private static final List<RpnConst> _constVec = new ArrayList<RpnConst>();
    private static final List<RpnOperator> _operatorVec = new ArrayList<RpnOperator>();
    private String _syntaxStr;
    private Object[] _syntaxArray;
    private double[] _stack;
    private String _delim = "|";

    public RpnFunction() {
    }

    public RpnFunction(String s) {
        this.setFunctionString(s);
    }

    public RpnFunction(String s, String d) {
        this.setFunctionString(s);
        this._delim = d;
    }

    public final synchronized double calc(double[] arg) {
        if (arg == null || this._stack == null || this._stack.length < 1) {
            return Double.NEGATIVE_INFINITY;
        }
        for (Object o : this._syntaxArray) {
            if (o instanceof RpnArg) {
                this.stackInsert(arg[((RpnArg)o)._idx]);
            }
            if (o instanceof RpnValue) {
                this.stackInsert(((RpnValue)o)._val);
                continue;
            }
            if (o instanceof RpnConst) {
                this.stackInsert(((RpnConst)o)._val);
                continue;
            }
            if (!(o instanceof RpnOperator)) continue;
            double val = ((RpnOperator)o).calc(this._stack);
            this.stackDrop(((RpnOperator)o)._argCount - 1);
            this._stack[0] = val;
        }
        return this._stack[0];
    }

    private void stackInsert(double d) {
        if (this._stack.length - 1 >= 0) {
            System.arraycopy(this._stack, 0, this._stack, 1, this._stack.length - 1);
        }
        this._stack[0] = d;
    }

    private void stackDrop(int n) {
        if (this._stack.length - n - (n - 1) >= 0) {
            System.arraycopy(this._stack, n - 1 + n, this._stack, n - 1, this._stack.length - n - (n - 1));
        }
    }

    public final String getFunctionString() {
        return this._syntaxStr;
    }

    public static String algebraicToRpn(String astr) {
        int imax;
        String[] elem = RpnFunction.parseAlgebraicElements(astr);
        if (elem == null) {
            return null;
        }
        int ipos = 0;
        int activeMax = imax = elem.length;
        ArrayDeque<String> opStack = new ArrayDeque<String>();
        while (ipos < imax) {
            if (activeMax < imax && ipos == activeMax) {
                while (!opStack.isEmpty()) {
                    elem[ipos] = (String)opStack.pop();
                    ++ipos;
                    ++activeMax;
                }
                break;
            }
            if (RpnFunction.isExpression(elem[ipos])) {
                elem[ipos] = RpnFunction.algebraicToRpn(elem[ipos]);
                ++ipos;
                continue;
            }
            if (RpnFunction.isOperator(elem[ipos])) {
                String tmp;
                if (ipos + 1 == activeMax) {
                    ++ipos;
                    continue;
                }
                if (!RpnFunction.isOperator(elem[ipos + 1])) {
                    tmp = elem[ipos];
                    elem[ipos] = elem[ipos + 1];
                    elem[ipos + 1] = tmp;
                    continue;
                }
                if (RpnFunction.comparePrecedence(elem[ipos], elem[ipos + 1]) < 0) {
                    opStack.push(elem[ipos]);
                    if (activeMax - 1 - ipos >= 0) {
                        System.arraycopy(elem, ipos + 1, elem, ipos, activeMax - 1 - ipos);
                    }
                    --activeMax;
                    continue;
                }
                ++ipos;
                while (!opStack.isEmpty() && RpnFunction.comparePrecedence(elem[ipos], tmp = (String)opStack.peek()) <= 0) {
                    if (activeMax - ipos >= 0) {
                        System.arraycopy(elem, ipos, elem, ipos + 1, activeMax - ipos);
                    }
                    elem[ipos] = (String)opStack.pop();
                    ++activeMax;
                    ++ipos;
                }
                continue;
            }
            ++ipos;
        }
        StringBuilder rpnStr = new StringBuilder();
        if (elem[0] != null) {
            rpnStr.append(elem[0]);
            for (int j = 1; j < elem.length; ++j) {
                rpnStr.append("|").append(elem[j]);
            }
        }
        return rpnStr.toString();
    }

    private static String[] parseAlgebraicElements(String astr) {
        StringBuilder buffer = new StringBuilder(astr);
        StringBuilder parenBuffer = new StringBuilder();
        LOGGER.log(Level.FINER, "parseAlgebraicElements:expression left is ' {0}'", buffer);
        if (buffer.length() < 1) {
            return new String[0];
        }
        ArrayList<String> expressionList = new ArrayList<String>();
        StringBuilder token = new StringBuilder();
        int lastType = -1;
        String tmpBuffer = buffer.toString().trim();
        buffer = new StringBuilder(tmpBuffer);
        int length = buffer.length();
        int index = 0;
        block0: while (index < length) {
            char ch;
            if (RpnFunction.isOperator(ch = buffer.charAt(index++))) {
                if (token != null && token.length() > 0) {
                    expressionList.add(token.toString().trim());
                }
                token = new StringBuilder("" + ch);
                if (lastType == 0 && ch == '-' || index - 1 == 0 && ch == '-') {
                    lastType = 1;
                    continue;
                }
                LOGGER.log(Level.FINER, "parseAlgebraicElements:char '" + ch + "' is an operator");
                lastType = 0;
                expressionList.add(token.toString());
                token = new StringBuilder();
                continue;
            }
            if (ch == '(') {
                parenBuffer.setLength(0);
                int parenCnt = 1;
                LOGGER.log(Level.FINER, "parseAlgebraicElements:char is an open paren");
                while (index < length) {
                    if ((ch = buffer.charAt(index++)) == '(') {
                        ++parenCnt;
                    } else if (ch == ')') {
                        --parenCnt;
                    }
                    if (ch == ')' && parenCnt < 1) {
                        expressionList.add(parenBuffer.toString());
                        lastType = 1;
                        while (index < length && buffer.charAt(index) == ' ') {
                            ++index;
                        }
                        continue block0;
                    }
                    parenBuffer.append(ch);
                }
                continue;
            }
            if (ch == ' ' && lastType != 1) continue;
            if (lastType == 0) {
                token = new StringBuilder();
            }
            if (ch != '[' && ch != ']') {
                token.append(ch);
            }
            lastType = 1;
        }
        if (token.length() > 0) {
            expressionList.add(token.toString());
        }
        String[] algElements = expressionList.toArray(new String[0]);
        for (int i = 0; i < algElements.length; ++i) {
            LOGGER.log(Level.FINEST, i + " '" + algElements[i] + "'");
        }
        return algElements;
    }

    private static boolean isExpression(String str) {
        if (str == null || str.length() < 1) {
            return true;
        }
        StringTokenizer token = new StringTokenizer(str, "+-/*^%");
        return token.countTokens() > 1;
    }

    public static boolean isOperator(char ch) {
        switch (ch) {
            case '%': 
            case '*': 
            case '+': 
            case '-': 
            case '/': 
            case '^': {
                return true;
            }
        }
        return false;
    }

    public static boolean isOperator(String str) {
        if (str == null || str.length() < 1) {
            return false;
        }
        return RpnFunction.isOperator(str.charAt(0)) && str.length() == 1;
    }

    private static int comparePrecedence(String op1, String op2) {
        if (op1 == null && op2 == null) {
            return 0;
        }
        if (op1 == null) {
            return 1;
        }
        if (op2 == null) {
            return -1;
        }
        char c1 = op1.charAt(0);
        char c2 = op2.charAt(0);
        int op1Lvl = c1 == '+' || c1 == '-' ? 0 : (c1 == '/' || c1 == '*' || c1 == '%' ? 1 : (c1 == '^' ? 2 : 0));
        int op2Lvl = c2 == '+' || c2 == '-' ? 0 : (c2 == '/' || c2 == '*' || c2 == '%' ? 1 : (c2 == '^' ? 2 : 0));
        return op1Lvl - op2Lvl;
    }

    public final boolean setFunctionString(String str) {
        if (str == null) {
            return false;
        }
        this._syntaxStr = str;
        ArrayList<Object> syntaxVec = new ArrayList<Object>();
        RpnConst con = null;
        RpnOperator op = null;
        StringTokenizer tok = new StringTokenizer(str, this._delim);
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken().toUpperCase();
            if (s.indexOf("ARG") == 0) {
                int idx = RpnFunction.parseInt(s.substring(3));
                if (idx == Integer.MIN_VALUE) {
                    return false;
                }
                syntaxVec.add(new RpnArg(idx));
                continue;
            }
            boolean found = false;
            Iterator<Object> idx = _constVec.iterator();
            while (idx.hasNext()) {
                RpnConst rpnConst;
                con = rpnConst = idx.next();
                if (!s.equals(con._name)) continue;
                found = true;
                break;
            }
            if (found) {
                syntaxVec.add(con);
                continue;
            }
            found = false;
            idx = _operatorVec.iterator();
            while (idx.hasNext()) {
                RpnOperator rpnOperator;
                op = rpnOperator = (RpnOperator)idx.next();
                if (!s.equals(op._name)) continue;
                found = true;
                break;
            }
            if (found) {
                syntaxVec.add(op);
                continue;
            }
            double v = NumericalConstants.parseDouble(s);
            if (v != Double.NEGATIVE_INFINITY) {
                syntaxVec.add(new RpnValue(v));
                continue;
            }
            return false;
        }
        int cnt = 0;
        int maxcnt = 0;
        for (Object o : this._syntaxArray = syntaxVec.toArray()) {
            if (o instanceof RpnArg) {
                ++cnt;
            } else if (o instanceof RpnValue) {
                ++cnt;
            } else if (o instanceof RpnConst) {
                ++cnt;
            } else if (o instanceof RpnOperator) {
                cnt -= ((RpnOperator)o)._argCount - 1;
            }
            if (maxcnt >= cnt) continue;
            maxcnt = cnt;
        }
        if (cnt != 1 || maxcnt < 1) {
            return false;
        }
        this._stack = new double[maxcnt];
        return true;
    }

    private static int parseInt(String str) {
        int val;
        if (str == null) {
            return Integer.MIN_VALUE;
        }
        int idx = (str = str.trim()).indexOf(44);
        if (idx >= 0) {
            str = NumericalConstants.removeChar(str, ',');
        }
        try {
            val = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            val = Integer.MIN_VALUE;
        }
        return val;
    }

    static {
        _constVec.add(new RpnConst("PI", Math.PI));
        _constVec.add(new RpnConst("E", Math.E));
        _operatorVec.add(new RpnAdd());
        _operatorVec.add(new RpnSub());
        _operatorVec.add(new RpnMul());
        _operatorVec.add(new RpnDiv());
        _operatorVec.add(new RpnInv());
        _operatorVec.add(new RpnPow());
        _operatorVec.add(new RpnMod());
    }

    private static final class RpnArg {
        private final int _idx;

        private RpnArg(int i) {
            this._idx = i;
        }
    }

    private static final class RpnValue {
        private final double _val;

        private RpnValue(double d) {
            this._val = d;
        }
    }

    private static final class RpnConst {
        private final String _name;
        private final double _val;

        private RpnConst(String n, double v) {
            this._name = n;
            this._val = v;
        }
    }

    private static abstract class RpnOperator {
        String _name;
        int _argCount;

        private RpnOperator() {
        }

        abstract double calc(double[] var1);
    }

    private static final class RpnAdd
    extends RpnOperator {
        private RpnAdd() {
            this._name = "+";
            this._argCount = 2;
        }

        @Override
        double calc(double[] arg) {
            if (arg == null || arg.length < 2) {
                return Double.NEGATIVE_INFINITY;
            }
            return arg[1] + arg[0];
        }
    }

    private static final class RpnSub
    extends RpnOperator {
        private RpnSub() {
            this._name = "-";
            this._argCount = 2;
        }

        @Override
        double calc(double[] arg) {
            if (arg == null || arg.length < 2) {
                return Double.NEGATIVE_INFINITY;
            }
            return arg[1] - arg[0];
        }
    }

    private static final class RpnMul
    extends RpnOperator {
        private RpnMul() {
            this._name = "*";
            this._argCount = 2;
        }

        @Override
        double calc(double[] arg) {
            if (arg == null || arg.length < 2) {
                return Double.NEGATIVE_INFINITY;
            }
            return arg[1] * arg[0];
        }
    }

    private static final class RpnDiv
    extends RpnOperator {
        private RpnDiv() {
            this._name = "/";
            this._argCount = 2;
        }

        @Override
        double calc(double[] arg) {
            if (arg == null || arg.length < 2) {
                return Double.NEGATIVE_INFINITY;
            }
            return arg[1] / arg[0];
        }
    }

    private static final class RpnInv
    extends RpnOperator {
        private RpnInv() {
            this._name = "INV";
            this._argCount = 1;
        }

        @Override
        double calc(double[] arg) {
            if (arg == null || arg.length < 1) {
                return Double.NEGATIVE_INFINITY;
            }
            return 1.0 / arg[0];
        }
    }

    private static final class RpnPow
    extends RpnOperator {
        private RpnPow() {
            this._name = "^";
            this._argCount = 2;
        }

        @Override
        public double calc(double[] arg) {
            if (arg == null || arg.length < 2) {
                return Double.NEGATIVE_INFINITY;
            }
            return Math.pow(arg[1], arg[0]);
        }
    }

    private static final class RpnMod
    extends RpnOperator {
        private RpnMod() {
            this._name = "%";
            this._argCount = 2;
        }

        @Override
        double calc(double[] arg) {
            if (arg == null || arg.length < 2) {
                return Double.NEGATIVE_INFINITY;
            }
            return arg[1] % arg[0];
        }
    }
}

