/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.measurement;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonRootName;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import java.time.Instant;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.location.LocationTemplate;
import mil.army.usace.hec.metadata.measurement.MeasurementRef;
import mil.army.usace.hec.metadata.measurement.StreamflowMeasurement;
import mil.army.usace.hec.metadata.measurement.SupplementalStreamflowMeasurement;
import mil.army.usace.hec.metadata.measurement.UsgsMeasurement;

@JsonRootName(value="measurement")
@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
public final class Measurement {
    private final String _heightUnit;
    private final String _flowUnit;
    private final String _tempUnit;
    private final String _velocityUnit;
    private final String _areaUnit;
    private final boolean _used;
    private final String _agency;
    private final String _party;
    private final String _wmComments;
    private final MeasurementRef _measurementRef;
    private final StreamflowMeasurement _streamflowMeasurement;
    private final SupplementalStreamflowMeasurement _supplementalStreamflowMeasurement;
    private final UsgsMeasurement _usgsMeasurement;

    private Measurement(Builder builder) {
        this._heightUnit = builder._heightUnit;
        this._flowUnit = builder._flowUnit;
        this._tempUnit = builder._tempUnit;
        this._velocityUnit = builder._velocityUnit;
        this._areaUnit = builder._areaUnit;
        this._used = builder._used;
        this._agency = builder._agency;
        this._party = builder._party;
        this._wmComments = builder._wmComments;
        this._measurementRef = builder._measurementRef;
        this._streamflowMeasurement = builder._streamflowMeasurement;
        this._supplementalStreamflowMeasurement = builder._supplementalStreamflowMeasurement;
        this._usgsMeasurement = builder._usgsMeasurement;
    }

    @JacksonXmlProperty(isAttribute=true)
    public String getHeightUnit() {
        return this._heightUnit;
    }

    @JacksonXmlProperty(isAttribute=true)
    public String getFlowUnit() {
        return this._flowUnit;
    }

    @JacksonXmlProperty(isAttribute=true)
    public String getTempUnit() {
        return this._tempUnit;
    }

    @JacksonXmlProperty(isAttribute=true)
    public String getVelocityUnit() {
        return this._velocityUnit;
    }

    @JacksonXmlProperty(isAttribute=true)
    public String getAreaUnit() {
        return this._areaUnit;
    }

    @JacksonXmlProperty(isAttribute=true)
    public boolean isUsed() {
        return this._used;
    }

    @JacksonXmlProperty(isAttribute=true)
    public String getOfficeId() {
        return this._measurementRef.getOfficeId();
    }

    public String getAgency() {
        return this._agency;
    }

    public String getParty() {
        return this._party;
    }

    public String getWmComments() {
        return this._wmComments;
    }

    @JsonProperty(value="location")
    public String getLocationId() {
        return this._measurementRef.getLocationId();
    }

    @JsonProperty(value="date")
    public Instant getInstant() {
        return this._measurementRef.getInstant();
    }

    public String getNumber() {
        return this._measurementRef.getNumber();
    }

    @JsonProperty(value="stream-flow-measurement")
    public StreamflowMeasurement getStreamflowMeasurement() {
        return this._streamflowMeasurement;
    }

    @JsonProperty(value="supplemental-stream-flow-measurement")
    public SupplementalStreamflowMeasurement getSupplementalStreamflowMeasurement() {
        return this._supplementalStreamflowMeasurement;
    }

    public UsgsMeasurement getUsgsMeasurement() {
        return this._usgsMeasurement;
    }

    @JsonIgnore
    public MeasurementRef getRef() {
        return this._measurementRef;
    }

    @JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
    public static final class Builder {
        private String _heightUnit;
        private String _flowUnit;
        private String _tempUnit;
        private String _velocityUnit;
        private String _areaUnit;
        private boolean _used;
        private String _agency;
        private String _party;
        private String _wmComments;
        private StreamflowMeasurement _streamflowMeasurement;
        private SupplementalStreamflowMeasurement _supplementalStreamflowMeasurement;
        private UsgsMeasurement _usgsMeasurement;
        private String _officeId;
        private String _locationId;
        private Instant _instant;
        private String _number;
        @JsonIgnore
        private MeasurementRef _measurementRef;

        public Builder withHeightUnit(String heightUnit) {
            this._heightUnit = heightUnit;
            return this;
        }

        public Builder withFlowUnit(String flowUnit) {
            this._flowUnit = flowUnit;
            return this;
        }

        public Builder withTempUnit(String tempUnit) {
            this._tempUnit = tempUnit;
            return this;
        }

        public Builder withVelocityUnit(String velocityUnit) {
            this._velocityUnit = velocityUnit;
            return this;
        }

        public Builder withAreaUnit(String areaUnit) {
            this._areaUnit = areaUnit;
            return this;
        }

        public Builder withUsed(boolean used) {
            this._used = used;
            return this;
        }

        public Builder withAgency(String agency) {
            this._agency = agency;
            return this;
        }

        public Builder withParty(String party) {
            this._party = party;
            return this;
        }

        public Builder withWmComments(String wmComments) {
            this._wmComments = wmComments;
            return this;
        }

        @JsonProperty(value="stream-flow-measurement")
        public Builder withStreamflowMeasurement(StreamflowMeasurement streamflowMeasurement) {
            this._streamflowMeasurement = streamflowMeasurement;
            return this;
        }

        @JsonProperty(value="supplemental-stream-flow-measurement")
        public Builder withSupplementalStreamflowMeasurement(SupplementalStreamflowMeasurement supplementalStreamflowMeasurement) {
            this._supplementalStreamflowMeasurement = supplementalStreamflowMeasurement;
            return this;
        }

        public Builder withUsgsMeasurement(UsgsMeasurement usgsMeasurement) {
            this._usgsMeasurement = usgsMeasurement;
            return this;
        }

        public Builder withOfficeId(String officeId) {
            this._officeId = officeId;
            return this;
        }

        @JsonProperty(value="location")
        public Builder withLocationId(String locationId) {
            this._locationId = locationId;
            return this;
        }

        public Builder withNumber(String number) {
            this._number = number;
            return this;
        }

        @JsonProperty(value="date")
        public Builder withInstant(Instant instant) {
            this._instant = instant;
            return this;
        }

        public Measurement build() throws DataSetIllegalArgumentException {
            this._measurementRef = new MeasurementRef.Builder().withLocationRef(new LocationTemplate(this._officeId, this._locationId)).withInstant(this._instant).withNumber(this._number).build();
            return new Measurement(this);
        }
    }
}

