/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.measurement;

import java.time.Instant;
import java.util.Comparator;
import mil.army.usace.hec.metadata.DataSetIllegalArgumentException;
import mil.army.usace.hec.metadata.location.LocationTemplate;

public final class MeasurementRef {
    public static final Comparator<MeasurementRef> DEFAULT_COMPARATOR = Comparator.comparing(MeasurementRef::getOfficeId, String.CASE_INSENSITIVE_ORDER).thenComparing(MeasurementRef::getLocationId, String.CASE_INSENSITIVE_ORDER).thenComparing(MeasurementRef::getNumber, String.CASE_INSENSITIVE_ORDER);
    private final Instant _instant;
    private final LocationTemplate _locationRef;
    private final String _number;

    private MeasurementRef(Builder builder) {
        this._instant = builder._instant;
        this._locationRef = builder._locationRef;
        this._number = builder._number;
    }

    public Instant getInstant() {
        return this._instant;
    }

    public LocationTemplate getLocationRef() {
        return this._locationRef;
    }

    public String getNumber() {
        return this._number;
    }

    public String getOfficeId() {
        return this._locationRef.getOfficeId();
    }

    public String getLocationId() {
        return this._locationRef.getLocationId();
    }

    public static final class Builder {
        private Instant _instant;
        private LocationTemplate _locationRef;
        private String _number;

        public Builder withInstant(Instant instant) {
            this._instant = instant;
            return this;
        }

        public Builder withLocationRef(LocationTemplate locationRef) {
            this._locationRef = locationRef;
            return this;
        }

        public Builder withNumber(String number) {
            this._number = number;
            return this;
        }

        public MeasurementRef build() throws DataSetIllegalArgumentException {
            if (this._locationRef == null) {
                throw new DataSetIllegalArgumentException("Location reference is required.");
            }
            if (this._number == null) {
                throw new DataSetIllegalArgumentException("Number is required.");
            }
            return new MeasurementRef(this);
        }
    }
}

