/*
 * Decompiled with CFR 0.152.
 */
package mil.army.usace.hec.metadata.measurement;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonDeserialize(builder=Builder.class)
@JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
public final class UsgsMeasurement {
    private final String _remarks;
    private final String _currentRating;
    private final String _controlCondition;
    private final Double _shiftUsed;
    private final Double _percentDifference;
    private final String _flowAdjustment;
    private final Double _deltaHeight;
    private final Double _deltaTime;
    private final Double _airTemp;
    private final Double _waterTemp;

    private UsgsMeasurement(Builder builder) {
        this._remarks = builder._remarks;
        this._currentRating = builder._currentRating;
        this._controlCondition = builder._controlCondition;
        this._shiftUsed = builder._shiftUsed;
        this._percentDifference = builder._percentDifference;
        this._flowAdjustment = builder._flowAdjustment;
        this._deltaHeight = builder._deltaHeight;
        this._deltaTime = builder._deltaTime;
        this._airTemp = builder._airTemp;
        this._waterTemp = builder._waterTemp;
    }

    public String getRemarks() {
        return this._remarks;
    }

    public String getCurrentRating() {
        return this._currentRating;
    }

    public String getControlCondition() {
        return this._controlCondition;
    }

    public Double getShiftUsed() {
        return this._shiftUsed;
    }

    public Double getPercentDifference() {
        return this._percentDifference;
    }

    public String getFlowAdjustment() {
        return this._flowAdjustment;
    }

    public Double getDeltaHeight() {
        return this._deltaHeight;
    }

    public Double getDeltaTime() {
        return this._deltaTime;
    }

    public Double getAirTemp() {
        return this._airTemp;
    }

    public Double getWaterTemp() {
        return this._waterTemp;
    }

    @JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
    public static final class Builder {
        private String _remarks;
        private String _currentRating;
        private String _controlCondition;
        private Double _shiftUsed;
        private Double _percentDifference;
        private String _flowAdjustment;
        private Double _deltaHeight;
        private Double _deltaTime;
        private Double _airTemp;
        private Double _waterTemp;

        public Builder withRemarks(String remarks) {
            this._remarks = remarks;
            return this;
        }

        public Builder withCurrentRating(String currentRating) {
            this._currentRating = currentRating;
            return this;
        }

        public Builder withControlCondition(String controlCondition) {
            this._controlCondition = controlCondition;
            return this;
        }

        public Builder withShiftUsed(Double shiftUsed) {
            this._shiftUsed = shiftUsed;
            return this;
        }

        public Builder withPercentDifference(Double percentDifference) {
            this._percentDifference = percentDifference;
            return this;
        }

        public Builder withFlowAdjustment(String flowAdjustment) {
            this._flowAdjustment = flowAdjustment;
            return this;
        }

        public Builder withDeltaHeight(Double deltaHeight) {
            this._deltaHeight = deltaHeight;
            return this;
        }

        public Builder withDeltaTime(Double deltaTime) {
            this._deltaTime = deltaTime;
            return this;
        }

        public Builder withAirTemp(Double airTemp) {
            this._airTemp = airTemp;
            return this;
        }

        public Builder withWaterTemp(Double waterTemp) {
            this._waterTemp = waterTemp;
            return this;
        }

        public UsgsMeasurement build() {
            return new UsgsMeasurement(this);
        }
    }
}

